{
 $Id$
}
{*****************************************************************************
 *
 *
 *  Purpose:
 *
 * vbc - 090208 - version number at line no. 137 and 347 but see fm_struct
 *                  removed regkey stuff.
 * vbc - 290208 - fixed bugs in active time
 * vbc - 080308 - Spelling errors que -> queue
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit Fm_Init;

{$O+}

Interface

Uses
  Crt, Dos, Crosslib, S_String, F_file,
  Fm_Hex, Fm_Mtask, Fm_Struct, Fm_Basic, Fm_Log,
{ Fm_key, }
  Fm_Dup;

Function  Verstr ( ver : word ) : string;
Procedure InitProgram;
Procedure OpenInit;
Procedure CloseInit;
Procedure ParameterHelp;
Procedure ExitProgram;
Procedure WriteSetupCfg;


CONST
  ValidParms = 'SCAN HATCH MGR ANNOUNCE NOTIFY SCHEDULE FILEFIND NEWSCAN CLEAN';
  ValidSwitch= 'AFDXSM';
  SwitchSet  = ['-','/'];


Implementation

Var
  Up   : LongInt;
  Init : Boolean;


Function  VerStr ( ver : word ) : String;
Var Tmp : String;
Begin
  Tmp := Int_to_str(ver);
  While length(tmp) < 3 do Tmp := '0' + Tmp;
  Verstr := First(1,tmp)+'.'+last(2,Tmp);
End;


Procedure ParameterHelp;
var ch : char;
begin
  WriteLn ('Usage:      FILEMGR <command> [<command>]',#10);
  WriteLn ('            Scan               Scan, move, forward files.');
  WriteLn ('            Mgr                Process FileMgr requests.');
  WriteLn ('            Announce           Post announcements of arrived files.');
  WriteLn ('            Schedule           Process scheduled events.');
  WriteLn ('            FileFind           Process FileFind requests.');
  WriteLn ('            Notify [<address>] Send a FileMgr statusreport to <address>, (wild-');
  WriteLn ('                               cards possible) or to all systems with the');
  Writeln ('                               ''Notify'' flag set.');
  Writeln ('              [-NoList]        Do not create list reports.');

    Write('More (Y/n) :');
    repeat
      ch := readkey;
    until ch in ['y','Y','n','N',#27,#13];
 write(#13,'          ',#13);

  Writeln ('              [-NoQuery]       Do not create query reports.');
  Writeln ('              [-NoUnlinked]    Do not create unlinked reports.');
  Writeln ('              [-NoHelp]        Do not create help messages.');
  Writeln ('              [-NoStatus]      Do not create status messages.');
  Writeln ('            NewScan            Scan your areas for new files.');
  Writeln ('            Clean              Clean your FileMgr outbound dir.');
  WriteLn ('            Hatch              Send files from your system manually.');
  WriteLn ('              -A<area>         Area to hatch file in.');
  WriteLn ('              -F<filespec>     File to hatch.');
  WriteLn ('              -D<description>  Description of hatched file. Use ''_'' for spaces.');
  WriteLn ('              [-X<filename>]   File to replace with hatched file.');
  WriteLn ('              [-S]             Send file only; don''t move to area.');
  Writeln ('              [-M<magicname>]  Magic request name');
  WriteLn ('            Cost [<address>]   Add or deduct an amount from <address>');
  Writeln ('              [<+/-cents>]     costsharings field.');
  WriteLn;
  Writeln ('            -NoForward         Do not forward files to downlinks.');
  Writeln ('            -NoBill            Do not send bills to downlinks.');
  Writeln ('            -NoMaint           Do not perform file area maintenance.');

  Halt(1);
end;


Procedure InitProgram;
Var
  TmpTime : Datetime;
  Dummy   : Word;
  Sr      : Searchrec;
Begin
  Init := false;
  Directvideo := false;
  TextAttr := 7;
  ClrScr;
  CheckBreak := False;
  DirStack := '';
  GetDir (0, DirStack);

  Randomize;
                        { version numbering also at line 342   }
  Writeln;
  TextAttr := 15;
  Writeln('FileMgr Beta v'+verstr(versionnr)+Build+' Compiled on '+COMPILED+' Echofile Processor');
  TextAttr := 12;
  Writeln(Copyright+'. All Rights Reserved.');
  Writeln;
  TextAttr := 7;

  With TmpTime do
    begin
      GetTime (Hour, Min, Sec, Dummy);
      GetDate (Year, Month, Day, Dummy);
    end;
  Up := GetUnixDate (TmpTime);

  tForward     := 0;
  tRequest     := 0;
  tFiles       := 0;
  tBad         := 0;
  tAnnounce    := 0;
  tSystems     := 0;

{  OwnerCode    := 'ABD&*^(&G!%&UK!9';    }

  FillChar (parNode, SizeOf(parNode), 0);
  parTAG       := '';
  parFile      := '';
  parRepl      := '';
  parMagic     := '';
  parDesc      := '';
  pnod         := '';
  parNOP       := false;
  part         := false;

  rescan       := false;
  BatchHatch   := false;
  ValidNode    := False;
{ ProgramCode  := 'File Manager';   }

  nohelp := false;
  noquery := false;
  nostatus := false;
  nolist := false;
  nounlinked := false;

  systempath   := getenv('FILEMGR');
  if (systempath = '\') or (systempath = '') then
    begin
      GetDir(0, SystemPath);
      if (length(systempath) > 0) and (last(1,systempath) <> '\') then systempath := systempath + '\';
      findfirst (systempath+'SETUP.FM',$0,sr);
      if doserror <> 0 then
        begin
          systempath := paramstr(0);
          repeat
            systempath := first(length(systempath)-1,systempath);
          until (last(1,systempath) = '\') or (systempath = '');
          if systempath = '' then getdir(0,systempath);
        end;
      while doserror = 0 do findnext(sr);
    end;
  if (length(systempath) > 0) and (last(1,systempath) <> '\') then
    systempath := systempath + '\';
End;


Procedure OpenInit;
Var
  I       : Byte;
  SR      : Searchrec;
  Dt      : Datetime;
  lu,mu   : longint;
  h, m,
  s, hund : Word;
Begin
  Assign (SF, SystemPath+'SETUP.FM');
  {$I-} Reset (SF); {$I+}
  If IOresult <> 0 then
    Begin
      WriteLn ('Error opening ',Systempath,'SETUP.FM. Please run FMSETUP.EXE first.');
      Halt (1);
    End;

  {$I-} Read (SF, SETUP); {$I+}
  If IOresult > 0 then
    Begin
      If filesize(Sf) < 12600 then
        Writeln('Old SETUP.FM version. Run UPGRADE.EXE first!') else
          WriteLn ('Error reading SETUP.FM');
      Close(SF);
      Halt(1);
    End;
  Close(SF);

  If SETUP.Version < VERSIONNR then
    Begin
      WriteLn ('Incorrect SETUP.FM version. Run UPGRADE.EXE first!');
      Halt(1);
    End;
  If setup.version > versionnr then
    begin
      writeln('Found version ',setup.version,' setup files, this FileMgr copy is for version ',versionnr,'!');
      halt(1);
    end;

  noforward := false;
  nomaint := false;
  nobill := false;
  If ParamCount = 0 then ParameterHelp else
  For Run := 1 to ParamCount do
    Begin
      ParamWord := Upper(ParamStr(Run));
      If Upper(Paramstr(1)) = 'HATCH' then
        Begin
          If (run > 1) and (ParamWord[1] in SwitchSet) then
            Begin
              Delete (paramWord, 1, 1);
              If Pos(paramWord[1], validSwitch) <> 0 then BatchHatch := true;
              Case Pos(paramWord[1], ValidSwitch) of
               1  : parTAG    := Copy(paramWord, 2, Length(paramWord)-1);
               2  : parFile   := Copy(paramWord, 2, Length(paramWord)-1);
               3  : begin
                      ParamWord := ParamStr(Run);
                      parDesc := Copy(paramWord, 3, Length(paramWord)-2);
                      parDesc := Replace('_',' ',parDesc);
                    end;
               4  : parRepl   := Copy(paramWord, 2, Length(paramWord)-1);
               5  : parNOP    := True;
               6  : parMagic  := Copy(paramWord, 2, Length(paramWord)-1);
               Else Begin
                      If upper(paramword) = 'NOFORWARD' then noforward := true else
                      If upper(paramword) = 'NOBILL' then nobill := true else
                      If upper(paramword) = 'NOMAINT' then nomaint := true else
                        ParameterHelp;
                    End;
              End; {case}
            End;
        End;
      If (run > 1) and ((Upper(paramstr(1)) = 'NOTIFY') or (upper(paramstr(1)) = 'COST')) then
        Begin
          if (run = 3) and (upper(paramstr(1)) = 'COST') then
            Begin
              partag := paramword;
            End;
          if (run = 2) and (first(1,paramword) <> '-') and (first(1,paramword) <> '\') then
            Begin
              ValidNode := True;
              For I := 1 to Length(ParamWord) do
                If not (ParamWord[I] in ['0'..'9','.',':','/','*']) then
                  ValidNode := False;
              If validnode and (pos('*',paramword) = length(paramword)) then
                begin
                  validnode := false;
                  part := true;
                  pnod := first(length(paramword)-1,paramword);
                End Else
                Begin
                  If ValidNode then Str2Node (ParamWord, parNode, SETUP.Address[1], ValidNode);
                  If NOT ValidNode then ParameterHelp;
                End;
            End Else
            Begin
              if upper(paramstr(1)) = 'NOTIFY' then
                begin
                 if pos('NOHELP',upper(paramword)) <> 0 then nohelp := true;
                 if pos('NOQUERY',upper(paramword)) <> 0 then noquery := true;
                 if pos('NOLIST',upper(paramword)) <> 0 then nolist := true;
                 if pos('NOSTATUS',upper(paramword)) <> 0 then nostatus := true;
                 if pos('NOUNLINKED',upper(paramword)) <> 0 then nounlinked := true;
                 if pos('NOFORWARD',upper(paramword)) <> 0 then noforward := true;
                 if pos('NOMAINT',upper(paramword)) <> 0 then nomaint := true;
                 if pos('NOBILL',upper(paramword)) <> 0 then nobill := true;
                end;
            End;
        End;
       if pos('NOFORWARD',upper(paramword)) <> 0 then noforward := true;
       if pos('NOMAINT',upper(paramword)) <> 0 then nomaint := true;
       if pos('NOBILL',upper(paramword)) <> 0 then nobill := true;
    End;

  WriteMTaskInfo(output);
  WriteLn;
(*    ------------------ RegKey code removed for Open source  version -----
   With SETUP do
    begin
      Rkp.Level := 10;
      Rkp.Name1 := SysopName;
      Rkp.name2 := SystemName;
      Rkp.Key   := SETUP.RegKey;
      If first(1,setup.regkey) = 'L' then VerifyKey;
      if Rkp.Status = Registered then
        WriteLn ('Registered to ',SysopName, ', ',Systemname,' (', Node2Str(Address[1]),')',#10) else
          begin
            I := textattr;
            Textattr := $8e;
            WriteLn (#7'Please consider registration of this program.'#7#10);
            Textattr := I;
            Halt(1);    {!!!}
          end;
    end;
 *)

{  MsgTearline := 'FileMgr '+first(2,compiled)+last(2,first(5,compiled))+'B'; }
{  if rkp.status <> registered then
    MsgTearline := msgtearline + '-' else msgtearline := msgtearline + '+';
}
    MsgTearLine := 'FileMgr Beta v'+verstr(versionnr)+Build+'B++';
  { temp path checken & evt creeren }

  setup.temppath := checkepath(setup.temppath,true);
  If Setup.temppath <> '' then
    Begin
      {$I-} ChDir(udir(setup.temppath)); {$I+}
      If Ioresult <> 0 then
        Begin
          {$I-} mkdir(udir(setup.temppath)); {$I+}
          If ioresult <> 0 then
            Begin
              Writeln('Temporary path '+udir(setup.temppath)+' does not exist!');
              Halt(1);
            End;
        End;
      if last(1,setup.temppath) <> '\' then setup.temppath := setup.temppath + '\';
    End;


  { check andere paden }
  setup.retirepath := checkepath(setup.retirepath,true);
  If Setup.retirepath <> '' then
    Begin
      {$I-} ChDir(udir(setup.retirepath)); {$I+}
      If Ioresult <> 0 then
        Begin
          Writeln('Retirement path '+udir(setup.retirepath)+' does not exist!');
          Halt(1);
        End;
      if last(1,setup.retirepath) <> '\' then setup.retirepath := setup.retirepath + '\';
    End;


  setup.inboundpath := checkepath(setup.inboundpath,true);
  If setup.InboundPath <> '' then
    Begin
      If not exist(udir(setup.inboundpath)) then
        Begin
          Writeln('Inbound path '+setup.inboundpath+' does not exist!');
          Halt;
        End;
    End Else
    Begin
      Writeln('Inbound path not set!');
      Halt;
    End;
  if last(1,setup.inboundpath) <> '\' then setup.inboundpath := setup.inboundpath + '\';

  setup.securepath := checkepath(setup.securepath,true);
  If setup.securePath <> '' then
    Begin
      If not exist(udir(setup.securepath)) then
        Begin
          Writeln('Inbound secure path '+setup.securepath+' does not exist!');
          Halt;
        End;
      if last(1,setup.securepath) <> '\' then setup.securepath := setup.securepath + '\';
    End;

  setup.outboundpath := checkepath(setup.outboundpath,true);
  If setup.OutboundPath <> '' then
    Begin
      If not exist(udir(setup.outboundpath)) then
        Begin
          Writeln('Outbound path '+setup.outboundpath+' does not exist!');
          Halt;
        End;
    End Else
    Begin
      Writeln('Outbound path not set!');
      Halt;
    End;
  if last(1,setup.outboundpath) <> '\' then setup.outboundpath := setup.outboundpath+ '\';

  setup.netmailpath := checkepath(setup.netmailpath,true);
  If setup.NetmailPath <> '' then
    Begin
      If not exist(udir(setup.netmailpath)) then
        Begin
          Writeln('Netmail path '+setup.netmailpath+' does not exist!');
          Halt;
        End;
    End Else
    Begin
      Writeln('Netmail path not set!');
      Halt;
    End;
  if last(1,setup.netmailpath) <> '\' then setup.netmailpath := setup.netmailpath + '\';

  setup.badfilepath := checkepath(setup.badfilepath,true);
  If setup.BadFilePath <> '' then
    Begin
      If not exist(udir(setup.badfilepath)) then
        Begin
          Writeln('Bad file path '+setup.badfilepath+' does not exist!');
          Halt;
        End;
    End Else
    Begin
      Writeln('Bad file path not set!');
      Halt;
    End;
  if last(1,setup.badfilepath) <> '\' then setup.badfilepath := setup.badfilepath + '\';

  setup.tplpath := checkepath(setup.tplpath,true);
  If setup.TPLpath <> '' then
    Begin
      If not exist(udir(setup.tplpath)) then
        Begin
          Writeln('Tpl file path '+setup.tplpath+' does not exist!');
          Halt;
        End;
    End Else
    Begin
      Writeln('Tpl file path not set!');
      Halt;
    End;
  if last(1,setup.tplpath) <> '\' then setup.tplpath := setup.tplpath + '\';


  setup.AliasFile[1] := checkepath(setup.aliasfile[1],false);
  setup.AliasFile[2] := checkepath(setup.aliasfile[2],false);

  If (setup.mailer = 2) {binkley} or (setup.mailer = 3) {dbridge}
     or (setup.mailer = 4) {pop} then
    Begin
      setup.quepath := checkepath(setup.quepath,true);
      If setup.Quepath <> '' then
        Begin
          If not exist(udir(setup.quepath)) then
            Begin
              Writeln('Mailer queue path '+setup.quepath+' does not exist!');
              Halt;
            End;
        End Else
        Begin
          Writeln('Mailer Queue path not set!');
          Halt;
        End;
      if last(1,setup.quepath) <> '\' then setup.quepath := setup.quepath + '\';
    End;

  {$I-} ChDir(udir(systempath)); {$I+}
  if IOresult <> 0 then
    Begin
      WriteLn ('Unable to change path to '+udir(systempath));
      Halt;
    End;

  if setup.logfile <> '' then
    setup.logfile := fexpand(checkepath(setup.logfile,false));

  if not checkdiskspace then halt;

  If Setup.semamode <> 0 {none} then
    Begin
      setup.semaphorepath := checkepath(setup.semaphorepath,true);
      If setup.semaphorepath = '' then setup.semaphorepath := upper(systempath);
      If last(1,setup.semaphorepath) <> '\' then setup.semaphorepath := setup.semaphorepath + '\';
      If Exist(setup.semaphorepath+'FMBUSY.NOW') then
        Begin                                       { check for startup semaphore }
          FindFirst(setup.semaphorepath+'FMBUSY.NOW', archive, sr);
          If Doserror = 0 then
            Begin
              unpacktime(sr.time,dt);
              mu := getunixdate(dt);
              With dt do
                begin
                  GetTime (Hour, Min, Sec, hund);
                  GetDate (Year, Month, Day, hund);
                end;
              lu := GetUnixDate(dt);
              If (lu-mu) > (setup.maxwaittime*60) then
                Begin        { als ie te oud is deleten }
                  Writeln('Semaphore is '+int_to_str((lu-mu) div 60)+' minutes old: deleted...');
                  Delete_file(setup.semaphorepath+'FMBUSY.NOW');
                  Create_File(setup.semaphorepath+'FMBUSY.NOW'); { en nieuwe creeren }
                End Else
                Begin       { anders wachten totdat maxwait op is }
                  Writeln('Other FileMgr task is busy, aborting...');
                  Halt;
                  { als ie dan nog bestaat halt }
                End;
              While doserror = 0 do findnext(sr);
            End;
        End Else
        Begin                           { if not found set startup semaphore zelf }
          Create_File(setup.semaphorepath+'FMBUSY.NOW');
        End;
    End;

  Filemode := 66;

  { ---- node file ---- }

  Assign (NF, SystemPath + 'NODEFILE.FM');
  {$I-} Reset (NF,1); {$I+}
  if IOresult > 0 then Error (1,SystemPath +'NODEFILE.FM not found');

  Assign (NFX, SystemPath + 'NODEFILE.FMX');
  {$I-} Reset (NFX,1); {$I+}
  if IOresult > 0 then Error (1,SystemPath +'NODEFILE.FMX not found');

  If MaxAvail < SizeOf(Nfxt^) then
    Begin
      Writeln('Not enough memory left for node index');
      Halt;
    End Else New(Nfxt);

  For NodeIdx := 1 to 1000 do FillChar(Nfxt^[nodeidx],sizeof(nfxt^[nodeidx]),0);
  NodeIdx := 0;

  BlockRead(Nfx,NFXt^[1],1000*sizeof(nodeindextype),NodeIdx);
  Close(Nfx);
  NodeIdx := NodeIdx div Sizeof(nodeindextype);

  { ---- area file ---- }

  Assign (AF, SystemPath + 'AREAFILE.FM');
  {$I-} Reset (AF,1); {$I+}
  if IOresult > 0 then Error (1,SystemPath +'AREAFILE.FM not found');

  Assign (AFX, SystemPath + 'AREAFILE.FMX');
  {$I-} Reset (AFX,1); {$I+}
  if IOresult > 0 then Error (1,SystemPath + 'AREAFILE.FMX not found');

  If MaxAvail < SizeOf(Afxt^) then
    Begin
      Writeln('Not enough memory left for area index');
      Halt;
    End Else New(Afxt);
  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      Writeln('Not enough memory left for area links');
      Halt;
    End Else New(Sfxt);

  For AreaIdx := 1 to 2000 do FillChar(Afxt^[areaidx],sizeof(afxt^[areaidx]),0);
  AreaIdx := 0;
  BlockRead(Afx,AFXt^[1],2000*sizeof(areaindextype),areaIdx);
  Close(Afx);
  AreaIdx := AreaIdx div Sizeof(areaindextype);

  { ---- de rest ---- }

  Assign (GF, SystemPath + 'GROUPS.FM');
  {$I-} Reset (GF); {$I+}
  if IOresult > 0 then Error (1,SystemPath + 'GROUPS.FM not found');

  Assign (MF, SystemPath + 'MESSAGES.FM');
  {$I-} Reset (MF); {$I+}
  if IOresult > 0 then Error (1,SystemPath + 'MESSAGES.FM not found');
  Close(Mf);

  Assign (HF, SystemPath + 'HISTORY.FM');
  {$I-} Reset (HF); {$I+}
  if IOresult > 0 then Rewrite (HF);
  Close(Hf);

  Init := true;

  InitLog;
End;


Procedure WriteAreaIndex;
Var
  Dummy : Word;
Begin
  Assign(Afx,systempath+'AREAFILE.FMX');   { herschrijven ivm evt veranderingen }
  {$I-} Rewrite(Afx,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot open/rewrite AREAFILE.FMX');
    End Else
    Begin
      BlockWrite(Afx,Afxt^,AreaIdx*sizeof(areaindextype),Dummy);
      If Dummy <> (AreaIdx*sizeof(areaindextype)) then
        Writeln('Cannot rewrite AREAFILE.FMX');
    End;
  Dispose(Afxt);
  Dispose(Sfxt);
End;


Procedure WriteNodeIndex;
Var
  Dummy : Word;
Begin
  Assign(Nfx,systempath+'NODEFILE.FMX');
  {$I-} Rewrite(Nfx,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot open/rewrite NODEFILE.FMX');
    End Else
    Begin
      BlockWrite(Nfx,Nfxt^,NodeIdx*sizeof(nodeindextype),Dummy);
      If Dummy <> (NodeIdx*sizeof(nodeindextype)) then
        Writeln('Cannot rewrite NODEFILE.FMX');
    End;
  Dispose(Nfxt);
End;


Procedure ExitProgram;
var t : file;
   count : word;
begin
  if (ExitCode > 0) and (ErrorAddr <> NIL) then
    Begin
      WriteLn;
      NotifyCR (1,'Fatal: '+ErrStr(ExitCode));
      NotifyCR (1,'Run-time error ['+int_to_str(ExitCode)+'] at ['
        +StrHex(Seg(ErrorAddr^),4)+':'+StrHex(Ofs(ErrorAddr^),4)+']');
      ErrorAddr := NIL;
      ExitProc  := NIL;
    End;

  If init then
    Begin
      WriteAreaIndex;
      WriteNodeIndex;

      inoutres := 0;

      assign(t,systempath+'setup.fm');
      {$I-} reset(t,1); {$I+}
      if ioresult <> 0 then
        begin
          writeln('Cannot open '+systempath+'setup.fm');
          halt;
        end;
      seek(t,12358);
      blockwrite(t,setup.namecount,4,count);
      if count <> 4 then writeln('Error writing setup.fm');
      close(t);

      If Setup.semamode <> 0 {none} then
        Delete_file(setup.semaphorepath+'FMBUSY.NOW');
    End;

  {$I-}
  Close (NF);
  Close (NFX);
  Close (AF);
  Close (AFX);
  Close (GF);
  {$I+}
  inoutres := 0;
  PopDir;
End;

Procedure WriteSetupCfg;
var
  count : word;
  T       : File;
Begin
  inoutres := 0;
  filemode := 66;
  assign(t,systempath+'setup.fm');
  {$I-} reset(t,1); {$I+}
  if ioresult <> 0 then
    begin
      writeln('Cannot find '+systempath+'setup.fm');
      halt;
    end;
  seek(t,12358);
  blockwrite(t,setup.namecount,4,count);
  if count <> 4 then writeln('Error re-writing setup.fm');
  close(t);

  If Setup.semamode <> 0 {none} then  {sema opnieuw redaten}
    Begin
      If Exist(setup.semaphorepath+'FMBUSY.NOW') then
        Begin
          assign(t,setup.semaphorepath+'FMBUSY.NOW');
          {$I-} rewrite(t); {$I+}
          if ioresult <> 0 then notifycr(2,'Cannot re-date semaphore file FMBUSY.NOW');
          close(t);
        End Else Create_File(setup.semaphorepath+'FMBUSY.NOW');
    End;
End;


Procedure CloseInit;
Var
  TmpTime : Datetime;
  Dummy   : Word;
  Dn      : Longint;
Begin
  WriteAreaIndex;
  WriteNodeIndex;

  writesetupcfg;

  If Setup.semamode <> 0 {none} then
    Delete_file(setup.semaphorepath+'FMBUSY.NOW');

  init := false;

  {$I-}
  Close (NF);
  Close (NFX);
  Close (AF);
  Close (AFX);
  Close (GF);
  {$I+}
  inoutres := 0;

  With TmpTime do
    begin
      GetTime (Hour, Min, Sec, Dummy);
      GetDate (Year, Month, Day, Dummy);
    end;
  Dn := GetUnixDate (TmpTime);

  Writeln;
  NotifyCR (9,'Forward: '  +expand(int_to_str( tForward  ),4)+
             ' Requests: ' +expand(int_to_str( tRequest  ),4)+
             ' Files: '    +expand(int_to_str( tFiles    ),4)+
             ' Bad: '      +expand(int_to_str( tBad      ),4));
  NotifyCR (9,'Systems: '  +expand(int_to_str( tSystems  ),4)+
             ' Announce: ' +expand(int_to_str( tAnnounce ),4));

  writeln('');
  NotifyCR (6,'Active : '+TimeDiff(Up,Dn));

  PopDir;
End;


END.
