{
 $Id$
}
{*****************************************************************************
 *
 *  Purpose:  Process for schedule ?
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit FM_Gen;

Interface

Uses Crt, Dos, CrossLib, s_String, f_file,
     Fm_struct;


function  flowstring (flow : flowtype; lastmonth : byte; which : byte) : string;
Function  AttribStr (Attr : msgAttribSet) : String;
Procedure MatchAKA (VAR Match : NodeType; ToNode : NodeType);
Function  NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
Procedure PopDir; { f & s }
Function  GetBbsAreaNaam(recnummer:word) : String; { f & s }


implementation


Function GetBbsAreaNaam(recnummer:word) : String;
Var
  Found    : Boolean;
  Tel, Max : Word;
Begin
  If Exist(systempath+'filearea.fm') then
    Begin
      Assign (bf, systempath+'filearea.fm');
      Reset (bf,1);
      Max   := (Filesize(bF) div sizeof(bbsarea)) -2;
      If Recnummer-1 <= Max then
        Begin
          Dec(Recnummer);
          Seek(bF, (Recnummer * SizeOf(Bbsarea)) + sizeof(Bbsarea) + 20);
          BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
          GetBbsAreaNaam := BbsArea.name;
        End Else
          GetBbsAreaNaam := '';
      Close(bf);
   End Else
    GetBbsAreaNaam := '';
End;


Procedure PopDir;
begin
  InOutRes := 0;
  {$I-} ChDir (DirStack); {$I+}
  if IOresult > 0 then WriteLn ('Unable to return to '+DirStack);
end;


{
Procedure SortNodeIndex (TAB : NFXptr);
VAR
  I,J : Byte;

Procedure Swp (VAR X,Y : NodeIndexType);
VAR T : NodeIndexType;
begin
  T := X;
  X := Y;
  Y := T;
end;

begin
  for I := 1 to NodeNr
  do for J := 1 to NodeNr
     do with TAB^[I].Address
        do begin
          if Zone < TAB^[J].Address.Zone
          then Swp(TAB^[I], TAB^[J])
          else if Zone = TAB^[J].Address.Zone
               then if Net < TAB^[J].Address.Net
                    then Swp(TAB^[I], TAB^[J])
                    else if Net = TAB^[J].Address.Net
                         then if Node < TAB^[J].Address.Node
                              then Swp(TAB^[I], TAB^[J])
                              else if Node = TAB^[J].Address.Node
                                   then if Point < TAB^[J].Address.Point
                                        then Swp(TAB^[I], TAB^[J]);
        end;

  Seek (NFX, 0);
  for I := 1 to NodeNr do Write (NFX, TAB^[I]);
end;
 }



Function AttribStr (Attr : msgAttribSet) : String;
VAR
  S : String;
begin
  S := '';
  if Privat        in Attr then S := S + 'Private ';
  if CrashMail     in Attr then S := S + 'Crash ';
  if HoldMail      in Attr then S := S + 'Hold ';
  if DirectMail    in Attr then S := S + 'Direct ';
  if FileRequest   in Attr then S := S + 'FilReq ';
  if Fattach       in Attr then S := S + 'File ';
  if FileUpdateReq in Attr then S := S + 'UpdReq ';
  AttribStr := Copy(S,1,Length(S)-1);
end;



Procedure MatchAKA (VAR Match : NodeType; ToNode : NodeType);
VAR
  I : Byte;
begin
  if Match.Zone = 0 then
    begin
      I := 0;
      repeat
        Inc(I);
      until (I>15)
      or ((SETUP.ZoneToAKA[I].Zone > 0) and
        (((SETUP.ZoneToAKA[I].Zone = ToNode.Zone) and (SETUP.ZoneToAKA[I].Net = ToNode.Net))
      or ((SETUP.ZoneToAKA[I].Zone = ToNode.Zone) and (SETUP.ZoneToAKA[I].Net = 0))));

      if I > 15 then
        begin
          I := 0;
          repeat
            Inc(I);
          until (I>15)
          or ((SETUP.Address[I].Zone > 0) and (SETUP.Address[I].Zone = ToNode.Zone));

          if I > 15
            then Match := SETUP.Address[1]
              else Match := SETUP.Address[I];
        end else
          Match := SETUP.Address[SETUP.ZoneToAKA[I].AKA];
  end;
end;

(*
Procedure ReadAreaIndex;
Begin
  if areaindexok then exit;

  close (afx);

  If MaxAvail < SizeOf(Afxt^) then
    Begin
      writeln(' not enough memory left');
      halt;
    End Else New(Afxt);

  For AreaIdx := 1 to 2000 do FillChar(Afxt^[areaidx],sizeof(afxt^[areaidx]),#0);
  AreaIdx := 0;

  Assign(AFX,systempath+'AREAFILE.FMX');
  {$I-} Reset(AFX,1); {$I+}
  If ioresult = 0 then
    Begin
      BlockRead(Afx,AFXt^,2000*sizeof(areaindextype),areaIdx);
      Close(Afx);
      AreaIdx := AreaIdx div Sizeof(areaindextype);
    End Else
    Begin
      Writeln(' Cannot open AREAFILE.FMX');
      Halt;
    End;

  areaindexok := true;
End;
*)

(*
procedure readareaindex;
var
  flash : file;
  i     : word;
begin
  if not areaindexok
  then begin
    close (afx);

    assign (flash, systempath + 'AREAFILE.FMX');
    reset (flash,1);
    afxsize := filesize(flash);

    if maxavail < afxsize
    then begin
{      closewindow;}
      close (flash);
      exit;
    end;

    getmem (afxt, afxsize);
    blockread (flash, afxt^, afxsize, i);
    areanr := afxsize div sizeof(areax);
    close (flash);

    assign (afx, systempath + 'AREAFILE.FMX');
    reset (afx);

    areaindexok := true;
  end;
end;
*)

(*
Procedure AddArea (AREAX : AreaIndexType; AREA : AreaType; sfxt : SystemList);
VAR
{  AFXtmp : AFXptr;}
  i      : byte;
begin
{  Inc(AreaNr);}
{  AFXinx := AreaNr;}

  for i := 1 to 12
  do begin
    area.flow[i].bytes := -1;
    area.flow[i].files := -1;
  end;

  AREAX.Grp := AREA.Grp;
  AREA.TAG := AREAX.TAG;
{  AREA.Active := True;}

  AREAX.AreaRec := FileSize(AF);
  Seek (AF, AREAX.AreaRec);
  BlockWrite (AF, AREA, SizeOf(AREA));
  BlockWrite (AF, sfxt^, AREA.ExportNr * SizeOf(ExportType));

{  Seek (AFX, filesize(AFX));
  Write (AFX, AREAX); }

{  FreeMem (AFXt, SizeOf(AREAX)*(AreaNr-1)); }
  AreaIndexOK := False;
  ReadAreaIndex;
end;
*)

(*
Procedure UpdateArea(VAR AREAX : AreaIndexType; AREA : AreaType; sfxt : SystemList; PrevNr : Byte);
VAR
{  AFXtmp : AFXptr;}
  savenr : Byte;
begin
  if PrevNr <> AREA.ExportNr
  then begin

    { more > fake old nr of exports, write old unactive one }

    savenr        := area.exportnr;
    area.exportnr := prevnr;
    Seek (AF, AREAX.AreaRec);
{    AREA.Active   := False; }
    BlockWrite (AF, AREA, SizeOf(AREA));

    { restore correct nr of exports }

    area.exportnr := savenr;
{    AREA.Active   := True;}
    AREAX.AreaRec := FileSize(AF);
  end;

  AREAX.Grp := AREA.Grp;
  AREA.TAG := AREAX.TAG;

  Seek (AF, AREAX.AreaRec);

  BlockWrite (AF, AREA, SizeOf(AREA));
  BlockWrite (AF, sfxt^, AREA.ExportNr * SizeOf(ExportType));

{  Seek (AFX, AFXinx-1);
  Write (AFX, AREAX);}
end;

*)
(*
Procedure ReadNodeIndex;
Begin
  if nodeindexok then exit;

  close(nfx);

  If MaxAvail < SizeOf(Nfxt^) then
    Begin
      Writeln(' Not enough memory left');
      Halt;
    End Else New(Nfxt);

  For NodeIdx := 1 to 1000 do FillChar(Nfxt^[nodeidx],sizeof(nfxt^[nodeidx]),#0);
  NodeIdx := 0;

  Assign(NFX,systempath+'NODEFILE.FMX');
  {$I-} Reset(NFX,1); {$I+}
  If ioresult = 0 then
    Begin
      BlockRead(Nfx,NFXt^,1000*sizeof(nodeindextype),NodeIdx);
      Close(Nfx);
      NodeIdx := NodeIdx div Sizeof(nodeindextype);

    End Else
    Begin
      writeln(' Cannot open NODEFILE.FMX');
      Halt;
    End;
End;
*)
(*
Procedure ReadNodeIndex;
var
  flash : file;
  i     : word;
begin
  if not nodeindexok
  then begin
    close (nfx);
    assign (flash, systempath + 'NODEFILE.FMX');
    reset (flash,1);
    nfxsize := filesize(flash);

    if maxavail < nfxSize
    then begin
      {closewindow;}
      exit;
    end;
    getmem (nfxt, nfxsize);
    blockread (flash, nfxt^, nfxsize, i);

    close (flash);
    nodenr := nfxsize div sizeof(nodex);

    assign (nfx, systempath + 'NODEFILE.FMX');
    reset (nfx);
    nodeindexok := True;
  end;
end;
*)



Function dayofweek (Day,Month,Year : Integer) : byte;
Var A,B       : Integer;
    Year_Corr : Real;
    julian    : longint;
Begin
  B := 0;
  If Month <= 2 Then
    Begin
      Dec (Year);
      Inc (Month,12);
    End;
  If (Year * 10000.0 + Month * 100.0 + Day >= 15821015.0) Then
    Begin
      A := Year Div 100;
      B := 2 - A + A Div 4;
    End;
  If Year > 0 Then Year_Corr := 0.0 Else Year_Corr := 0.75;

  Julian := longint(Trunc((365.25 * Year - Year_Corr)) +
                    Trunc((30.6001 * (Month+1) + Day + 1720994 + B)));
  DayOfWeek := Integer ((julian+2) Mod 7);
End;




Function NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
CONST
  DS  = 60*60*24; { nr of sec's in day }
VAR
  DT  : DateTime;
  DOW : Word;
  New : Boolean;
begin
  FillChar (DT, Sizeof(DT), 0);

  { if today is allowed, from FMSETUP }

  if D = 0 then
    begin
      new := True;
      GetDate (DT.Year, DT.Month, DT.Day, DOW);
      D := GetUnixDate(DT) - DS;
      if DOW > 0 then Dec(DOW) else DOW := 6;
    end else
    begin
      New := False;
      getdosdate (d, dt);
      dow := dayofweek (dt.day, dt.month, dt.year);
    end;

  case IV of
  Dayly    : begin
               {Inc(d);}
               GetDate (DT.Year, DT.Month, DT.Day, DOW);
               D := GetUnixDate(DT) + DS;
             end;
  Weekly   : begin
               dec(day);
               if dow = day then inc(d,ds*7) else
                 while dow <> day do
                   begin
                     inc(d,ds);
                     if dow < 6 then inc(dow) else dow := 0;
                   end;
             end;
  Weekly2  : begin
               if not New then
                 begin
                   Inc (D, DS*8);  { next week }
                   if DOW < 6 then Inc (DOW) else DOW := 0;
                 end;
               repeat
                 Inc (D, DS);
                 if DOW < 6 then Inc (DOW) else DOW := 0;
               until DOW = Day;
             end;
  Monthly  : repeat
               Inc(D, DS);
               GetDOSdate (D, DT);
             until Day = DT.Day;
  Monthly2 : begin
               if not New then Inc (D, DS*31);  { next month }
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
  Monthly3 : begin
               if not New then Inc (D, DS*62);
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
  end; {case}

  NextDate := D;
end;



function flowstring (flow : flowtype; lastmonth : byte; which : byte) : string;
var   { 0 = nodereport, 1 = areareport, 2 = fmsetup }
  dummy    : byte;
  months   : byte;
  avbytes,
  avfiles  : longint;
begin
  months  := 0;
  avbytes := 0;
  avfiles := 0;

  for dummy := 1 to 12
  do begin
    if flow[dummy].bytes >= 0
    then begin
      avbytes := avbytes + flow[dummy].bytes;
      inc (months);
    end;
    if flow[dummy].files >= 0 then avfiles := avfiles + flow[dummy].files;
  end;
  if months > 0 then
    begin
      avbytes  := round((avbytes/months)/1024);
      avfiles  := round(avfiles/months);
      case which of
       0 : begin
             if (avbytes / 1024) > 10 then
               begin
                 avbytes := round(avbytes/1024);
                 flowstring := ' '+int_to_str(avbytes) + 'Mb in ' + int_to_str(avfiles) + ' files.';
               end else
                 flowstring := ' '+int_to_str(avbytes) + 'Kb in ' + int_to_str(avfiles) + ' files.';
           end;
       1 : begin
             if (avbytes / 1024) > 10 then
               begin
                 avbytes := round(avbytes/1024);
                 flowstring := ' (' + int_to_str(avbytes) + 'Mb in ' + int_to_str(avfiles) + ' files)';
               end else
                 flowstring := ' (' + int_to_str(avbytes) + 'Kb in ' + int_to_str(avfiles) + ' files)';
           end;
       2 : begin
             flowstring := int_to_str(avbytes)+' '+int_to_str(avfiles)+' '+int_to_str(months);
           end;
      end;
    end else
    begin
      case which of
       0 : flowstring := ' nothing';
       1 : flowstring := ' (no flow)';
       2 : flowstring := '';
      end;
    end;
end;


END.

