/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   UED.H Main program header                           All Rights Reserved 
  ;*/

/* Denote a BETA version, activates expiry */
/* #define BETAVERSION */

#if defined(BETAVERSION)
    #define VERSION "3.00.B8"
#else
    #define VERSION "3.01   "
#endif

#define EXPIRE_YEAR 1997
#define EXPIRE_MNTH 7 /* Jul */
#define EXPIRE_STR  "   1st Jul 97"

#define UNREGWRITELIMIT 5

/* Main loop status */
#define STAT_NONE 0x0000
#define STAT_QUIT 0x0001
#define STAT_BROW 0x0002
#define STAT_EDIT 0x0004

/* Return status from popup menu */
#define MENU_NONE 0x0000
#define MENU_QUIT 0x0001
#define MENU_NEWR 0x0002
#define MENU_PACK 0x0004
#define MENU_SORT 0x0008
#define MENU_CFGS 0x0010
#define MENU_GDEL 0x0020

#define DATE_OZ         0                       /* Australian date display */
#define DATE_US         1                       /* American date display   */
#define DATE_JP         2                       /* Jap date display        */

#define _PRIVS_NUM 12 /* Number of default Max privs */
#define _PROT_NUM  7
#define _HELP_NUM  3
#define _SORT_NUM  16
#define _PROFILES  16                           /* Number of Profiles      */
#define XFLAG_EXPDATREL  0x0080

/* DataBase update tone */
#define TONEUPDATE()   if(!UedCfg.NoSound)DosBeep(402,60)
/* Error tone */
#define TONEERROR()    if(!UedCfg.NoSound)DosBeep(268,500)
/* Search found tone */
#define TONEFOUND()    if(!UedCfg.NoSound)DosBeep(536,60)

#define WINSHADOW() WinShadow(DGREY|_BLACK)

/**/

#pragma pack(1)
struct __priv {
    PCHAR name;
    SHORT priv;
};
struct __prot {
    PCHAR name;
    CHAR value;
};
struct __video {
    char *name;
    unsigned char value;
};
struct __help {
    char *name;
    unsigned char value;
};
typedef struct _lkey {
    USHORT low;
    USHORT high;
} LKEY;
#define lkey(a) (((LKEY *)(&(a)))->low)
#define hkey(a) (((LKEY *)(&(a)))->high)

typedef struct _profile {       /* UpGrade profile structure            */
    CHAR Title[43];             /* Profile title                        */
    BOOL FlagPriv;              /* Flag (TRUE/FALSE) priv set           */
    USHORT Priv;                /* Access level                         */
    BOOL FlagCredit;            /* Flag (TRUE/FALSE) set credit         */
    USHORT Credit;              /* Matrix credit, in cents              */
    BOOL FlagExp;               /* Flag (TRUE/FALSE) set expiry         */
    USHORT XpPriv;              /* Expiry set demote priv               */
    SCOMBO XpDate;              /* Expiry set Bit-mapped date           */
    ULONG XpMins;               /* Expiry set minutes                   */
    UCHAR XpFlag;               /* Expiry set flags for expiry          */
    USHORT XpMths;              /* Expiry set relative date in months   */
    CHAR Keys[34];              /* Key flags                            */
} PROFILE;

typedef struct _globdel {       /* Global delete structure              */
    CHAR PrivFlag[16];          /* Priv process flags          gdelpriv */
    USHORT PrivDays[16];        /* Days each priv              gdeldays */
    USHORT PrivCalls[16];       /* Calls each priv            gdelcalls */
    BOOL FlagXpSetDel;          /* Expiry set delete flag    gdelexpiry */
    BOOL FlagCrdtSetDel;        /* Credit set delete flag    gcrtexpiry */
    CHAR Keys[34];              /* Key flags                   gdelkeys */
} GLOBDEL;

typedef struct _globexp {       /* Global expiry structure              */
    CHAR gExpPriv[16];          /* Global expiry set priv process flags */
    UCHAR xp_flag;              /* Global expiry set flags for expiry   */
    SCOMBO xp_date;             /* Global expiry set Bit-mapped date    */
    ULONG xp_mins;              /* Global expiry set minutes            */
    USHORT xp_priv;             /* Global expiry set demote priv        */
    CHAR gExpKeys[32];          /* Global expiry set key flags          */
    BOOL gCdtExpSet;            /* Global expiry set credit flag        */
    BOOL gOvrExpSet;            /* Global expiry set overwrite flag     */
} GLOBEXP;

typedef struct _globkey {       /* Global keys structure                */
    CHAR gKeyPriv[16];          /* Global keys set priv process flags   */
    CHAR gKeyKeys[32];          /* Global keys set key flags            */
    BOOL gKeyExpSet;            /* Global keys set expiry flag          */
    BOOL gKeyCdtSet;            /* Global keys set credit flag          */
} GLOBKEY;

typedef struct _globcdt {       /* Global credit/debit structure        */
    CHAR gCdtPriv[16];          /* Global credit priv process flags     */
    USHORT gCdtVal[16];         /* Global credit value each priv        */
    CHAR gDbtPriv[16];          /* Global debit priv process flags      */
    USHORT gDbtVal[16];         /* Global debit value each priv         */
    CHAR gcdtkeys[32];          /* Global credit/debit key flags        */
    BOOL gCdtExpiry;            /* Global credit/debit expiry set flag  */
} GLOBCDT;

typedef struct _uedcfg {
    CHAR MaxPath[140];             /* Maximus directory                    */
    CHAR PrmFile[40];              /* Maximus Prm file name                */
    CHAR UserFile[40];             /* User file name                       */
    CHAR AreaFile[40];             /* Message area data file name          */
    SHORT DateFormat;              /* Date display type                    */
    SHORT NoSound;                 /* No sound flag                        */
    SHORT SortTyp;                 /* Initial sort method                  */
    SHORT SortDir;                 /* Initial sort direction               */
    SHORT Maintenance;             /* Debug/Maintenance flag               */
    SHORT DefaultScreen;           /* Default screen (EDIT/BROWSE)         */
    CHAR key[32][16];              /* Key strings                          */
    CHAR lang[8][10];              /* Language strings                     */
    CHAR comp[16][10];             /* Compression strings                  */
    SHORT PrivNum;                 /* Access levels count                  */
    CHAR Priv[16][10];             /* Access strings                       */
    USHORT PrivValue[16];          /* Access values                        */
    CHAR PrivDesc[16][21];         /* Access descriptions                  */
    SHORT ShowPwd;                 /* Show unencrypted passwords flag      */
    PROFILE Profile[_PROFILES];    /* UpGrade profiles                     */
    GLOBDEL GlobDel;               /* Global Delete structure              */
    GLOBEXP GlobExp;               /* Global Expiry structure              */
    GLOBKEY GlobKey;               /* Global Keys structure                */
    GLOBCDT GlobCdt;               /* Global Credit/Debit structure        */
    BOOL NoPwEncrypt;              /* No password encryption flag          */
    CHAR RegCode[40];              /* Registration code                    */
    CHAR RegName[40];              /* Registration name                    */
    CHAR RegCity[40];              /* Registration location                */
} UEDCFG;
#pragma pack()

/**/

/* UED.C */
extern USHORT MainStat;
extern USHORT MenuStat;
extern PUDEF Ud;
extern SHORT CurRec;
extern SHORT nattr;
extern SHORT battr;
extern SHORT wattr;
extern SHORT qattr;
extern SHORT fattr;
extern SHORT hattr;
extern SHORT sattr;
extern SHORT selbar;
extern SHORT nosel;
extern SHORT battr2;
extern SHORT wattr2;
extern SHORT qattr2;
extern SHORT fattr2;
extern SHORT hattr2;
extern SHORT sattr2;
extern SHORT selbar2;
extern SHORT nosel2;
extern SHORT bdr;
extern CHAR Yes[];
extern CHAR No[];
extern CHAR On[];
extern CHAR Off[];
extern BOOL IsRegistered;
extern SHORT RegWriteCount;

/* CFG.C */
extern UEDCFG UedCfg;                   /* UED CFG struct                   */
extern CHAR CfgFile[160];               /* Configuration file path & name   */
extern SHORT PfPtr;                     /* Current profile pointer          */
extern SHORT CfgChanged;                /* Cfg changed flag                 */

/* UTIL.C */
extern struct __priv _privs[];
extern struct __prot _prot[];
extern struct __video _video[];
extern struct __help _help[];
extern CHAR KeyNum[32];

/* SORT.C */
extern PCHAR SortStr[_SORT_NUM];
extern CHAR SortChr[_SORT_NUM];
extern SHORT SortTyp;
extern SHORT SortDir;

/**/

/* UED.C */
VOID PASCAL Exit (SHORT Status);
VOID PASCAL TheMenu (VOID);
VOID ShowVer (VOID);
SHORT PASCAL TitleWindow (SHORT offset);
SHORT PASCAL UpGrde (VOID);

/* EDIT.C */
VOID EditScreen (VOID);
VOID StringToMD5 (PCHAR szString, PCHAR pbMD5);

/* BROWSE.C */
VOID BrowseScreen (VOID);

/* GLOB.C */
VOID GlobalDelete (VOID);
VOID GlobalExp (VOID);
VOID GlobalKeys (VOID);
VOID GlobalCdt (VOID);

/* STAT.C */
VOID StatGlob (VOID);
VOID StatPriv (VOID);
VOID StatBest (VOID);
VOID StatCall (VOID);
VOID StatUpld (VOID);
VOID StatDnld (VOID);
VOID PASCAL StatFree (VOID);

/* SEARCH.C */
SHORT PASCAL UsrSearch (VOID);

/* SORT.C */
SHORT PASCAL Sort (SHORT WinOffset);

/* CFG.C */
VOID PASCAL CfgInit (VOID);
SHORT PASCAL CfgRead (VOID);
SHORT PASCAL GetPrmInfo (VOID);
VOID PASCAL CfgCheck (VOID);
VOID CfgWrite (VOID);
VOID CfgReg (VOID);
VOID CfgPath (VOID);
VOID CfgName (VOID);
VOID CfgDate (VOID);
VOID CfgSound (VOID);
VOID CfgSort (VOID);
VOID CfgView (VOID);
VOID CfgDebug (VOID);
VOID CfgLabel (VOID);
VOID CfgUpg (VOID);

/* UTIL.C */
SHORT PASCAL YesNo (PCHAR Msg, SHORT srow, SHORT scol, SHORT erow, SHORT ecol);
VOID PASCAL Mesage (PCHAR message, SHORT srow, SHORT scol, SHORT erow, SHORT ecol);
PCHAR PASCAL ShowDate (SCOMBO *pt, PCHAR str);
VOID PASCAL GetDate (SCOMBO *pt, PCHAR str);
PCHAR PASCAL ShowDOB (UCHAR Dd, UCHAR Mm, USHORT Yy, PCHAR str);
VOID PASCAL GetDOB (PUCHAR Dd, PUCHAR Mm, PUSHORT Yy, PCHAR str);
PCHAR PASCAL ShowTime (SCOMBO *pt, PCHAR str);
VOID PASCAL GetTime (SCOMBO *pt, PCHAR str);
PCHAR PASCAL ShowPriv (USHORT priv);
SHORT PASCAL GetPriv (USHORT priv);
SHORT PASCAL GetXPriv (USHORT priv);
PCHAR PASCAL ShowProt (CHAR prot);
SHORT PASCAL GetProt (CHAR prot);
PCHAR PASCAL ShowKeys (ULONG keys);
PCHAR PASCAL ShowVideo (UCHAR video);
SHORT PASCAL GetVideo (UCHAR video);
PCHAR PASCAL ShowHelp (UCHAR help);
SHORT PASCAL GetHelp (UCHAR help);
VOID PreMenu (VOID);
PCHAR PASCAL RemUS (PCHAR Str);
PCHAR PASCAL AddUS (PCHAR Str);

/**/

