/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   STAT.C Statistics functions                         All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <signal.h>
#include <dos.h>
#include <ctype.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "prm.h"
#include "ued.h"

#define R_SZE_NAME 25 /* For the stat array */
typedef struct _stats {                /* User file stats                  */
    LONG calls;                        /* Total calls to the system        */
    ULONG uploads;                     /* Total uploads to the system      */
    ULONG dnloads;                     /* Total dnloads to the system      */
    LONG privcallsno[16];              /* Total calls count per priv level */
    CHAR topcallers[10][R_SZE_NAME+1]; /* Top 10 callers names pointer     */
    CHAR topuploads[10][R_SZE_NAME+1]; /* Top 10 uploaders names ptr       */
    CHAR topdnloads[10][R_SZE_NAME+1]; /* Top 10 dnloaders names ptr       */
    CHAR topusers[10][R_SZE_NAME+1];   /* Top 10 users names ptr           */
    USHORT tcallers[10];               /* Top 10 callers call number       */
    ULONG tuploads[10];                /* Top 10 uploaders upload count    */
    ULONG tdnloads[10];                /* Top 10 dnloaders dnload count    */
    USHORT tusers[10];                 /* Top 10 users index               */
    LONG tusersdat[10][3];             /* Top 10 users data                */
} STATS;

/**/

STATS *stats=NULL;                     /* User file global stats           */

static SHORT PASCAL StatScan (VOID);
static SHORT PASCAL UserIdx (struct _usr *tusr);
static SHORT PASCAL StatLabels (SHORT ctl);
static VOID PASCAL WaitClose (VOID);

/**/
/*
Ŀ
  GLOBAL STATISTICS      Total Records: 00000  
Ĵ
                                               
  Total Calls: 00000000  Average Calls: 00000  
                                               
  Total Uplds: 00000000  Average Uplds: 00000  
                                               
  Total Dnlds: 00000000  Average Dnlds: 00000  
                                               

*/
VOID StatGlob (VOID)
{
    CHAR records[16], calls[16], uploads[16], dnloads[16];
    CHAR avcalls[16], avuploads[16], avdnloads[16];

    if(!StatScan()) return;

    sprintf(records,"%5u",Ud->Unum);
    sprintf(calls,"%8lu",stats->calls);
    sprintf(uploads,"%8lu",stats->uploads);
    sprintf(dnloads,"%8lu",stats->dnloads);
    sprintf(avcalls,"%5lu",Ud->Unum?stats->calls/(Ud->Unum):0);
    sprintf(avuploads,"%5lu",Ud->Unum?stats->uploads/(Ud->Unum):0);
    sprintf(avdnloads,"%5lu",Ud->Unum?stats->dnloads/(Ud->Unum):0);

    if(WinOpen(10,16,20,64,bdr,WHITE|_CYAN,WHITE|_CYAN)) {
        WINSHADOW();
        WinPrintS(0, 2,WHITE|_CYAN,"GLOBAL STATISTICS");
        WinPrintS(0,25,BLUE|_CYAN,"Total Records:");
        WinPrintS(0,40,BLUE|_CYAN,records);
        WinHLine(1,0,48,bdr,WHITE|_CYAN);
        WinPrintS(3, 2,BLUE|_CYAN,"Total Calls:");
        WinPrintS(3,15,BLUE|_CYAN,calls);
        WinPrintS(3,25,BLUE|_CYAN,"Average Calls:");
        WinPrintS(3,40,BLUE|_CYAN,avcalls);
        WinPrintS(5, 2,BLUE|_CYAN,"Total Uplds:");
        WinPrintS(5,15,BLUE|_CYAN,uploads);
        WinPrintS(5,25,BLUE|_CYAN,"Average Uplds:");
        WinPrintS(5,40,BLUE|_CYAN,avuploads);
        WinPrintS(7, 2,BLUE|_CYAN,"Total Dnlds:");
        WinPrintS(7,15,BLUE|_CYAN,dnloads);
        WinPrintS(7,25,BLUE|_CYAN,"Average Dnlds:");
        WinPrintS(7,40,BLUE|_CYAN,avdnloads);
        WaitClose();
    }
}

/**/
/*
Ŀ
  CALL PERCENTAGES                Total calls: 00000000  
Ĵ
  Level      Calls  Percent   Level      Calls  Percent  
                                                         
  SysOp      00000   100 %    Limited    00000   100 %   
  AsstSysOp  00000   100 %    Disgrace   00000   100 %   
  Clerk      00000   100 %    Twit       00000   100 %   
  Extra      00000   100 %    Hidden     00000   100 %   
  Favored    00000   100 %                               
  Privel     00000   100 %                               
  Worthy     00000   100 %                               
  Normal     00000   100 %                               
                                                         

*/
VOID StatPriv (VOID)
{
    SHORT i;
    CHAR buf[30];

    if(!StatScan()) return;

    if(WinOpen(6,10,20,68,bdr,WHITE|_CYAN,WHITE|_CYAN)) {
        WINSHADOW();
        WinPrintS(0, 2,WHITE|_CYAN,"CALL PERCENTAGES");
        WinPrintS(0,34,BLUE|_CYAN,"Total calls:");
        sprintf(buf,"%8lu",stats->calls); WinPrintS(0,47,BLUE|_CYAN,buf);
        WinHLine (1,0,57,bdr,WHITE|_CYAN);
        WinPrintS(2, 2,WHITE|_CYAN,"Level      Calls  Percent");
        WinPrintS(2,30,WHITE|_CYAN,"Level      Calls  Percent");

        for(i=0;i<8&&i<UedCfg.PrivNum;i++) {
            WinPrintS(i+4,2,BLUE|_CYAN,UedCfg.Priv[i]);
            sprintf(buf,"%5lu",stats->privcallsno[i]);
            WinPrintS(i+4,13,BLUE|_CYAN,buf);
            sprintf(buf,"%3lu",stats->calls?stats->privcallsno[i]*100L/stats->calls:0);
            WinPrintS(i+4,21,BLUE|_CYAN,buf);
            WinPrintS(i+4,25,BLUE|_CYAN,"%");
        }
        for(i=8;i<16&&i<UedCfg.PrivNum;i++) {
            WinPrintS(i-4,30,BLUE|_CYAN,UedCfg.Priv[i]);
            sprintf(buf,"%5lu",stats->privcallsno[i]);
            WinPrintS(i-4,41,BLUE|_CYAN,buf);
            sprintf(buf,"%3lu",stats->calls?stats->privcallsno[i]*100L/stats->calls:0);
            WinPrintS(i-4,49,BLUE|_CYAN,buf);
            WinPrintS(i-4,53,BLUE|_CYAN,"%");
        }
        WaitClose();
    }
}

/**/

VOID StatBest (VOID)
{
/*
Ŀ
  TOP SYSTEM USERS                                          
Ĵ
  No  Name                       Calls Upload Dnload Index  
  01  1234567890123456789012345  00000 000000 000000 00000  
  02                                                        
  03                                                        
  04                                                        
  05                                                        
  06                                                        
  07                                                        
  08                                                        
  09                                                        
  10                                                        

*/
    SHORT i;
    CHAR buf[30];

    if(!StatScan()) return;

    if(!WinOpen(6,9,20,70,bdr,WHITE|_CYAN,WHITE|_CYAN)) return;
    WINSHADOW();
    WinPrintS(0, 2,WHITE|_CYAN,"TOP SYSTEM USERS");
    WinHLine(1,0,60,bdr,WHITE|_CYAN);
    WinPrintS(2, 2,WHITE|_CYAN,"No  Name                       Calls Upload Dnload Index");
    for(i=0;i<10;i++) {
        sprintf(buf,"%02u",i+1); WinPrintS(i+3,2,BLUE|_CYAN,buf);
        WinPrintS(i+3,6,BLUE|_CYAN,stats->topusers[i]);
        sprintf(buf,"%5lu",stats->tusersdat[i][0]);
        WinPrintS(i+3,33,BLUE|_CYAN,buf);
        sprintf(buf,"%6lu",stats->tusersdat[i][1]);
        WinPrintS(i+3,39,BLUE|_CYAN,buf);
        sprintf(buf,"%6lu",stats->tusersdat[i][2]);
        WinPrintS(i+3,46,BLUE|_CYAN,buf);
        sprintf(buf,"%5u",stats->tusers[i]);
        WinPrintS(i+3,53,BLUE|_CYAN,buf);
    }

    WaitClose();
}

/**/

VOID StatCall (VOID)
{
    if(!StatScan()) return;
    if(StatLabels(0)) {
        WinPrintS(0, 2,WHITE|_CYAN,"TOP TEN CALLERS");
        WinPrintS(2,34,WHITE|_CYAN,"Calls");
        WaitClose();
    }
}

/**/

VOID StatUpld (VOID)
{
    if(!StatScan()) return;
    if(StatLabels(1)) {
        WinPrintS(0, 2,WHITE|_CYAN,"TOP TEN UPLOADERS");
        WinPrintS(2,34,WHITE|_CYAN,"Value");
        WaitClose();
    }
}

/**/

VOID StatDnld (VOID)
{
    if(!StatScan()) return;
    if(StatLabels(2)) {
        WinPrintS(0, 2,WHITE|_CYAN,"TOP TEN DNLOADERS");
        WinPrintS(2,34,WHITE|_CYAN,"Value");
        WaitClose();
    }
}

/**/

VOID PASCAL StatFree (VOID)
{
    if(stats!=NULL) { free(stats); stats=NULL; }
}

/**/
/*
Ŀ
  TOP TEN CALLERS                       
Ĵ
  No  Name                       Calls  
  01  1234567890123456789012345 000000  
  02                                    
  03                                    
  04                                    
  05                                    
  06                                    
  07                                    
  08                                    
  09                                    
  10                                    

*/
static SHORT PASCAL StatLabels (SHORT ctl)
{
    SHORT i;
    CHAR buf[30];

    if(!WinOpen(6,19,20,61,bdr,WHITE|_CYAN,WHITE|_CYAN)) return 0;
    WINSHADOW();
    WinHLine(1,0,42,bdr,WHITE|_CYAN);
    WinPrintS(2, 2,WHITE|_CYAN,"No  Name");
    for(i=0;i<10;i++) {
        sprintf(buf,"%02u",i+1); WinPrintS(i+3,2,BLUE|_CYAN,buf);
        switch(ctl) {
        case 0:
            WinPrintS(i+3,6,BLUE|_CYAN,stats->topcallers[i]);
            sprintf(buf,"%8u",stats->tcallers[i]);
            break;
        case 1:
            WinPrintS(i+3,6,BLUE|_CYAN,stats->topuploads[i]);
            sprintf(buf,"%8lu",stats->tuploads[i]);
            break;
        case 2:
            WinPrintS(i+3,6,BLUE|_CYAN,stats->topdnloads[i]);
            sprintf(buf,"%8lu",stats->tdnloads[i]);
            break;
        }
        buf[8]='\0';
        WinPrintS(i+3,31,BLUE|_CYAN,buf);
    }

    return 1;
}

/**/

static SHORT PASCAL StatScan (VOID)
{
    USHORT count, uidx;
    SHORT i, j;
    CHAR tbuf[30];              /* String display temp buffer   */

    if(stats!=NULL) return 1; /* Already scanned */

    stats=(STATS *)malloc(sizeof(STATS));
    if(stats==NULL) return 0;
    memset(stats,'\0',sizeof(STATS));

    for(i=0;i<10;i++) { /* Setup stats */
        strcpy((stats->topcallers)[i],"       Blank Entry       ");
        strcpy((stats->topuploads)[i],"       Blank Entry       ");
        strcpy((stats->topdnloads)[i],"       Blank Entry       ");
        strcpy((stats->topusers)[i],  "       Blank Entry       ");
    }

    /* Open the searching status window */
    if(!WinOpen(11,22,13,56,bdr,WHITE|_RED,WHITE|_RED)) {
        StatFree();
        return 0;
    }
    WINSHADOW();
    WinPrintS(0,5,WHITE|_RED,"Scanning Record       1");

    /* Scan all records */
    for(count=0;count<Ud->Unum;count++) {

        if(!((count+1)%100)) {
            sprintf(tbuf,"%5u",count+1);
            WinPrintS(0,23,WHITE|_RED,tbuf);
        }

        if(UserRead(Ud,count)) break;

        stats->calls+=Ud->Usr->times;
        stats->uploads+=Ud->Usr->up;
        stats->dnloads+=Ud->Usr->down;
        stats->privcallsno[GetPriv(Ud->Usr->priv)]+=Ud->Usr->times;

        for(j=0;j<10;j++) { /* Scan through the top ten list */
            if(Ud->Usr->times>stats->tcallers[j]) { /* Do top callers */
                for(i=9;i>j;i--) {
                    stats->tcallers[i]=stats->tcallers[i-1];
                    strcpy((stats->topcallers)[i],(stats->topcallers)[i-1]);
                }
                stats->tcallers[j]=Ud->Usr->times;
                strncpy((stats->topcallers)[j],Ud->Usr->name,R_SZE_NAME);
                (stats->topcallers)[j][R_SZE_NAME]='\0';
                break;
            }
        }
        for(j=0;j<10;j++) { /* Scan throught the top uploaders */
            if(Ud->Usr->up>stats->tuploads[j]) { /* Do uploaders */
                for(i=9;i>j;i--) {
                    stats->tuploads[i]=stats->tuploads[i-1];
                    strcpy((stats->topuploads)[i],(stats->topuploads)[i-1]);
                }
                stats->tuploads[j]=Ud->Usr->up;
                strncpy((stats->topuploads)[j],Ud->Usr->name,R_SZE_NAME);
                (stats->topuploads)[j][R_SZE_NAME]='\0';
                break;
            }
        }
        for(j=0;j<10;j++) { /* Scan throught the downloaders list */
            if(Ud->Usr->down>stats->tdnloads[j]) { /* Do downloaders */
                for(i=9;i>j;i--) {
                    stats->tdnloads[i]=stats->tdnloads[i-1];
                    strcpy((stats->topdnloads)[i],(stats->topdnloads)[i-1]);
                }
                stats->tdnloads[j]=Ud->Usr->down;
                strncpy((stats->topdnloads)[j],Ud->Usr->name,R_SZE_NAME);
                (stats->topdnloads)[j][R_SZE_NAME]='\0';
                break;
            }
        }
        uidx=UserIdx(Ud->Usr);
        for(j=0;j<10;j++) { /* Scan through the top ten users list */
            if(uidx>stats->tusers[j]) { /* Do top callers */
                for(i=9;i>j;i--) {
                    stats->tusers[i]=stats->tusers[i-1];
                    stats->tusersdat[i][0]=stats->tusersdat[i-1][0];
                    stats->tusersdat[i][1]=stats->tusersdat[i-1][1];
                    stats->tusersdat[i][2]=stats->tusersdat[i-1][2];
                    strcpy((stats->topusers)[i],(stats->topusers)[i-1]);
                }
                stats->tusers[j]=uidx;
                stats->tusersdat[j][0]=(long)Ud->Usr->times;
                stats->tusersdat[j][1]=Ud->Usr->up;
                stats->tusersdat[j][2]=Ud->Usr->down;
                strncpy((stats->topusers)[j],Ud->Usr->name,R_SZE_NAME);
                (stats->topusers)[j][R_SZE_NAME]='\0';
                break;
            }
        }
    }

    WinClose(); /* Close window */
    return 1;
}

/**/

#define WMAXVAL 65535L
static SHORT PASCAL UserIdx (struct _usr *tusr)
{
    long u_up, u_down, result;

    /* Normalize */
    if((u_up=tusr->up)>WMAXVAL) u_up=WMAXVAL;
    if((u_down=tusr->down)>WMAXVAL) u_down=WMAXVAL;

    result=((long)tusr->times*400L/WMAXVAL) +
           (u_up*300L/WMAXVAL) -
           (u_down*100L/WMAXVAL);

    return (SHORT)result<0?0:(SHORT)result;
}

/**/

static VOID PASCAL WaitClose (VOID)
{
    MenuWaitKey(); WinClose();
}

/**/

