/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   PRM.C Maximus PRM file routines                     All Rights Reserved 
  ;*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#define INCL_DOS
#include <os2.h>

#include "prm.h"

#define PRM(a) (offsets+(prm->a))
#define MAX_PRM_HEAP 4096

/**/

#pragma pack(1)

/* Max Prm file */
#define CTL_VER             9   /* Version number of BBS.PRM               */
#define OFS USHORT
#define MAX_DRIVES         26   /* Maximum number of drives on system      */
#ifndef CHAR_BITS
    #define CHAR_BITS       8   /* Number of bits in a 'char'              */
#endif
#define DRIVESAVE ((MAX_DRIVES/CHAR_BITS)+1)
#define MAX_LANG           8       /* Max. number of possible languages    */
#define MAX_YELL          10       /* Max number of yell slots             */
#define MAX_EXTERNP       16       /* max. number of external programs     */
#define ALIAS_CNT         15       /* number of matrix addresses           */
/** Definitions for the `prm.flags' variable **/
#define FLAG_keyboard    0x0001 /* If local mode is on by default         1*/
#define FLAG_watchdog    0x0002 /* Use watchdog for outside commands      2*/
#define FLAG_snoop       0x0004 /* If snoop is on by default              3*/
#define FLAG_norname     0x0008 /* If we should disable ^aREALNAME kludge 4*/
#define FLAG_close_sf    0x0010 /* Close all standard files for O)utside  5*/
#define FLAG_break_clr   0x0020 /* Send break to dump modem's buffer      6*/
#define FLAG_log_echo    0x0040 /* Log user-written echomail              7*/
#define FLAG_no_ulist    0x0080 /* User can't list users in msg           8*/
#define FLAG_no_magnet   0x0100 /* Disable the MagnEt editor              9*/
#define FLAG_autodate    0x0200 /* Automatically search directory for     0*/
                                /* file size & date.                       */
#define FLAG_statusline  0x0400 /* If SysOp wants a status line on screen 1*/
#define FLAG_ask_phone   0x0800 /* If we should ask user for phone number 2*/
#define FLAG_noyell      0x1000 /* If yell is toggled on or off by Sysop  3*/
#define FLAG_lbaud96     0x2000 /* If we should use 9600 for local caller 4*/
#define FLAG_alias       0x4000 /* If running a system which allows alias 5*/
#define FLAG_ask_name    0x8000 /* If we should ask user for their alias  6*
                                 * name too -- Only needed if using        *
                                 * FLAG_alias.                             */
#define FLAG2_gate       0x0001 /* Gate netmail messages, use zonegate!   1*/
#define FLAG2_has_snow   0x0002 /* Video adapter is slow CGA w/snow       2*/
#define FLAG2_CHKRIP     0x0004 /* Check for RIP setting on login         3*/
#define FLAG2_ltimeout   0x0008 /* Local keyboard timeout                 4*/
#define FLAG2_noshare    0x0010 /* SHARE not used -- don't lock files!    5*/
#define FLAG2_CAPTURE    0x0020 /* Sysop chat capture automatically on    6*/
#define FLAG2_NOCRIT     0x0040 /* Don't use internal crit.err handler    7*/
#define FLAG2_CHECKDUPE  0x0080 /* Check for duplicate uploads            8*/
#define FLAG2_CHECKEXT   0x0100 /* Compare extension for duplicate uploads9*/
#define FLAG2_GLOBALHB   0x0200 /* Global high bit allowed               10*/
#define FLAG2_1NAME      0x0400 /* Allow one-word names                  11*/
#define FLAG2_UMSGID     0x0800 /* Display UMSGIDs to user instead of    12*/
                                /* virtual message numbers.                */
#define FLAG2_SWAPOUT    0x1000 /* Swap to disk when shelling            13*/
#define FLAG2_NOENCRYPT  0x2000 /* Disable password encryption           14*/
#define FLAG2_STRICTXFER 0x4000 /* Kick users off in file transfers if   15*/
                                /* time limit exceeded.                    */
#define FLAG2_CHKANSI    0x8000 /* Check for ANSI setting on login       16*/
#define LOG_TERSE       0x02
#define LOG_VERBOSE     0x04
#define LOG_TRACE       0x06
#define LOG_terse       LOG_TERSE
#define LOG_verbose     LOG_VERBOSE
#define LOG_trace       LOG_TRACE
#define MULTITASKER_AUTO        -1
#define MULTITASKER_NONE        0
#define MULTITASKER_DOUBLEDOS   1
#define MULTITASKER_DESQVIEW    2
#define MULTITASKER_TOPVIEW     3
#define MULTITASKER_MLINK       4
#define MULTITASKER_MSWINDOWS   5
#define MULTITASKER_OS2         6
#define MULTITASKER_PCMOS       7
#define MULTITASKER_NT          8
#define MULTITASKER_auto        MULTITASKER_AUTO
#define MULTITASKER_none        MULTITASKER_NONE
#define MULTITASKER_doubledos   MULTITASKER_DOUBLEDOS
#define MULTITASKER_desqview    MULTITASKER_DESQVIEW
#define MULTITASKER_topview     MULTITASKER_TOPVIEW
#define MULTITASKER_mlink       MULTITASKER_MLINK
#define MULTITASKER_mswindows   MULTITASKER_MSWINDOWS
#define MULTITASKER_os2         MULTITASKER_OS2
#define MULTITASKER_pcmos       MULTITASKER_PCMOS
#define MULTITASKER_nt          MULTITASKER_NT
/* Special values for the character set byte */
#define CHARSET_SWEDISH   0x01
#define CHARSET_CHINESE   0x02
#define XTERNEXIT       0x40      /* If external protocl has erlvl exit */
#define XTERNBATCH      0x80      /* If protocol can do batch transfers */
#define NLVER_5         5
#define NLVER_6         6
#define NLVER_7         7
#define NLVER_FD       32
typedef struct _netaddr {
    USHORT zone;
    USHORT net;
    USHORT node;
    USHORT point;
} NETADDR;
#define PRM_HEAP_START sysop
#define PRM_HEAP_END caller_log
struct m_pointers {
 UCHAR   id;                     /* Always equal to 'M'               STABLE  */
 UCHAR   version;                /* for safety                        STABLE  */
 USHORT  heap_offset;            /* OFFSET OF BEGINNING OF HEAP!      STABLE  */
 UCHAR   task_num;               /* for multi-tasking systems         STABLE  */
 SHORT   com_port;               /* Com1=0, Com2=1, etc               STABLE  */
 UCHAR   noise_ok;               /* If yell noise is currently on     STABLE  */
 UCHAR   video;                  /* Mode for local video display              */
 UCHAR   log_mode;               /* What style of logging to use              */
 USHORT  max_baud;               /* fastest speed we can use                  */
 CHAR    multitasker;            /* flag for DoubleDos (see below)            */
 UCHAR   nlver;                  /* Which nodelist version we use (NLVER_XXX) */
 SHORT   rsvd_1[2];              /* Reserved                                  */
 UCHAR   exit_val;               /* Erl to use after caller if none of below  */
 UCHAR   edit_exit;              /* erl to use after matrix mail written      */
 UCHAR   echo_exit;              /* ERRORLEVEL for after inbound echomail     */
 UCHAR   local_exit;             /* Errorlevel after entering local msgs      */
 SHORT   carrier_mask;           /* Modem information                         */
 SHORT   handshake_mask;         /* Modem information                         */
 USHORT  logon_priv;             /* Access level for new users                */
 USHORT  logon_time;             /* time to give for logons                   */
 USHORT  min_baud;               /* minimum baud to get on-line               */
 USHORT  speed_graphics;         /* min baud for graphics                     */
 UCHAR   auto_kill;              /* RECD PVT msgs. 0=no 1=ask 2=yes           */
 USHORT  ctla_priv;              /* Priv to see CONTROL-A lines in messages   */
 USHORT  seenby_priv;            /* Min priv to see SEEN-BY line              */
 USHORT  pvt_priv;               /* Min priv to read pvt msgs                 */
 USHORT  msg_ask[16];            /* Array of privs. for message attr ask's    */
 USHORT  msg_assume[16];         /* Array of privs. for message attr assume's */
 USHORT  msg_fromfile;           /* Priv. for doing message from file         */
 USHORT  speed_rip;              /* min baud for rip graphics                 */
 UCHAR   rsvd1[2];               /* used to be high_msgarea, begin_msgarea    */
 USHORT  unlisted_priv;          /* Priv needed to send to unlisted node      */
 SHORT   unlisted_cost;          /* Charge to send to unlisted node           */
 USHORT  mc_reply_priv;          /* Priv to reply to msg with mailchecker     */
 USHORT  mc_kill_priv;           /* Priv to kill msg with mailchecker         */
 SHORT   date_style;             /* Used for FILES.BBS display                */
 USHORT  rsvd20;                 /* Reserved (used to be dlall_priv)          */
 USHORT  rsvd21;                 /* Reserved (used to be ulbbs_priv)          */
 ULONG   k_free;                 /* K free before we let a user upload        */
 USHORT  rsvd7;                  /* reserved - used to be upload reward       */
 USHORT  rsvd_3;                 /* Obsolete - now in class information       */
 UCHAR   rsvd2[4];               /* used to be high_filearea, begin_filearea  */
 NETADDR address[ALIAS_CNT];
 UCHAR   rsvd3[60];              /* Reserved by Maximus for future use        */
 UCHAR   rsvd_2[168];
 SHORT   protoexit;              /* Errorlevel for protocol exit              */
 CHAR    protoflag[MAX_EXTERNP];
 USHORT  flags;
 USHORT  flags2;
 USHORT  flags3;
 USHORT  flags4;
 CHAR    drive_save[DRIVESAVE];
 UCHAR   fbbs_margin;            /* Margin for wrapping FILES.BBS comments    */
 UCHAR   kill_attach;            /* Kill file attaches 0=no 1=ask 2=yes       */
 USHORT  max_ptrs;               /* Maximum size of pointers of ALL *.LTFs    */
 USHORT  max_heap;               /* Maximus heap size of all *.LTFs           */
 UCHAR   max_lang;               /* Current number of languages               */
 UCHAR   rsvd_lang;
 USHORT  max_glh_ptrs;
 USHORT  max_glh_len;
 USHORT  max_syh_ptrs;
 USHORT  max_syh_len;
 UCHAR   input_timeout;          /* # of mins until Max hangs up - no input   */
 UCHAR   charset;                /* Character set support - see CHARSET_XXXX  */
 USHORT  max_pack;               /* Max # of msgs to pack into a .QWK packet  */
 USHORT  msg_localattach;        /* Priv. for doing local file attaches       */
 USHORT  kill_attach_priv;       /* Priv. for killing local file attaches     */
 USHORT  mcp_sessions;           /* Max number of MCP sessions                */
 ULONG   max_msgsize;            /* Truncate uploaded messages to this size   */
 UCHAR   rsvd65[2];              /* Reserved by Maximus for future use        */
 OFS     sysop;                  /* sysop's name - FIRST offset in prm file   */
 OFS     system_name;            /* board's name                              */
 OFS     m_busy;                 /* mdm cmd to take modem off hook            */
 OFS     sys_path;               /* path to SYSTEM?.BBS files                 */
 OFS     misc_path;              /* path to `F-key files'                     */
 OFS     net_info;               /* path to NODELIST files                    */
 OFS     temppath;               /* place to put temporary files              */
 OFS     ipc_path;               /* path for inter-process communications     */
 OFS     user_file;              /* path/filename of User.Bbs                 */
 OFS     log_name;               /* name of the log file                      */
 OFS     chat_prog;              /* External chat program, if any             */
 OFS     chat_fbegin;            /* File to display instead of "CHAT: begin"  */
 OFS     chat_fend;              /* File to display instead of "END CHAT"     */
 OFS     local_editor;           /* Command for local editor, if any          */
 OFS     notfound;               /* User name not found in user file          */
 OFS     junk;                   /* Don't use this for anything!              */
 OFS     logo;                   /* first file shown to a caller              */
 OFS     bad_logon;              /* if user's last logon attempt was bad      */
 OFS     welcome;                /* shown after logon                         */
 OFS     quote;                  /* For displaying "random" quotes from       */
 OFS     newuser1;               /* Asks user to type in password             */
 OFS     newuser2;               /* Replaces `welcome' for a new user         */
 OFS     rookie;                 /* Replaces `welcome' for rookies            */
 OFS     application;            /* new user questionnaire                    */
 OFS     byebye;                 /* file displayed at logoff                  */
 OFS     out_leaving;            /* Bon Voyage                                */
 OFS     out_return;             /* Welcome back from O)utside                */
 OFS     daylimit;               /* Sorry, you've been on too long...         */
 OFS     timewarn;               /* warning about forced hangup               */
 OFS     tooslow;                /* explains minimum logon baud rate          */
 OFS     barricade;              /* Displayed before prompt for access code   */
 OFS     shelltodos;             /* Displayed when Sysop hits Alt-J           */
 OFS     backfromdos;            /* Displayed when Sysop returns from Alt-J   */
 OFS     areanotexist;           /* Display file - "That area doesn't exist!" */
 OFS     access;                 /* Database of user privilege levels         */
 OFS     xferbaud;               /* explains minimum file transfer baud rate  */
 OFS     file_area_list;         /* dump file... used instead of Dir.Bbs      */
 OFS     no_space;               /* Display file UL with less than k_free     */
 OFS     fname_format;           /* Essay on MS-DOS filenames for U)ploads    */
 OFS     ul_log;                 /* Log file for uploads                      */
 OFS     file_header;            /* Format for file area's A)rea command      */
 OFS     file_format;            /* Format for A)rea command entries          */
 OFS     file_footer;            /* Format for footer for file.area menu      */
 OFS     proto_dump;             /* Dump file for protocol screen             */
 OFS     msgarea_list;           /* dump file... used instead of Dir.Bbs      */
 OFS     echotoss_name;          /* Name of your echomail tosslog             */
 OFS     nomail;                 /* Display by mailchecker if no mail wtng.   */
 OFS     msg_header;             /* Format for msg.area's A)rea command       */
 OFS     msg_format;             /* Format for A)reas command entries         */
 OFS     msg_footer;             /* Format for footer for msg.area menu       */
 OFS     hlp_editor;             /* intro to msg editor for novices.          */
 OFS     hlp_replace;            /* Explain the Msg.Editor E)dit command      */
 OFS     msg_inquire;            /* Explain the Msg. I)nquire command         */
 OFS     hlp_locate;             /* Explain the Files L)ocate command         */
 OFS     hlp_contents;           /* Explain the Files C)ontents command       */
 OFS     oped_help;              /* help file for the full-screen editor      */
 OFS     hlp_scan;               /* help file for S)can                       */
 OFS     hlp_list;               /* help file for L)ist                       */
 OFS     protocols[MAX_EXTERNP]; /* external file protocol programs           */
 OFS     protoname[MAX_EXTERNP]; /* name of protocol, on menu                 */
 OFS     timeformat;
 OFS     dateformat;
 OFS     adat_name;              /* **OBSOLETE** Max 2.x area.dat/idx files   */
 OFS     aidx_name;              /* **OBSOLETE** Max 2.x area.dat/idx files   */
 OFS     menupath;               /* The default place to look for the menus   */
 OFS     first_menu;             /* The name of the first menu to display     */
 OFS     edit_menu;              /* Name of the EDIT menu                     */
 OFS     achg_keys;              /* Characters used to change area -/+        */
 OFS     tune_file;              /* Path to TUNES.MAX                         */
 OFS     lang_path;              /* Path to *.LTF files                       */
 OFS     lang_file[MAX_LANG];    /* Array of all *.LTF names                  */
 OFS     m_init;                 /* Modem initialization string               */
 OFS     m_ring;                 /* Command modem sends when phone ringing    */
 OFS     m_answer;               /* Cmd to send to modem when ring detect     */
 OFS     m_connect;              /* Connect string, as returned by modem      */
 OFS     high_msgarea;
 OFS     begin_msgarea;          /* Msg area to put new users in              */
 OFS     high_filearea;
 OFS     begin_filearea;         /* File area to put new users in             */
 OFS     fidouser;               /* Name of FIDOUSER.LST file to use          */
 OFS     cmtarea;                /* Message area to put comments in           */
 OFS     arc_ctl;                /* Control file for archiving programs       */
 OFS     olr_name;               /* OLR: Filename to use for DL packets       */
 OFS     olr_dir;                /* OLR: Directory for off-line stuff         */
 OFS     phone_num;
 OFS     viruschk;               /* batch file name to call for virus check   */
 OFS     protocol_max;           /* Name of compiled protocol data file       */
 OFS     track_privview;         /* Priv req'd to see tracking info not owned */
 OFS     track_privmod;          /* Priv req'd to modify track info not owned */
 OFS     track_base;             /* Base name of the tracking database files  */
 OFS     track_exclude;          /* File containing list of names to exclude  */
 OFS     stagepath;              /* Path for staged CD-ROM transfers          */
 OFS     attach_base;            /* Base name of the local attach database    */
 OFS     attach_path;            /* Default path for local file attaches      */
 OFS     attach_archiver;        /* File attach archiver                      */
 OFS     inbound_files;          /* Inbound FTS-1 attaches for users          */
 OFS     rippath;                /* Default icon & RIP screens path           */
 OFS     hlp_hdrentry;           /* Help screen for message header entry      */
 OFS     hlp_msgentry;           /* Help screen for start of message entry    */
 OFS     not_configured;         /* Displayed if user is not configured       */
 OFS     mcp_pipe;               /* Default MCP pipe                          */
 OFS     marea_name;             /* Name of message area data file            */
 OFS     farea_name;             /* Name of file area data file               */
 OFS     caller_log;             /* Caller information log                    */
};

/* Access database class info */
#define CLS_ID  0x8f7c9321L
typedef struct _clshdr
{
  ULONG ulclhid;                                          /* ID signature */
  USHORT usclfirst;                             /* Offset of first record */
  USHORT usn;                     /* Number of user class records present */
  USHORT ussize;                      /* Size of individual class records */
  USHORT usstr;                                    /* Size of all strings */
} CLSHDR;
typedef struct _clsrec
{
  USHORT usLevel;                               /* Numeric security level */
  USHORT usKey;              /* Keyletter for MECCA [?below] [?above] etc */
  OFS zAbbrev;                             /* Abbreviation for this class */
  OFS zDesc;                                           /* Long class name */
  OFS zAlias;                               /* Alias for the abbreviation */
  USHORT usTimeDay;                    /* Daily time allowance in minutes */
  USHORT usTimeCall;                    /* Call time allowance in minutes */
  USHORT usCallsDay;                             /* Max calls/day -1=none */
  USHORT usMinBaud;                           /* Minimum logon baud / 100 */
  USHORT usFileBaud;                       /* Minimum download baud / 100 */
  USHORT usFileRatio;                       /* File upload:download ratio */
  USHORT usFreeRatio;     /* Download allowance before ratio takes effect */
  ULONG ulFileLimit;           /* Maximum download allowance in kilobytes */
  USHORT usUploadReward;                               /* % upload reward */
  OFS zLoginFile;          /* Show this file (in misc directory) on login */
  ULONG ulAccFlags;                         /* Access related class flags */
  ULONG ulMailFlags;                          /* Mail related class flags */
  ULONG ulUsrFlags;                           /* User-defined class flags */
  USHORT usOldPriv;      /* 'old' user priv equivalent, for compatibility */
} CLSREC;

#pragma pack()

/**/

PRMINFO PrmInfo;

/**/

static SHORT PASCAL AccessRead (PCHAR Fname);
static SHORT PASCAL CompressRead (PCHAR Fname);

/**/

/* #define NEVER 1 */
#if defined(NEVER)
VOID main (VOID)
{
    if(!PrmRead("MAX.PRM")) {
        printf("max_lang    : %d\n",PrmInfo.max_lang);
        printf("lang_file[0]: %s\n",PrmInfo.lang_file[0]);
        printf("lang_file[1]: %s\n",PrmInfo.lang_file[1]);
        printf("PrmPrivNum  : %d\n",PrmInfo.PrmPrivNum);
    }
}
#endif

/**/

SHORT PASCAL PrmRead (PCHAR Fname)
{
    SHORT i;
    USHORT rc, usAction, cbBytesRead;
    ULONG ulNewPtr;
    HFILE Fh;
    struct m_pointers *prm=NULL;
    PCHAR offsets=NULL;

    /* Open the prm file for read */
    rc=DosOpen(
        Fname,
        &Fh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_OPEN,
        OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Allocate struct storage */
    prm=(struct m_pointers *)malloc(sizeof(struct m_pointers));
    if(prm==NULL) { DosClose(Fh); return -1; }
    memset(prm,'\0',sizeof(struct m_pointers));

    /* Read the structure */
    rc=DosRead(Fh,prm,sizeof(struct m_pointers),&cbBytesRead);
    if(rc||cbBytesRead!=sizeof(struct m_pointers)) {
        free(prm); DosClose(Fh); return -1;
    }

    /* Check file id & version */
    if(prm->id!='M' || prm->version!=CTL_VER) {
        free(prm); DosClose(Fh); return -1;
    }

    /* Allocate heap storage */
    offsets=(PCHAR)malloc(sizeof(CHAR)*MAX_PRM_HEAP);
    if(offsets==NULL) { free(prm); DosClose(Fh); return -1; }
    memset(offsets,'\0',sizeof(CHAR)*MAX_PRM_HEAP);

    /* Seek the file */
    rc=DosChgFilePtr(Fh,(ULONG)prm->heap_offset,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=(ULONG)prm->heap_offset) {
        free(offsets); free(prm); DosClose(Fh); return -1;
    }

    /* Read the heap */
    rc=DosRead(Fh,offsets,sizeof(CHAR)*MAX_PRM_HEAP,&cbBytesRead);
    if(rc) { free(offsets); free(prm); DosClose(Fh); return -1; }

    DosClose(Fh); /* Close the file */


    /* Save the data */
    PrmInfo.noencrypt=(BOOL)prm->flags2 & FLAG2_NOENCRYPT;
    PrmInfo.max_lang=prm->max_lang;
    for(i=0;i<(SHORT)prm->max_lang;i++) {
        strcpy(PrmInfo.lang_file[i],PRM(lang_file[i]));
    }
    AccessRead(PRM(access));        /* Get access (priv) info   */
    CompressRead(PRM(arc_ctl));     /* Get the compression info */

    /* Free storage */
    free(offsets); /* Free heap storage */
    free(prm); /* Free struct storage */

    return 0;
}

/**/

/* Read the access database */
static SHORT PASCAL AccessRead (PCHAR Fname)
{
    USHORT i, rc, usAction, cbBytesRead;
    ULONG ulNewPtr;
    HFILE Fh;
    CLSHDR ClsHdr;
    CLSREC ClsRec[16];
    CHAR buf[160];
    PCHAR pHeap;

    PrmInfo.PrmPrivNum=0;
    strcpy(buf,Fname); strcat(buf,".DAT");

    /* Open the access file for read */
    rc=DosOpen(
        buf,
        &Fh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_OPEN,
        OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Read the header structure */
    rc=DosRead(Fh,&ClsHdr,sizeof(CLSHDR),&cbBytesRead);
    if(rc||cbBytesRead!=sizeof(CLSHDR)) {
        DosClose(Fh); return -1;
    }
    /* Check the id */
    if(ClsHdr.ulclhid!=CLS_ID) { DosClose(Fh); return -1; }

    /* Allocate heap storage */
    pHeap=(PCHAR)malloc(sizeof(CHAR)*ClsHdr.usstr);
    if(pHeap==NULL) { DosClose(Fh); return -1; }
    memset(pHeap,'\0',sizeof(CHAR)*ClsHdr.usstr);

    /* Seek the file to first record */
    rc=DosChgFilePtr(Fh,(ULONG)ClsHdr.usclfirst,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=(ULONG)ClsHdr.usclfirst) {
        free(pHeap); DosClose(Fh); return -1;
    }

    /* Read the records */
    for(i=0;i<ClsHdr.usn&&i<16;i++) {
        rc=DosRead(Fh,&ClsRec[i],sizeof(CLSREC),&cbBytesRead);
        if(rc||cbBytesRead!=sizeof(CLSREC)) {
            free(pHeap); DosClose(Fh); return -1;
        }

        if(ClsHdr.ussize!=sizeof(CLSREC)) {
            rc=DosChgFilePtr(Fh,(ULONG)ClsHdr.ussize*(i+1),FILE_CURRENT,&ulNewPtr);
        }
    }

    /* Read the string heap */
    rc=DosRead(Fh,pHeap,sizeof(CHAR)*ClsHdr.usstr,&cbBytesRead);
    if(rc||cbBytesRead!=sizeof(CHAR)*ClsHdr.usstr) {
        free(pHeap); DosClose(Fh); return -1;
    }

    /* Save data */
    for(i=0;i<ClsHdr.usn&&i<16;i++) {
        PrmInfo.PrmPriv[i].usLevel=ClsRec[i].usLevel;
        strcpy(PrmInfo.PrmPriv[i].zAbbrev,pHeap+ClsRec[i].zAbbrev);
        strncpy(PrmInfo.PrmPriv[i].zDesc,pHeap+ClsRec[i].zDesc,20);
        PrmInfo.PrmPriv[i].zDesc[20]='\0';
    }
    PrmInfo.PrmPrivNum=ClsHdr.usn>16?16:ClsHdr.usn;

    free(pHeap);
    DosClose(Fh); /* Close the file */
    return 0;
}

/**/

/* Read the compression txtfile */
static SHORT PASCAL CompressRead (PCHAR Fname)
{
    FILE *fp;
    CHAR *p, *q, line[256];

    PrmInfo.CompNum=0;

    fp=fopen(Fname,"r");
    if(fp==NULL) return -1;

    for(;;) {
        if(NULL==fgets(line,256,fp)) break;
        p=strtok(line," \t\n\r");
        if(p!=NULL) {
            if(!stricmp(p,"Archiver")) {
                q=strtok(NULL," \t\n\r");
                if(q!=NULL) {
                    /* Save an archiver */
                    strncpy(PrmInfo.Comp[PrmInfo.CompNum],q,9);
                    PrmInfo.Comp[PrmInfo.CompNum][9]='\0';
                    if(++PrmInfo.CompNum>=15) break;
                }
            }
        }
    }

    fclose(fp); /* Close the file */
    return 0;
}

/**/

