/*͸
   OS/2 Video API Version 1.00  13-01-96    (C) 1996 by CodeLand Australia 
   MENU.H                                              All Rights Reserved 
  ;*/

/* Definition of onkey record */
struct _onkey_t {
    struct _onkey_t *prev;      /* pointer to previous record      */
    struct _onkey_t *next;      /* pointer to next record          */
    USHORT keycode;             /* Scan/ASCII code of trap key     */
    void (*func) (void);        /* address of onkey function       */
    USHORT pass;                /* key to pass back, 0=don't pass  */
};

/* Definition of kbuf record */
struct _kbuf_t {
    struct _kbuf_t *prev;       /* previous record */
    struct _kbuf_t *next;       /* next record     */
    USHORT xch;                 /* keypress        */
};

struct _kbinfo_t {
    struct _kbuf_t *kbuf;       /* pointer to head record in key buffer      */
    struct _onkey_t *onkey;     /* pointer to head record in onkey list      */
    void (*kbloop) (void);      /* pointer to function to call while waiting */
    UCHAR inmenu;               /* inmenu flag used by menuing functions     */
    UCHAR source;               /* source of keypress 0=kb, 1=kbuf, 2=mouse  */
};

extern struct _kbinfo_t _kbinfo;

/**/

#define MenuClearKeys()         while(KbHit()) getch()
#define MenuSetKbLoop(a)        (_kbinfo.kbloop=a)
#define MenuMCurr()             (_WinInfo.cmenu)
#define MenuICurr()             (MenuMCurr()->citem)

/**/

SHORT MenuBeg (SHORT srow, SHORT scol, SHORT erow, SHORT ecol, SHORT btype,
    SHORT battr, SHORT wattr, VOID (*open)(VOID));
SHORT MenuBegC (VOID);
SHORT MenuItem (SHORT wrow, SHORT wcol, CHAR *str, SHORT schar, SHORT tagid,
    SHORT fmask, VOID (*select)(VOID), USHORT hotkey, SHORT help);
SHORT MenuEnd (SHORT taginit, SHORT menutype, SHORT barwidth, SHORT textpos,
    SHORT textattr, SHORT scharattr, SHORT noselattr, SHORT barattr);
SHORT MenuGet (VOID);
struct _item_t *MenuIFind (SHORT tagid);
SHORT MenuIBA (void (*before)(void), void (*after)(void));
SHORT MenuSetOnKey (USHORT keycode, void (*func) (void), USHORT pass);
VOID MenuFreOnKey (VOID);
SHORT MenuKbPut (USHORT xch);
SHORT MenuKbPutS (PCHAR str);
SHORT MenuWaitKey (VOID);
SHORT MenuWaitKeyT (SHORT duration);
VOID MenuDelay (SHORT duration);
SHORT MenuKbHit (VOID);
SHORT MenuGetC (VOID);
SHORT MenuGetChF (PCHAR valid, SHORT defchar);
USHORT MenuGetXCh (VOID);
SHORT KbHit (VOID);

/**/

