/*͸
   OS/2 Video API Version 1.00  13-01-96    (C) 1996 by CodeLand Australia 
   MENU.C Menu routines                                All Rights Reserved 
  ;*/

#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <conio.h>
/* #include <stdio.h> */ /* DEBUG */

#define INCL_DOS
#define INCL_VIO
#define INCL_KBD
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"

/**/

/* Menu item movement definitions */
#define ITM_LT  0
#define ITM_RT  1
#define ITM_UP  2
#define ITM_DN  3
#define ITM_FR  4
#define ITM_LS  5

/**/

/* Prototypes for local functions */
static void pascal call_keyfunc (void (*func)(void));
static struct _item_t * pascal find_hotkey (struct _menu_t *wmenu, USHORT xch);
static struct _item_t * pascal search_menu (struct _menu_t *menu, SHORT tagid);
static SHORT pascal calc_bar_width (struct _menu_t *wmenu, struct _item_t *witem);
static SHORT pascal calc_center_item (struct _item_t *item);
static void pascal call_after (struct _item_t *citem);
static void pascal call_before (struct _item_t *citem);
static void pascal call_func (void (*func)(void));
static void pascal close_window (WINDOW w);
static void pascal disp_item (struct _item_t *witem, SHORT bar);
static struct _item_t * pascal first_item (void);
static void pascal free_menu (struct _menu_t *wmenu);
static struct _item_t * pascal goto_item (struct _item_t *citem, SHORT which);
static struct _item_t * pascal last_item (void);
static void pascal post_move (struct _item_t *citem);
static void pascal pre_exit (WINDOW w, SHORT close);
static void pascal pre_move (struct _item_t *citem);
static struct _item_t * left_item (struct _item_t *curr);
static struct _item_t * right_item (struct _item_t *curr);
static struct _item_t * up_item (struct _item_t *curr);
static struct _item_t * down_item (struct _item_t *curr);
static USHORT pascal get_keybrd_xch (VOID);
static SHORT pascal scan_code (SHORT ch);

/**/

/* Array of function pointers to some of the item movement functions */
static struct _item_t *(*funcs[4])(struct _item_t *) =
    { left_item,right_item,up_item,down_item };

/* Flag used for initial display of menu selections */
static SHORT dispdesc=1;

/* Keyboard information structure */
struct _kbinfo_t _kbinfo=
{
    NULL,   /* Pointer to head record in key buffer      */
    NULL,   /* Pointer to head record in onkey list      */
    NULL,   /* Pointer to function to call while waiting */
    0,      /* Inmenu flag used by menuing functions     */
    0       /* Source of keypress 0=kb, 1=kbuf, 2=mouse  */
};

/**/

SHORT MenuBeg (SHORT srow, SHORT scol, SHORT erow, SHORT ecol, SHORT btype,
    SHORT battr, SHORT wattr, VOID (*open)(VOID))
{
    struct _menu_t *wmenu;

    /* If this is a submenu, then make sure that it is under a menu item */
    if(_WinInfo.mlevel>_WinInfo.ilevel) return (_WinInfo.errno=W_NOITMDEF);

    /* Allocate memory for new menu record */
    if((wmenu=malloc(sizeof(struct _menu_t)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);

    /* If menu is not a submenu, make it a new base menu record */
    if(!_WinInfo.mlevel) {
        if(_WinInfo.menu!=NULL) _WinInfo.menu->next=wmenu;
        wmenu->prev=_WinInfo.menu;
        wmenu->next=NULL;
        wmenu->parent=NULL;
        _WinInfo.menu=_WinInfo.cmenu=wmenu;
    }
    else {
        wmenu->parent=_WinInfo.cmenu;
        _WinInfo.cmenu=_WinInfo.cmenu->item->child=wmenu;
    }

    /* Save info in menu record */
    wmenu->srow=(UCHAR)srow;
    wmenu->scol=(UCHAR)scol;
    wmenu->erow=(UCHAR)erow;
    wmenu->ecol=(UCHAR)ecol;
    wmenu->btype=(UCHAR)btype;
    wmenu->battr=(UCHAR)VidMapAttr(battr);
    wmenu->wattr=(UCHAR)VidMapAttr(wattr);
    wmenu->open=open;
    wmenu->usecurr=0;
    wmenu->item=NULL;

    _WinInfo.mlevel++; /* Increment menu level */

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

/* Starts a menu definition in active window  */
SHORT MenuBegC (VOID)
{
    /* Call MenuBeg() using current window parameters */
    if(MenuBeg(_WinInfo.active->srow,_WinInfo.active->scol,
        _WinInfo.active->erow,_WinInfo.active->ecol,_WinInfo.active->btype,
        _WinInfo.active->battr,_WinInfo.active->wattr,NULL))
        return(_WinInfo.errno);

    /* Turn on use-current-window flag */
    _WinInfo.cmenu->usecurr=1;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT MenuItem (SHORT wrow, SHORT wcol, CHAR *str, SHORT schar, SHORT tagid,
    SHORT fmask, VOID (*select)(VOID), USHORT hotkey, SHORT help)
{
    struct _item_t *witem;

    /* Make sure that MenuBeg() or MenuBegC() has been called */
    if(!_WinInfo.mlevel) return (_WinInfo.errno=W_NOMNUBEG);

    /* Allocate memory for new item record */
    if((witem=malloc(sizeof(struct _item_t)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);

    /* Add new menu item record to linked list */
    if(_WinInfo.cmenu->item!=NULL) _WinInfo.cmenu->item->next=witem;
    witem->prev=_WinInfo.cmenu->item;
    witem->next=NULL;
    _WinInfo.cmenu->item=witem;

    /* Save info in item record */
    witem->wrow   = (UCHAR)wrow;
    witem->wcol   = (UCHAR)wcol;
    witem->str    = str;
    witem->schar  = (UCHAR)schar;
    witem->tagid  = tagid;
    witem->fmask  = (UCHAR)fmask;
    witem->select = select;
    witem->hotkey = hotkey;
    witem->desc   = NULL;
    witem->dwrow  = 0;
    witem->dwcol  = 0;
    witem->dattr  = 0;
    witem->redisp = 0;
    witem->help   = help;
    witem->child  = NULL;
    witem->before =
    witem->after  = NULL;

    _WinInfo.ilevel=_WinInfo.mlevel; /* Set item level == menu level */

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT MenuEnd (SHORT taginit, SHORT menutype, SHORT barwidth, SHORT textpos,
    SHORT textattr, SHORT scharattr, SHORT noselattr, SHORT barattr)
{
    struct _item_t *item;
    SHORT w_width, border, found;

    /* Make sure at least 1 menu item has been defined */
    if(!_WinInfo.mlevel||_WinInfo.mlevel>_WinInfo.ilevel)
        return (_WinInfo.errno=W_NOITMDEF);

    /* Make sure that the specified initial tagid matches the */
    /* tagid of one of the defined menu items in this menu    */
    for(found=0,item=_WinInfo.cmenu->item;item!=NULL;item=item->prev) {
        if(item->tagid==taginit) {
            found=1;
            break;
        }
    }
    if(!found) return (_WinInfo.errno=W_INVTAGID);

    /* If bar width > window width, then bar width = window width */
    border=(_WinInfo.cmenu->btype==5)?0:1;
    w_width=(_WinInfo.cmenu->ecol-border)-(_WinInfo.cmenu->scol+border)+1;
    if(barwidth>w_width) barwidth=w_width;

    /* Add rest of menu information to menu record */
    _WinInfo.cmenu->citem     = NULL;
    _WinInfo.cmenu->tagcurr   = taginit;
    _WinInfo.cmenu->menutype  = (UCHAR)menutype;
    _WinInfo.cmenu->barwidth  = (UCHAR)barwidth;
    _WinInfo.cmenu->textpos   = barwidth?(UCHAR)textpos:(UCHAR)0;
    _WinInfo.cmenu->textattr  = (UCHAR)VidMapAttr(textattr);
    _WinInfo.cmenu->scharattr = (UCHAR)VidMapAttr(scharattr);
    _WinInfo.cmenu->noselattr = (UCHAR)VidMapAttr(noselattr);
    _WinInfo.cmenu->barattr   = _VidInfo.MapAttr ?
        (UCHAR)VidRevsAttr(_WinInfo.cmenu->textattr) : (UCHAR)barattr;

    /* Set current menu pointer to parent menu */
    if((_WinInfo.cmenu=_WinInfo.cmenu->parent)==NULL)
        _WinInfo.cmenu=_WinInfo.menu;

    /* Decrement menu and item levels */
    _WinInfo.mlevel--; _WinInfo.ilevel--;

    return (_WinInfo.errno=W_NOERROR); /* Return with no error */
}

/**/

SHORT MenuGet (VOID)
{
    USHORT xch;
    struct _item_t *citem;
    struct _item_t *item;
    SHORT valid, pulldown=0, menuerr, winerr /*, err */;
    CHAR ch;
    WINDOW w;

    /* Make sure we have a defined menu */
    if(_WinInfo.cmenu==NULL) { _WinInfo.errno=W_NOMNUDEF; return -1; }

    /* Make sure that MenuEnd() was called */
    if(_WinInfo.mlevel||_WinInfo.ilevel) {
        _WinInfo.errno=W_NOMNUEND;
        return -1;
    }

    /* Open menu's window (unless menu is to use current window) */
    if(!_WinInfo.cmenu->usecurr) {
        w=WinHandle();
        if(!WinOpen(_WinInfo.cmenu->srow,_WinInfo.cmenu->scol,
            _WinInfo.cmenu->erow,_WinInfo.cmenu->ecol,_WinInfo.cmenu->btype,
            _WinInfo.cmenu->battr,_WinInfo.cmenu->wattr)
        ) return -1;

        /* save environment info, call menu open   */
        /* function, then restore environment info */
        if(_WinInfo.cmenu->open!=NULL) call_func(_WinInfo.cmenu->open);
    }

    /* Find first item in linked list */
    if((item=_WinInfo.cmenu->item)!=NULL)
        for(;item->prev!=NULL;item=item->prev);

    /* Display all menu items */
    dispdesc=0; valid=0;
    while(item!=NULL) {
        disp_item(item,0);
        if(!(item->fmask&M_NOSEL)) valid=1;
        item=item->next;
    }
    dispdesc=1;

    /* Make sure there is at least 1 selectable menu item */
    if(!valid) {
        pre_exit(w,1);
        _WinInfo.errno=W_NOSELECT;
        return -1;
    }

    /* Search linked list of item records for the item matching    */
    /* the last item.  If there was no last item, search for       */
    /* the initial tag ID position.  If no initial tag ID position */
    /* was specified, then find the upper-leftmost menu item.      */
    citem=NULL;
    if(_WinInfo.cmenu->menutype&M_SAVE) {
        for(citem=_WinInfo.cmenu->item;citem!=NULL;citem=citem->prev) {
            if((_WinInfo.cmenu->citem==citem)&&
               (!(citem->fmask&M_NOSEL)))
                break;
        }
    }
    if(citem==NULL) {
        citem=MenuIFind(_WinInfo.cmenu->tagcurr);
        if((citem==NULL)||(citem->fmask&M_NOSEL)) citem=first_item();
    }

    /* Call the current menu item's 'before'  */
    /* function and display current menu item */
    post_move(citem);

    /* Main process of function */

    for(;;) {

        /* Update current menu item and help category */
        _WinInfo.cmenu->citem=citem; _WinInfo.help=citem->help;

        /* Read keyboard for keypress, then test the keypress */
        _kbinfo.inmenu=TRUE;
        citem=_WinInfo.cmenu->citem;
        xch=MenuGetXCh();
        _kbinfo.inmenu=FALSE;
        switch(xch) {
            case 0x011b:    /* Esc */
                /* If Esc checking is on, erase selection bar, */
                /* free menu records and return to caller      */
                if(_WinInfo.esc||(_WinInfo.cmenu!=_WinInfo.menu)) {
                    pre_move(citem);
                    pre_exit(w,1);
                    _WinInfo.errno=W_ESCPRESS;
                    return -1;
                }
                break;

            case 0x4700:    /* Home */
                /* Hide selection bar and find upper-leftmost menu item */
                citem=goto_item(citem,ITM_FR);
                break;

            case 0x4b00:    /* LeftArrow */
                /* If current menu is a pull-down menu,         */
                /* then erase selection bar, free menu records, */
                /* and return special code to caller            */
                if(_WinInfo.cmenu->menutype&M_PD) {
                    pre_move(citem);
                    pre_exit(w,1);
                    _WinInfo.errno=W_NOERROR;
                    return (M_PREVPD);
                }

                /* If current menu is a horizontal menu, then hide */
                /* selection bar and find menu item to the left    */
                if(_WinInfo.cmenu->menutype&M_HORZ)
                    citem=goto_item(citem,ITM_LT);

                /* If pull-down menu flag is set, select this item */
                if(pulldown&&citem->child!=NULL) goto enter;
                break;

            case 0x4800:    /* UpArrow */
                /* If current menu is a vertical menu, then hide */
                /* selection bar and find menu item upwards      */
                if(_WinInfo.cmenu->menutype&(M_VERT|M_PD))
                    citem=goto_item(citem,ITM_UP);
                break;

            case 0x4d00:    /* RightArrow */
                /* If current menu is a pull-down menu,         */
                /* then erase selection bar, free menu records, */
                /* and return special code to caller            */
                if(_WinInfo.cmenu->menutype&M_PD) {
                    pre_move(citem);
                    pre_exit(w,1);
                    _WinInfo.errno=W_NOERROR;
                    return (M_NEXTPD);
                }

                /* If current menu is a horizontal menu, then hide */
                /* selection bar and find menu item to the right   */
                if(_WinInfo.cmenu->menutype&M_HORZ)
                    citem=goto_item(citem,ITM_RT);

                /* If pulldown flag is set, then select this item */
                if(pulldown&&citem->child!=NULL) goto enter;
                break;

            case 0x5000:    /* DownArrow */
                /* If current item has a pull-down menu, select it */
                if(citem->fmask&M_HASPD) goto enter;

                /* If current menu is a vertical menu, then hide */
                /* selection bar and find menu item downwards    */
                if(_WinInfo.cmenu->menutype&(M_VERT|M_PD))
                    citem=goto_item(citem,ITM_DN);
                break;

            case 0x4f00:    /* End */
                /* Hide selection bar and find */
                /* lower-rightmost menu item   */
                citem=goto_item(citem,ITM_LS);
                break;

            case 0x1c0d:    /* Enter */
enter:
                /* If current menu item has a pull-down menu */
                /* attached, then set the pulldown flag      */
                if(citem->fmask&M_HASPD) pulldown=1;

                /* Display menu item with selection bar */
                disp_item(citem,1);

                menuerr=0;

                /* If current menu item has a child menu */
                if(citem->child!=NULL) {

                    /* Save environment info, process child */
                    /* menu, then restore environment info  */
                    _WinInfo.cmenu=citem->child;
                    /* err=whelpush(); */
                    menuerr=MenuGet();
                    winerr=_WinInfo.errno;
                    /* if(!err) whelpop(); */
                    _WinInfo.cmenu=_WinInfo.cmenu->parent;

                    /* If an error was returned by   */
                    /* child menu, free menu records */
                    /* and pass error code to caller */
                    if(menuerr==-1&&winerr!=W_ESCPRESS) {
                        call_after(citem);
                        menuerr=winerr;
                        pre_exit(w,1);
                        _WinInfo.errno=menuerr;
                        return -1;
                    }
                }

                /* If the M_CLOSB feature is on, then close the menu's */
                /* window before the selection function is called.     */
                if(citem->fmask&M_CLOSB) close_window(w);

                /* This is used as a flag to see if the selection bar's */
                /* position has been changed by the select function.    */
                _WinInfo.cmenu->tagcurr=-1;

                /* If current menu item has a select function, call it */
                if(citem->select!=NULL) call_func(citem->select);

                /* If the M_CLOSB feature is on, then free the current */
                /* menu a before the selection function is called.     */
                if(citem->fmask&M_CLOSB) {
                    call_after(citem);
                    pre_exit(w,0);
                    _WinInfo.errno=W_NOERROR;
                    return (citem->tagid);
                }

                /* Check all menu items in current menu to  */
                /* see if their redisplay flag has been set */
                for(item=_WinInfo.cmenu->item;item!=NULL;item=item->prev) {
                    if(item->redisp) {
                        disp_item(item,(item==citem));
                        item->redisp=0;
                    }
                }

                /* See if selection bar position was changed by select   */
                /* function.  if so, then move selection bar to new item */
                if(_WinInfo.cmenu->tagcurr!=-1) {
                    item=MenuIFind(_WinInfo.cmenu->tagcurr);
                    if(item!=NULL&&(!(item->fmask&M_NOSEL))) {
                        pre_move(citem);
                        post_move(_WinInfo.cmenu->citem=citem=item);
                        break;
                    }
                }

                /* If current menu item has a pull-down attached */
                if(citem->fmask&M_HASPD) {

                    /* If child menu returned previous pull-down menu */
                    /* flag, find menu item to the left and select it */
                    if(menuerr==M_PREVPD) {
                        citem=goto_item(citem,ITM_LT);
                        if(citem->fmask&M_HASPD) goto enter;
                        break;
                    }

                    /* If child menu returned next pull-down menu      */
                    /* flag, find menu item to the right and select it */
                   if(menuerr==M_NEXTPD) {
                        citem=goto_item(citem,ITM_RT);
                        if(citem->fmask&M_HASPD) goto enter;
                        break;
                    }
                }

                /* Turn off pulldown flag */
                pulldown=0;

                /* If child menu returned an exit-all-menus flag, */
                /* then free menu records and pass exit-all-menus */
                /* flag onto caller                               */
                if((menuerr==M_EXITALL)||(citem->fmask&M_CLALL)) {
                    disp_item(citem,1);
                    call_after(citem);
                    pre_exit(w,1);
                    _WinInfo.errno=W_NOERROR;
                    return (M_EXITALL);
                }

                /* Unless an exit-this-menu flag was returned by the */
                /* child menu, or current item has close-menu        */
                /* specified, free menu records, and return tag      */
                /* identifier of current menu item                   */
                if(citem->child!=NULL||citem->select!=NULL)
                    if((menuerr!=M_EXIT)&&(!(citem->fmask&M_CLOSE)))
                        break;
                call_after(citem);
                pre_exit(w,1);
                _WinInfo.errno=W_NOERROR;
                return (citem->tagid);

            default:
                /* Separate ASCII code from keypress code, if ASCII */
                /* code is zero, then it must be an extended key    */
                ch=(CHAR)xch;
                if(!ch) break;

                /* Scan through list of items for one that */
                /* has a tag identifier matching keypress  */
                valid=1;
                item=citem->next;
                for(;;) {
                    while(item!=NULL) {
                        if((toupper(ch)==toupper(item->schar))&&(!(item->fmask
                          &M_NOSEL))) goto farbreak;
                        if(citem==item) {
                            valid=0;
                            goto farbreak;
                        }
                        item=item->next;
                    }
                    for(item=_WinInfo.cmenu->item;item->prev!=NULL;
                      item=item->prev);
                }
farbreak:
                /* If a matching tag identifier was found,          */
                /* then hide selection bar, and if quick-key        */
                /* selection is allowed, select the found menu item */
                if(valid) {
                    if(item!=citem) {
                        pre_move(citem);
                        post_move(_WinInfo.cmenu->citem=citem=item);
                    }
                    if(!(_WinInfo.cmenu->menutype&M_NOQS)) goto enter;
                }
        }
    }
}

/**/

/* Finds item record in a menu structure */
struct _item_t *MenuIFind (SHORT tagid)
{
    struct _item_t *item;

    /* Check for existance of a menu */
    if(_WinInfo.cmenu==NULL) {
        _WinInfo.errno=W_NOMNUDEF;
        return NULL;
    }

    /* Start search process at root of menu structure */
    item=search_menu(_WinInfo.menu,tagid);

    /* Return to caller */
    _WinInfo.errno=(item==NULL?W_NOTFOUND:W_NOERROR);
    return item;
}

/**/

/* Adds a before and after function pointer to menu item */
SHORT MenuIBA (void (*before)(void), void (*after)(void))
{
    /* Make sure at least 1 menu item has been defined */
    if(!_WinInfo.mlevel||_WinInfo.mlevel>_WinInfo.ilevel)
        return (_WinInfo.errno=W_NOITMDEF);

    /* Update menu item record */
    _WinInfo.cmenu->item->before=before;
    _WinInfo.cmenu->item->after=after;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

/* Attaches/detaches a key to a function */
SHORT MenuSetOnKey (USHORT keycode, void (*func) (void), USHORT pass)
{
    struct _onkey_t *onkey, *prev, *next;

    /* Search for a keycode that is already defined */
    onkey=_kbinfo.onkey;
    while(onkey!=NULL) {
        if( onkey->keycode == keycode ) break;
        onkey=onkey->prev;
    }

    /* Check to see if a key detachment is being requested */
    if(func==NULL) {

        /* if no defined onkey was found, then error */
        if(onkey==NULL) return 2;

        /* Delete record from linked list */
        prev=onkey->prev;
        next=onkey->next;
        if(prev!=NULL) prev->next=next;
        if(next!=NULL) next->prev=prev;
        if(onkey==_kbinfo.onkey) _kbinfo.onkey=prev;

        free(onkey); /* Free memory allocated for deleted record */
    }
    else {
        /* If key was found, change func pointer */
        /* otherwise create a new onkey record */
        if(onkey!=NULL) onkey->func=func;
        else {
            /* Allocate memory for new record */
            onkey=malloc(sizeof(struct _onkey_t));
            if(onkey==NULL) return 1;

            /* Add new record to linked list */
            if(_kbinfo.onkey!=NULL) _kbinfo.onkey->next=onkey;
            onkey->prev=_kbinfo.onkey;
            onkey->next=NULL;
            _kbinfo.onkey=onkey;

            /* save info in onkey record */
            _kbinfo.onkey->keycode=keycode;
            _kbinfo.onkey->func=func;
            _kbinfo.onkey->pass=pass;
        }
    }

    return 0; /* Return normally */
}

/**/

/* Frees all active onkey definitions from memory */
VOID MenuFreOnKey (VOID)
{
    struct _onkey_t *temp;

    /* Free all onkey records in linked list */
    while(_kbinfo.onkey!=NULL) {
        temp=_kbinfo.onkey->prev;
        free(_kbinfo.onkey);
        _kbinfo.onkey=temp;
    }
}

/**/

/* Puts a keystroke into the CXL keyboard "buffer"  */
SHORT MenuKbPut (USHORT xch)
{
    struct _kbuf_t *kbuf, *temp;

    /* Allocate space for another keypress record */
    if((kbuf=malloc(sizeof(struct _kbuf_t)))==NULL) return 1;

    /* Find last record in linked list */
    if((temp=_kbinfo.kbuf)!=NULL) for(;temp->next!=NULL;temp=temp->next);

    /* Add new record to end of linked list */
    kbuf->next=NULL; kbuf->prev=temp;
    if(temp!=NULL) temp->next=kbuf;

    /* Add keypress info to new record */
    kbuf->xch=xch;

    /* If kbuf pointer was NULL, point it to new record */
    if(_kbinfo.kbuf==NULL) _kbinfo.kbuf=kbuf;

    return 0; /* Return normally */
}

/**/

/* Puts a string of characters into CXL's keyboard buffer  */
SHORT MenuKbPutS (PCHAR str)
{
    PCHAR p;

    for(p=str;*p;p++) if(MenuKbPut((scan_code(*p)<<8)|*p)) return 1;
    return 0;
}

/**/

/* Halts execution until a key is pressed  */
SHORT MenuWaitKey (VOID)
{
    SHORT ch;

    MenuClearKeys();

    do {
        ch=MenuGetXCh();
    } while(_kbinfo.source==2 && ch!=0x1c0d && ch!=0x011b);

    return (ch&0x00ff);
}

/**/

/* Halts execution until a key is pressed or time expires */
SHORT MenuWaitKeyT (SHORT duration)
{
    ULONG limit;
    USHORT xch;

    limit=VidTimer()+duration;
    MenuClearKeys();

    for (;;) {
        if(MenuKbHit()) {
            xch=MenuGetXCh();
            return(xch&0x00ff);
        }

        if(VidTimer()>=limit) return -1;
        DosSleep(100L);
    }
}

/**/

VOID MenuDelay (SHORT duration)
{
    ULONG limit;

    limit=VidTimer()+duration;

    for (;;) {
        if(VidTimer()>=limit) return;
        DosSleep(100L);
    }
}

/**/

/* Check for a key press */
SHORT MenuKbHit (VOID)
{
    /* Process keyboard handler */
    if(_kbinfo.kbloop!=NULL) (*_kbinfo.kbloop) ();

    /* Check for a keypress in keyboard buffers */
    if( _kbinfo.kbuf!=NULL || KbHit() ) return 1;

    return 0;
}

/**/

/* Gets a key from the keyboard from within a window  */
SHORT MenuGetC (VOID)
{
    SHORT ch;

    /* Check for active windows */
    if(!_WinInfo.total) {
        _WinInfo.errno=W_NOACTIVE;
        return 0;
    }

    ch=MenuGetXCh()&0x00ff;
    /* if(isprint(ch)) */ WinPutC(ch); /* Echo character to window */

    _WinInfo.errno=W_NOERROR;
    return ch;
}
/**/

/* Gets a character from the keyboard from a valid list  */
SHORT MenuGetChF (PCHAR valid, SHORT defchar)
{
    SHORT i;
    SHORT ch;

    /* Check for active windows */
    if(!_WinInfo.total) {
        _WinInfo.errno=W_NOACTIVE;
        return 0;
    }

    for(;;) {
        ch=(CHAR)(MenuGetXCh()&0x00ff);
        ch=toupper(ch);
        if(ch==ESC) {
            if(_WinInfo.esc) { /* Is Escape checking on? */
                _WinInfo.errno=W_ESCPRESS;
                return 0;
            }
        }
        if(ch==CR&&defchar) {
            ch=toupper(defchar);
            goto dispchar;
        }
        for(i=0;valid[i];i++) {
            if(ch==toupper(valid[i])) {
dispchar:
                WinPutC(ch);
                _WinInfo.errno=W_NOERROR;
                return ch;
            }
        }
    }
}

/**/

/* Gets a key (ASCII code/extended ASCII code) from keyboard  */
USHORT MenuGetXCh (VOID)
{
    USHORT xch;
    struct _onkey_t *onkey;
    struct _kbuf_t *kbuf;
    struct _item_t *item;

    /* Check for any keys in the keyboard "buffer" */
    if(_kbinfo.kbuf==NULL) {
        /* Loop until a key has no match in the defined onkey linked list */
        for(;;) {
Continue:
            /* Check menu's keyboard buffer for keystrokes */
            if(_kbinfo.kbuf!=NULL) goto keybuf;

            /* Process keyboard loop handler */
            if(_kbinfo.kbloop!=NULL) {
                while(!KbHit()) {
                    (*_kbinfo.kbloop) ();
                    if(_kbinfo.kbuf!=NULL) break;
                }
            }

            /* Check menu's keyboard buffer for keystrokes */
            if(_kbinfo.kbuf!=NULL) goto keybuf;

            /* Get key from keyboard */
            xch=get_keybrd_xch();
            _kbinfo.source=0;

            /* Search through onkey linked list for a         */
            /* matching defined onkey.  if one is found,      */
            /* then save the current environment, call the    */
            /* onkey's function, and restore the environment. */
            onkey=_kbinfo.onkey;
            while(onkey!=NULL) {
                if( onkey->keycode == xch ) {
                    call_keyfunc(onkey->func);
                    if(_kbinfo.inmenu) return 0;
                    break;
                }
                onkey=onkey->prev;
            }
            if(onkey!=NULL) {
                if(!onkey->pass) continue;
                xch=onkey->pass;
                break;
            }

            /* Search for a menu hot key.  if one is found,    */
            /* then save the current environment, call the     */
            /* hotkey's function, and restore the environment. */
            if(_WinInfo.menu!=NULL) {
                item=find_hotkey(_WinInfo.menu,xch);
                if(item!=NULL) {
                    call_keyfunc(item->select);
                    if(_kbinfo.inmenu) return(0);
                    goto Continue;
                }
            }
  
            break;
        }
    }
    else {
keybuf:
        /* Return key from top of buffer */
        xch=_kbinfo.kbuf->xch;

        /* Set variable to indicate that key came from buffer */
        _kbinfo.source=1;

        /* Free keypress record and update linked list */
        kbuf=_kbinfo.kbuf->next;
        free(_kbinfo.kbuf);
        _kbinfo.kbuf=kbuf;
        if(_kbinfo.kbuf!=NULL) _kbinfo.kbuf->prev=NULL;
    }

    return xch; /* Return keypress */
}

/**/

/* Used by MenuGetXCh() */
static void pascal call_keyfunc (void (*func)(void))
{
    struct _menu_t *menu;
    SHORT sline, eline, row, col;

    VidGetCurSz(&sline,&eline);
    VidReadCur(&row,&col);
    menu=_WinInfo.cmenu;
    (*func)();
    _WinInfo.cmenu=menu;
    VidGotoXY(row,col);
    VidSetCurSz(sline,eline);
}

/**/

/* Used by MenuGetXCh() */
static struct _item_t * pascal find_hotkey (struct _menu_t *wmenu, USHORT xch)
{
    struct _item_t *witem, *item;

    /* Do while more items in this menu */
    for(witem=wmenu->item;witem!=NULL;witem=witem->prev) {

        /* If hot key matches keypress, return its item address */
        if(witem->hotkey==xch&&(!(witem->fmask&M_NOSEL))&&witem->select!=NULL)
            return witem;

        /* If current item has a child menu, process it */
        if(witem->child!=NULL) {
            item=find_hotkey(witem->child,xch);
            if(item!=NULL) return item;
        }
    }
    
    return witem; /* Return address of item found */
}

/**/

/* Used by MenuIFind() */
static struct _item_t * pascal search_menu (struct _menu_t *menu, SHORT tagid)
{
    struct _item_t *witem,*item;

    /* Do while more items in this menu */
    for(witem=menu->item;witem!=NULL;witem=witem->prev) {

        /* If tagid of found item matches item we're      */
        /* searching for, then return that item's address */
        if(witem->tagid==tagid) return witem;

        /* If current item has a child menu, search it */
        if(witem->child!=NULL) {
            item=search_menu(witem->child,tagid);
            if(item!=NULL) return item;
        }
    }

    return witem; /* return address of item found */
}

/**/

/* Calculate the width of the selection bar */
static SHORT pascal calc_bar_width (struct _menu_t *wmenu, struct _item_t *witem)
{
    SHORT width;

    width=strlen(witem->str);
    if(wmenu->barwidth) width=wmenu->barwidth;
    return (width);
}

/**/

/* Calculate the window column at the center of the given menu item */
static SHORT pascal calc_center_item (struct _item_t *item)
{
    return (((SHORT)item->wcol) + (strlen(item->str)/2) );
}

/**/

/* Call a menu item's "after" function if it exists */
static void pascal call_after (struct _item_t *citem)
{
    if(citem->after!=NULL) call_func(citem->after);
}

/**/

/* Call a menu item's "before" function if it exists */
static void pascal call_before (struct _item_t *citem)
{
    if(citem->before!=NULL) call_func(citem->before);
}

/**/

/* Calls the given function */
static void pascal call_func (void (*func)(void))
{
    struct _menu_t *menu;
    WINDOW w;
    /* SHORT err; */

    menu=_WinInfo.cmenu;
    w=WinHandle();
    /* err=whelpush(); */
    (*func)();
    WinActiv(w);
    /* if(!err) whelpop(); */
    _WinInfo.cmenu=menu;
}

/**/

/* Closes the current menu's window and reactivates the menu window open */
/* prior to opening the current menu window  */
static void pascal close_window (WINDOW w)
{
    if(!_WinInfo.cmenu->usecurr) { WinClose(); WinActiv(w); }
}

/**/

/* Displays a menu selection, using selection bar if specified */
static void pascal disp_item (struct _item_t *witem,SHORT bar)
{
    CHAR *p;
    SHORT i;
    SHORT ch, textend, width, chattr, wcol, found=0;

    /* Initialize width of output and end of text */
    p=witem->str;
    width=calc_bar_width(_WinInfo.cmenu,witem);
    textend=_WinInfo.cmenu->textpos+strlen(p)-1;
    wcol=witem->wcol;
    /* WinGotoXY(witem->wrow,wcol); */

    /* Display menu item including selection bar */
    for(i=0;i<width;i++) {

        /* See if currently in bar region.  if so, then use  */
        /* a space for the character. otherwise use the      */
        /* character from the current position in the string */
        ch=(i<(SHORT)_WinInfo.cmenu->textpos||i>textend)?' ':(*p++);

        /* Select attribute of character to be displayed based upon if      */
        /* selection bar was specified, if the menu item is non-selectable, */
        /* if the character is a tag character, or none of the above.       */
        if(bar)
            chattr=_WinInfo.cmenu->barattr;
        else if(witem->fmask&M_NOSEL)
            chattr=_WinInfo.cmenu->noselattr;
        else if((ch==(SHORT)witem->schar)&&!found) {
            found=1;
            chattr=_WinInfo.cmenu->scharattr;
        }
        else chattr=_WinInfo.cmenu->textattr;

        /* Display character in selected attribute */
        WinPrintC(witem->wrow,wcol++,chattr,ch);
    }

    /* Display text description, if one exists */
    if(witem->desc!=NULL&&dispdesc) {
        WinGotoXY(witem->dwrow,witem->dwcol);
        WinTextAttr(witem->dattr);
        WinPutS(witem->desc);
        WinClrEol();
    }
}

/**/

/* Finds the upper-leftmost menu selection */
static struct _item_t * pascal first_item (void)
{
    struct _item_t *best,*temp;

    /* Initialize best record to highest record in linked list */
    best=_WinInfo.cmenu->item;

    /* Search backwards through linked list, testing each item */
    for(temp=best->prev;temp!=NULL;temp=temp->prev) {
        if( (temp->wrow<best->wrow) ||
            ( (temp->wrow==best->wrow) && (temp->wcol<best->wcol) ) )
                best=temp;
    }

    /* See if menu selection is non-selectable */
    if(best->fmask&M_NOSEL) best=right_item(best);

    return (best); /* Return best record */
}

/**/

/* A recursive function that frees a menu and all of its submenus */
static void pascal free_menu (struct _menu_t *wmenu)
{
    struct _item_t *witem;

    /* Free all items in menu, including sub-menus */
    while(wmenu->item!=NULL) {
        if(wmenu->item->child!=NULL) free_menu(wmenu->item->child);
        witem=wmenu->item->prev;
        free(wmenu->item);
        wmenu->item=witem;
        if(wmenu->item!=NULL) wmenu->item->next=NULL;
    }

    free(wmenu); /* Free the menu itself */
}
 
/**/

/* Moves the selection bar to another menu item,  */
/* automatically taking care of necessary pre/post move actions */
static struct _item_t * pascal goto_item (struct _item_t *citem, SHORT which)
{
    struct _item_t *item;

    if(which==ITM_FR) item=first_item();
    else if(which==ITM_LS) item=last_item();
    else item=(*funcs[which])(citem);

    if(item!=citem) { pre_move(citem); post_move(citem=item); }

    return citem;
}

/**/

/* Find the bottom-rightmost menu selection */
static struct _item_t * pascal last_item (void)
{
    struct _item_t *best, *temp;
    SHORT bcol;

    /* Initialize best record to highest record in linked list */
    best=_WinInfo.cmenu->item; bcol=best->wcol;

    /* Search backwards through linked list, testing each item */
    for(temp=best->prev;temp!=NULL;temp=temp->prev) {
        if( (temp->wrow>best->wrow) ||
            ( (temp->wrow==best->wrow) &&
                ((SHORT)temp->wcol>bcol) ) ) {
                    best=temp;
                    bcol=best->wcol;
        }
    }

    /* See if menu selection is non-selectable */
    if(best->fmask&M_NOSEL) best=left_item(best);

    return (best); /* Return best record */
}

/**/

/* Called after a menu bar move */
static void pascal post_move (struct _item_t *citem)
{
    _WinInfo.cmenu->citem=citem;
    _WinInfo.help=citem->help;
    disp_item(citem,1);
    call_before(citem);
}

/**/

static void pascal pre_exit (WINDOW w, SHORT close)
{
    struct _menu_t *wmenu;

    /* If not using current window for menu, then close it */
    if(close) close_window(w);

    /* If at highest menu then free the whole menu structure */
    if(_WinInfo.cmenu==_WinInfo.menu) {
        wmenu=_WinInfo.menu->prev;
        if(_WinInfo.cmenu!=NULL) free_menu(_WinInfo.cmenu);
        _WinInfo.menu=wmenu;
        if(_WinInfo.menu!=NULL) _WinInfo.menu->next=NULL;
        _WinInfo.cmenu=_WinInfo.menu;
    }
}

/**/

/* Prepares for a menu bar move */
static void pascal pre_move (struct _item_t *citem)
{
    disp_item(citem,0);
    call_after(citem);
}

/**/

/* Find the menu selection to the left of current */
static struct _item_t * left_item (struct _item_t *curr)
{
    struct _item_t *best, *temp;
    SHORT wwidth, bpos, tpos, cpos;

    /* Calculate window width and current position */
    wwidth=_WinInfo.cmenu->ecol - _WinInfo.cmenu->scol + 1;
    cpos=(curr->wrow * wwidth) + curr->wcol;

    /* Initialize best record to NULL, and best position to -1 */
    best=NULL; bpos=-1;

    /* Search backwards through linked list, testing each item */
    for(temp=_WinInfo.cmenu->item;temp!=NULL;temp=temp->prev) {

        /* Calculate position of test each item */
        tpos=(temp->wrow*wwidth) + temp->wcol;

        /* Compare position of test item with best item, current item */
        if(tpos>bpos && tpos<cpos) { best=temp; bpos=tpos; }
    }

    /* If there wasn't a item to the left, then wrap around */
    if(best==NULL) best=last_item();
    else
        /* See if menu selection is non-selectable */
        if(best->fmask&M_NOSEL) best=left_item(best);

    return (best); /* Return best record */
}

/**/

/* Find the menu selection to the right of current */
static struct _item_t * right_item (struct _item_t *curr)
{
    struct _item_t *best, *temp;
    SHORT wwidth, bpos, tpos, cpos;

    /* Calculate window width and current position */
    wwidth=_WinInfo.cmenu->ecol - _WinInfo.cmenu->scol + 1;
    cpos=(curr->wrow * wwidth) + curr->wcol;

    /* Initialize best record to NULL, and best position to 32767 */
    best=NULL; bpos=32767;

    /* Search backwards through linked list, testing items */
    for(temp=_WinInfo.cmenu->item;temp!=NULL;temp=temp->prev) {

        /* Calculate position of test item */
        tpos=(temp->wrow*wwidth) + temp->wcol;

        /* Compare position of test item with best item, current item */
        if(tpos<bpos && tpos>cpos) {
            best=temp;
            bpos=tpos;
        }
    }

    /* If there wasn't a item to the right, then wrap around */
    if(best==NULL) best=first_item();
    else
        /* See if menu selection is non-selectable */
        if(best->fmask&M_NOSEL)
            best=right_item(best);

    return (best); /* Return best record */
}

/**/

/* Finds the previous menu selection upwards */
static struct _item_t * up_item (struct _item_t *curr)
{
    struct _item_t *best, *temp;
    SHORT brow, bcol, tcol, crow, trow, ccol, tdist, bdist;

    /* Initialize best record to NULL */
    best=NULL; brow=-1; bcol=32767;

    /* Calculate window column at center of current item */
    crow=(SHORT)curr->wrow; ccol=calc_center_item(curr);

    /* Search backwards through linked list, testing items */
    for(temp=_WinInfo.cmenu->item;temp!=NULL;temp=temp->prev) {

        /* Calculate window column at center of test item */
        trow=(SHORT)temp->wrow;
        tcol=calc_center_item(temp);

        if(trow<crow) {
            tdist=abs(ccol-tcol);
            bdist=abs(ccol-bcol);
            if((trow>brow)||((trow==brow&&tdist<bdist))) {
                best=temp;
                brow=trow;
                bcol=tcol;
            }
        }
    }

    /* If there wasn't a item to the left, then wrap around */
    if(best==NULL) {
        if((temp=malloc(sizeof(struct _item_t)))==NULL) {
            best=curr;
        }
        else {
            *temp=*curr;
            temp->wrow=255;
            best=up_item(temp);
            free(temp);
        }
    }
    else
        /* See if menu selection is non-selectable */
        if(best->fmask&M_NOSEL) best=up_item(best);

    return (best); /* return best record */
}

/**/

/* Finds the next menu selection down */
static struct _item_t * down_item (struct _item_t *curr)
{
    struct _item_t *best,*temp;
    SHORT brow, bcol, tcol, trow, crow, ccol, tdist, bdist;

    /* Initialize best record to NULL */
    best=NULL; brow=bcol=32767;

    /* Calculate window column at center of current item */
    crow=(SHORT)curr->wrow;
    ccol=calc_center_item(curr);

    /* Search backwards through linked list, testing each item */
    for(temp=_WinInfo.cmenu->item;temp!=NULL;temp=temp->prev) {

        /* Calculate window column at center of test item */
        trow=(SHORT)temp->wrow;
        tcol=calc_center_item(temp);

        if(trow>crow) {
            tdist=abs((ccol-tcol));
            bdist=abs((ccol-bcol));
            if((trow<brow)||((trow==brow&&tdist<bdist))) {
                best=temp;
                brow=trow;
                bcol=tcol;
            }
        }
    }

    /* If there wasn't an item downwards, then wrap around */
    if(best==NULL) {
        if((temp=malloc(sizeof(struct _item_t)))==NULL) {
            best=curr;
        }
        else {
            *temp=*curr;
            temp->wrow=-1;
            best=down_item(temp);
            free(temp);
        }
    }
    else
        /* See if menu selection is non-selectable */
        if(best->fmask&M_NOSEL) best=down_item(best);

    return (best); /* Return best record */
}

/**/

static USHORT pascal get_keybrd_xch (VOID)
{
    KBDKEYINFO KbdData;
    HKBD KbdHandle=0;
    USHORT key;

    memset(&KbdData,'\0',sizeof(KBDKEYINFO));
    KbdCharIn(&KbdData,IO_WAIT,KbdHandle);

    if(KbdData.chChar==0xE0) KbdData.chChar=0x00;

    /* Convert 'extended' keyboard ENTER to 'normal' scan code */
    if((KbdData.chChar==0x0D)&&(KbdData.chScan==0xE0)) KbdData.chScan=0x1C;

    key=(KbdData.chScan<<8)+KbdData.chChar;

    /*
    fprintf(stderr, "[_bios_keybrd out]\t ch=0x%02x; scan=0x%02x; key=0x%04x;\n",
        KbdData.chChar, KbdData.chScan, key);
    */
    return key;
}

/**/

/* Returns the scan code of an ASCII character  */
static SHORT pascal scan_code (SHORT ch)
{
    static UCHAR sc_table[] = {
    /*  ^2  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O      */
         3, 30, 48, 46, 32, 18, 33, 34, 35, 23, 36, 37, 38, 50, 49, 24,
    /*  ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^\  ^]  ^6  ^-      */
        25, 16, 19, 31, 20, 22, 47, 17, 45, 21, 44, 26, 43, 27,  7, 12,
    /*       !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /      */
        57,  2, 40,  4,  5,  6,  8, 40, 10, 11,  9, 13, 51, 12, 52, 53,
    /*   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?      */
        11,  2,  3,  4,  5,  6,  7,  8,  9, 10, 39, 39, 51, 13, 52, 53,
    /*   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O      */
         3, 30, 48, 46, 32, 18, 33, 34, 35, 23, 36, 37, 38, 50, 49, 24,
    /*   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _      */
        25, 16, 19, 31, 20, 22, 47, 17, 45, 21, 44, 26, 43, 27,  7, 12,
    /*   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o      */
        41, 30, 48, 46, 32, 18, 33, 34, 35, 23, 36, 37, 38, 50, 49, 24,
    /*   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  ^bksp   */
        25, 16, 19, 31, 20, 22, 47, 17, 45, 21, 44, 26, 43, 27, 41, 14
    };

    return ( (ch<=127) ? sc_table[ch] : 0 );
}

/**/

SHORT KbHit (VOID)
{
    KBDKEYINFO kbciKeyInfo;

    if(KbdPeek(&kbciKeyInfo,0)) return 0;

    /* Double-byte character set */
    if(kbciKeyInfo.fbStatus & 0x80) if(KbdPeek(&kbciKeyInfo,0)) return 0;

    if(kbciKeyInfo.fbStatus & 0x40) return 1; /* Return True if found */

    return 0;
}

/**/

