/*͸
   OS/2 Video API Version 1.00  04-09-96    (C) 1996 by CodeLand Australia 
   LIST.C ListBox routines                             All Rights Reserved 
  ;*/

#define DEBUG

#include <stdio.h> /* DEBUG */
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <conio.h>

#define INCL_DOS
#define INCL_VIO
#define INCL_KBD
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "list.h"

/* List item movement definitions */
#define ITM_UP  0
#define ITM_DN  1
#define ITM_FR  2
#define ITM_LS  3

/**/

PLISTITEM ListIFind (PLIST Plist, SHORT tagid);
static VOID disp_item (PLIST Plist, PLISTITEM witem, SHORT bar);
static SHORT calc_bar_width (struct _list *wmenu, PLISTITEM witem);
static VOID pre_exit (PLIST Plist, WINDOW w, SHORT close);
static VOID free_list (struct _list *wmenu);
static VOID close_window (PLIST Plist, WINDOW w);
static PLISTITEM search_list (struct _list *list, SHORT tagid);
static PLISTITEM first_item (PLIST Plist);
static PLISTITEM up_item (PLIST Plist, PLISTITEM curr);
static PLISTITEM down_item (PLIST Plist, PLISTITEM curr);
static PLISTITEM last_item (PLIST Plist);
static VOID pre_move (PLIST Plist, PLISTITEM citem);
static VOID post_move (PLIST Plist, PLISTITEM citem);
static PLISTITEM goto_item (PLIST Plist, PLISTITEM citem, SHORT which);

/**/

#if defined(DEBUG)
VOID ListShadow (VOID);
VOID main (SHORT argc, PCHAR argv[])
{
    PUSHORT ScrnSave;
    SHORT val, i, bdrtype=0;
    CHAR Str[16][16];
    PLIST Plist=NULL;

    /* Init the video api */
    VidVideoInit();

    /* Save screen and display background */
    ScrnSave=VidSSave(); VidHideCur(); VidcClrScrn(0xB0,WHITE|_LGREY);

    /* Setup example data */
    val=0;
    for(i=0;i<16;i++) sprintf(Str[i],"Item %2d",i+1);

    ListBeg(&Plist,8,25,12,10,bdrtype,BLUE|_LGREY,BLUE|_LGREY,ListShadow);
    for(i=0;i<16;i++) ListItem(Plist,i,0,Str[i],i);
    ListEnd(Plist,val,20,1,BLUE|_LGREY,WHITE|_RED);
    val=ListGet(Plist);

    /* Restore the screen and cursor */
    VidSRestore(ScrnSave); VidShowCur();

    exit(0);
}
VOID ListShadow (VOID)
{
    WinShadow(DGREY|_BLACK);
}
#endif

/**/

SHORT ListBeg (PLIST *Plist, SHORT srow, SHORT scol, SHORT length, SHORT width,
    SHORT btype, SHORT battr, SHORT wattr, VOID (*open)(VOID))
{
    /* Allocate memory for new list record */
    if((*Plist=malloc(sizeof(struct _list)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);

    /* Save info in list record */
    (*Plist)->srow=(UCHAR)srow;
    (*Plist)->scol=(UCHAR)scol;
    (*Plist)->erow=(UCHAR)(srow+length+1);
    (*Plist)->ecol=(UCHAR)(scol+width+1);
    (*Plist)->btype=(UCHAR)btype;
    (*Plist)->battr=(UCHAR)VidMapAttr(battr);
    (*Plist)->wattr=(UCHAR)VidMapAttr(wattr);
    (*Plist)->open=open;
    (*Plist)->usecurr=0;
    (*Plist)->ListItemNum=0;
    (*Plist)->ListItemCur=0;
    (*Plist)->DisplayCount=length;
    (*Plist)->DisplayOffset=0;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListBegC (PLIST *Plist)
{
    /* Call ListBeg() using current window parameters */
    if(ListBeg(Plist,_WinInfo.active->srow,_WinInfo.active->scol,
        (_WinInfo.active->srow-_WinInfo.active->erow)-1,
        (_WinInfo.active->scol-_WinInfo.active->ecol)-1,
        _WinInfo.active->btype,
        _WinInfo.active->battr,_WinInfo.active->wattr,NULL))
        return(_WinInfo.errno);

    /* Turn on use-current-window flag */
    (*Plist)->usecurr=1;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListItem (PLIST Plist, SHORT wrow, SHORT wcol, CHAR *str, SHORT tagid)
{
    PLISTITEM Pitem;

    /* Make sure that ListBeg() or ListBegC() has been called */
    if(NULL==Plist) return (_WinInfo.errno=W_NOMNUBEG);

    /* Allocate memory for new item record */
    if((Plist->ListItem[Plist->ListItemNum]=(PLISTITEM)malloc(sizeof(LISTITEM)))==NULL)
        return (_WinInfo.errno=W_ALLOCERR);
    Pitem=Plist->ListItem[Plist->ListItemNum];

    /* Save info in item record */
    Pitem->wrow   = (UCHAR)wrow;
    Pitem->wcol   = (UCHAR)wcol;
    strcpy(Pitem->data,str);
    Pitem->tagid  = tagid;

    (Plist->ListItemNum)++;

    return (_WinInfo.errno=W_NOERROR); /* Return normally */
}

/**/

SHORT ListEnd (PLIST Plist, SHORT taginit, SHORT barwidth, SHORT textpos,
    SHORT textattr, SHORT barattr)
{
    PLISTITEM Pitem;
    SHORT i, w_width, border, found;

    /* Make sure that the specified initial tagid matches the */
    /* tagid of one of the defined list items in this list    */
    for(i=0;i<Plist->ListItemNum;i++) {
        if(Plist->ListItem[i]->tagid==taginit) { found=1; break; }
    }
    if(!found) return (_WinInfo.errno=W_INVTAGID);

    /* If bar width > window width, then bar width = window width */
    border=(Plist->btype==5)?0:1;
    w_width=(Plist->ecol-border)-(Plist->scol+border)+1;
    if(barwidth>w_width) barwidth=w_width;

    /* Add rest of list information to list record */
    Plist->citem     = NULL;
    Plist->tagcurr   = taginit;
    Plist->barwidth  = (UCHAR)barwidth;
    Plist->textpos   = barwidth?(UCHAR)textpos:(UCHAR)0;
    Plist->textattr  = (UCHAR)VidMapAttr(textattr);
    Plist->barattr   = _VidInfo.MapAttr ?
        (UCHAR)VidRevsAttr(Plist->textattr) : (UCHAR)barattr;

    return (_WinInfo.errno=W_NOERROR); /* Return with no error */
}

/**/

SHORT ListGet (PLIST Plist)
{
    USHORT xch;
    PLISTITEM citem;
    PLISTITEM item;
    CHAR ch;
    WINDOW w;
    SHORT i;

    /* Make sure we have a defined list */
    if(NULL==Plist) { _WinInfo.errno=W_NOMNUDEF; return -1; }

    /* Open list's window (unless list is to use current window) */
    if(!Plist->usecurr) {
        w=WinHandle();
        if(!WinOpen(Plist->srow,Plist->scol,
            Plist->erow,Plist->ecol,Plist->btype,
            Plist->battr,Plist->wattr)
        ) return -1;

        /* Call list open */
        if(Plist->open!=NULL) (*Plist->open)();
    }

    /* Display all list items */
    for(i=0;i<Plist->ListItemNum;i++) {
        disp_item(Plist,Plist->ListItem[i],0);
    }

    /* search for                                                  */
    /* the initial tag ID position.  If no initial tag ID position */
    /* was specified, then find the first list item.               */
    Plist->ListItemCur=0;

    /* Display current list item */
    post_move(Plist,Plist->ListItem[Plist->ListItemCur]);

    /* Main process of function */

    for(;;) {
        /* Update current list item */
        Plist->citem=citem;

        /* Read keyboard for keypress, then test the keypress */
        _kbinfo.inmenu=TRUE;
        citem=Plist->citem;
        xch=MenuGetXCh();
        _kbinfo.inmenu=FALSE;
        switch(xch) {
            case 0x011b:    /* Esc */
                /* If Esc checking is on, erase selection bar, */
                /* free list records and return to caller      */
                if(_WinInfo.esc) {
                    pre_move(Plist,citem);
                    pre_exit(Plist,w,1);
                    _WinInfo.errno=W_ESCPRESS;
                    return -1;
                }
                break;

            case 0x4700:    /* Home */
                /* Hide selection bar and find upper-leftmost list item */
                citem=goto_item(Plist,citem,ITM_FR);
                break;

            case 0x4800:    /* UpArrow */
                citem=goto_item(Plist,citem,ITM_UP);
                break;

            case 0x5000:    /* DownArrow */
                citem=goto_item(Plist,citem,ITM_DN);
                break;

            case 0x4f00:    /* End */
                /* Hide selection bar and find */
                /* lower-rightmost list item   */
                citem=goto_item(Plist,citem,ITM_LS);
                break;

            case 0x1c0d:    /* Enter */
                /* Display list item with selection bar */
                disp_item(Plist,citem,1);

                /* Free list records, and return tag                 */
                /* identifier of current list item                   */
                pre_exit(Plist,w,1);
                _WinInfo.errno=W_NOERROR;
                return (citem->tagid);

            default:
                /* Separate ASCII code from keypress code, if ASCII */
                /* code is zero, then it must be an extended key    */
                ch=(CHAR)xch;
                if(!ch) break;
        }
    }
}

/**/

/* Finds item record in a list structure */
PLISTITEM ListIFind (PLIST Plist, SHORT tagid)
{
    PLISTITEM item;

    /* Check for existance of a list */
    if(Plist==NULL) {
        _WinInfo.errno=W_NOMNUDEF;
        return NULL;
    }

    /* Start search process at root of list structure */
    item=search_list(Plist,tagid);

    /* Return to caller */
    _WinInfo.errno=(item==NULL?W_NOTFOUND:W_NOERROR);
    return item;
}


/**/

/* Displays a list selection, using selection bar if specified */
static VOID disp_item (PLIST Plist, PLISTITEM witem, SHORT bar)
{
    CHAR *p;
    SHORT i;
    SHORT ch, textend, width, chattr, wcol, found=0, wrow;

    /* Calculate window row */
    wrow=witem->ItemNum-Plist->DisplayOffset;

    /* Initialize width of output and end of text */
    p=witem->data;
    width=calc_bar_width(Plist,witem);
    textend=Plist->textpos+strlen(p)-1;
    wcol=witem->wcol;

    /* Display list item including selection bar */
    for(i=0;i<width;i++) {

        /* See if currently in bar region.  if so, then use  */
        /* a space for the character. otherwise use the      */
        /* character from the current position in the string */
        ch=(i<(SHORT)Plist->textpos||i>textend)?' ':(*p++);

        /* Select attribute of character to be displayed based upon if      */
        /* selection bar was specified, if the list item is non-selectable, */
        /* if the character is a tag character, or none of the above.       */
        if(bar) chattr=Plist->barattr;
        else chattr=Plist->textattr;

        /* Display character in selected attribute */
        WinPrintC(wrow,wcol++,chattr,ch);
    }
}

/**/

/* Calculate the width of the selection bar */
static SHORT calc_bar_width (struct _list *wmenu, PLISTITEM witem)
{
    SHORT width;

    width=strlen(witem->data);
    if(wmenu->barwidth) width=wmenu->barwidth;
    return (width);
}

/**/

static VOID pre_exit (PLIST Plist, WINDOW w, SHORT close)
{
    /* If not using current window for list, then close it */
    if(close) close_window(Plist, w);

    free_list(Plist);
}

/**/

/* Frees a list and all of its subitems */
static VOID free_list (struct _list *wmenu)
{
    PLISTITEM witem;

    /* Free all items in list */
    while(wmenu->item!=NULL) {
        witem=wmenu->item->prev;
        free(wmenu->item);
        wmenu->item=witem;
        if(wmenu->item!=NULL) wmenu->item->next=NULL;
    }

    free(wmenu); /* Free the list itself */
}

/**/

/* Closes the current list's window and reactivates the window open */
/* prior to opening the current list window  */
static VOID close_window (PLIST Plist, WINDOW w)
{
    if(!Plist->usecurr) { WinClose(); WinActiv(w); }
}

/**/

/* Used by ListIFind() */
static PLISTITEM search_list (struct _list *list, SHORT tagid)
{
    PLISTITEM witem;

    /* Do while more items in this list */
    for(witem=list->item;witem!=NULL;witem=witem->prev) {

        /* If tagid of found item matches item we're      */
        /* searching for, then return that item's address */
        if(witem->tagid==tagid) return witem;
    }

    return witem; /* return address of item found */
}

/**/

/* Finds the first list item */
static PLISTITEM first_item (PLIST Plist)
{
    PLISTITEM temp;

    temp=Plist->item;
    while(temp->prev!=NULL) temp=temp->prev;

    return temp;
}

/**/

/* Finds the previous list item */
static PLISTITEM up_item (PLIST Plist, PLISTITEM curr)
{
    if(curr->prev==NULL) return curr;
    return curr->prev;
}

/**/

/* Finds the next list item */
static PLISTITEM down_item (PLIST Plist, PLISTITEM curr)
{
    if(curr->next==NULL) return curr;
    return curr->next;
}

/**/

/* Find the last list item */
static PLISTITEM last_item (PLIST Plist)
{
    return Plist->item;
}


/**/

/* Prepares for a list bar move */
static VOID pre_move (PLIST Plist, PLISTITEM citem)
{
    disp_item(Plist,citem,0);
}

/**/

/* Called after a list bar move */
static VOID post_move (PLIST Plist, PLISTITEM citem)
{
    Plist->citem=citem;
    disp_item(Plist,citem,1);
}

/**/

/* Moves the selection bar to another list item,  */
/* automatically taking care of necessary pre/post move actions */
static PLISTITEM goto_item (PLIST Plist, PLISTITEM citem, SHORT which)
{
    PLISTITEM item;

    if(which==ITM_UP) item=up_item(Plist,citem);
    else if(which==ITM_DN) item=down_item(Plist,citem);
    else if(which==ITM_FR) item=first_item(Plist);
    else if(which==ITM_LS) item=last_item(Plist);

    if(item!=citem) { pre_move(Plist,citem); post_move(Plist,citem=item); }

    return citem;
}

/**/

