/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   DESC.C User description functions                   All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_DOS
#include <os2.h>

#include "form.h"
#include "user.h"
#include "ued.h"
#include "desc.h"

/**/

FILE *cp=NULL;              /* Descriptions file pointer */
CHAR desc_text[EXT_MAXC+1]; /* Descriptions buffer */

/**/

static ULONG PASCAL find_space (USHORT length);
static SHORT PASCAL make_len (USHORT ctl, USHORT len);
static VOID break_len (PUSHORT ctl, PUSHORT len, USHORT lenfield);

/**/

/* Read a description from USER.EXT at offset 'offset' */
SHORT PASCAL ReadDesc (ULONG offset)
{
    USHORT lrptr, lenfield, ctl, len;

    if(cp==NULL) if(!OpenDesc()) return 0;         /* Open file if necessary */

    if(fseek(cp,offset,SEEK_SET)) return 0;              /* Goto offset       */
    if(fread(&lrptr,sizeof(USHORT),1,cp)!=1) return 0;   /* Read lastread     */
    if(lrptr!=Ud->Usr->lastread_ptr) return 0;           /* lr check          */
    if(fread(&lenfield,sizeof(USHORT),1,cp)!=1) return 0;/* Read length       */
    break_len(&ctl,&len,lenfield);                       /* Compute ctl & len */
    if(ctl!=EXT_DESC) return 0;                          /* Check is desc     */
    if(len>EXT_MAXC+1) len=EXT_MAXC+1;               /* Adjust for max rd len */
    if(fread(desc_text,len,1,cp)!=1) return 0;           /* Read description  */
    desc_text[EXT_MAXC]='\0';                            /* Safty             */

    return 1;
}

/**/

/* Updates a user description, returns offset or zero on error */
ULONG PASCAL WritDesc (ULONG offset)
{
    USHORT lrptr, lenfield, ctl, len, nlen;

    if(cp==NULL) if(!OpenDesc()) return 0L; /* Open the file if necessary */

    nlen=strlen(desc_text)+1; /* Get length of new description */

    /* Get old length */
    if(fseek(cp,offset,SEEK_SET)) return 0L;
    if(fread(&lrptr,sizeof(USHORT),1,cp)!=1) return 0L; /* Read lastread */
    if(fread(&lenfield,sizeof(USHORT),1,cp)!=1) return 0L; /* Read length */
    break_len(&ctl,&len,lenfield); /* Get type and length */

    if(nlen>len) { /* Is new length larger than entry on disk */
        /* Delete old entry, add new one */
        DelDesc(offset);
        return AddDesc();
    }

    /* Update existing entry */
    lrptr=Ud->Usr->lastread_ptr;
    ctl=EXT_DESC; lenfield=make_len(ctl,len);
    if(len>EXT_MAXC+1) len=EXT_MAXC+1; /* Fix to our maximum buffer for write */
    if(fseek(cp,offset,SEEK_SET)) return 0L;
    if(fwrite(&lrptr,sizeof(USHORT),1,cp)!=1) return 0L; /* Write lastread */
    if(fwrite(&lenfield,sizeof(USHORT),1,cp)!=1) return 0L; /* Write length */
    if(fwrite(desc_text,len,1,cp)!=1) return 0L;

    return offset;
}

/**/

/* Writes a new user description, returns offset or zero on error */
ULONG PASCAL AddDesc (VOID)
{
    USHORT lrptr, lenfield, ctl, len;
    ULONG offset;

    if(cp==NULL) if(!OpenDesc()) return 0L; /* Open the file if necessary */

    len=strlen(desc_text)+1; /* Get length of new description */

    /* Check for free space in the file */
    if((offset=find_space(len))==0L) {
        /* No free space, so append to the file */
        if(fseek(cp,0L,SEEK_END)) return 0L; /* Goto eof */
        if((offset=ftell(cp))==-1L) return 0L;
    }
    else { /* Get old length to use */
        if(fseek(cp,offset,SEEK_SET)) return 0L;
        if(fread(&lrptr,sizeof(USHORT),1,cp)!=1) return 0L; /* Read lastread */
        if(fread(&lenfield,sizeof(USHORT),1,cp)!=1) return 0L; /* Read length */
        break_len(&ctl,&len,lenfield); /* Get type and length */
    }

    lrptr=Ud->Usr->lastread_ptr;
    ctl=EXT_DESC; lenfield=make_len(ctl,len);
    if(len>EXT_MAXC+1) len=EXT_MAXC+1; /* Fix to our maximum buffer for write */
    if(fseek(cp,offset,SEEK_SET)) return 0L;
    if(fwrite(&lrptr,sizeof(USHORT),1,cp)!=1) return 0L; /* Write lastread */
    if(fwrite(&lenfield,sizeof(USHORT),1,cp)!=1) return 0L; /* Write length */
    if(fwrite(desc_text,len,1,cp)!=1) return 0L;

    return offset;
}

/**/

/* Change description entry  to free space */
VOID PASCAL DelDesc (ULONG offset)
{
    USHORT lenfield, ctl, len;

    if(cp==NULL) if(!OpenDesc()) return;

    /* Seek to length entry */
    if(fseek(cp,offset+sizeof(USHORT),SEEK_SET)) return;

    /* Fix ctl/length entry */
    if(fread(&lenfield,sizeof(USHORT),1,cp)!=1) return; /* Read length */
    break_len(&ctl,&len,lenfield); /* Get length and ctl info */
    if(ctl!=EXT_DESC) return;
    ctl=EXT_FREE;
    lenfield=make_len(ctl,len);
    if(fseek(cp,offset+sizeof(USHORT),SEEK_SET)) return;
    if(fwrite(&lenfield,sizeof(USHORT),1,cp)!=1) return; /* Write length */
}

/**/

/* Open description file, return true on success */
SHORT PASCAL OpenDesc (VOID)
{
    CHAR fname[160], ident[2];
    PCHAR p;

    /* Build fill file path&name */
    strcpy(fname,Ud->Mpath);
    if(*fname&&fname[strlen(fname)-1]!='\\') strcat(fname,"\\");
    strcat(fname,Ud->Uname);
    p=FormStrIInc(".BBS",fname);
    if(p!=NULL) strcpy(p,".EXT");
    else return 0;

    if((cp=fopen(fname,"r+b"))==NULL) {
        /* Create the file */
        if((cp=fopen(fname,"w+b"))==NULL) return 0;
        fputs("M!",cp);
        return 1;
    }

    /* Check the file ident */
    if(fread(ident,2*sizeof(CHAR),1,cp)!=1) return 0; /* Read ident */
    if(ident[0]!='M'||ident[1]!='!') return 0;

    return 1;
}

/**/

/* Close description file */
VOID PASCAL CloseDesc (VOID)
{
    if(cp!=NULL) { fclose(cp); cp=NULL; }
}

/**/

/* Cuts description buffer into 3 strings for display */
VOID PASCAL SplitDesc (PCHAR d1, PCHAR d2, PCHAR d3)
{
    SHORT len;
    PCHAR p;

    d1[0]='\0'; d2[0]='\0'; d3[0]='\0';
    len=strlen(desc_text);
    strncpy(d1,desc_text,EXT_LLEN); d1[EXT_LLEN]='\0';
    if(len>EXT_LLEN) {
        p=desc_text+EXT_LLEN;
        strncpy(d2,p,EXT_LLEN); d2[EXT_LLEN]='\0';
        if(len>EXT_LLEN*2) {
            p=desc_text+EXT_LLEN*2;
            strncpy(d3,p,EXT_LLEN); d3[EXT_LLEN]='\0';
        }
    }
}

/**/

/* Adds three strings into description buffer */
VOID PASCAL JoinDesc (PCHAR d1, PCHAR d2, PCHAR d3)
{
    strcpy(desc_text,d1); strcat(desc_text,d2); strcat(desc_text,d3);
    FormStrTrim(desc_text);
}

/**/

static ULONG PASCAL find_space (USHORT length)
{
    USHORT lrptr, lenfield, ctl, len;
    ULONG ofsave, offset;

    offset=2L;
    rewind(cp); /* Position at start of file */
    if(fseek(cp,offset,SEEK_SET)) return 0L; /* Goto first record */

    for(;;) {
        ofsave=offset; /* Save start of record position for insert */
        /* Read start of desc record (lastread pointer) */
        if(fread(&lrptr,sizeof(USHORT),1,cp)!=1) return 0L;
        offset+=sizeof(USHORT); /* Adjust running offset */
        if(fread(&lenfield,sizeof(USHORT),1,cp)!=1) return 0L; /* Read length */
        offset+=sizeof(USHORT); /* Adjust running offset */
        break_len(&ctl,&len,lenfield); /* Get type and length */

        if(ctl==EXT_FREE && len>=length) { /* Found an insert spot */
            return ofsave;
        }

        if(fseek(cp,(long)len,SEEK_CUR)) return 0L; /* Skip desc block */
        offset+=len; /* Adjust running offset */
    }
}

/**/

/* Generates EXT file len field from type and desc length */
static SHORT PASCAL make_len (USHORT ctl, USHORT len)
{
    len&=0x0FFF;    /* Zero ctl section of len */
    ctl=ctl<<12;    /* Move ctl info */
    return ctl|len;
}

/**/

/* Generates type and desc length from EXT file len field */
static VOID break_len (PUSHORT ctl, PUSHORT len, USHORT lenfield)
{
    *ctl=lenfield>>12;
    *len=lenfield&0x0FFF; /* Zero ctl section */
}

/**/

