//<c>   Copyright 1998-1999 by Gerry J. Danen; all rights reserved.

//<t>   Convert Squish Message Bases to HTML

//      Compiled with Microsoft C 8.00. Requires DANEN library and
//      Squish Developers Kit Version 2.00 (SQDEV200.ZIP) to recompile.
//      Source released into the Public Domain.

//      todo (maybe...):
//      build index in memory as a linked list, with message numbers attached,
//      then process from linked list.


#include"gd_tools.h"
#include"gd_extrn.h"
#include"gd_ansi.h"
//#include"gd_llist.h"            // for linked lists
#include"msgapi.h"              // from Squish Developers Kit v2.00


#define pgVERS_ "V1.30"
#define pgTITL_ "Convert Squish Message Base to HTML"
#define pgCOPR_ "1998"

#define DEBUG   0

#if     (! LARGE_MODEL)
  #error LARGE MEMORY MODEL REQUIRED
#endif


#define HTML_FONT               "Verdana, Arial, Helvetica"
#define HTML_BG                 "bg_y2k.gif"    // or something like "/_support/bg_y2k.gif"
#define BUFSIZE                 4096
#define MAXMSGLINESIZE          18000
#define PREV_INIT_STRING        "**!@#$%^&(abc)_+**"
#define MAXKEY                  140


//      variables starting with SQ are used by the Squish message API
char    *SQbufr, *SQctrl, cLast='\xFF', cMarker='\xFE', sMarker[]="\xFE",
        cmd[1025], msFrom[XMSG_FROM_SIZE*2], msSubj[XMSG_SUBJ_SIZE*2],
        msTo[XMSG_TO_SIZE*2], msDate[12], msTime[8], sArchiveName[FS_LEN],
        sMsgOut[FS_LEN], sPrefix[5], sSQD[FS_LEN], sSortWork[]="SQ$SORT.$$$",
        sTmp[FS_LEN], sCompact[]="SQ$COM.$$$", sTopOut[FS_LEN],
        sComBuf[MAXMSGLINESIZE+1] ;

int     iLongestKey=0 ;
FILE    *fTop, *fMsg, *fTmp, *fWrk, *fCom ;
ULONG   nTotalMessages=0, nThisMsg=0, nTopicNumber=0, nTotalTopics=0,
        nEarlyDate=999999999 ;
BOOL    ynProcess=FALSE, ynMsgIsOpen=FALSE, ynCompact=FALSE, ynDeBug=FALSE ;
XMSG    SQmsg ;
HAREA   SQhArea ;
HMSG    SQhMsg ;
dword   SQoffset ;
long    SQgot ;
int     SQmsgtype, SQctrlsize ;
struct _minf SQmi ;


//      function definitions
void    main(int argc,char *argv[]);
void    help(void);
void    init(STRING par1,STRING par2);
void    phase_1(void);
void    phase_2(void);
void    phase_3(void);
void    finish(void);
void    format_header_field(STRING pDest,STRING pFrom,STRING pXlate);


// ---- User Help ----------------------------------------------------------- //~~~

void    help_more( void )
{
    fprintf( stderr, "\rPress a key to continue..." );
    while ( ! _getch() )
        ;
    fprintf( stderr, "\r                          \r" );
}


void    help( void )
{
    printf(
        "\n%s converts a Squish message base to a set of HTML pages, \n"
        "and a top index to control access to individual pages.\n\n"
        "%s needs 2 parameters: the name of the .SQ? database, and the name of the\n"
        "top level index.\n\n"
        "Example: %s 2000 y2kmess\n\n"
        "This will read 2000.SQ*, and create Y2KMESS.HTM, along with Y2KM0001.HTM,\n"
        "Y2KM0002.HTM, Y2KM0003.HTM, etc.\n\n"
        "A third parameter may be used to create more compact HTML message pages, and\n"
        "eliminate any SEEN-BY's at the end of some messages. The trade-off is speed.\n"
        "This option requires an intermediate file to be created... Use /COMPACT or\n"
        "/C for this option.\n\n",
        get_global_program_name(), get_global_program_name(), get_global_program_name() );
    help_more();
    printf(
        "The created pages are best viewed with IE4 and later, as it uses font styles.\n"
        "Netscape and other browser users should experiment with default fonts to get\n"
        "pages to show nicely. Try the Verdana/Arial/Helvetica fonts with 8 and 10pt\n"
        "size. Verdana 8pt and Arial 10pt worked well in our tests. You may wish to\n"
        "point this out to your readers.\n\n"
        "SET environment variable GD.DEBUG=Y to save debug information...\n" );
    exit( GD_ERROR_HELP );
}



void    write_temp( FILE *ff, ULONG msgnum, STRING subj, STRING fr, STRING to, STRING dt, ULONG d, ULONG early )
{
    static UCHAR key[161], sub[sizeof(msSubj)], sdt[9], smn[9] ;

//  what do we want as a key? each individual key becomes a separate topic...
//  I think we want the "only_alnum" part of the topic, and then we need
//  message numbers...

    sprintf( smn, "%05lu", msgnum );
    ST_CPY( key, subj );
    st_keep_only_alnum( key );
    strupr( key );
    if ( (int) strlen(key) > iLongestKey )
        iLongestKey = strlen(key);
    fprintf( ff, "%s%c%06lu\n", key, cMarker, msgnum );

#if DEBUG
    // printf("wt> %d %s %s %s %s\n", (int) msgnum, subj, fr, to, dt );
#endif
}


void    format_header_field( STRING pDest, STRING pFrom, STRING pXlate )
{
    strcpy( pDest, pFrom );
    st_xlate( pDest, pXlate, "" );
    st_reduce_spaces( pDest );
    st_trim ( pDest );
    st_uplow( pDest );

//  remove leading and trailing junk characters
    while ( *pDest != EOS )                     // leading character check
    {
        if ( isalnum(*pDest) )
            break ;
        if ( *pDest == '\"' ||
             *pDest == '`' ||
             *pDest == '$' ||
             *pDest == '[' ||
             *pDest == '(' )
            break ;
        *pDest = ' ' ;
        st_trim ( pDest );
    }
    while ( strlen(pDest) )                     // trailing character check
    {
        if ( isalnum(ST_LASTCHAR(pDest)) )
            break ;
        if ( ST_LASTCHAR(pDest) == '\"' ||
             ST_LASTCHAR(pDest) == '\'' ||
             ST_LASTCHAR(pDest) == '`' ||
             ST_LASTCHAR(pDest) == '?' ||
             ST_LASTCHAR(pDest) == ']' ||
             ST_LASTCHAR(pDest) == ')' )
            break ;
        ST_CLR_LASTCHAR(pDest);
        st_trim ( pDest );
    }
    st_trim( pDest );
}


void    format_date( UCHAR date[] )
{
    date[2] = date[6] = ' ' ;
    if ( date[0] == '0' )
        date[0] = ' ' ;
    st_trim( date );
}


long    format_header_data( STRING sub, STRING frm, STRING to, STRING dt, STRING tm )
{
    static long d, m, y, hh, mm, ss, nDt ;
    static char sTm[8], sDt[12] ;

    format_header_field( frm, SQmsg.from, "." );
    format_header_field( to , SQmsg.to  , "." );
    format_header_field( sub, SQmsg.subj, "!^*_" );

    //  note that the "re:" part is not always followed by a space...
    st_cpy( cmd, sub, 4 );
    if ( st_eq( cmd, "re:" ) )
    {
        sub[0] = sub[1] = sub[2] = ' ' ;
        st_trim( sub );
    }

    st_get_word( cmd, sub );
    if ( st_eq( cmd, "re" ) || st_eq( cmd, "re:" ) )
        st_remove_word( sub );                  // remove first word in string

    if ( ! strlen(frm) )
        strcpy( frm, "n/a" );
    if ( ! strlen(to) )
        strcpy( to, "All" );
    if ( ! strlen(sub) )
        strcpy( sub, "no subject" );

    d   = SQmsg.date_written.date.da ;
    m   = SQmsg.date_written.date.mo ;
    y   = SQmsg.date_written.date.yr+1980 ;

    nDt = (long) (y*10000+m*100+d) ;

    hh  = SQmsg.date_written.time.hh ;
    mm  = SQmsg.date_written.time.mm ;
    ss  = SQmsg.date_written.time.ss ;

    FormatTime( ((INT32) ((hh*100)+mm)), sTm, 2, 0 );
    FormatDate( ((INT32) nDt), sDt, 9 );
    format_date( sDt );
    if ( sTm[0] == '0' )  sTm[0] = ' ' ;
    st_trim( sTm );
    strcpy( dt, sDt );
    strcpy( tm, sTm );
    return( nDt );
}



// ---- Message File Processing --------------------------------------------- //~~~

void    new_message_file( void )
{
    sprintf( sMsgOut, "%s%04d.HTM", sPrefix, nTopicNumber );
    fMsg = fopen( sMsgOut, "w" );
    if ( ! fMsg )
    {
        fprintf( stderr, "\rCannot create %s\a\n", sMsgOut );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }
    ynMsgIsOpen = TRUE ;
    fprintf( stderr, "\rCreating %s", sMsgOut );

    fprintf( fMsg, "<html><head><title>%s: %s</title>"
                   "<meta name=\"GENERATOR\" content=\"%s %s\"></head><body>\n",
                   sArchiveName, msSubj, pgm_name, pgm_vers );
}


void    process_message( long len )
{
    register int x ;
    register char c ;

    len -- ;
    ynProcess = TRUE ;
    LOOP( x, 0, len, 1 )
    {
        c = SQbufr[x] ;
        if ( c == '\0' || c == '\x01' )         // ASCII 00 or 01
        {
            ynProcess = FALSE ;
            return ;
        }
        // skip linefeeds ('\n') and soft returns ('\x8d') from older apps
        if ( c != '\n' && c != '\x8d' )
        {
            if ( c == '\r' )
                cLast = '\n' ;
            else
                cLast = c ;
            if ( ynCompact )
            {
                if ( (long)x == len )
                {
                    if ( cLast != '\n' )
                        fprintf( fCom, "%c", cLast );
                }
                else
                    fprintf( fCom, "%c", cLast );
            }
            else
            {
                if ( cLast == '\n' )
                    fprintf( fMsg, "<br>\n" );
                else
                    fprintf( fMsg, "%s", ht_ch2html(cLast, cmd) );
            }
        }
    }
}


void    process_message_exit( void )
{
    int         iLastLine, iLines = 0 ;
    static UCHAR *p, seenby[9] ;

    if ( ynCompact )
    {
        fclose( fCom );
        fCom = fopen( sCompact, "r" );
        if ( ! fCom )
        {
            fprintf( stderr, "\nCannot open intermediate message file %s\a\n", sCompact );
            exit( GD_ERROR_CANNOT_OPEN_FOR_READ );
        }

        while ( fgets( sComBuf, (sizeof(sComBuf)-1), fCom ) )
        {
            iLines ++ ;                         // count lines in the file
        }
        iLastLine = iLines ;
        iLines = 0 ;
        rewind( fCom );
        while ( fgets( sComBuf, (sizeof(sComBuf)-1), fCom ) )
        {
            st_trim( sComBuf );
            iLines ++ ;
            if ( iLines > (iLastLine-2) )       // check last 2 lines
            {
                ST_CPY( seenby, sComBuf );
                if ( st_eq(seenby, "SEEN-BY:") )
                        sComBuf[0] = EOS ;
            }
            p = sComBuf ;
            while ( *p )
            {
                fprintf( fMsg, "%s", ht_ch2html(*p, cmd) );
                p ++ ;
            }
            if ( iLines == iLastLine )          // drop last line if blank
            {
                if ( strlen( sComBuf ) )
                    fprintf( fMsg, "<br>\n" );
            }
            else
                fprintf( fMsg, "<br>" );
        }
        fclose( fCom );
    }
    fprintf( fMsg, "</font></strong></td></tr></table></div>\n" );
}


void    close_message_file( void )
{
    if ( ynMsgIsOpen )
    {
        fprintf( fMsg, "</body></html>\n" );
        fclose( fMsg );
        ynMsgIsOpen = FALSE ;
    }
}


// ---- Open/Close Index HTML file ------------------------------------------ //~~~

void    open_index_html( void )
{
    fTop = fopen( sTopOut, "w" );
    if ( ! fTop )
    {
        fprintf( stderr, "\rCannot create %s\a\n", sTopOut );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }

    fprintf( fTop,
             "<html><head><meta name=\"GENERATOR\" content=\"%s %s\">\n"
             "<title>Message Archive %s - Index</title></head>"
             "<body background=\"%s\" bgcolor=\"#F0FFFF\">\n",
             pgm_name, pgm_vers, sArchiveName, HTML_BG );
    fprintf( fTop,
             "<table border=\"9\" width=\"100%%\" cellspacing=\"0\" "
             "bgcolor=\"#FFFFB0\"><tr><td width=\"100%%\">"
             "<p align=\"center\"><font face=\"%s\" size=\"5\" "
             "color=\"#FF0000\"><strong>Message Archive %s</strong>"
             "</font></td></tr></table>\n",
             HTML_FONT, sArchiveName );
    fprintf( fTop,
             "<p align=\"center\"><font size=\"2\" face=\"Arial\">"
             "<strong>%lu</strong> messages in <strong>%lu</strong> "
             "topics</font></p>\n<table border=\"1\" width=\"100%%\" "
             "cellspacing=\"0\" valign=\"middle\" style=\"font-family: "
             "%s; font-size: 8pt\" bordercolor=\"#E0E0E0\">\n",
             nTotalMessages, nTotalTopics, HTML_FONT );
    fprintf( fTop,
             "<tr><td><big><strong><font color=\"#FF0000\">&nbsp;</font>"
             "</strong></big></td><td><big><strong><font color=\"#FF0000\">"
             "Topic</font></strong></big></td><td><big><strong>"
             "<font color=\"#FF0000\">Date</font></strong></big></td>"
             "<td align=\"right\"><big><strong><font color=\"#FF0000\">#</font>"
             "</strong></big></td></tr>\n" );
}


void    close_index_html( void )
{
    UCHAR       temp[81], date[21] ;

    strcpy( cmd, pgm_copyrite );
    st_get_word( temp, cmd );
    st_remove_word( cmd );
    strcpy( date, TodaysCDate() );
    format_date( date );

//~~~ <hr>
    fprintf( fTop,
             "</table><font color=\"#000080\" size=\"1\" "
             "face=\"Arial, Verdana, Helvetica\"><strong>"
             "Created by %s %s on %s<br>%s %s %s.</strong><br>\n"
             "Send e-mail to <a href=\"mailto:gdanen@bigfoot.com?subject="
             "Improving %s %s\">Gerry Danen</a> for suggestions on how to "
             "improve this program.<br>\n"
             "Best viewed with Internet Explorer 4.0 and higher.<br>\n"
             "<strong>Visit the author's page at <a href=\"http://home.istar.ca/~gdanen\">"
             "http://home.istar.ca/~gdanen</a></strong><br>\n"
             "</font></body></html>\n",
             pgm_name, pgm_vers, date, temp, "&copy;", cmd,
             pgm_name, pgm_vers );
    fclose( fTop );
}


void    open_temp_for_writing( void )
{
    fTmp = fopen( sTmp, "w" );
    if ( ! fTmp )
    {
        fprintf( stderr, "\rCannot create temporary file %s...\a\n", sTmp );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }
}


void    open_sorted_file( void )
{
    fWrk = fopen( sSortWork, "r" );
    if ( ! fWrk )
    {
        fprintf( stderr, "\rCannot open sort file %s for reading...\a\n", sSortWork );
        exit( GD_ERROR_CANNOT_OPEN_FOR_READ );
    }
}


// ---- Initialization ------------------------------------------------------ //~~~

void    init( STRING par1, STRING par2 )
{
    ST_CPY( sSQD,    par1 );
    ST_CPY( sTopOut, par2 );
    ST_CPY( sPrefix, par2 );
    strupr( sSQD );
    strupr( sTopOut );
    strupr( sPrefix );
    ST_CPY( sArchiveName, sSQD );
    strlwr( sTopOut );
    strlwr( sPrefix );
    ST_CAT( sSQD,    ".SQD" );
    ST_CAT( sTopOut, ".HTM" );

    sprintf( sTmp, "%s.TMP", get_global_program_name() );  // temp file for indexing

    MsgOpenApi( &SQmi );
    SQmsgtype = MSGTYPE_SQUISH ;

    if ( (SQhArea = MsgOpenArea(par1, MSGAREA_NORMAL, SQmsgtype)) == NULL )
    {
        fprintf( stderr, "Cannot open message area \"%s\" for reading!\a\n", par1 );
        exit( GD_ERROR_CANNOT_OPEN_FOR_READ );
    }

    MsgLock( SQhArea );

    if ( (SQbufr = malloc(BUFSIZE)) == NULL )
    {
        fprintf( stderr, "Out of memory. Need %lu bytes for Squish message buffer...\n",
                 (ULONG) BUFSIZE );
        exit( GD_ERROR_NO_MEMORY );
    }

    nTotalMessages = (ULONG) MsgHighMsg(SQhArea);

    if ( ynCompact )
        fprintf( stderr, "\nHTML files will be as compact as can be. Processing will be slower!\n" );
    else
        fprintf( stderr, "\nHTML files will be created in fast mode, but will not be as compact.\n" );

//  dll_init_list();                            // init doubly linked list
}


// ---- Phase 1: Create Temp file with an entry for each message ------------ //~~~

void    phase_1( void )
{
    long        nDt ;

    fprintf( stderr, "\nPhase 1: Reading message base and creating temporary file %s\n", sTmp );
    fprintf( stderr, "Processing %lu messages\n", nTotalMessages );

    open_temp_for_writing();

    for ( nThisMsg = 1L; nThisMsg <= MsgHighMsg(SQhArea); nThisMsg ++ )
    {
        if ( (SQhMsg = MsgOpenMsg(SQhArea,MOPEN_READ,(dword)nThisMsg)) == NULL )
            continue;

        SQctrlsize = (int)MsgGetCtrlLen(SQhMsg);
        if ( (SQctrl = malloc(SQctrlsize)) == NULL )
            SQctrlsize = 0 ;

        //  read control information
        MsgReadMsg( SQhMsg, &SQmsg, 0L, 0L, NULL, SQctrlsize, SQctrl );

        nDt = format_header_data( msSubj, msFrom, msTo, msDate, msTime );
        write_temp( fTmp, nThisMsg, msSubj, msFrom, msTo, msDate, nDt, nDt );

        if ( SQctrl )
            free( SQctrl );

        MsgCloseMsg( SQhMsg );
    }
    fclose( fTmp );

    if ( ynDeBug )
        system( "copy sq2htm.tmp c:\\sq1.tmp >nul" );

    fl_delete( sSortWork );
    fprintf( stderr, "Sorting %s\n", sTmp );
    sprintf( cmd, "sorttext %s %s >nul", sTmp, sSortWork );
    system( cmd );

    if ( ynDeBug )
    {
        sprintf( cmd, "copy %s %s >nul", sSortWork, "c:\\sq1.srt" );
        system( cmd );
    }

    fprintf( stderr, "Longest sort key is %d characters.\n", iLongestKey );
}


// ---- Phase 2: Fix Topic info on Temp file -------------------------------- //~~~

void    p2_write( STRING key, STRING data, int iMessages )
{

    if ( ! st_eq(key, PREV_INIT_STRING) )
    {
        if ( iMessages > 0 )
        {
            fprintf( fTmp, "%s%c%d%c%s\n", key, cMarker, iMessages, cMarker, data );
            nTotalTopics ++ ;
        }
    }
}

void    phase_2( void )
{
    char        arMessages[10001], cmdx[sizeof(cmd)], key[MAXKEY+1],
                msgnum[11], sPrevKey[XMSG_SUBJ_SIZE*2], sThisMsg[21] ;
    int         iMessNumber=0 ;

    fprintf( stderr, "\nPhase 2: Organizing messages by topic\n" );

    open_sorted_file();
    open_temp_for_writing();

    arMessages[0] = EOS ;
    strcpy( sPrevKey, PREV_INIT_STRING );
    iMessNumber = 0 ;

    while ( fgets( cmd, (sizeof(cmd)-1), fWrk ) )
    {
        st_trim( cmd );
        if ( strlen(cmd) )
        {
            SplitString( cmd , sMarker, key   , cmdx );  // key
            SplitString( cmdx, sMarker, msgnum, cmd  );  // message number

            nThisMsg = atol(msgnum);
            sprintf( sThisMsg, "%lu", nThisMsg );

            if ( ! st_eq(sPrevKey, key) )       // same topic?
            {
                p2_write( sPrevKey, arMessages, iMessNumber );
                iMessNumber = 0 ;
                strcpy( sPrevKey, key );
                arMessages[0] = EOS ;
            }
            iMessNumber ++ ;
            ST_CAT( arMessages, sThisMsg );
            ST_CAT( arMessages, sMarker );
        }
    }

    p2_write( sPrevKey, arMessages, iMessNumber );

    fclose( fTmp );
    fclose( fWrk );
    fprintf( stderr, "Found %lu topics\n", nTotalTopics );

    if ( ynDeBug )
        system( "copy sq2htm.tmp c:\\sq2.tmp >nul" );

    fl_delete( sSortWork );
    fprintf( stderr, "Sorting %s\n", sTmp );
    sprintf( cmd, "sorttext %s %s >nul", sTmp, sSortWork );
    system( cmd );

    if ( ynDeBug )
    {
        sprintf( cmd, "copy %s %s >nul", sSortWork, "c:\\sq2.srt" );
        system( cmd );
    }
}


// ---- Phase 3: Produce the HTML files ------------------------------------- //~~~

void    phase_3( void )
{
    char        key[MAXKEY+1], msgnum[11], cmdx[sizeof(cmd)], sPrevKey[XMSG_SUBJ_SIZE*2],
                sSaved[sizeof(cmd)] ;
    int         iMsg = 0, iMessagesInTopic = 0, x ;
    BOOL        isBreak = FALSE ;

    fprintf( stderr, "\nPhase 3: Creating html files\n" );

    open_sorted_file();
    open_index_html();

    strcpy( sPrevKey, PREV_INIT_STRING );
    nTopicNumber = 0 ;

    while ( fgets( cmd, (sizeof(cmd)-1), fWrk ) )
    {
        st_trim( cmd );
        if ( strlen(cmd) )
        {
            nTopicNumber ++ ;
            SplitString( cmd , sMarker, key   , cmdx );  // key
            SplitString( cmdx, sMarker, msgnum, cmd  );  // # messages
            iMessagesInTopic = atoi(msgnum);
            iMsg = 0 ;

            LOOP( x, 1, iMessagesInTopic, 1 )
            {
                SplitString( cmd , sMarker, msgnum, cmdx );  // message number
                nThisMsg = atol(msgnum);
                strcpy( sSaved, cmdx );

                if ( (SQhMsg = MsgOpenMsg(SQhArea,MOPEN_READ,(dword)nThisMsg)) != NULL )
                {
                    SQctrlsize = (int)MsgGetCtrlLen(SQhMsg);

                    if ( (SQctrl = malloc(SQctrlsize)) == NULL )
                        SQctrlsize = 0 ;

                    //  read control information
                    MsgReadMsg( SQhMsg, &SQmsg, 0L, 0L, NULL, SQctrlsize, SQctrl );

                    format_header_data( msSubj, msFrom, msTo, msDate, msTime );
                    ht_str2html( cmd, msSubj );  ST_CPY( msSubj, cmd );
                    ht_str2html( cmd, msFrom );  ST_CPY( msFrom, cmd );
                    ht_str2html( cmd, msTo   );  ST_CPY( msTo  , cmd );

// msg header
                    iMsg ++ ;
                    if ( iMsg == 1 )
                    {
                        fprintf( fTop,
                                 "<tr><td align=\"right\">%lu</td>"
                                 "<td><a href=\"%s%04lu.htm#1\">%s</a></td>"
                                 "<td>%s</td>"
                                 "<td align=\"right\">%d</td></tr>",
                                 nTopicNumber, sPrefix, nTopicNumber, msSubj, msDate, iMessagesInTopic );
                        close_message_file();
                        new_message_file();
                    }
                    fprintf( fMsg,
                             "<font size=\"1\" face=\"%s\"><small><small><small>"
                             "<a name=\"%d\">%d/%d</a></small></small></small><br>"
                             "<table border=\"1\" width=\"100%%\" cellspacing=\"0\">"
                             "<tr><td><table border=\"0\" width=\"100%%\" cellspacing=\"0\" "
                             "cellpadding=\"0\"><tr><td width=\"90%%\" bgcolor=\"#FFFFB0\">"
                             "<strong><font size=\"2\" face=\"%s\">%s</font></strong></td>"
                             "<td width=\"10%%\" bgcolor=\"#FFFFB0\"><p align=\"right\">"
                             "<font size=\"1\" face=\"%s\">%lu</font></td></tr></table>\n",
                             HTML_FONT, iMsg, iMsg, iMessagesInTopic, HTML_FONT, msSubj, HTML_FONT, nThisMsg );
                    fprintf( fMsg,
                             "<table border=\"0\" width=\"100%%\" cellspacing=\"0\" "
                             "cellpadding=\"0\"><tr><td width=\"41%%\"><font size=\"2\" "
                             "face=\"%s\" color=\"#0000A0\"><strong>%s</strong></font></td>"
                             "<td width=\"35%%\"><font size=\"1\" face=\"%s\"><strong>"
                             "To %s</strong></font></td><td width=\"24%%\">"
                             "<p align=\"right\"><font size=\"1\" face=\"%s\">%s %s"
                             "</font></td></tr></table></td></tr></table>\n",
                             HTML_FONT, msFrom, HTML_FONT, msTo, HTML_FONT, msDate, msTime );
// msg body
                    fprintf( fMsg,
                             "<div align=\"right\"><table border=\"0\" width=\"95%%\" "
                             "cellspacing=\"0\"><tr><td width=\"100%%\" bgcolor=\"#F0FFFF\" "
                             "background=\"%s\"><strong><font size=\"1\" face=\"%s\">\n",
                             HTML_BG, HTML_FONT );

                    cLast = '\n' ;

                    if ( ynCompact )
                    {
                        fCom = fopen( sCompact, "w" );
                        if ( ! fCom )
                        {
                            fprintf( stderr, "\rCannot create intermediate message file %s\a\n", sCompact );
                            exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
                        }
                    }

                    //  read message in blocks of BUFSIZE
                    for ( SQoffset = 0L ; SQoffset < MsgGetTextLen(SQhMsg) ; )
                    {
                        SQgot = MsgReadMsg( SQhMsg, NULL, SQoffset, BUFSIZE, SQbufr, 0L, NULL );

                        if ( SQgot <= 0 )
                            break;

                        process_message( SQgot );
                        if ( ! ynProcess )
                            break ;

                        SQoffset += SQgot;
                    }
                    process_message_exit();

                    if ( SQctrl )
                        free( SQctrl );

                    MsgCloseMsg( SQhMsg );
                }
                strcpy( cmd, sSaved );
            }
        }
    }

    close_message_file();
    close_index_html();
}


// ---- Finish up ----------------------------------------------------------- //~~~

void    finish( void )
{
    free( SQbufr );
    MsgCloseArea( SQhArea );
    MsgCloseApi();

    fprintf( stderr, "\nCreated %lu topic pages...\n", nTotalTopics );

    fprintf( stderr,
             "\nConditions for use:\n"
             "If you post the resulting HTML files on the internet (or a company's intranet),\n"
             "you must leave the link to my home page, and the e-mail address. Thank you. :-)\n\n"
             "E-mail your suggestions for improvement to gdanen@bigfoot.com.\n\n" );

    fcloseall();
}


// ---- Main ---------------------------------------------------------------- //~~~

void    main( int argc, char *argv[] )
{
    tt_init( SHAREWARE_VERSION, 0, pgVERS_, pgTITL_, pgCOPR_ );
    ansi_cls( 2, stderr );
    logon(1);
    fprintf( stderr, "Portions Copyright 1989-1994 by SCI Communications.\n" );

    ynDeBug = ut_get_debug_setting();

    if ( argc < 3 )
        help();

    if ( argc > 3 )
    {
        if ( st_eq(argv[3], "/c") || st_eq(argv[3], "/compact") )
            ynCompact = TRUE ;
        else
        {
            fprintf( stderr,
                     "\nParameter 3 (%s) not recognized.\n"
                     "Run this program without parameters for help.\n\n", argv[3] );
            exit( GD_ERROR_INVALID_PARM );
        }
    }

    init( argv[1], argv[2] );
    phase_1();
    phase_2();
    phase_3();
    finish();

    if ( ! ynDeBug )
    {
        fl_delete( sTmp );
        fl_delete( sSortWork );
        fl_delete( sCompact );
    }

    exit( GD_ERROR_NONE );
}
