'Este programa extrae los ficheros file_id.diz, o subsidiariamente
'readme.txt o readme.doc, que contienen muchos de los archivos comprimidos
'disponibles en Internet y BBS, y crea un fichero listabbs.txt en el formato
'files.bbs usado por Maximus 3.x (Nombre fichero + descripcin en una lnea)
'Simplifica la tarea del sysop al aadir ficheros a la base de la bbs.

DECLARE SUB lineacom (param$)   'Leer parmetros lnea comando

DECLARE SUB cfg ()              'Leer fichero configuracin

DECLARE SUB TipoFicheroDesc (dirlis$) 
                                'Determinar tipo fichero descripcin
                                'y abrirlo.

DECLARE SUB CreaListaZips (uniarc$, unilis$, dirarc$, dirlis$)
                                'Crear lista de ficheros comprimidos

DECLARE SUB oneline (fichzip$)  'Leer fichero descripcin
                                'Convertirlo a una lnea
                                'Quitar caracteres grficos
                                'Quitar espacios en blanco innecesarios
                                'Escribir en listabbs.txt nombre fichero
                                'y descripcin

DECLARE SUB creditos (version$) 'Mostrar en pantalla informacin
                                'del programa

CONST version$ = "1.2"

DIM SHARED diz, txt, doc, punto
DIM SHARED fichdiz$, fichtxt$, fichdoc$, param$
DIM SHARED uniarc$, dirarc$, unilis$, dirlis$
DIM SHARED listazip$, listadat$, listabbs$, fichzip$, pilladiz$, ext$, dat$

CONST ListFichDesc$ = " file_id.diz readme.txt readme.doc "
param$ = LTRIM$(RTRIM$(COMMAND$))

CLS

'Determinar modo de operacin
'Si hay parmetros, seguirlos; si no, leer damebbs.cfg
IF param$ <> "" THEN CALL lineacom(param$)
IF param$ = "" THEN CALL cfg

CALL CreaListaZips(uniarc$, unilis$, dirarc$, dirlis$)

'Creamos/abrimos listabbs.txt
listabbs$ = dirlis$ + "\listabbs.txt"
ON ERROR GOTO nodir
OPEN listabbs$ FOR APPEND AS #3
ON ERROR GOTO 0

'Procesamos la lista de archivos comprimidos listazip.dat
ON ERROR GOTO Nolista
listadat$ = dirlis$ + "\listazip.dat"
OPEN listadat$ FOR INPUT AS #1
ON ERROR GOTO 0

DO WHILE NOT EOF(1)
        LINE INPUT #1, fichzip$

        'Averiguamos extensin ficheros listados en listazip.dat
        punto = INSTR(fichzip$, ".")
        ext$ = LCASE$(MID$(fichzip$, punto + 1, 3))

        'Definimos cadena a enviar al S.O. para extraer file_id.diz
        SELECT CASE ext$
                CASE IS = "zip"
                        pilladiz$ = "pkunzip " + fichzip$ + ListFichDesc$ + dirlis$
                CASE IS = "rar"
                        pilladiz$ = "unrar x " + fichzip$ + ListFichDesc$ + dirlis$
                CASE IS = "arj"
                        pilladiz$ = "arj e " + fichzip$ + ListFichDesc$ + dirlis$
        END SELECT

        'Si el fichero actual es soportado (zip, arj o rar),
        'se ejecuta el proceso principal
        IF ext$ = "zip" OR ext$ = "arj" OR ext$ = "rar" THEN
               
                SHELL pilladiz$                 'Descomprimimos ficheros
                                                'de descripcin
                                              
                CALL TipoFicheroDesc(dirlis$)   'Seleccionamos fichero
                                                'de descripcin

                CALL oneline(fichzip$)          'Procesamos fichero de
                                                'descripcin

                CLOSE #2                        'Cerramos fichero de
                                                'descripcin
               
                ON ERROR GOTO NoBorroDiz        'Borramos ficheros de
                                                'descripcin
                KILL fichdiz$
                KILL fichtxt$
                KILL fichdoc$
                ON ERROR GOTO 0
                diz = 0
                txt = 0
                doc = 0
        END IF
LOOP

CLS

ON ERROR GOTO NoBorroDiz
SHELL unilis$
CHDIR dirlis$
ON ERROR GOTO 0

PRINT
PRINT "Procesados ficheros en: "; dirarc$
PRINT "Creada lista en       : "; listabbs$

fin:
CLOSE
ON ERROR GOTO NoBorroDiz
dat$ = dirlis$ + "\listazip.dat"
KILL dat$
ON ERROR GOTO 0
CALL creditos(version$)
END

NoDiz:
IF ERR = 53 THEN diz = 1
RESUME NEXT

NoTxt:
IF ERR = 53 THEN txt = 1
RESUME NEXT

NoDoc:
IF ERR = 53 THEN doc = 1
RESUME NEXT

NoBorroDiz:
RESUME NEXT

nodir:
IF ERR = 53 OR ERR = 76 OR ERR = 255 THEN
        CLS
        PRINT
        PRINT "Datos incorrectos"
        PRINT "Consulta damebbs.doc para configurar damebbs.cfg"
        PRINT "Teclea 'damebbs /?' para informacin sobre parmetros"
        RESUME fin
ELSE
        PRINT
        PRINT "Error irrecuperable, cdigo "; ERR
END IF
RESUME fin

Nolista:
IF ERR = 53 THEN
        PRINT
        PRINT "No he encontrado ficheros .zip, .arj o .rar en "; UCASE$(dirarc$)
ELSE
        PRINT
        PRINT "Error irrecuperable, cdigo "; ERR
END IF
RESUME fin

Uso:
IF ERR = 254 THEN
        PRINT "Sintaxis:"
        PRINT
        PRINT "damebbs [/?] <rutarch> <rutlist>"
        PRINT
        PRINT "/? .......... Muestra esta pantalla de ayuda"
        PRINT "<rutarch> ... Ruta para los ficheros comprimidos a procesar"
        PRINT "<rutlist> ... Ruta para crear listabbs.txt"
        PRINT
        PRINT "Ejemplos:"
        PRINT "damebbs e:\files\news c:\taller"
        PRINT "damebbs /?"
        RESUME fin
ELSE
        PRINT "Error desconocido, cdigo: "; ERR
END IF
RESUME fin

SUB cfg
i = 1
SHARED uniarc$
SHARED dirarc$
SHARED unilis$
SHARED dirlis$

ON ERROR GOTO nodir
OPEN "damebbs.cfg" FOR INPUT AS #5
ON ERROR GOTO 0

DIM config$(1 TO 15)
DO WHILE NOT EOF(5)
        LINE INPUT #5, lin$
        IF MID$(lin$, 1, 1) <> ";" THEN
                config$(i) = lin$
                i = i + 1
        END IF
LOOP
CLOSE #5
dirarc$ = config$(1)
dirlis$ = config$(2)
uniarc$ = MID$(config$(1), 1, 3)
unilis$ = MID$(config$(2), 1, 3)

END SUB

SUB CreaListaZips (uniarc$, unilis$, dirarc$, dirlis$)
ON ERROR GOTO nodir
IF uniarc$ = "" AND unilis$ = "" THEN ERROR 255
ON ERROR GOTO 0

SHELL uniarc$

ON ERROR GOTO nodir
CHDIR dirarc$
ON ERROR GOTO 0

'Creamos lista ficheros .zip, .arj y .rar
ON ERROR GOTO nodir
IF dirlis$ <> "" AND dirlis$ <> " " THEN
        listazip$ = "listazip.bat " + dirlis$ + "\listazip.dat"
        SHELL listazip$
END IF
IF dirlis$ = "" OR dirlis$ = " " THEN ERROR 76
ON ERROR GOTO 0

END SUB

SUB creditos (version$)
PRINT
PRINT "Damebbs "; version$; " - Utilidad para Maximus 3.x"
PRINT "(c) Jaime Domenech Socias - Fido 2:347/6 - jdomene@ibm.net"
PRINT "Freeware"
PRINT
PRINT "Gracias por usar Damebbs"
END SUB

SUB lineacom (param$)

DIM arg$(1 TO 200)
a = 1

ON ERROR GOTO Uso
IF MID$(param$, 1, 2) = "/?" THEN ERROR 254
ON ERROR GOTO 0

FOR i = 1 TO LEN(param$)
        c$ = MID$(param$, i, 1)
        IF c$ = " " THEN
                ON ERROR GOTO nodir
                IF a > 3 THEN ERROR 76
                ON ERROR GOTO 0
                a = a + 1
                c$ = ""
        END IF
        arg$(a) = arg$(a) + c$
NEXT i

uniarc$ = MID$(arg$(1), 1, 3)
dirarc$ = arg$(1)
unilis$ = MID$(arg$(2), 1, 3)
dirlis$ = arg$(2)

END SUB

SUB oneline (fichzip$)
'diz = 0 implica que HAY file_id.diz
'txt = 0 implica que HAY readme.txt
'doc = 0 implica que HAY readme.doc
IF diz = 0 OR txt = 0 OR doc = 0 THEN
        DO WHILE NOT EOF(2)
                LINE INPUT #2, trozolin$: trozolin$ = LTRIM$(RTRIM$(trozolin$))
                FOR i = 1 TO LEN(trozolin$)
                        'Quitamos caracteres grficos
                        c$ = MID$(trozolin$, i, 1)
                        IF LEN(c$) > 0 THEN
                                IF ASC(c$) > 168 OR c$ = "=" THEN
                                        c$ = ""
                                        IF i < LEN(trozolin$) THEN
                                                d$ = MID$(trozolin$, i + 1, 1)
                                                e$ = MID$(trozolin$, i, 2)
                                                IF e$ = "--" THEN
                                                        c$ = ""
                                                END IF
                                                IF ASC(d$) < 169 AND ASC(d$) <> 45 THEN
                                                        c$ = " "
                                                END IF
                                        END IF
                                END IF
                        END IF
                        'Aadimos un carcter a la lnea
                        linea$ = LTRIM$(linea$) + c$
                        IF LEN(linea$) > 999 THEN EXIT DO
                NEXT i
                'Aadimos siguiente lnea
                linea$ = RTRIM$(linea$) + " "
        LOOP
        FOR i = 1 TO LEN(linea$)               'Quitamos blancos sobrantes
                a$ = MID$(linea$, i, 1)
                IF a$ = " " THEN
                        IF i < LEN(linea$) THEN
                                b$ = MID$(linea$, i + 1, 1)
                                IF b$ = " " THEN
                                        a$ = ""
                                END IF
                        END IF
                END IF
                lindef$ = lindef$ + a$
        NEXT i
END IF
IF diz = 0 OR txt = 0 OR doc = 0 THEN
        PRINT #3, fichzip$ + " " + lindef$      'Ya est! :-)
END IF
IF diz = 1 AND txt = 1 AND doc = 1 THEN
        PRINT #3, fichzip$ + " Sin descripcin"
END IF
END SUB

SUB TipoFicheroDesc (dirlis$)
fichdiz$ = dirlis$ + "\file_id.diz"
fichtxt$ = dirlis$ + "\readme.txt"
fichdoc$ = dirlis$ + "\readme.doc"

ON ERROR GOTO NoDiz:
OPEN fichdiz$ FOR INPUT AS #2
ON ERROR GOTO 0                 'Si file_id.diz no existe, diz = 1

IF diz = 1 THEN                 'Si no hay file_id.diz, probamos readme.txt
                                'Si no hay readme.txt, txt = 1
        fichdiz$ = fichtxt$
        ON ERROR GOTO NoTxt
        OPEN fichdiz$ FOR INPUT AS #2
        ON ERROR GOTO 0
END IF

IF txt = 1 THEN
        fichdiz$ = fichdoc$
        ON ERROR GOTO NoDoc
        OPEN fichdiz$ FOR INPUT AS #2
        ON ERROR GOTO 0
END IF

END SUB

