PROGRAM ConnStat;
{ͻ}
{ Shows connection statistics                   Last changed: 09.10.95  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES OpString, OpDate, Dos, PoPTypes, Misc;

TYPE
  TConnectLine = RECORD
    BaudRate : LongInt;
    Protocol : S5;
    Connects : ARRAY[0..3] OF LongInt;
  END;

  TConnectArray = ARRAY[0..MaxBaudStat] OF TConnectLine;

VAR
  F : File OF TPortalStat;
  StatRec : TPortalStat;
  CArray : TConnectArray;
  Tot : LongInt;
  k,j : Byte;
  Baud: LongInt;
  Total : TConnectLine;
  Out   : Text;

  PROCEDURE SortStat;
  VAR
    i,j,k,m : Byte;
  BEGIN
    FillChar(CArray, SizeOf(CArray), 0);
    k:=0;
    WHILE StatRec.Connect.Bauds[k]<>0 DO
    BEGIN
      Baud:=StatRec.Connect.Bauds[k];
      m:=0;
      WHILE (CArray[m].BaudRate<>0) AND (CArray[m].BaudRate<Baud) DO
        Inc(m);
      IF CArray[m].BaudRate<>0 THEN
      BEGIN
        Move(CArray[m], CArray[m+1], SizeOf(TConnectLine)*(MaxBaudStat-m));
      END;
      CArray[m].BaudRate:=Baud;
      CArray[m].Protocol:=StatRec.Connect.Protocol[k];
      FOR i:=0 TO 1 DO
        FOR j:=0 TO 1 DO
          CArray[m].Connects[j+(i*2)]:=StatRec.Connect.Stat[j,i,k];
      Inc(k);
    END;
  END;

BEGIN
  WriteLn('Portal Connect Statistic Viewer v'+ver) ;
  WriteLn('Copyright (C) 1992-95 by The Portal Team') ;
  WriteLn;
  Assign(f, 'PORTAL'+GetPoPTask+'.STA'); Reset(f);
  IF IOResult=0 THEN
  BEGIN
    Read(f,StatRec); Close(f);

    SortStat;
    Assign(Out, ''); ReWrite(Out);
    WriteLn(Out,CharStr(' ',8),'Connection statistics since: ',DateToDateString('dd.mm.yyyy',StatRec.Start.D),
                '  ',TimeToTimeString('hh:mm',StatRec.Start.T),'  Task: '+GetPoPTask);
    WriteLn(Out);
    WriteLn(Out,' INCOMING  OUTGOING ');
    WriteLn(Out,'Baudrate           Mail        User        Mail        User       Total');
    WriteLn(Out,'');
    k:=0; FillChar(Total, SizeOf(Total), 0);
    WHILE CArray[k].BaudRate<>0 DO
    BEGIN
      Write(Out,CArray[k].BaudRate:5,Pad(CArray[k].Protocol,5),' ');
      tot:=0;
      FOR j:=0 TO 3 DO
      BEGIN
        IF CArray[k].Connects[j]>0 THEN
          Write(Out,CArray[k].Connects[j]:12)
        ELSE
          Write(Out,'           -');
        inc(Tot,CArray[k].Connects[j]);
        inc(Total.Connects[j],CArray[k].Connects[j]);
      END;
      WriteLn(Out,Tot:12);
      Inc(k);
    END;
    WriteLn(Out,'');
    Write(Out,  'TOTAL:     ');
    tot:=0;
    FOR j:=0 TO 3 DO
    BEGIN
      IF Total.Connects[j]>0 THEN
        Write(Out,Total.Connects[j]:12)
      ELSE
        Write(Out,'           -');
      inc(Tot,Total.Connects[j]);
    END;
    WriteLn(Out,Tot:12);
    WriteLn(Out,'');
    Close(Out);
  END ELSE
    WriteLn('Can''t find PORTAL'+GetPopTask+'.STA?');
END.
