UNIT RngAnaly;
{ͻ}
{ Ring Analyzer                                 Last changed: 09.03.00  MR }
{                                                                          }
{                       (C) Copyright 1999,2000 by                         }
{                            Marcus Roeckrath                              }
{                           2:2449/523@fidonet                             }
{                        marcus.roeckrath@gmx.de                           }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PopTypes;

FUNCTION RingAnalyzerAnswerCall(RingString: S80): BOOLEAN;
FUNCTION NoConnectAnalyzer(NoConnectString: S80): BOOLEAN;

IMPLEMENTATION

USES Dos, Globals, Util, OPDate, OPString, StrUtil, Mailutil,
     Modem, Com, LogFile, APTimer;

VAR F                : Text;
    FileInfo         : SearchRec;
    TempLine, Line   : STRING;
    RejectString     : S10;
    SearchString1    : S30;
    SearchString2    : S208;
    SearchString3    : S25;
    StartTime,
    EndTime          : Time;
    ErrorLevel       : INTEGER;
    Reject           : BOOLEAN;
    Hour, Min        : BYTE;
    FreePollTime     : BYTE;
    FreePollTimer    : EventTimer;
    ClearBufferTimer : EventTimer;
    NetworkAddress   : TFidoAddress;
    I, I1            : INTEGER;
    MinusPos         : BYTE;
    OutDir           : PathStr;
    LastFreePollRing : S80;


PROCEDURE OutDirectory;
BEGIN
  OutDir := cfg.Outbound;
  IF NetworkAddress.Zone <> cfg.Addresses[cfg.MainAdrNum].Zone THEN
    OutDir := OutDir + '.' + Copy(HexW(WORD(NetworkAddress.Zone)), 2, 3);
  OutDir := OutDir + '\' + HexW(WORD(NetworkAddress.Net)) + HexW(WORD(NetworkAddress.Node));
  IF NetworkAddress.Point <> 0 THEN
    OutDir := OutDir + '.PNT\' + '0000' + HexW(WORD(NetworkAddress.Point));
END;


FUNCTION CalculateTimePeriod(StartPos: BYTE): BOOLEAN;
BEGIN
  CalculateTimePeriod := FALSE;
  Val(Copy(Line, StartPos, 2), Hour, I);
  Val(Copy(Line, StartPos+3, 2), Min, I1);
  IF (I=0) AND (I1=0) AND ValidTime(Hour, Min, 0) THEN BEGIN
    StartTime := HMSToTime(Hour, Min, 0);
    Val(Copy(Line, StartPos+6, 2), Hour, I);
    Val(Copy(Line, StartPos+9, 2), Min, I1);
    IF (I=0) AND (I1=0) AND ValidTime(Hour, Min, 59) THEN BEGIN
      EndTime := HMSToTime(Hour, Min, 59);
      CalculateTimePeriod := TimeIsBetween(StartTime, EndTime);
    END;
  END;
END;


PROCEDURE CalculateErrorlevel;
BEGIN
  MinusPos := Pos('-', TempLine);
  IF MinusPos > 0 THEN Reject := TRUE ELSE Reject := FALSE;
  TempLine := Copy(TempLine, MinusPos+1, Length(TempLine)-MinusPos);
  ErrorLevel := 0;
  IF Length(TempLine) > 0 THEN BEGIN
    Val(TempLine, I1, I);
    IF I = 0 THEN Errorlevel := I1;
  END;
END;


PROCEDURE RejectCall;
BEGIN
  TranslateModemString(RejectString);
  NewTimerSecs(ClearBufferTimer, 5);
  WHILE (ComPort^.KeyPressed) AND (NOT TimerExpired(ClearBufferTimer)) DO
    ComPort^.PurgeIn;
END;


FUNCTION RingAnalyzerAnswerCall(RingString: S80): BOOLEAN;
  CONST FileExtensions : ARRAY[1..10] OF S3 = ('FLO', 'CLO', 'HLO', 'ILO', 'DLO', 'OUT', 'CUT', 'HUT', 'IUT', 'DUT');
  VAR Found : BOOLEAN;
  BEGIN
    Found := FALSE;
    RingAnalyzerAnswerCall := TRUE;
    IF RingString = 'RING' THEN Exit;
    Assign(F, StartPath + PoPRingAnalyzerFileName);
    FileMode:=ShareRead+ShareDenyW;
    Reset(F);
    IF IOResult = 0 THEN BEGIN
      RejectString := '';
      Line := '';
      WHILE NOT (EoF(F)) AND (Copy(Line,1,25) <> 'String1-----------------|') DO BEGIN
        ReadLn(F, Line);
        IF StUpcase(Copy(Line,1,6)) = 'REJECT' THEN BEGIN
          Line := TrimSpaces(Copy(Line, 8, Length(Line)-7));
          RejectString := NextWord(' ', Line);
        END;
      END;
      WHILE NOT (EoF(F)) AND (NOT Found) DO BEGIN
        ReadLn(F, Line);
        Line := TrimSpaces(Line);
        IF (Line[1] <> ';') AND (Length(Line) >= 61) THEN BEGIN
          SearchString1 := TrimSpaces(Copy(Line, 1, 25));
          SearchString2 := TrimSpaces(Copy(Line, 27, 10));
          SearchString3 := TrimSpaces(Copy(Line, 38, 10));
          IF SearchString1 = '' THEN SearchString1 := 'RING';
          IF SearchString2 = '' THEN SearchString2 := 'RING';
          IF SearchString3 = '' THEN SearchString3 := 'RING';
          IF ((SearchString1 <> 'RING') OR (SearchString2 <> 'RING') OR (SearchString3 <> 'RING'))
             AND (Pos(SearchString1, RingString) > 0)
             AND (Pos(SearchString2, RingString) > 0)
             AND (Pos(SearchString3, RingString) > 0) THEN BEGIN
            IF CalculateTimePeriod(49) THEN BEGIN
              Found := TRUE;
              TempLine := TrimSpaces(Copy(Line, 61, 5));
              IF (Length(TempLine) > 0) OR (Length(Line) > 70) THEN BEGIN
                CalculateErrorlevel;
                IF Length(Line) > 70 THEN BEGIN
                  IF (LastFreePollRing = RingString) AND (NOT TimerExpired(FreePollTimer)) THEN BEGIN
                    LastFreePollRing := '';
                    Close(F);
                    IF ErrorLevel > 0 THEN SpawnWithErrorlevel(Errorlevel, 'Exit on FreePoll override', FALSE, FALSE)
                    ELSE Exit;
                  END;
                  Val(Copy(Line, 67, 2), I1, I);
                  IF I = 0 THEN FreePollTime := I1 ELSE FreePollTime := 0;
                  Line := TrimSpaces(Copy(Line, 70, Length(Line) - 69));
                  WHILE Length(Line) > 0 DO BEGIN
                    IF GetAdressFromStr(NextWord(' ', Line), NetworkAddress) THEN BEGIN
                      OutDirectory;
                      I := 1;
                      REPEAT
                        FindFirst(OutDir+'.'+FileExtensions[I], 63, FileInfo);
                        IF DosError = 0 THEN BEGIN
                          IF FileInfo.Size > 0 THEN BEGIN
                            IF LastFreePollRing = RingString THEN LastFreePollRing := '';
                            Close(F);
                            IF ErrorLevel > 0 THEN
                              SpawnWithErrorlevel(Errorlevel, 'Exit on outbound file found at FreePoll', FALSE, FALSE)
                            ELSE Exit;
                          END;
                        END;
                        FindClose(FileInfo);
                        Inc(I);
                      UNTIL I = 11;
                    END;
                  END;
                  RejectCall;
                  AddLog('!', 'Call rejected - No files waiting for caller');
                  RingAnalyzerAnswerCall := FALSE;
                  NewTimerSecs(FreePollTimer, FreePollTime);
                  LastFreePollRing := RingString;
                END
                ELSE BEGIN
                  IF Reject THEN BEGIN
                    RejectCall;
                    AddLog('!', 'Call rejected - caller not allowed to get in');
                    RingAnalyzerAnswerCall := FALSE;
                  END;
                  IF ErrorLevel > 0 THEN BEGIN
                    Close(F);
                    IF Reject THEN
                      SpawnWithErrorlevel(ErrorLevel, 'Exit on special ring/caller', FALSE, TRUE)
                    ELSE SpawnWithErrorlevel(ErrorLevel, 'Exit on special ring/caller', FALSE, FALSE);
                  END;
                END;
              END;
            END;
          END;
        END;
      END;
      Close(F);
    END
    ELSE AddLog('!', 'Ring Analyzer configuration file ' + PoPRingAnalyzerFileName + ' not found');
  END;


FUNCTION Call2String: S23;
  VAR S  : S23;
      S1 : S5;
  BEGIN
    Str(Call.Zone, S); S := S + ':';
    Str(Call.Net, S1); S := S + S1;
    Str(Call.Node, S1); S := S + '/' + S1;
    IF Call.Point > 0 THEN BEGIN
      Str(Call.Point, S1);
      S := S + '.' + S1;
    END;
    Call2String := S;
  END;


FUNCTION NoConnectAnalyzer(NoConnectString: S80): BOOLEAN;
  CONST FileExtensions : ARRAY[1..11] OF S3 = ('FLO', 'CLO', 'HLO', 'ILO', 'DLO', 'OUT', 'CUT', 'HUT', 'IUT', 'DUT', 'REQ');
  VAR Found : BOOLEAN;
  BEGIN
    SearchString3 := ' ' + Call2String + ' ';
    UpdateUndialable(Call, 1, 0);
    Found := FALSE;
    NoConnectAnalyzer := FALSE;
    Assign(F, StartPath + PoPNConAnalyzerFileName);
    FileMode:=ShareRead+ShareDenyW;
    Reset(F);
    IF IOResult = 0 THEN BEGIN
      Line := '';
      WHILE NOT (EoF(F)) AND (Copy(Line,1,30) <> 'String-----------------------|') DO BEGIN
        ReadLn(F, Line);
      END;
      WHILE NOT (EoF(F)) AND (NOT Found) DO BEGIN
        ReadLn(F, Line);
        Line := TrimSpaces(Line);
        IF (Line[1] <> ';') AND (Length(Line) >= 44) THEN BEGIN
          SearchString1 := TrimSpaces(Copy(Line, 1, 30));
          IF Length(Line) > 50 THEN SearchString2 := ' ' + TrimSpaces(Copy(Line, 50, Length(Line)-49)) + ' '
          ELSE SearchString2 := SearchString3;
          IF (Pos(SearchString1, NoConnectString) > 0) AND
             (Pos(SearchString3, SearchString2) > 0) THEN BEGIN
            IF CalculateTimePeriod(32) THEN BEGIN
              Found := TRUE;
              TempLine := TrimSpaces(Copy(Line, 44, 5));
              IF (Length(TempLine) > 0) OR (Length(Line) > 50) THEN BEGIN
                NoConnectAnalyzer := TRUE;
                CalculateErrorlevel;
                IF Length(Line) > 50 THEN BEGIN
                  SearchString2 := Copy(SearchString2, 2, Length(SearchString2)-2);
                  WHILE Length(SearchString2) > 0 DO BEGIN
                    IF GetAdressFromStr(NextWord(' ', SearchString2), NetworkAddress) THEN BEGIN
                      OutDirectory;
                      I := 1;
                      REPEAT
                        FindFirst(OutDir+'.'+FileExtensions[I], 63, FileInfo);
                        IF DosError = 0 THEN BEGIN
                          IF FileInfo.Size > 0 THEN BEGIN
                            AddLog('!', 'Mail for Node ' + Address2Str(Call) + ' waiting');
                            Close(F);
                            IF ErrorLevel > 0 THEN
                              SpawnWithErrorlevel(Errorlevel,
                                'Exit on rejected out call with outbound file found', FALSE, FALSE)
                            ELSE Exit;
                          END;
                        END;
                        FindClose(FileInfo);
                        Inc(I);
                      UNTIL I = 12;
                    END;
                  END;
                  UpdateUnDialable(Call, 255, 0);
                  AddLog('!', 'No Mail for Node ' + Address2Str(Call) + ' waiting');
                  AddLog('!', 'Made Node ' + Address2Str(Call) + ' undialable');
                  IF ErrorLevel > 0 THEN BEGIN
                    Close(F);
                    SpawnWithErrorlevel(Errorlevel, 'Exit on rejected out call without outbound file found', FALSE, FALSE);
                  END;
                END
                ELSE BEGIN
                  IF Reject THEN BEGIN
                     UpdateUnDialable(Call, 255, 0);
                     AddLog('!', 'Made Node ' + Address2Str(Call) + ' undialable');
                  END;
                  IF ErrorLevel > 0 THEN BEGIN
                    Close(F);
                    SpawnWithErrorlevel(Errorlevel, 'Exit on rejected out call', FALSE, FALSE);
                  END;
                END;
              END;
            END;
          END;
        END;
      END;
      Close(F);
    END
    ELSE AddLog('!', 'No Connect Analyzer configuration file ' + PoPNConAnalyzerFileName + ' not found');
  END;

BEGIN
  NewTimer(FreePollTimer, 0);
  NewTimer(ClearBufferTimer, 0);
  LastFreePollRing := '';
END.
