UNIT Repacker;
{ͻ}
{ Repacker with A.I.                            Last changed: 22.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE RunRepacker;

IMPLEMENTATION

USES Dos, PoPTypes, ArcView, Globals, Input, FileUtil, Util,
     MailUtil, StrUtil, ApTimer, MTask, Fossil, KeyBoard, OpCrt, OpDos,
     OpString, OpWindow, OproUtil, OpEntry, OpCmd;

PROCEDURE RunRepacker;
VAR
  t:EventTimer;
  Temp:WindowPtr;
  RepackPath:PathStr;
  Recursive, Ai, TrySelf   :BOOLEAN;
  FromPacker,ToPacker:ARRAY[1..7] OF BOOLEAN;

  FUNCTION GetInfo:BOOLEAN;
  VAR
    Esr:TPoPEntryScreen;
    ExitCommand:WORD;
    i:BYTE;
  BEGIN
    GetInfo:=False;

    TrySelf:=True;
    Ai:=True;
    Recursive:=True;
    FILLCHAR(FromPacker,SizeOf(FromPacker),1);
    FILLCHAR(ToPacker,SizeOf(ToPacker),1);
    ESR.Init(2,3,79,ScreenHeight-4,2,'Run parameters');
    WITH Esr DO
    BEGIN
      AddYesNoField('Only convert if saved space : ',2,2,'',2,32,0,Ai);
      AddYesNoField('Try packing with same arc   : ',4,2,'',4,32,0,TrySelf);
      AddYesNoField('Convert arcs inside arcs    : ',6,2,'',6,32,0,Recursive);
      AddTextField('      From     To',8,1);
      FOR i:=1 TO 7 DO
      BEGIN
        AddYesNoField(PackerExtension(i)+' :',8+i,2,'',8+i,10,0,FromPacker[i]);
        AddYesNoField('',8+i,2,'',8+i,17,0,ToPacker[i]);
      END;
      Process;
    END;
    ExitCommand:=ESR.GetLastCommand;
    Esr.Done;
    IF ExitCommand<>ccQuit THEN
    BEGIN
      RepackPath:=StartPath;
      IF NOT SelectPath(RepackPath) THEN Exit;
    END ELSE
      Exit;

    GetInfo:=True;
  END;

  FUNCTION DeleteWorkDir(CONST WorkDir,NewPath:PathStr):BOOLEAN;
  VAR
    Error:BOOLEAN;

    PROCEDURE KillFiles(CONST Dir:PathStr);
    VAR
      sr:SEARCHREC;
    BEGIN
      FINDFIRST(Dir+'\*.*',AnyFile,sr);
      WHILE DOSERROR=0 DO
      BEGIN
        IF sr.attr AND Directory=0 THEN
        BEGIN
          IF NOT DeleteFile(Dir+'\'+sr.name) THEN
          BEGIN
            FindClose(sr);
            Error:=True;
            EXIT;
          END;
        END;
        FINDNEXT(sr);
      END;
      FindClose(sr);
    END;

    PROCEDURE KillDirs(CONST Dir:PathStr);
    VAR
      sr:SEARCHREC;
    BEGIN
      FINDFIRST(Dir+'\*.*',Directory,sr);
      WHILE DOSERROR=0 DO
      BEGIN
        IF (sr.attr AND Directory<>0) AND (sr.name[1]<>'.') THEN
        BEGIN
          RmDir(Dir+'\'+sr.name);
          IF IORESULT<>0 THEN
          BEGIN
            FindClose(sr);
            Error:=True;
            EXIT;
          END;
        END;
        FINDNEXT(sr);
      END;
      FindClose(sr);
    END;

    PROCEDURE ParseDir(CONST Dir:PathStr);
    VAR
      DTA : SearchRec;
    BEGIN
      IF NOT Error THEN KillFiles(Dir);
      FINDFIRST(Dir+'\*.*',Directory,DTA);
      WHILE (DosError=0) AND NOT Error DO
      BEGIN
        IF ((DTA.Attr AND Directory<>0) AND (DTA.Name[1]<>'.')) THEN ParseDir(Dir+'\'+DTA.Name);
        IF NOT Error THEN KillDirs(Dir);
        FINDNEXT(DTA);
      END;
      FindClose(DTA);
    END;

  BEGIN
    Error:=False;
    IF NOT ChangeDir(NewPath) THEN WriteLn('Error changing to: '+NewPath);
    IF IsDirectory(WorkDir) THEN
    BEGIN
      IF WorkDir<>'' THEN ParseDir(WorkDir);
      RmDir(WorkDir);
    END;
    DeleteWorkDir:=NOT Error;
  END;

  PROCEDURE TryRepacking(CONST FileName:PathStr; Nesting:BYTE);
  VAR
    sr:SEARCHREC;
    i,x,y:SHORTINT;
    CurrentName,GemDir,WorkDir,ArcName:PathStr;
    BestSize,OldSize,NewSize:LONGINT;
    DidSomething, Flag:BOOLEAN;

    PROCEDURE UpdateBest;
    BEGIN
      BestSize:=NewSize;
      WriteLn('Conversion to ',PackerExtension(i),' saved ',OldSize-BestSize,' byte(s)');
      DeleteFile(CurrentName);
      CurrentName:=ForceExtension(FileName,PackerExtension(i));
      RenameFile(ArcName,CurrentName);
    END;

    PROCEDURE UpdateFilesBBS;
    VAR
      ind,ud:TEXT;
      oldname,newname:S13;
      p:PathStr;
      s:STRING;
    BEGIN
      p:=JustPathName(FileName);
      oldname:=JustFileName(FileName);
      newname:=CPad(JustFileName(CurrentName),13);
      ASSIGN(Ind,p+'\FILES.BBS'); RESET(ind);
      IF IORESULT=0 THEN
      BEGIN
        WriteLn('Updating FILES.BBS');
        ASSIGN(ud,p+'\FILES.$$$'); REWRITE(ud);
        WHILE NOT EOF(ind) DO
        BEGIN
          READLN(Ind,s);
          IF COPY(s,1,LENGTH(OldName))=oldname THEN
          BEGIN
            DELETE(s,1,13);
            INSERT(newname,s,1);
          END;
          WriteLn(ud,s);
        END;
        Close(ud);
        Close(ind);
        DeleteFile(p+'\FILES.BAK');
        RenameFile(p+'\FILES.BBS',p+'\FILES.BAK');
        RenameFile(p+'\FILES.$$$',p+'\FILES.BBS');
      END;
    END;

    FUNCTION Indent:STRING;
    BEGIN
      Indent:=CharStr(' ',2*Nesting);
    END;

  BEGIN
    GetDir(0,GemDir);
    DidSomething:=False;
    REPEAT
      WorkDir:=StartPath[1]+':\POPREPAK.$'+HexB(Cfg.TaskNumber)+'\'+COPY(InventPktName,1,8);
      MkDir(WorkDir);
    UNTIL IORESULT=0;
    x:=ArcType(FileName);
    IF (x>0) AND (x<>127) THEN { Known packer, and not a GIF }
    BEGIN
      FINDFIRST(FileName,AnyFile,sr);
      FindClose(sr);
      OldSize:=sr.Size;
      BestSize:=OldSize;
      IF NOT ChangeDir(WorkDir) THEN WriteLn('Error changing to: '+WorkDir);
      IF (FromPacker[x]) THEN
      BEGIN
        WriteLn(Indent,'Unpacking ',JustFileName(FileName));
        IF ArcCommand(x,2,FileName,'*.*') THEN
        BEGIN
          DidSomething:=True;
          IF Recursive THEN
          BEGIN
            FINDFIRST(WorkDir+'\*.*',AnyFile,sr);
            WHILE DOSERROR=0 DO
            BEGIN
              y:=ArcType(WorkDir+'\'+sr.name);
              IF (y>0) AND (FromPacker[y]) THEN TryRepacking(WorkDir+'\'+sr.name,Nesting+1);
              FINDNEXT(sr);
            END;
            FindClose(sr);
          END;
          ArcName:=ForceExtension(JustPathName(FileName)+'\'+InventPktName,'TMP');
          CurrentName:=FileName;
          FOR i:=1 TO 7 DO
          BEGIN
            Flag:=ToPacker[i];
            IF Flag AND (x=i) AND (NOT TrySelf) THEN Flag:=False;
            IF Flag THEN
            BEGIN
              WRITE(Indent,'Packing with ',PackerExtension(i),'  ');
              IF ArcCommand(i,1,ArcName,'*.*') THEN
              BEGIN
                IF ExistFile(ArcName) THEN
                BEGIN
                  IF (Ai) THEN
                  BEGIN
                    FINDFIRST(ArcName,AnyFile,sr);
                    FindClose(sr);
                    NewSize:=sr.Size;
                    IF NewSize>BestSize THEN
                    BEGIN
                      DeleteFile(ArcName);
                      WriteLn('Conversion would have wasted ',NewSize-BestSize,' byte(s)');
                    END ELSE
                      UpdateBest;
                  END ELSE
                    UpdateBest;
                END ELSE
                  WriteLn('Packer created no archive');
              END ELSE
                WriteLn;
            END;
          END;
          IF (Nesting=0) AND (CurrentName<>FileName) THEN UpdateFilesBBS;
          DeleteWorkDir(WorkDir,GemDir);
        END ELSE
        BEGIN
          DeleteWorkDir(WorkDir,GemDir);
          WriteLn;
        END;
      END;
    END ELSE
      DeleteWorkDir(WorkDir,GemDir);
    IF DidSomething AND (Nesting=0) THEN WriteLn('Cleaning up');
  END;

  PROCEDURE DoRepacker;
  VAR
    sr:SEARCHREC;
  BEGIN
    FINDFIRST(RepackPath+'\*.*',Archive,sr);
    WHILE DOSERROR=0 DO
    BEGIN
      TryRepacking(RepackPath+'\'+sr.name,0);
      FINDNEXT(sr);
    END;
    FindClose(sr);
  END;

BEGIN
  MyWin(Temp,1,2,80,ScreenHeight,2,'Repacker',False);
  MkDir(StartPath[1]+':\POPREPAK.$'+HexB(Cfg.TaskNumber));
  IF IOResult=0 THEN ;
  IF GetInfo THEN DoRepacker;
  NewTimerSecs(t,5);
  WHILE (NOT TimerExpired(t)) AND (NOT FKeyPressed) AND (NOT PoPKeyPressed) DO
    GiveUpTime;
  IF KeyPressed THEN PoPReadKeyWord;
  DeleteWorkDir(StartPath[1]+':\POPREPAK.$'+HexB(Cfg.TaskNumber),COPY(StartPath,1,LENGTH(StartPath)-1));
  KillWindow(Temp);
END;

END.
