UNIT OvrlayIn;
{ͻ}
{ Initializing of overlay manager               Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

IMPLEMENTATION

USES {$IFDEF Alpha} OpCrt, {$ENDIF} Overlay, Dos, OpXms, OpString, OvrLay;

TYPE
  OvrSteu = RECORD
    Int3f     : Integer;
    Unterbr   : Integer;
    CodePtr   : LongInt;
    CodeLen   : Word;
    RelocLen  : Word;
    JmpCnt    : Integer;
    NextCode  : Word;
    LoadAdr   : Word;
    StackPos  : Word;
    NextLoad  : Word;
    EmsNr     : Integer;
    EmsOffs   : Word;
    free1     : Integer;
    XMSOffset : LongInt;          { Offset of unit into XMS Memory }
    Vector    : array[0..1] of array[1..4] of byte;
  END;

VAR
  XMSHandle    : Word;
  OldReadBuf   : OvrReadFunc;
  OrgExit      : Pointer;
  CurXMSOffset : LongInt;


  PROCEDURE OvrXMSExit;
  BEGIN
    ExitProc:=OrgExit;
    OvrReadBuf:=OldReadBuf;
    IF XMSHandle<>0 THEN FreeExtMem(XMSHandle);
  END;

  FUNCTION GetReqOvlSize: LongInt;
  VAR
    w       : Word;
    OSize   : LongInt;
    SteuPtr : ^OvrSteu;
  BEGIN
    OSize:=0;
    w:=OvrCodeList;
    WHILE w<>0 DO
    BEGIN
      SteuPtr:=Ptr(w+PreFixSeg+$10,0);
      Inc(OSize,SteuPtr^.CodeLen+1);
      w:=SteuPtr^.NextCode;
    END;
    GetReqOvlSize:=OSize;
  END;

{$IFDEF Alpha}
  FUNCTION OwnOvrReadBuf(OvrSeg: Word): Integer; far;
  BEGIN
    OwnOvrReadBuf:=OldReadBuf(OvrSeg);
    FastWrite(Long2Str(OvrLoadCount), 1, 1, $70);
  END;
{$ENDIF}

  FUNCTION OwnOvrReadFromXMS(OvrSeg: Word): Integer; far;
  VAR
    ps,pd   : ExtMemPtr;
    Result  : Integer;
    SteuPtr : ^OvrSteu;
  BEGIN
    SteuPtr:=Ptr(OvrSeg,0);
    IF SteuPtr^.EMSNr=0 THEN               { Still not loaded from file }
    BEGIN
      Result:=OldReadBuf(OvrSeg);
      IF Result=0 THEN
      BEGIN
        SteuPtr^.XMSOffset:=CurXMSOffset;
        SteuPtr^.EMSNr:=1;                  { Mark as loaded in XMS }
        ps.RealPtr:=Ptr(SteuPtr^.LoadAdr,0);
        pd.ProtectedPtr:=CurXMSOffset;
        IF Odd(SteuPtr^.CodeLen) THEN Inc(SteuPtr^.CodeLen);
        IF MoveExtMemBlock(SteuPtr^.CodeLen, 0, ps, XMSHandle, pd)<>0 THEN
        BEGIN
          Result:=-4
        END ELSE
          Inc(CurXMSOffset,SteuPtr^.CodeLen);
      END;
    END ELSE
    BEGIN
      pd.RealPtr:=Ptr(SteuPtr^.LoadAdr,0);
      ps.ProtectedPtr:=SteuPtr^.XMSOffset;
      Result:=MoveExtMemBlock(SteuPtr^.CodeLen, XMSHandle, ps, 0, pd);
    END;
    OwnOvrReadFromXMS:=Result;
  END;

  PROCEDURE OvrInitXMS;
  VAR
    OSize : LongInt;
    TotalFree,LargestBlock: Word;
  BEGIN
    OvrResult:=0;
    OSize:=(GetReqOvlSize+$3FF) SHR 10;
    IF NOT (XMSInstalled AND (QueryFreeExtMem(TotalFree, LargestBlock)=0) AND
       (LargestBlock>=OSize) AND (AllocateExtMem(OSize, XMSHandle)=0)) THEN
    BEGIN
      OvrResult:=-6;
    END ELSE
    BEGIN
      CurXMSOffset:=0;
      OldReadBuf:=OvrReadBuf;
      OrgExit:=ExitProc;
      ExitProc:=@OvrXMSExit;
      OvrReadBuf:=OwnOvrReadFromXMS;
    END;
  END;

  PROCEDURE InitOverlay;
  VAR
    i          : Byte;
    ii         : Integer;
    OvrUseEMS  : Boolean;
    OvrXtraBuf : LongInt;

    PROCEDURE ParseCmdLine;
    VAR
      i: Byte;
      Tmp, Param : String;
      x  : LongInt;
      Ok : Integer;
    BEGIN
      Tmp:=StUpCase(GetEnv('POPCMDLINE'));
      FOR i:=1 TO ParamCount DO
        Tmp:=Tmp+' '+StUpCase(ParamStr(i));
      FOR i:=1 TO WordCount(Tmp, [' ']) DO
      BEGIN
        Param:=ExtractWord(i, Tmp, [' ']);

        IF Param[1] IN ['-','/'] THEN
        BEGIN
          Delete(Param,1,1);
          CASE Param[1] OF
            'B' : BEGIN
                    Val(Copy(Param,2,Length(Param)-1),x,ok);
                    IF ok=0 THEN OvrXtraBuf:=x;
                  END;
            '?',
            'E' : OvrUseEMS:=False;
          END;
        END;
      END;
    END;

  BEGIN
    OvrUseEMS:=True;
    OvrXtraBuf:=65536;
    ParseCmdLine;

    OvrFileMode:=$20;
    OvrInit(Copy(ParamStr(0),1,Length(ParamStr(0))-3)+'OVR');
    IF OvrResult<>ovrOk THEN
    BEGIN
      OvrInit(ParamStr(0));
      IF OvrResult<>ovrOk THEN
      BEGIN
        WriteLn('Error initializing overlaymanager.');
        Halt(252);
      END;
    END;
    OvrSetBuf(LongInt(OvrGetBuf+OvrXtraBuf) DIV 512 * 512);
    IF OvrResult<>OvrOK THEN
    BEGIN
      WriteLn('Overlay: OvrSetBuf error.');
      Halt(252);
    END;
    OverlayLocation:=Disk;
    IF OvrUseEMS THEN
    BEGIN
      OvrInitXMS;
      IF OvrResult=OvrOk THEN
      BEGIN
        OverlayLocation:=XMS;
      END ELSE
      BEGIN
        OvrInitEMS;
        IF OvrResult=OvrOk THEN OverlayLocation:=EMS;
      END;
    END;
    OvrSetRetry(OvrGetBuf DIV 3) ;
{$IFDEF Alpha}
    IF OverlayLocation=Disk THEN
    BEGIN
      OldReadBuf:=OvrReadBuf;
      OvrReadBuf:=OwnOvrReadBuf;
    END;
{$ENDIF}
  END;

BEGIN
{$IFDEF Alpha}
  StartMemAvail:=MemAvail;
{$ENDIF}
  InitOverlay;
END.

