UNIT OutInfo;
{ͻ}
{ Information about outbound traffic            Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may NOT be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{                                                                          }
{                        (C) Copyright 1998-2000 by                        }
{                          The German Portal Team                          }
{          Carsten Brandt, Michael Kleefeld and Marcus Roeckrath           }
{                                                                          }
{                                                                          }
{ Changes made                                                             }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 17 August 1999                                       }
{ Last Modification : 17 August 1999                                       }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE GetOutboundInformation;
PROCEDURE ExpandOutboundEntry;

IMPLEMENTATION

USES Dos, OpCrt, OpString, OpRoot, OpDate, OpWindow, OpKey, ApTimer,
{$IFDEF OS2}
     VpUtils,
{$ENDIF}
     PoPTypes, NodeList, MailUtil, StrUtil, OproUtil, KeyBoard, Com,
     Display, Util, Globals, LogFile;


  PROCEDURE GetOutboundInformation;
  VAR
    Escaped        : Boolean;
    OutName,
    ZoneOut,ss     : PathStr;
    SRec, sr,
    sr3            : SearchRec;
    i,
    GlobZone, GlobNet,
    GlobNode,Io    : Integer;
    p              : STRING[4];
    WaitWin        : PWait;

    FUNCTION CheckMType(MType: Byte): Boolean;
    VAR
      i : Byte;
    BEGIN
      CheckMType:=False;
      FOR i:=0 TO 7 DO
        IF (1 SHL Cfg.Modem.ModemType[i].Bit) AND MType<>0 THEN
        BEGIN
          CheckMType:=NOT Cfg.Modem.ModemType[i].DialOut;
          Break;
        END;
    END;

    PROCEDURE AddToList(CONST FName: S12; FSize, FileTime: LongInt);
    LABEL
      Again;
    VAR
      i              : Integer;
      DT             : DateTime;
      TmpAge         : LongInt;
      D,M,Y          : Integer;
      Ext            : S3;
      NlRec          : NodeListRecType;
      TmpPtr         : POutList;
      TmpAdr         : TFidoAddress;
    BEGIN
      WITH TmpAdr DO
      BEGIN
        Zone:=GlobZone;
        IF GlobNet=0 THEN
        BEGIN
          Val('$'+Copy(sr.Name, 1, 4), Net, i);
          Val('$'+Copy(sr.Name, 5, 4), Node, i);
          Point:=0;
        END ELSE
        BEGIN
          Net:=GlobNet;
          Node:=GlobNode;
          Val('$'+Copy(sr.Name, 5, 4), Point, i);
        END;
      END;
      CLOutListPtr:=POutList(OutList^.Head);
      WHILE (CLOutListPtr<>Nil) And NOT CmpAdr(CLOutListPtr^.Address,TmpAdr) DO
        CLOutListPtr:=POutList(OutList^.Next(CLOutListPtr));
      IF CLOutListPtr<>Nil THEN
      BEGIN
        CLOutListPtr^.Size:=CLOutListPtr^.Size+FSize;
      END ELSE
      BEGIN
        New(CLOutListPtr, Init);
        IF OutList^.Size=0 THEN
          OutList^.Append(CLOutListPtr)
        ELSE
        BEGIN
          TmpPtr:=POutList(OutList^.Head);
          WHILE (TmpPtr<>Nil) And (Address2Sort(TmpPtr^.Address)<Address2Sort(TmpAdr)) DO
            TmpPtr:=POutList(OutList^.Next(TmpPtr));
          IF TmpPtr<>Nil THEN
            OutList^.PlaceBefore(CLOutListPtr, TmpPtr)
          ELSE
            OutList^.Append(CLOutListPtr)
        END;
        WITH CLOutListPtr^ DO
        BEGIN
          Address:=TmpAdr;
          Size:=FSize;
Again:
          IF FindNode(TmpAdr,NlRec) THEN
          BEGIN
            Baud:=NlRec.BaudRate;
            Closed:=NlRec.SystemName[1]='<';
            NoCMail:=(NlRec.Flags And nlf_CrashMail)=0;
            Known:=True;
            Cost:=NlRec.RealCost;
            DontCall:=CheckMType(NlRec.ModemType);
          END;
          IF NoCMail THEN
            IF NOT FindNodeInfo(NodesRec, TmpAdr) THEN
            BEGIN
              IF TmpAdr.Point<>0 THEN
              BEGIN
                TmpAdr.Point:=0;
                GOTO Again;
              END;
              IF Cfg.Addresses[Cfg.MainAdrNum].Zone=Address.Zone THEN
              BEGIN
                OpenFrom:=Cfg.ZMHStart;
                OpenTo:=Cfg.ZMHEnd;
              END ELSE
                OpenTo:=HMSToTime(0, 0, 1);
            END ELSE
            BEGIN
              IF NodesRec.Phone<>'' THEN
              BEGIN
                Known:=True;
                Closed:=False;
              END;
              OpenFrom:=NodesRec.OpenFrom;
              OpenTo:=NodesRec.OpenTo;
            END;
          FindUnDialable(TmpAdr, NC, BWZ);
        END;
      END;
      I:=Pos('.', FName);
      Ext:=Copy(FName, i+1, 3);
      IF Ext='GLU' THEN
        CLOutListPtr^.Glued:=True
      ELSE
      BEGIN
        UnPackTime(FileTime,DT);
        WITH DT DO
          TmpAge:=Today-DMYToDate(Day,Month,Year);
        IF TmpAge>CLOutListPtr^.Age THEN CLOutListPtr^.Age:=TmpAge;
        IF FName<>'' THEN Inc(CLOutListPtr^.FilesToSend);
        WITH CLOutListPtr^ DO
        BEGIN
          IF i <> 0 THEN
          BEGIN
            IF Ext = 'REQ' THEN Bits:=(Bits OR 32) ELSE
              IF (Copy(Ext, 2, 2) = 'UT') OR (Pos(Copy(Ext, 1, 2), 'MO*TU*WE*TH*FR*SA*SU*') > 0) THEN
                Bits:=(Bits OR 64)
              ELSE
                Bits:=(Bits OR 128);
          END;
          CASE sr.Name[10] OF
            'C' : Bits:=Bits OR 4;
            'H' : Bits:=Bits OR 16;
            'D' : Bits:=Bits OR 2;
            'F',
            'O' : Bits:=Bits OR 1;
            'I' : Bits:=Bits OR 8;
          END;
        END;
      END;
    END;

    PROCEDURE SearchDir;
    VAR
      f   : TBufTextFile;
      e,i : Byte;
      sr2 : SearchRec;
      s   : STRING;

      FUNCTION SearchExt(x: Byte): {$IFDEF OS2} S4 {$ELSE} S3 {$ENDIF};
      BEGIN
        CASE x OF
          1 : SearchExt:='REQ';
          2 : SearchExt:='?UT';
          3 : SearchExt:='GLU';
          4 : SearchExt:='?LO';
        END;
      END;

    BEGIN
      FOR e:=1 TO 4 DO
      BEGIN
        IF Escaped THEN Break;
        FindFirst(ZoneOut+'????????.'+SearchExt(e), Archive, Sr);
{$IFDEF OutDebug}
        AddLog('!', 'Found: '+Sr.Name);
{$ENDIF}
        WHILE (DosError=0) AND NOT Escaped DO
        BEGIN
          IF (e<4) THEN
          BEGIN
            AddToList(Sr.Name, Sr.Size, Sr.Time);
            IF ComPort^.KeyPressed OR ((CurrentEvent.typ AND etDynamic=0) AND PoPKeyPressed) THEN Escaped:=True;
          END ELSE
          BEGIN
            IF f.Init(ZoneOut+Sr.Name, SOpenRead+ShareDenyNone, 10240) THEN
            BEGIN
              WHILE NOT f.EOF AND NOT Escaped DO
              BEGIN
                f.ReadLn(s);
                IF (s<>'') AND (s[1]<>'~') THEN
                BEGIN
                  IF s[1] IN ['#', '^'] THEN Delete(s, 1, 1);
                  FindFirst(s, archive, sr2);
                  IF DosError=0 THEN
                    AddToList(sr2.Name,sr2.size,sr2.Time)
                  ELSE
                    AddLog('!', 'Invalid entry in: '+ZoneOut+Sr.Name+' ('+s+')');
                  FindClose(sr2);
                END;
                IF ComPort^.KeyPressed OR ((CurrentEvent.typ AND etDynamic=0) AND PoPKeyPressed) THEN Escaped:=True;
              END;
              f.Done;
            END;
            AddToList('', 0, sr.time);
          END;
          FindNext(Sr);
{$IFDEF OutDebug}
          AddLog('!', 'Found: '+Sr.Name);
{$ENDIF}
          WaitWin^.Animate;
        END;
        FindClose(Sr);
      END;
    END;

  BEGIN
    Escaped:=ComPort^.KeyPressed OR (PoPKeyPressed AND (CurrentEvent.typ AND etDynamic=0));
    Dispose(OutList, Done);
    New(OutList, Init);
    New(WaitWin, Init(12, 2, 'Scanning outbound'));
    FindFirst(cfg.outbound+'.*', Directory, Srec);
{$IFDEF OutDebug}
    AddLog('!', 'Found: '+Srec.Name);
{$ENDIF}
    OutName:=JustFileName(cfg.outbound);
    GlobNode:=0; GlobNet:=0;
    StopClock;
    WHILE (DosError=0) AND NOT Escaped DO
    BEGIN
      io:=0;
      IF Srec.Name=OutName THEN
        GlobZone:=Cfg.Addresses[Cfg.MainAdrNum].Zone
      ELSE
      BEGIN
        p:=Copy(Srec.Name, Pos('.', Srec.Name)+1, 3);
        Val('$'+p, GlobZone, io);
        IF (GlobZone=Cfg.Addresses[Cfg.MainAdrNum].Zone) THEN
        BEGIN
          AddLog('!', 'Invalid outbound directory: '+SRec.Name);
          FindNext(SRec);
{$IFDEF OutDebug}
          AddLog('!', 'Found: '+SRec.Name);
{$ENDIF}
          Continue;
        END;
      END;
      IF (io=0) AND (GlobZone<>0) THEN
      BEGIN
        ZoneOut:=HoldAreaNameMunge(GlobZone,False);
        SearchDir;
        FindFirst(ZoneOut+'*.PNT',Directory,Sr3);
{$IFDEF OutDebug}
        AddLog('!', 'Found: '+Sr3.Name);
{$ENDIF}
        ss:=ZoneOut;
        WHILE (DosError=0) AND NOT Escaped DO
        BEGIN
          ZoneOut:=AddBackSlash(ss+Sr3.Name);
          Val('$'+Copy(sr3.Name, 1, 4), GlobNet, i);
          Val('$'+Copy(sr3.Name, 5, 4), GlobNode, i);
          SearchDir;
          FindNext(Sr3);
{$IFDEF OutDebug}
          AddLog('!', 'Found: '+Sr3.Name);
{$ENDIF}
        END;
        FindClose(Sr3);
      END;
      GlobNet:=0; GlobNode:=0;
      FindNext(SRec);
{$IFDEF OutDebug}
      AddLog('!', 'Found: '+SRec.Name);
{$ENDIF}
    END;
    FindClose(SRec);
    StartClock;
    CLOutListPtr:=POutList(OutList^.Head);
    FLOutListPtr:=POutList(OutList^.Head);
    Dispose(WaitWin, Done);
    IF Escaped THEN
    BEGIN
      NewTimerSecs(OutboundReRead, 120);
      MailToSend:=True;
    END ELSE
      NewTimerSecs(OutboundReRead, Cfg.OutReReadDelay);
  END;

  PROCEDURE ExpandOutboundEntry;
  LABEL
    AllDone;
  TYPE
    DetailRec      = RECORD
                       Name           : S12;
                       Mode           : Char;
                       after          : S8;
                       size           : LongInt;
                     END;
    DetailTab      = ARRAY[1..200] OF DetailRec;
  VAR
    Detail         : ^DetailTab;
    sr, sr1        : SEARCHREC;
    f              : TBufTextFile;
    i,num          : Integer;
    s              : STRING;
    spec           : Char;
    Temp           : windowptr;
    InKey          : Word;
  BEGIN
    IF OutList^.Size>0 THEN
    BEGIN
      New(Detail);
      WITH CLoutlistPtr^ DO
      BEGIN
        mywin(Temp, 1, 8, 80, ScreenHeight, 2, 'Outgoing files for '+Address2Str(Address),False);
        FindFirst(HoldFileName(Address,False)+'*', AnyFile, sr);
        num:=0;
        WHILE DosError = 0 DO
        BEGIN
          IF (Copy(sr.Name, 11, 2) = 'LO') OR (Copy(sr.Name, 11, 2) = 'EQ') THEN
          BEGIN
            IF f.Init(HoldAreaPath(Address,False)+sr.Name, SOpenRead+ShareDenyNone, 10240) THEN
            BEGIN
              WHILE NOT f.EoF DO
              BEGIN
                f.ReadLn(s);
                S:=StUpCase(S);
                Inc(num);
                Detail^[num].Mode:=sr.Name[10];
                IF Detail^[num].Mode = 'F' THEN Detail^[num].Mode:='N';
                IF s[1] IN ['#', '^','~'] THEN
                BEGIN
                  spec:=s[1];
                  Delete(s, 1, 1);
                END ELSE spec:=#0;
                FindFirst(s, AnyFile, sr1);
                IF DosError = 0 THEN
                BEGIN
                  Detail^[num].size:=sr1.Size
                END ELSE
                  Detail^[num].size:=0;
                Detail^[num].Name:=JustFileName(s);
                CASE spec OF
                  '^' : Detail^[num].after:='Erase';
                  '#' : Detail^[num].after:='Trunc';
                  '~' : Detail^[num].after:='Sent ';
                  #0  : Detail^[num].after:='Keep ';
                END;
              END;
              f.Done;
            END;
          END ELSE
            IF (Copy(sr.Name, 11, 2) = 'UT') AND (sr.Name[10] IN ['C', 'H', 'D', 'O','I']) THEN
            BEGIN
              Inc(num);
              Detail^[num].Name:=sr.Name;
              Detail^[num].Mode:=sr.Name[10];
              Detail^[num].after:='TRUNC';
              Detail^[num].size:=sr.size;
            END;
          FindNext(sr);
        END;
        FindClose(sr);
        FOR i:=1 TO num DO
          WITH Detail^[i] DO
          BEGIN
            Write(' '+CPad(Name,13)+' '+LongIntForm('##########',size)+' '+Mode+' '+after+CharStr(' ',5));
            IF ((i MOD 30)=0) And (i<>Num) THEN
            BEGIN
              InKey:=WaitForAction(20);
              IF ComPort^.KeyPressed OR (InKey=Esc) THEN GOTO AllDone;
              ClrScr;
            END ELSE
              IF NOT Odd(i) THEN WriteLn;
          END;
        WaitForAction(20);
AllDone:
        KillWindow(Temp);
      END;
      Dispose(Detail);
    END;
  END;

END.
