UNIT LCR;
{ͻ}
{ Least Cost Routing                            Last changed: 04.07.99  MR }
{                                                                          }
{                       (C) Copyright 1998,99 by                           }
{                            Marcus Roeckrath                              }
{                           2:2449/523@fidonet                             }
{                        marcus.roeckrath@gmx.de                           }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PopTypes;

VAR Costs : LONGINT;
    Zone : S40;
    Provider : S40;

FUNCTION LeastCostRouting(Phone: S40): S60;

IMPLEMENTATION

USES Dos, Globals, Util, OPDate, OPString, LogFile;

VAR F : Text;
    Line : STRING;
    I, I1 : SMALLINT;
    TodayYear, TodayMonth, TodayDay, TodayWeekday, TodayDayNumber : SMALLWORD;
    TodayHoliday : BOOLEAN;
    LCRDays : STRING[7];
    LCRDay, LCRMonth : SMALLWORD;
    LCRTimeStart, LCRTimeEnd : Time;
    Hour, Min: BYTE;
    LCRADD : STRING[20];
    LCRCosts : LONGINT;
    LCRDayNumber : SMALLWORD;

FUNCTION DayNumber(Year, Month, Day: SMALLWORD): SMALLWORD;
  VAR Temp, Temp1 : SMALLWORD;
  BEGIN
    Temp := (Month + 10) DIV 13;
    Temp1 := Day + (611 * (Month + 2)) DIV 20 - 2*Temp - 91;
    DayNumber := Temp1 + Byte(IsLeapYear(SMALLINT(Year)))*Temp;
  END;

FUNCTION Weekday(Year, Month, Day: SMALLWORD): SMALLWORD;
  VAR Temp, Temp1 : SMALLWORD;
  BEGIN
    Temp := (Year - 1) MOD 100;
    Temp1 := (Year - 1) DIV 100;
    Weekday := (28 + Temp + DayNumber(Year, Month, Day) + (Temp DIV 4) + (Temp1 DIV 4) + 5*Temp1) MOD 7;
  END;

FUNCTION Easter(Year: SMALLWORD): SMALLWORD;
  VAR Gz, Jhd, Ksj, Korr, So, Epakte, N : SMALLWORD;
  BEGIN
    Gz := (Year MOD 19) + 1;
    Jhd := (Year DIV 100) + 1;
    Ksj := ((3*Jhd) DIV 4) - 12;
    Korr := ((8*Jhd + 5) DIV 25) - 5;
    So := ((5*Year) DIV 4) - Ksj - 10;
    Epakte := (11*Gz + 20 + Korr - Ksj) MOD 30;
    IF ((Epakte = 25) AND (Gz > 11)) OR (Epakte = 24) THEN Inc(Epakte);
    N := 44 - Epakte;
    IF N < 21 THEN N := N + 30;
    N := N + 7 - (So + N) MOD 7;
    N := N + BYTE(IsLeapYear(SMALLINT(Year)));
    Easter := N + 59;
  END;

PROCEDURE CalcHolidays;
  CONST HolidaysShortCuts = 'ES-EM-AW-ML-MT-GF-CH-WS-WM-CC';
        HolidaysEasterDif : ARRAY[1..10] OF SHORTINT = (0,1,-46,-48,-3,-2,39,49,50,60);
  VAR TempDay, TempMonth, EasterDay : SMALLWORD;
      HoliPos : BYTE;
  BEGIN
    TodayHoliday := FALSE;
    EasterDay := Easter(TodayYear);
    WHILE Not EoF(F) AND (Copy(Line, 1, 15) <> '[HOLIDAYSSTART]') DO ReadLn(F, Line);
    WHILE Not EoF(F) AND (Copy(Line, 1, 13) <> '[HOLIDAYSEND]') AND Not TodayHoliday DO BEGIN
      ReadLn(F, Line);
      IF (Length(Line) > 0) AND (Line[1] <> ';') THEN BEGIN
        IF Copy(Line, 1, 1) = 'D' THEN BEGIN
          Val(Copy(Line, 3, 2), TempDay, I);
          Val(Copy(Line, 6, 2), TempMonth, I1);
          IF (I = 0) AND (I1 = 0) AND ValidDate(SMALLINT(TempDay), SMALLINT(TempMonth), SMALLINT(TodayYear)) AND
             (DayNumber(TodayYear, TempMonth, TempDay) = TodayDayNumber) THEN
            TodayHoliday := TRUE;
        END ELSE
        BEGIN
          HoliPos := Pos(Copy(Line, 1, 2), HolidaysShortCuts);
          IF HoliPos > 0 THEN BEGIN
            IF (EasterDay + HolidaysEasterDif[(HoliPos+2) DIV 3]) = TodayDayNumber THEN
              TodayHoliday := TRUE;
          END ELSE
          BEGIN
            IF Copy(Line, 1, 2) = 'RP' THEN BEGIN
              IF DayNumber(TodayYear, 12, 24) - Weekday(TodayYear, 12, 24) - 4*7 - 4 = TodayDayNumber THEN
                TodayHoliday := TRUE;
            END;
          END;
        END;
      END;
    END;
  END;

PROCEDURE SearchBlockBegin;
  BEGIN
    Line := '';
    WHILE NOT EoF(F) AND (Copy(Line, 1, 12) <> '[BLOCKBEGIN]') DO Readln(F, Line);
    IF Copy(Line, 1, 12) = '[BLOCKBEGIN]' THEN
      Zone := TrimSpaces(Copy(Line, 13, Length(Line)-12))
    ELSE Zone := '?';
  END;

FUNCTION SearchPhoneNumber(Phone: S40): BOOLEAN;
  VAR Found : BOOLEAN;
  BEGIN
    Found := FALSE;
    SearchBlockBegin;
    WHILE NOT EoF(F) AND Not Found DO BEGIN
      Readln(F, Line);
      IF Copy(Line, 1, 7) = 'SMTWTFS' THEN SearchBlockBegin
      ELSE BEGIN
        IF (Length(Line) >  0) AND (Line[1] <> ';') THEN BEGIN
          Line := TrimSpaces(Line);
          IF Pos(' ', Line) > 0 THEN Line[0] := Chr(Pos(' ', Line) - 1);
          IF Pos(Line, Phone) = 1 THEN BEGIN
            Found := TRUE;
            WHILE NOT EoF(F) AND (Copy(Line, 1, 7) <> 'SMTWTFS') DO BEGIN
              Readln(F, Line);
            END;
          END;
        END;
      END;
    END;
    SearchPhoneNumber := Found;
  END;

FUNCTION LeastCostRouting(Phone: S40): S60;
VAR TempPhone : S40;
    TempCosts : STRING;
BEGIN
  Costs := MaxLongInt;
  Assign(F, STARTPATH + PoPLeastCostRoutingFileName);
  FileMode:=ShareRead+ShareDenyW;
  Reset(F);
  TempPhone := '';
  Zone := '?';
  Provider := '?';
  IF IOResult = 0 THEN BEGIN
    FOR I := 1 TO Length(Phone) DO
      IF (Phone[I] >= '0') AND (Phone[i] <= '9') THEN TempPhone := TempPhone + Phone[i];
    GetDate(TodayYear, TodayMonth, TodayDay, TodayWeekDay);
    Inc(TodayWeekDay);
    TodayDayNumber := DayNumber(TodayYear, TodayMonth, TodayDay);
    CalcHolidays;
    IF SearchPhoneNumber(TempPhone) THEN BEGIN
      TempPhone := '';
      WHILE Not Eof(F) AND (Copy(Line, 1, 10) <> '[BLOCKEND]') DO BEGIN
        Readln(F, Line);
        IF (Length(Line) >= 42) AND (Line[1] <> ';') THEN BEGIN
          LCRDays := Copy(Line, 1, 7);
          Val(Copy(Line, 9, 2), Hour, I);
          Val(Copy(Line, 12, 2), Min, I1);
          IF (I = 0) AND (I1 = 0) AND ValidTime(Hour, Min, 0) THEN BEGIN
            LCRTimeStart := HMSToTime(Hour, Min, 0);
            Val(Copy(Line, 15, 2), Hour, I);
            Val(Copy(Line, 18, 2), Min, I1);
            IF (I = 0) AND (I1 = 0) AND ValidTime(Hour, Min, 59) THEN BEGIN
              LCRTimeEnd := HMSToTime(Hour, Min, 59);
              TempCosts := TrimSpaces(Copy(Line, 42, Length(Line)-41));
              IF Pos(' ', TempCosts) > 0 THEN TempCosts[0] := Chr(Pos(' ', TempCosts) - 1);
              Val(TempCosts, LCRCosts, I);
              IF I = 0 THEN BEGIN
                LCRAdd := Copy(Line, 21, 20);
                LCRDayNumber := 0;
                IF Upcase(LCRDays[1]) = 'D' THEN BEGIN
                  Val(Copy(LCRDays, 2, 2), LCRDay, I);
                  Val(Copy(LCRDays, 5, 2), LCRMonth, I1);
                  IF (I = 0) AND (I1 = 0) AND ValidDate(SMALLINT(LCRDay), SMALLINT(LCRMonth), SMALLINT(TodayYear)) THEN
                    LCRDayNumber := DayNumber(TodayYear, LCRMonth, LCRDay);
                END;
                IF ((Upcase(LCRDays[TodayWeekDay]) = 'X') OR (LCRDayNumber = TodayDayNumber)
                   OR ((LCRDays = 'HOLIDAY') AND TodayHoliday))
                   AND TimeIsBetween(LCRTimeStart, LCRTimeEnd) AND (Costs > LCRCosts) THEN BEGIN
                  Costs := LCRCosts;
                  TempPhone := TrimSpaces(LCRAdd);
                  Provider := TrimSpaces(Copy(Line, 42, Length(Line)-41));
                  IF Pos(' ', Provider) > 0 THEN
                    Provider := TrimSpaces(Copy(Provider, Pos(' ', Provider) + 1, Length(Provider) - Pos(' ', Provider)))
                  ELSE Provider := '?';
                END;
              END;
            END;
          END;
        END;
      END;
    END
    ELSE TempPhone := '';
    Close(F);
  END
  ELSE AddLog('!', 'Least Cost Router configuration file ' + PoPLeastCostRoutingFileName + ' not found');
  IF Zone = '' THEN Zone := '?';
  LeastCostRouting := TempPhone + Phone;
END;

END.
