UNIT AMFBBS;
{ͻ}
{ File areamanager # FilesBBSFileman            Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, AMList, AreaMisc;

TYPE
  FilesbbsType = Object(Alist)
    FilesBBS    : FilesBBSTab;
    MemOk,
    MarkedOne   : Boolean;
    MaxL,
    Line        : Byte;
    Files       : ^FilesTab;
    NumFiles,
    FilesBBSNum : WORD;
    All : Boolean;
    OldArea     :integer;

    Constructor Init;
    Destructor Done; Virtual;
    FUNCTION MarkCount : Word;
    PROCEDURE ShowFilesBBSLine(CONST f: FilesBBSRec; L: Integer; Current: Boolean);
    PROCEDURE TotalHeader;
    PROCEDURE MarkedHeader;
    PROCEDURE ShowFilesInArea(fp: Integer);
    PROCEDURE ScrollFilesUp;
    PROCEDURE ScrollFilesDown;
    PROCEDURE EditFileDescription;
    PROCEDURE InsertLine;
    PROCEDURE ViewGIF;
    PROCEDURE RenameLine;
    PROCEDURE DeleteOneLine(Ask, Del: Boolean; Num: Integer);
    PROCEDURE DeleteLine(Ask: Boolean);
    PROCEDURE TouchFile;
    PROCEDURE MoveLine;
    PROCEDURE TouchAllFiles;

    PROCEDURE ReAllignDownloadCounters(Silent: Boolean);
    PROCEDURE DeleteDownloadCounters;
    PROCEDURE ResetDownloadCounters;
    PROCEDURE InsertDownLoadCounters(Silent: Boolean);
    PROCEDURE GlobalCommands;
    PROCEDURE SortFilesBBS;
    PROCEDURE SendFilesToNode;
    PROCEDURE HatchFiles;
    PROCEDURE AreaManagerMain;
 END;


PROCEDURE Information(CONST txt : String);

IMPLEMENTATION

USES Dos, OpCrt, OpDos, OpKey, OpString, OpRoot, OpCmd, OpFrame,
     OpWindow, OpEdit,
     Tick , AreaMan, OutUtil, ArcView, NodeList, Input, Display,
     MailUtil, FileUtil, StrUtil, OproUtil, Util, Resource,
     Keyboard, PoPTypes, Globals;

  PROCEDURE AreaManagerKbdStatProc(KbdFlags: Byte); far;
  VAR
    s,ss:S80;
  BEGIN
    s:='';
    ss:='';
    CASE KbdFlags OF
      0 : BEGIN
            s:='F1=Help         F2=Delete line  F3=Edit descr.  F4=Move/Copy    F5=Rename File';
            ss:='F6=Touch File   F7=Insert line  F8=Sort files   F9=View Archive F0=Global cmds';
          END;
    2,1 : BEGIN
            s:='F1=Send files   F2=Hatch tick   F3=Center line  F4=Join lines';
            ss:='                                                F9=View Picture';
          END;
    END;
    WITH Cfg.Color[2] DO
    BEGIN
      FastText(CPad(s,80),ScreenHeight-1,1);
      FastText(CPad(ss,80),ScreenHeight,1);
    END;
  END;

  PROCEDURE NewStr(VAR Sp: StringPtr; CONST s: STRING);
  BEGIN
    DisposeString(sp);
    Sp:=StringToHeap(s);
  END;

  PROCEDURE Information(CONST txt : String);
  BEGIN
    FastWrite(txt+charstr(' ',80-Length(txt)),ScreenHeight-2,1,cfg.color[2].TextColor);
  END;

  PROCEDURE FilesbbsFindFile(A : Alistptr); { Original code provided by Steen Buch Christensen }
  VAR
    S : String;
    NumF,FBBSNum,j,I : Word;
    Found : Boolean;
    Conf : Boolean;
    LE   : LineEditor;
    f:^FilesTab;
    FBBS:^FilesBBSTab;
    Temp2 : WindowPtr;
  BEGIN
    New(f);
    New(FBBS);
    S:='';
    FBBSNum:=0;
    IF InputString(5,8,70,50,3,'Search','Text : ',s) THEN
      FOR i:= 1 TO Numarea DO
      BEGIN
        If GotEsc then break;
        IF ReadFilesInArea(Area^[i]^.FPath^,4,F^,FBBS^,FBBSNum,NumF,I) THEN
        BEGIN
          s:=StUpCase(s);
          Found:=FALSE;
          FOR j:=1 TO FBBSNum DO
          BEGIN
            IF POS(s,StUpCase(FBBS^[j]^.tekst^))<>0 THEN
            BEGIN
              MyWin(Temp2,3,8,78,12,4,'Found...',False);
              Temp2^.wFastWrite('Area: ('+Area^[i]^.tag^+') '+Area^[i]^.title^,1,2,Cfg.Color[4].HighLightColor);
              Temp2^.wFastWrite('File: '+Trim(COPY(FBBS^[j]^.Tekst^,1,12)),2,2,Cfg.Color[4].HighLightColor);
              Temp2^.wFastWrite('Desc: '+Trim(COPY(FBBS^[j]^.Tekst^,13,80)),3,2,Cfg.Color[4].HighLightColor);
{             Temp^.wFastWrite('Continue search [Y/N] ? ',5,2,Cfg.Color[4].HighLightColor);
              LE.Init(Cfg.Color[4]);
              Conf:=LE.YesOrNo('Continue search [Y/N] ? ',5,2,'Y'); }
              Conf := Confirm('Continue search ?','N',14);
              KillWindow(Temp2);
              If not Conf THEN
              BEGIN
                Found:=True;
                Break;
              END;
            END;
          END;
          IF Found THEN
          BEGIN
            StuffKey(Enter);
            A^.TopArea:=i-1;
            A^.AreaLine:=1;
            A^.StartLine:=j-1;
            Break;
          END;
        END;
      END;
    DeAllocateFiles(FBBS^,FBBSNum);
    Dispose(f);
    Dispose(FBBS);
  END;

{=== FilesbbsType ===}


  CONSTRUCTOR FilesbbsType.Init;
  BEGIN
    InitAreaManager;
    MarkedOne:=FALSE;
    NumFiles:=0;
    FilesBBSNum:=0;
    Filefinder := FilesbbsFindFile;
{   MyWin(MainFuncKeyWin,1,ScreenHeight-2,80,ScreenHeight,2,'',False); }
    FileMgrWin^.WFrame.AddHeader('',heBL);
    FileMgrWin^.WFrame.AddHeader('',heBR);
    FileMgrWin^.WFrame.DrawHeader(1);
    FileMgrWin^.WFrame.DrawHeader(2);
    New(Files);
    FillChar(Files^,SizeOf(FilesTab),0);
  END;

  DESTRUCTOR FilesbbsType.Done;
  BEGIN
    Dispose(Files);
    DeAllocateFiles(FilesBBS,FilesBBSNum);
    FinishAreaManager;
  END;

  FUNCTION FilesbbsType.MarkCount : Word;
  VAR
    i,j:Word;
  BEGIN
    i:=0;
    FOR j:=1 TO FilesBBSNum DO
      IF FilesBBS[j]^.Mark THEN Inc(i);
    MarkCount:=i;
  END;


  PROCEDURE FilesbbsType.ShowFilesBBSLine(CONST f: FilesBBSRec; L: Integer; Current: Boolean);
  VAR
    j,i        : Integer;
    Dt         : DateTime;
    linetoshow : S78;
    s          : String;
  BEGIN
    j:=GetFileInfo(f.Tekst^,Files^,NumFiles);
    linetoshow:=f.Tekst^;
    s:=f.Tekst^+' ';
    IF HasFileName(s) THEN
    BEGIN
      IF j<>0 THEN
      BEGIN
        WITH Files^[j] DO
        BEGIN
          UnPackTime(Time,Dt);
          linetoshow:=Name+charstr(' ',13-Length(Name))+tochar(Dt.Day)+'/' +
          tochar(Dt.Month)+'-'+tochar(Dt.Year MOD 100)+LongIntForm('########',size);
        END;
        s:=f.Tekst^+' ';
        Delete(s,1,pos(' ',s));
        i:=0;
        REPEAT
          Inc(i);
        UNTIL (s[i]<>' ') OR (i>Length(s));
        Delete(s,1,i-1);
        linetoshow:=linetoshow+' '+s;
      END ELSE
      BEGIN
        linetoshow:=f.Tekst^;
        IF Length(f.Tekst^)<13 THEN linetoshow:=linetoshow+charstr(' ',13-Length(f.Tekst^));
        Insert('     MISSING     ',linetoshow,14);
      END;
    END;
    linetoshow:=linetoshow+charstr(' ',78);
    j:=FirstShown+L;
    FileMgrWin^.wFastWrite(linetoshow,L,1,CorrectAttribute(2,Current,f.Mark));
  END;

  PROCEDURE FilesbbsType.TotalHeader;
  VAR
    Redraw:Boolean;
    TotalBytes:LONGINT;
    i:Word;
  BEGIN
    TotalBytes:=0;
    FOR i:=1 TO NumFiles DO
      Inc(TotalBytes,Files^[i].Size);
    FileMgrWin^.wFrame.ChangeHeaderString(1,' Files '+LongIntForm('####',NumFiles)+
                                                ' Bytes : '+LongIntForm('###,###,###',TotalBytes)+' ',ReDraw);
    IF ReDraw THEN FileMgrWin^.wFrame.UpDateFrame ELSE FileMgrWin^.wFrame.DrawHeader(1);
  END;

  PROCEDURE FilesbbsType.MarkedHeader;
  VAR
    Redraw:Boolean;
    TotalBytes:LONGINT;
    i,j:Word;
  BEGIN
    TotalBytes:=0;
    FOR i:=1 TO FilesBBSNum DO
      IF FilesBBS[i]^.Mark THEN
      BEGIN
        j:=GetFileInfo(FilesBBS[i]^.Tekst^,Files^,NumFiles);
        IF j>0 THEN Inc(TotalBytes,Files^[j].Size);
      END;
    FileMgrWin^.wFrame.ChangeHeaderString(2,' Marked Lines '+LongIntForm('####',MarkCount)+
                                                ' Bytes : '+LongIntForm('###,###,###',TotalBytes)+' ',ReDraw);
    IF ReDraw THEN FileMgrWin^.wFrame.UpDateFrame ELSE FileMgrWin^.wFrame.DrawHeader(2);
  END;

  PROCEDURE FilesbbsType.ShowFilesInArea(fp: Integer);
  VAR
    f,i : Integer;
  BEGIN
    FileMgrWin^.Clear;
    f:=fp;
    IF (f<0) OR (FilesBBSNum<0) THEN
    BEGIN
      f:=0;
      FilesBBSNum:=0;
      Line:=0;
    END;
    FirstShown:=f;
    i:=0;
    WHILE (i<ScreenHeight-6) AND (f+i<FilesBBSNum) DO
    BEGIN
      Inc(i);
      ShowFilesBBSLine(FilesBBS[i+f]^,i,FALSE);
    END;
    MaxL:=i;
    IF Line>MaxL THEN Line:=MaxL;
    IF (Line<1) AND (MaxL>0) THEN Line:=1;
    TotalHeader;
    MarkedHeader;
  END;

  PROCEDURE FilesbbsType.ScrollFilesUp;
  BEGIN
    IF FirstShown+ScreenHeight-6<=FilesBBSNum THEN
    BEGIN
      Inc(FirstShown);
      FileMgrWin^.ScrollVert(1);
      IF MaxL=ScreenHeight-6 THEN
      BEGIN
        ShowFilesBBSLine(FilesBBS[FirstShown+ScreenHeight-6]^,ScreenHeight-6,True);
      END;
    END;
  END;

  PROCEDURE FilesbbsType.ScrollFilesDown;
  BEGIN
    IF FirstShown>0 THEN
    BEGIN
      Dec(FirstShown);
      FileMgrWin^.Scrollvert(-1);
      ShowFilesBBSLine(FilesBBS[FirstShown+1]^,1,True);
    END;
  END;

  PROCEDURE FilesbbsType.EditFileDescription;
  VAR
    i,j     : Integer;
    s,ss    : String;
  BEGIN
    s:=FilesBBS[FirstShown+Line]^.Tekst^;
    j:=GetFileInfo(s,Files^,NumFiles);
    ss:='';
    IF HasFileName(s) THEN
    BEGIN
      i:=1;
      WHILE (s[i]<>' ') AND (Length(s) >=i) DO
        Inc(i);
      WHILE (s[i]=' ') AND (Length(s) >=i) DO
        Inc(i);
      ss:=Copy(s,1,i-1);
      Delete(s,1,i-1);
      IF ss<>'' THEN ss:=ss+charstr(' ',13-Length(ss));
    END;
    IF InputString(3,7,250,65,3,'Edit description','Desc : ',s) THEN
    BEGIN
      ss:=ss+s;
      NewStr(FilesBBS[FirstShown+Line]^.Tekst,ss);
    END;
    ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,True);
  END;

  PROCEDURE FilesbbsType.InsertLine;
  VAR
    i,j : Integer;
    m   : TPoPMenu;
    ec,
    key : Word;
  BEGIN
    BEGIN
      IF FilesBBSNum>0 THEN
      BEGIN
        GetMenu(MnuAMInsertLine,3,m);
        m.ProcessMenu(Key, ec);
      END ELSE
        ec:=ccNone;
      IF ec<>ccQuit THEN
      BEGIN
        j:=1;
        Inc(FilesBBSNum);
        New(FilesBBS[FilesBBSNum]);
        IF FilesBBSNum>1 THEN
        BEGIN
          IF key=1 THEN j:=0 ELSE j:=1;
          FOR i:=FilesBBSNum-1 DOWNTO FirstShown+Line+j DO
            FilesBBS[i+1]^:=FilesBBS[i]^;
        END;
        FilesBBS[FirstShown+Line+j]^.Tekst:=StringToHeap('');
        FilesBBS[FirstShown+Line+j]^.Mark:=False;
        IF FirstShown>FilesBBSNum THEN FirstShown:=FilesBBSNum;
        ShowFilesInArea(FirstShown);
      END;
    END;
  END;

  PROCEDURE FilesbbsType.ViewGIF;
  Var
    s         : S13;
    ss        : String;
  BEGIN
    BEGIN
      s:=FilesBBS[FirstShown+Line]^.Tekst^+' ';
      s:=Copy(s,1,pos(' ',s)-1);
      If (s<>'') and (TrimSpaces(Cfg.AreaMan.ViewCMD)<>'') THEN
      BEGIN
        Ss:=Cfg.AreaMan.ViewCMD;
        Replace(ss,'$filename',s,0);
        RunCmd(ss,'');
      END;
    END;
  END;

  PROCEDURE FilesbbsType.RenameLine;
  VAR
    s,ss    : S13;
    Tmp     : STRING;
    i,j     : Integer;
    f       : FILE;
  BEGIN
    BEGIN
      s:=FilesBBS[FirstShown+Line]^.Tekst^+' ';
      s:=Copy(s,1,pos(' ',s)-1);
      ss:=s;
      IF s<>'' THEN
      BEGIN
        IF InputString(30,8,12,12,3,'Rename file','FileName : ',s) AND (s<>ss) THEN
        BEGIN
          s:=StUpCase(s);
          j:=GetFileInfo(s,Files^,NumFiles);
          Assign(f,ss); Rename(f,s);
          IF IoResult=0 THEN
          BEGIN
            i:=GetFileInfo(ss,Files^,NumFiles);
            IF i<>0 THEN Files^[i].Name:=s;
          END;
          Tmp:=FilesBBS[FirstShown+Line]^.Tekst^;
          Delete(Tmp,1,Length(ss));
          Insert(s,Tmp,1);
          IF Length(s)<Length(ss) THEN
          BEGIN
            i:=Length(ss)-Length(s);
            Insert(charstr(' ',i),Tmp,Length(s)+1);
          END
          ELSE
            IF Length(s)>Length(ss) THEN
            BEGIN
              i:=Length(s)-Length(ss);
              Delete(Tmp,Length(s)+1,i);
            END;
          NewStr(FilesBBS[FirstShown+Line]^.Tekst,Tmp);
          SorterFiles(Files^,NumFiles);
          ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,True);
        END;
      END
      ELSE
      BEGIN
        AskError(8,'This line does NOT contain a file name',3);
      END;
    END;
  END;

  PROCEDURE FilesbbsType.DeleteOneLine(Ask, Del: Boolean; Num: Integer);
  VAR
    i:Integer;
    s:STRING;
    sr:SEARCHREC;
    d:Boolean;
  BEGIN
    d:=Del;
    BEGIN
      s:=FilesBBS[num]^.Tekst^+' ';
      s:=Copy(s,1,pos(' ',s)-1);
      DisposeString(FilesBBS[num]^.Tekst);
      FOR i:=num TO FilesBBSNum-1 DO
        FilesBBS[i]^:=FilesBBS[i+1]^;
      Dispose(FilesBBS[FilesBBSNum]);
      Dec(FilesBBSNum);
      IF s<>'' THEN
      BEGIN
        i:=GetFileInfo(s,Files^,NumFiles);
        IF i<>0 THEN
        BEGIN
          IF WritableFile(Area^[CurrentArea]^.Path^+s) THEN
          BEGIN
            IF All THEN d:=TRUE ELSE
              IF Ask THEN
              BEGIN
                CASE ConfirmAll(' Delete '+s+' also?',6) OF
                  'Y' : d:=TRUE;
                  'N' : d:=FALSE;
                  'A' : BEGIN
                          All:=TRUE;
                          d:=TRUE;
                        END;
                END;
              END;
            IF D THEN
            BEGIN
              FINDFIRST(s,archive,sr);
              WHILE DOSERROR=0 DO
              BEGIN
                DeleteFile(sr.Name);
                FINDNEXT(sr);
              END;
              FindClose(sr);
              Move(Files^[i+1],Files^[i],SizeOf(FilesRec)*(NumFiles-i));
              Dec(NumFiles);
            END;
          END;
        END;
      END;
    END;
  END;

  PROCEDURE FilesbbsType.DeleteLine(Ask: Boolean);
  VAR
    j   : Integer;
    Del : Boolean;
  BEGIN
    BEGIN
      Del:=NOT Ask;
      IF Ask THEN
        IF MarkCount=0 THEN Del:=Confirm('Delete current line','Y',5)
                       ELSE Del:=Confirm('Delete MARKED lines','N',5);
      IF Del THEN
      BEGIN
        IF MarkCount=0 THEN FilesBBS[FirstShown+Line]^.Mark:=True;
        j:=1;
        All:=FALSE;
        REPEAT
          IF FilesBBS[j]^.Mark THEN
          BEGIN
            DeleteOneLine(Ask,Del,j);
          END ELSE Inc(j);
        UNTIL j>FilesBBSNum;
        IF FirstShown>=FilesBBSNum THEN FirstShown:=FilesBBSNum-1;
        ShowFilesInArea(FirstShown);
        IF Line>MaxL THEN Line:=MaxL;
      END;
    END;
  END;

  PROCEDURE FilesbbsType.TouchFile;
  VAR
    l      : LongInt;
    Sec100,
    dofw,i : Word;
    s      : String;
    Dt     : DateTime;
    f      : FILE;
  BEGIN
    BEGIN
      IF MarkCount=0 THEN FilesBBS[FirstShown+Line]^.Mark:=True;
      FOR i:=1 TO FilesBBSNum DO
        IF FilesBBS[i]^.Mark AND HasFileName(FilesBBS[i]^.Tekst^) THEN
        BEGIN
          s:=FilesBBS[i]^.Tekst^+' ';
          s:=Copy(s,1,pos(' ',s)-1);
          IF s<>'' THEN
          BEGIN
            WITH Dt DO
            BEGIN
              GetTime(Hour,Min,Sec,Sec100);
              GetDate(Year,Month,Day,dofw);
            END;
            packtime(Dt,l);
            Assign(f,s); FileMode:=ShareRead+ShareDenyW; Reset(f);
            IF IoResult=0 THEN
            BEGIN
              dofw:=GetFileInfo(s,Files^,NumFiles);
              IF dofw<>0 THEN Files^[dofw].Time:=l;
              SetFTime(f,l); Close(f);
            END;
          END;
        END;
      IF MarkCount=1 THEN
      BEGIN
        FilesBBS[FirstShown+Line]^.Mark:=False;
        ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,True);
      END;
      ShowFilesInArea(FirstShown);
    END;
  END;

  PROCEDURE FilesbbsType.MoveLine;
  VAR
    m   : TPoPMenu;
    key : Word;

    PROCEDURE InitMenu(VAR m : TPoPMenu);
    VAR
      sd:CHAR;
    BEGIN
      GetMenu(MnuAMMoveFile,3,m);
      IF GetDiskClass(Area^[CurrentArea]^.Path^[1],sd)=CDRomDisk THEN
      BEGIN
        m.ProtectItem(1);
        m.ProtectItem(2);
      END;
      IF (MarkCount>1) OR
         (GetDiskClass(Area^[CurrentArea]^.FPath^[1],sd)=CDRomDisk) THEN m.ProtectItem(5);
      m.Draw;
    END;

    PROCEDURE MoveFileToOtherArea(Keep, InFileArea: Boolean);
    LABEL
      Slut, Skip, DoTheMove, MoveTheText;
    VAR
      Go, All        : BOOLEAN;
      OldAreaLine,
      OldTopArea, j  : Integer;
      GemTekst, Fp,
      s,ss, DestPath : String;
      testfile       : FILE;
      f              : TBufTextFile;
      Escaped        : Boolean;
      M              : TPoPMenu;
      Key, Inkey     : Word;

      procedure InitMenu(var M : TPoPMenu);
      begin
        GetMenu(MnuCopyFileError,3,m);
        M.WFrame.AddHeader(' '+ss+' ',heTC);
        m.Draw;
      end;

    BEGIN
      BEGIN
        j:=1;
        OldArea:=CurrentArea;
        OldTopArea:=TopArea;
        OldAreaLine:=AreaLine;
        IF InFileArea THEN
        BEGIN
          Escaped:=NOT ChooseFileArea(InKey);
          DestPath:=Area^[CurrentArea]^.Path^;
          AreaLine:=OldAreaLine;
          TopArea:=OldTopArea;
          ChangeDir(Area^[OldArea]^.path^);
          IF Escaped THEN GOTO Slut;
        END ELSE
        BEGIN
          DestPath:='A:';
          IF NOT SelectPath(DestPath) THEN GOTO Slut;
        END;
        IF ((CurrentArea<>OldArea) OR NOT InFileArea) THEN
        BEGIN
          IF MarkCount=0 THEN
          BEGIN
            FilesBBS[FirstShown+Line]^.Mark:=True;
            MarkedOne:=True;
          END ELSE MarkedOne:=FALSE;
          IF InFileArea THEN Fp:=Area^[CurrentArea]^.FPath^ ELSE Fp:=AddBackSlash(DestPath)+'FILES.BBS';
          f.InitCreate(Fp, SOpenWrite, 2048);
          All:=FALSE;
          REPEAT
            IF FilesBBS[j]^.Mark THEN
            BEGIN
              GemTekst:=FilesBBS[j]^.Tekst^;
              s:=GemTekst+' ';
              s:=Copy(s,1,pos(' ',s)-1);
              IF ExistFile(AddBackSlash(DestPath)+s) THEN
              BEGIN
                IF NOT All THEN
                BEGIN
                  CASE ConfirmAll('Overwrite existing file "'+s+'" ?',8) OF
                    'Y' : Go:=TRUE;
                    'N' : Go:=FALSE;
                    'A' : BEGIN
                            Go:=TRUE;
                            All:=TRUE;
                          END;
                  END;
                END;
                IF Go THEN GOTO DoTheMove ELSE FilesBBS[j]^.Mark:=FALSE;
              END ELSE
              BEGIN
DoTheMove:
                IF (Copy(Area^[OldArea]^.path^,1,1)=COPY(DestPath,1,1)) AND Not Keep THEN
                BEGIN
                  {Assign(TestFile,AddBackSlash(DestPath)+s); Erase(TestFile);}
                  Deletefile(AddBackSlash(DestPath)+s);
                  InOutRes:=0; io:=0;
                  Assign(TestFile,Area^[OldArea]^.path^+s); Rename(TestFile,AddBackSlash(DestPath)+s);
                  IF IoResult=0 THEN GOTO MoveTheText;
                END
                ELSE
                BEGIN
                  IF HasFileName(s) AND ExistFile(Area^[OldArea]^.Path^+s) THEN
                    Io:=CopyFile(Area^[OldArea]^.path^+s,AddBackSlash(DestPath)+s,False,False)
                  ELSE io:=0;
                END;
                IF io=0 THEN
                BEGIN
MoveTheText:
                  f.WriteLn(GemTekst);
                  IF Not Keep THEN DeleteOneLine(False,True,j);
                END ELSE
                BEGIN
                  f.Done;
                  CASE io OF
                      5 : ss:='No Room for '+JustFileName(s);
                    152 : ss:='Drive not ready';
                    162 : ss:='General failure';
                    ELSE  ss:='Unknown error #'+Long2Str(io);
                  END;
                  InitMenu(M);
                  m.Process;
                  Key := m.MenuChoice;
                  IF m.GetLastCommand=ccQuit THEN Key:=2;
                  m.Done;
                  CASE Key OF
                    1 : BEGIN
                          f.InitCreate(Fp, SOpenWrite, 2048);
                          GOTO DoTheMove;
                        END;
                    2 : GOTO Slut;
                    3 : GOTO Skip;
                  END;
                END;
              END;
Skip:
              IF Keep OR (io=5) THEN Inc(j);
            END ELSE
              Inc(j);
          UNTIL j>FilesBBSNum;
          f.Done;
Slut:
          IF MarkedOne AND (MarkCount=1) THEN FilesBBS[FirstShown+Line]^.Mark:=FALSE;
          ShowFilesInArea(FirstShown);
        END;
        IF InFileArea THEN CurrentArea:=OldArea;
      END;
    END;

  BEGIN
    InitMenu(m);
    m.Process;
    key:=m.MenuChoice;
    m.Erase;
    IF m.GetLastCommand<>ccQuit THEN
    BEGIN
      CASE key OF
     1..4 : MoveFileToOtherArea(Key IN [3,4],Key IN [1,3]);
        5 : BEGIN
              movemode:=True;
              Information('MOVE MODE: F-Keys disabled. Hit RETURN to finish.');
            END;
      END;
    END;
    m.Done;
  END;

  PROCEDURE FilesbbsType.TouchAllFiles;
  VAR
    f      : FILE;
    i      : Integer;
    l      : LongInt;
    Dt     : DateTime;
    Sec100,
    dofw   : Word;
  BEGIN
    IF Confirm('Touch ALL files >','Y',5) THEN
    BEGIN
      WITH Dt DO
      BEGIN
        GetTime(Hour,Min,Sec,Sec100);
        GetDate(Year,Month,Day,dofw);
      END;
      packtime(Dt,l);
      FOR i:=1 TO NumFiles DO
      BEGIN
        Files^[i].Time:=l;
        Assign(f,Files^[i].Name); FileMode:=ShareRead+ShareDenyW;
        Reset(f);
        SetFTime(f,l);
        Close(f);
      END;
      ShowFilesInArea(FirstShown);
    END;
  END;

  PROCEDURE FilesbbsType.ReAllignDownloadCounters(Silent: Boolean);
  VAR
    s          : String;
    HadOne     : Boolean;
    i,j,test,x : Integer;
  BEGIN
      IF (Cfg.AreaMan.DLCntStart>' ') AND (Cfg.AreaMan.DLCntStop>' ') THEN
      BEGIN
        IF Silent OR Confirm('Re-align download counters in this area','Y',8) THEN
        BEGIN
          FOR x:=1 TO FilesBBSNum DO
          BEGIN
            s:=FilesBBS[x]^.Tekst^;
            HadOne:=(GetDlC(s)>0) OR Cfg.AreaMan.InsDLCnt;
            AddDlC(s);
            IF NOT HadOne THEN DelDlC(s);
            NewStr(FilesBBS[x]^.Tekst,s);
          END;
          IF NOT Silent THEN ShowFilesInArea(FirstShown);
        END;
      END ELSE
        IF NOT Silent THEN AskError(8,'Download Counters NOT defined',3);
  END;

  PROCEDURE FilesbbsType.DeleteDownloadCounters;
  VAR
    s          : String;
    i,j,test,x : Integer;
  BEGIN
    BEGIN
      IF (Cfg.AreaMan.DLCntStart>' ') AND (Cfg.AreaMan.DLCntStop>' ') THEN
      BEGIN
        IF Confirm('Delete ALL download counters in this area','N',8) THEN
        BEGIN
          FOR x:=1 TO FilesBBSNum DO
          BEGIN
            s:=FilesBBS[x]^.Tekst^;
            DelDlC(s);
            NewStr(FilesBBS[x]^.Tekst,s);
          END;
          ShowFilesInArea(FirstShown);
        END;
      END ELSE
        AskError(8,'Download Counters NOT defined',3);
    END;
  END;

  PROCEDURE FilesbbsType.ResetDownloadCounters;
  VAR
    s          : String;
    i,j,test,x : Integer;
  BEGIN
    BEGIN
      IF (Cfg.AreaMan.DLCntStart>#32) AND (Cfg.AreaMan.DLCntStop>#32) THEN
      BEGIN
        IF Confirm('Reset ALL download counters in this area','N',8) THEN
        BEGIN
          FOR x:=1 TO FilesBBSNum DO
          BEGIN
            s:=FilesBBS[x]^.Tekst^;
            ZeroDlC(s);
            NewStr(FilesBBS[x]^.Tekst,s);
          END;
          ShowFilesInArea(FirstShown);
        END;
      END ELSE
        AskError(8,'Download Counters NOT defined',3);
    END;
  END;

  PROCEDURE FilesbbsType.InsertDownLoadCounters(Silent: Boolean);
  VAR
    s : String;
    x : Integer;
  BEGIN
    BEGIN
      IF (Cfg.AreaMan.DLCntStart>#32) AND (Cfg.AreaMan.DLCntStop>#32) THEN
      BEGIN
        IF Silent OR Confirm('Insert missing download counters in this area','Y',8) THEN
        BEGIN
          FOR x:=1 TO FilesBBSNum DO
          BEGIN
            s:=FilesBBS[x]^.Tekst^;
            AddDlC(s);
            NewStr(FilesBBS[x]^.Tekst,s);
          END;
          IF NOT Silent THEN ShowFilesInArea(FirstShown);
        END;
      END ELSE
        IF NOT Silent THEN AskError(8,'Download Counters NOT defined',3);
    END;
  END;

  PROCEDURE FilesbbsType.GlobalCommands;
  VAR
    m       : TPoPMenu;
    key,
    LastCmd : Word;
  BEGIN
    IF NOT WritableFile(Area^[CurrentArea]^.Path^) AND
       NOT WritableFile(Area^[CurrentArea]^.FPath^) THEN
      EXIT;
    GetMenu(MnuAMGlobalFunc,3,m);
    IF NOT WritableFile(Area^[CurrentArea]^.FPath^) THEN
    BEGIN
      FOR LastCmd:=1 TO 6 DO
        IF NOT (LastCmd<>2) THEN m.ProtectItem(LastCmd);
    END;
    IF NOT WritableFile(Area^[CurrentArea]^.Path^) THEN m.ProtectItem(2);
    m.ProcessMenu(Key, LastCmd);
    IF LastCmd<>ccQuit THEN
    BEGIN
      CASE key OF
        1 : BEGIN
              AdoptOrphans(FALSE,True,FilesBBS,Files^,NumFiles,FilesBBSNum,'');
              IF Cfg.AreaMan.InsDLCnt THEN InsertDownLoadCounters(True);
                ShowFilesInArea(0);
            END;
        2 : TouchAllFiles;
        3 : DeleteDownloadCounters;
        4 : ResetDownloadCounters;
        5 : InsertDownLoadCounters(FALSE);
        6 : ReAllignDownloadCounters(FALSE);
      END;
    END;
  END;

  PROCEDURE FilesbbsType.SortFilesBBS;
  VAR
    num,bufsiz,
    First, Last,
    i, j        : Word;
    f           : TBufTextFile;
    s,LastUsed,Smallest : S13;
  BEGIN
    BEGIN
      IF MarkCount=2 THEN
      BEGIN
        i:=1;
        WHILE NOT FilesBBS[i]^.Mark DO
          Inc(i);
        IF NOT HasFileName(FilesBBS[i]^.Tekst^) THEN
        BEGIN
          AskError(8,'First line MUST contain a file name',3);
          EXIT;
        END;
        IF MaxAvail>32768 THEN bufsiz:=32768 ELSE bufsiz:=MaxAvail;
        f.Init(JustPathName(Area^[CurrentArea]^.FPath^)+'\PORTAL.$$$', SCreate, BufSiz);
        i:=1;
        WHILE NOT FilesBBS[i]^.Mark DO
        BEGIN
          f.WriteLn(FilesBBS[i]^.Tekst^);
          Inc(i);
        END;
        LastUsed:='';
        First:=i;
        Last:=i+1;
        WHILE NOT FilesBBS[Last]^.Mark DO
          Inc(Last);
        FOR i:=First TO Last DO
        BEGIN
          Smallest:=charstr(#255,13);
          FOR j:=First TO Last DO
          BEGIN
            IF HasFileName(FilesBBS[j]^.Tekst^) THEN
            BEGIN
              s:=Copy(FilesBBS[j]^.Tekst^,1,13);
              IF (s>LastUsed) AND (s<Smallest) THEN
              BEGIN
                Smallest:=s;
                num:=j;
              END;
            END;
          END;
          IF Smallest<charstr(#255,13) THEN
          BEGIN
            LastUsed:=Smallest;
            j:=num;
            REPEAT
              f.WriteLn(FilesBBS[j]^.Tekst^);
              Inc(j);
            UNTIL (j>Last) OR HasFileName(FilesBBS[j]^.Tekst^);
          END;
        END;

        FOR i:=Last+1 TO FilesBBSNum DO
          f.WriteLn(FilesBBS[i]^.Tekst^);
        f.Done;
        IF DeleteFile(Area^[CurrentArea]^.FPath^) THEN
          IF RenameFile(JustPathName(Area^[CurrentArea]^.FPath^)+'\PORTAL.$$$',Area^[CurrentArea]^.FPath^) THEN
            MemOk:=ReadFilesInArea(Area^[CurrentArea]^.FPath^,4,
                                   Files^,FilesBBS,FilesBBSNum,NumFiles,0);
      END;
      Information('');
      IF MemOk THEN ShowFilesInArea(FirstShown);
    END;
  END;

  PROCEDURE FilesbbsType.SendFilesToNode;
  VAR
    ch:Char;
    m:Byte;
    Escaped:Boolean;
    i : Integer;
    SendAddress: TFidoAddress;
    s : STRING;
  BEGIN
    BEGIN
      FillChar(SendAddress, SizeOf(SendAddress), 0);
      IF MarkCount=0 THEN FilesBBS[FirstShown+Line]^.Mark:=True;
      NodeListPathStr:=#255;
      InitialiseNodeList(Cfg.NodeList,Cfg.NodeListTyp);
      IF GetConfirmAddress(3,4,SendAddress,1503) THEN
      BEGIN
        m:=SelectMailType(Escaped,1550);
        IF NOT Escaped THEN
        BEGIN
          ExtFlags[1]:='H';
          ExtFlags[3]:='F';
          ch:=ExtFlags[m];
          FOR i:=1 TO FilesBBSNum DO
            WITH FilesBBS[i]^ DO
              IF Mark AND HasFileName(Tekst^) THEN
              BEGIN
                s:=Tekst^+' ';
                SendAFile(Area^[CurrentArea]^.Path^+COPY(s,1,POS(' ',s)-1),SendAddress,ch,STNothing);
              END;
        END;
      END;
      FreeUpMemory;
      IF MarkCount=1 THEN FilesBBS[FirstShown+Line]^.Mark:=FALSE;
    END;
  END;

  PROCEDURE FilesbbsType.HatchFiles;
  VAR
    i : Integer;
    s : STRING;
  BEGIN
    BEGIN
      IF MarkCount=0 THEN FilesBBS[FirstShown+Line]^.Mark:=True;
      FOR i:=1 TO FilesBBSNum DO
        WITH FilesBBS[i]^ DO
          IF Mark AND HasFileName(Tekst^) THEN
          BEGIN
            s:=Tekst^+' ';
            Hatch(Area^[CurrentArea]^.Path^+COPY(s,1,POS(' ',s)-1),COPY(s,14,128));
          END;
      IF MarkCount=1 THEN FilesBBS[FirstShown+Line]^.Mark:=FALSE;
    END;
  END;

  PROCEDURE FilesbbsType.AreaManagerMain;
  VAR
    s        : String;
    i,GemNum : Integer;
    TmpFB    : FilesBBSRec;
    Ch       : Char;
    AreaNum,
    InKey    : Word;
    ReDraw   : Boolean;
    sr       : SearchRec;
  BEGIN
    BEGIN
      REPEAT
        IF (ChooseFileArea(InKey)) AND (CurrentArea<>0) THEN
        BEGIN
          BEGIN
            IF NOT Str2Word(Area^[CurrentArea]^.Tag^, AreaNum) THEN AreaNum:=0;
            FileMgrWin^.wFrame.ChangeHeaderString(0,' Area : '+Area^[CurrentArea]^.Title^+' ',ReDraw);
            IF ReDraw THEN FileMgrWin^.wFrame.UpDateFrame ELSE FileMgrWin^.wFrame.DrawHeader(0);
            MemOk:=ReadFilesInArea(Area^[CurrentArea]^.FPath^,7,
                                   Files^,FilesBBS,FilesBBSNum,NumFiles,AreaNum);
            IF MemOk THEN
            BEGIN
              IF Cfg.AreaMan.AdoptDefault THEN AdoptOrphans(True,True,FilesBBS,
                   Files^,NumFiles,FilesBBSNum,'');
              IF Cfg.AreaMan.InsDLCnt THEN InsertDownloadCounters(True);
              ShowFilesInArea(StartLine);
              Line:=1;
              REPEAT
                Topic:=51;
              SetKbdStatProc(AreaManagerKbdStatProc);
              IF MaxL>0 THEN ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,True);
              InKey:=PopReadKeyWord;
              IF MaxL>0 THEN ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
              SetKbdStatProc(NoKbdStatProc);
              Ch:=Char(Lo(InKey));
              CASE ch OF
                'a'..'z' : ch:=UpCase(ch);
                ''      : ch:='';
                ''      : ch:='';
                ''      : ch:='';
              END;
              CASE Ch OF
       '0'..'9',
       'A'..'Z',
       '','','' : IF MaxL>0 THEN
                     BEGIN
                       gemnum:=FirstShown+Line;
                       i:=GemNum;
                       REPEAT
                         Inc(i);
                         IF i>FilesBBSNum THEN i:=1;
                       UNTIL (GemNum=i) OR (ch=COPY(FilesBBS[i]^.Tekst^,1,1));
                       IF i<>GemNum THEN
                       BEGIN
                         IF i>8 THEN Line:=9 ELSE Line:=i;
                         FirstShown:=i-Line;
                         ShowFilesInArea(FirstShown);
                       END;
                     END;
                #0 : BEGIN
                       s:=FilesBBS[FirstShown+Line]^.Tekst^+' ';
                       s:=Copy(s,1,pos(' ',s)-1);
                       CASE InKey OF
                         Del,
                         F2 : IF WritableFile(Area^[CurrentArea]^.FPath^) AND
                                 NOT movemode AND (MaxL>0) THEN DeleteLine(True);
                         F3 : IF WritableFile(Area^[CurrentArea]^.FPath^) AND
                                 NOT movemode AND (MaxL>0) THEN EditFileDescription;
                         F4 : IF NOT movemode AND (MaxL>0) THEN MoveLine;
                         F5 : IF WritableFile(Area^[CurrentArea]^.Path^+s) AND
                                 NOT movemode AND (MaxL>0) THEN RenameLine;
                         F6 : IF WritableFile(Area^[CurrentArea]^.Path^+s) AND
                                 NOT movemode AND (MaxL>0) THEN TouchFile;
                         Ins,
                         F7 : IF WritableFile(Area^[CurrentArea]^.FPath^) AND
                                 NOT movemode THEN InsertLine;
                         F8 : IF WritableFile(Area^[CurrentArea]^.FPath^) THEN SortFilesBBS;
                         F9 : IF NOT movemode THEN
                              BEGIN
                                IF HasFileName(s) THEN
                                BEGIN
                                  ViewArchive(AddBackSlash(Area^[CurrentArea]^.Path^)+s,ArcType(s));
                                  Information('');
                                  FindFirst(s,Archive,sr);
                                  i:=GetFileInfo(s,Files^,NumFiles);
                                  IF i>0 THEN
                                  BEGIN
                                    Move(sr.Time,Files^[i],21);
                                    ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
                                  END;
                                  FindClose(sr);
                                END;
                              END;
                        F10 : IF NOT movemode THEN GlobalCommands;
                       ShF1 : SendFilesToNode;
                       ShF2 : HatchFiles;
                       ShF3 : IF (MaxL>0) AND (NOT HasFileName(FilesBBS[FirstShown+Line]^.Tekst^)) AND
                                 (WritableFile(Area^[CurrentArea]^.FPath^)) THEN
                              BEGIN
                                s:=Trim(FilesBBS[FirstShown+Line]^.Tekst^);
                                s:=CharStr(' ',40-(LENGTH(s) DIV 2))+s;
                                NewStr(FilesBBS[FirstShown+Line]^.Tekst,s);
                                ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
                              END;
                       ShF4 : IF (FirstShown+Line+1<FilesBBSNum) AND
                                 (NOT HasFileName(FilesBBS[FirstShown+Line+1]^.Tekst^)) AND
                                 (WritableFile(Area^[CurrentArea]^.FPath^)) THEN
                              BEGIN
                                s:=Trim(FilesBBS[FirstShown+Line+1]^.Tekst^);
                                IF LENGTH(s)<126-LENGTH(FilesBBS[FirstShown+Line]^.Tekst^) THEN
                                BEGIN
                                  DisposeString(FilesBBS[FirstShown+Line+1]^.Tekst);
                                  NewStr(FilesBBS[FirstShown+Line]^.Tekst,FilesBBS[FirstShown+Line]^.Tekst^+' '+s);
                                  FOR i:=FirstShown+Line+1 TO FilesBBSNum-1 DO
                                    FilesBBS[i]^:=FilesBBS[i+1]^;
                                  DEC(FilesBBSNum);
                                  ShowFilesInArea(FirstShown);
                                END;
                              END;
                        ShF9: IF NOT movemode AND (MaxL>0) THEN ViewGIF;
                        Home: IF MaxL>0 THEN
                              BEGIN
                                IF movemode THEN
                                BEGIN
                                  TmpFB:=FilesBBS[FirstShown+Line]^;
                                  FOR i:=FirstShown+Line DOWNTO 2 DO
                                    FilesBBS[i]^:=FilesBBS[i-1]^;
                                  FilesBBS[1]^:=TmpFB;
                                END;
                                ShowFilesInArea(0);
                                Line:=1;
                              END;
                         Up : IF (MaxL>0) AND (FirstShown+Line>1) THEN
                              BEGIN
                                IF movemode THEN
                                BEGIN
                                  TmpFB:=FilesBBS[FirstShown+Line-1]^;
                                  FilesBBS[FirstShown+Line-1]^:=FilesBBS[FirstShown+Line]^;
                                  FilesBBS[FirstShown+Line]^:=TmpFB;
                                  IF Line>1 THEN ShowFilesBBSLine(FilesBBS[FirstShown+Line-1]^,Line-1,FALSE);
                                  ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
                                END;
                                IF Line>1 THEN Dec(Line) ELSE
                                  IF FirstShown>0 THEN
                                  BEGIN
                                    ScrollFilesDown;
                                    IF (MaxL<ScreenHeight-6) AND (FirstShown+Line<FilesBBSNum) THEN Inc(MaxL);
                                  END;
                              END;
                        PgUp: BEGIN
                                IF (MaxL>0) THEN
                                BEGIN
                                  IF movemode AND (FirstShown+Line>1) THEN
                                  BEGIN
                                    IF FirstShown+Line>ScreenHeight-7 THEN GemNum:=FirstShown+Line-(ScreenHeight-7)
                                    ELSE GemNum:=1;
                                    TmpFB:=FilesBBS[FirstShown+Line]^;
                                    FOR i:=FirstShown+Line-1 DOWNTO GemNum DO
                                      FilesBBS[i+1]^:=FilesBBS[i]^;
                                    FilesBBS[GemNum]^:=TmpFB;
                                  END;
                                  GemNum:=FirstShown;
                                  FOR i:=1 TO ScreenHeight-7 DO
                                    IF Line>1 THEN Dec(Line) ELSE
                                      IF FirstShown>0 THEN Dec(FirstShown);
                                  IF (GemNum<>FirstShown) OR movemode THEN ShowFilesInArea(FirstShown);
                                END;
                              END;
                        EndKey: IF NOT movemode THEN
                              BEGIN
                                i:=INTEGER(FilesBBSNum)-(ScreenHeight-6);
                                IF i<0 THEN i:=0;
                                ShowFilesInArea(i);
                                Line:=MaxL;
                              END
                              ELSE
                              BEGIN
                                TmpFB:=FilesBBS[FirstShown+Line]^;
                                FOR i:=FirstShown+Line TO FilesBBSNum-1 DO
                                  FilesBBS[i]^:=FilesBBS[i+1]^;
                                FilesBBS[FilesBBSNum]^:=TmpFB;
                                i:=FilesBBSNum-(ScreenHeight-6);
                                IF i<0 THEN i:=0;
                                ShowFilesInArea(i);
                                Line:=MaxL;
                              END;
                        Down: IF (MaxL>0) THEN
                              BEGIN
                                IF movemode AND (FirstShown+Line<FilesBBSNum) THEN
                                BEGIN
                                  TmpFB:=FilesBBS[FirstShown+Line+1]^;
                                  FilesBBS[FirstShown+Line+1]^:=FilesBBS[FirstShown+Line]^;
                                  FilesBBS[FirstShown+Line]^:=TmpFB;
                                  ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
                                  IF Line<MaxL THEN ShowFilesBBSLine(FilesBBS[FirstShown+Line+1]^,Line+1,FALSE);
                                END;
                                IF Line<MaxL THEN Inc(Line) ELSE
                                  IF FirstShown+Line<FilesBBSNum THEN ScrollFilesUp;
                              END;
                         PgDn: IF (MaxL>0) THEN
                              BEGIN
                                IF movemode AND (FirstShown+Line<FilesBBSNum) THEN
                                BEGIN
                                  IF FirstShown+Line+(ScreenHeight-7)<=FilesBBSNum THEN GemNum:=FirstShown+Line+ScreenHeight-7
                                                                                   ELSE GemNum:=FilesBBSNum;
                                  TmpFB:=FilesBBS[FirstShown+Line]^;
                                  FOR i:=FirstShown+Line TO GemNum DO
                                    FilesBBS[i]^:=FilesBBS[i+1]^;
                                  FilesBBS[GemNum]^:=TmpFB;
                                END;
                                GemNum:=FirstShown;
                                FOR i:=1 TO ScreenHeight-7 DO
                                  IF Line<MaxL THEN Inc(Line) ELSE
                                    IF FirstShown+Line<FilesBBSNum THEN Inc(FirstShown);
                                IF (GemNum<>FirstShown) OR movemode THEN ShowFilesInArea(FirstShown);
                                Line:=MaxL;
                              END;
                       END;
                     END;
               #13 : IF MaxL>0 THEN
                     BEGIN
                       IF movemode THEN
                       BEGIN
                         movemode:=False;
                         ShowFilesInArea(FirstShown);
                         Information('');
                       END ELSE
                       BEGIN
                         FilesBBS[FirstShown+Line]^.Mark:=NOT FilesBBS[FirstShown+Line]^.Mark;
                         ShowFilesBBSLine(FilesBBS[FirstShown+Line]^,Line,FALSE);
                         MarkedHeader;
                         IF FirstShown+Line<FilesBBSNum THEN
                           IF Line<MaxL THEN Inc(Line) ELSE ScrollFilesUp;
                       END;
                     END;
               #32 : BEGIN
                       FOR i:=1 TO FilesBBSNum DO
                         FilesBBS[i]^.Mark:=FALSE;
                       ShowFilesInArea(FirstShown);
                     END;
                END;
              UNTIL (InKey=Esc) AND NOT movemode;
              InKey:=0;
              WriteCurrentFilesBBS(Area^[CurrentArea]^.FPath^,FilesBBSNum,FilesBBS,True);
            END ELSE
            BEGIN
              DeAllocateFiles(FilesBBS,FilesBBSNum);
              AskError(8,'Insufficient memory to enter this area',3);
            END;
        END;
      END;
      UNTIL InKey=Esc;
    END;
  END;

END.
