unit ddovr;
{$O+,F+,V-}

interface

uses crt;

{procedure showhelp;}

procedure GetBBSInfo(
 User_Account: byte;
 var graphics: byte;
 var bbs_time_left: integer;
 var user_first_name,user_last_name: string;
 var com_port: byte;
 var baud_rate : Longint;
 var lockbaud: LongInt;
 var local: boolean;
 var fossilio,extd_foss_ok: boolean;
 var node_num:byte;
 var lordpath:string);

procedure MakeInfoStrings(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate,baud_modem: longint;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var dropfilepath: string;
 var lockbaud: longint);

const
 numddovrstr=11;
type
 ddovrstrptr=^string;
 ddovrstrarray=array[1..numddovrstr] of ddovrstrptr;
var
 ddovrinfo: ddovrstrarray;

implementation

procedure GetBBSInfo(
 User_Account: byte;
 var graphics: byte;
 var bbs_time_left: integer;
 var user_first_name,user_last_name: string;
 var com_port: byte;
 var baud_rate : Longint;
 var lockbaud: LongInt;
 var local: boolean;
 var fossilio,extd_foss_ok: boolean;
 var node_num:byte;
 var lordpath:string);


type

   char2  = array[1..2] of char;
   char4  = array[1..4] of char;
   char5  = array[1..5] of char;
   char8  = array [1..8] of char;
   char9  = array [1..9] of char;
   char12 = array[1..12] of char;
   char13 = array [1..13] of char;
   char15 = array[1..15] of char;
   char25 = array[1..25] of char;
   single = array [0..3] of byte;
   bitmap = record
     bits : array [0..4] of byte;
   end;

   basic_real_type = array[1..4] of char;
{--------------------------------------------------------------------------}

Function IntToStr(Num: longint): String;
var st: string;
begin
     str(num,st);
     IntTostr:=st;
end;

{--------------------------------------------------------------------------}

Function StrToInt(St: String): longint;
{ String to integer value }
Var num: longint; code: integer;
Begin
  Val(St,num,code);
  StrToInt := num;
End;

{--------------------------------------------------------------------------}

function wva(a: word): string;
var
 s: string;
begin;
 str(a,s);
 wva:=s;
end;

function stu(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 stu:=s;
end;

procedure DDError(s: string);
begin;
 writeln('ERROR: '+s);
 delay(2000);
 halt(2);
end;

function basic_real(breal: basic_real_type): real;
type
 atmp=array[1..6] of char;
var
 dummy: real;
 x: atmp absolute dummy;
begin;
 x[1]:=breal[4];
 x[2]:=#0;
 x[3]:=#0;
 x[4]:=breal[1];
 x[5]:=breal[2];
 x[6]:=breal[3];
 basic_real:=int(dummy);
end;

{--------------------------------------------------------------------------}
Procedure Read_Info;

var
 s: string;
 f: text;
 fn: string;
 a,b,c: integer;
 ofm: word;

begin;

 fn:=(lordpath+'\info.'+inttostr(node_num));
 ofm:=filemode;
 filemode:=66;
 assign(f,fn);
 {$i-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Missing info.'+inttostr(node_num));
 if ioresult=0 then
   begin
     assign(f,fn);
     {$i-}
     reset(f);
     {$I+}
   end;
 if ioresult=0 then begin;
  readln(f,s);
   User_account:=strtoint(s);
  readln(f,s);
  graphics:=strtoint(s);
  readln(f,s);readln(f,s);
  readln(f,s);
  bbs_time_left:=strtoint(s);
  readln(f,s);{HANDLE}
  readln(f,user_first_name);
  readln(f,user_last_name);
  readln(f,s);
  com_port:=strtoint(s);
   if com_port=0 then local:=true;
  readln(f,s);
  baud_rate:=strtoint(s);
   if baud_rate=0 then local:=true;
  readln(f,s);
  lockbaud:=strtoint(s);
  readln(f,s);
     if s='FOSSIL' then fossilio:=true else
     if s='XFOSSIL' then
       begin
         fossilio:=true;
         Extd_Foss_OK:=true;
       end;
  close(f);
 filemode:=ofm;

end;
end;
{--------------------------------------------------------------------------}

begin;
 baud_rate:=0;
 Read_info;
 user_first_name:=stu(user_first_name);
 user_last_name:=stu(user_last_name);
 if node_num=0 then node_num:=1;
end;

function wva(w: word): string;
var
 s: string;
begin;
 str(w,s);
 wva:=s;
end;

procedure stuffstr(n: word; s: string);
begin;
 getmem(ddovrinfo[n],length(s)+1);
 move(s,ddovrinfo[n]^,length(s)+1);
end;

procedure MakeInfoStrings(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate,baud_modem: longint;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var dropfilepath: string;
 var lockbaud: longint);

const
 software_names: array[0..14] of string[15]=
  ('Maint',     'Local',      'Sysop',      'QBBS',       'PCBoard 12',
   'WWIV',      'PCBoard 15',        'RBBS 16+',   'Phoenix',    'Wildcat',
   'PCBoard 14','DOORSYS',    'Spitfire',   '2am-bbs',   'TriBBS');
 drop_files: array[0..14] of string[15]=
  ('n/a',        'n/a',         'n/a',         'DORINFOx.DEF',
   'PCBOARD.SYS','CHAIN.TXT','PCBOARD.SYS', 'DORINFOx.DEF',
   'INFO.BBS',   'CALLINFO.BBS','PCBOARD.SYS', 'DOOR.SYS',
   'SFDOORS.DAT','JUMPER.DAT','TRIBBS.SYS');
 istrue: array[false..true] of string[8] = ('FALSE','TRUE');
var
 s: string;
 a: integer;
begin;
 stuffstr( 1,'Baud rate: '+wva(baud_rate));
 stuffstr( 2,'    Local: '+istrue[local]);
 stuffstr( 3,' Graphics: '+wva(graphics));
 stuffstr( 4,'Time left: '+wva(bbs_time_left));
 stuffstr( 5,' Com Port: '+wva(com_port));
 stuffstr( 6,'     User: '+user_first_name+' '+user_last_name);
 stuffstr( 7,'Access lv: '+wva(user_access_level));
 stuffstr( 8,' Node num: '+wva(node_num));
 if lockbaud=0 then s:='Not Locked' else s:=wva(lockbaud);
 stuffstr( 9,'Lock Baud: '+s);
 stuffstr( 10,' Software: '+software_names[bbstype]);
 s:=drop_files[bbstype];
 for a:=1 to length(s) do if s[a]='x' then s[a]:=chr(node_num+ord('0'));
 stuffstr(11,'Drop file: '+s);
 stuffstr(12,'Drop Path: '+dropfilepath);
end;

{
 /E - Use ESM for extra memory');
 /L - Local mode');
 /Bxxx - Specify locked baud rate (i.e. /B38400)');
 /C    - Specify comport number.
 /Nx   - Specify node number');
 /R    - Force RIP graphics');
 /Pyyy - Specify path to drop file (i.e. /Pc:\bbs');

    }

end.