{
  MUTILS.PAS
  Miscellaneous routines

    Written By:   Rick Parrish
    Last Updated: September 07, 2002

  CHANGE LOG

    09/07/02 - First official release

  NOTES

    None
}
unit mUtils;

interface

uses
  Dos, Windows, SysUtils;

function AppName: String;
function AppPath: String;
function GetParamStr(AFirst: Integer): String;
function MSecElapsed(AFirst, ASecond: LongInt): LongInt;
function MSecToday: LongInt;
function SecElapsed(AFirst, ASecond: LongInt): LongInt;
function SecToday: LongInt;
function TimeZoneBias: LongInt;
function UnixTimeToDateTime(ATime: Double): Double;

implementation

uses
  mStrings;

{
  Return the filename of the currently running application
}
function AppName: String;
begin
     AppName := ExtractFileName(ParamStr(0));
end;

{
  Return the path name with trailing backslash of the currently running app.
}
function AppPath: String;
begin
     AppPath := AddSlash(ExtractFilePath(ParamStr(0)));
end;

{
  Returns the command-line parameters starting with AFIRST as a space
  seperated string.
  So GetParamStr(2) in a program started like:
  C:\TEST.EXE THIS IS A TEST
  would return:
  'IS A TEST'
}
function GetParamStr(AFirst: Integer): String;
var
   I: Integer;
   S: String;
begin
     S := '';
     if (ParamCount > 0) and (AFirst <= ParamCount) then
     begin
          for I := AFirst to ParamCount do
              S := S + ' ' + ParamStr(I);
          Delete(S, 1, 1);
     end;
     GetParamStr := S;
end;

{
  Returns the number of milliseconds elapsed between AFIRST and ASECOND
  Handles midnight rollover
}
function MSecElapsed(AFirst, ASecond: LongInt): LongInt;
begin
     if (ASecond < AFirst) then
        Inc(ASecond, 86400000);
     MSecElapsed := ASecond - AFirst;
end;

{
  Returns the number of milliseconds which have elapsed since midnight
}
function MSecToday: LongInt;
var
   DT: TSystemTime;
   H, M, S, MS: LongInt;
begin
     GetLocalTime(DT);
     H := DT.wHour;
     M := DT.wMinute;
     S := DT.wSecond;
     MS := DT.wMilliSeconds;
     MSecToday := (((H * 3600) + (M * 60) + S) * 1000) + MS;
end;

{
  Same as MSecElapsed(), but returns value in seconds
}
function SecElapsed(AFirst, ASecond: LongInt): LongInt;
begin
     if (ASecond < AFirst) then
        Inc(ASecond, 86400);
     SecElapsed := ASecond - AFirst;
end;

{
  Same as SecToday(), but returns value in seconds
}
function SecToday: LongInt;
begin
     SecToday := MSecToday div 1000;
end;

{
  Returns the number of minutes between UTC and the current local time
}
function TimeZoneBias: LongInt;
var
   Res: LongInt;
   TZI: TTimeZoneInformation;
begin
     Res := GetTimeZoneInformation(TZI);
     if (Res = TIME_ZONE_ID_STANDARD) then
        TimeZoneBias := TZI.Bias + TZI.StandardBias
     else
     if (Res = TIME_ZONE_ID_DAYLIGHT) then
        TimeZoneBias := TZI.Bias + TZI.DaylightBias
     else
         TimeZoneBias := 0;
end;

{
  Convert a unix time stamp to a DateTime value
}
function UnixTimeToDateTime(ATime: Double): Double;
begin
{         Unix = Seconds since 01/01/1970 00:00:00 GMT
      DateTime = Days since 30/12/1899 00:00:00 in local timezone
       / 86400 = Turn "seconds since" into "days since"
      365 * 70 = Make up for 70 year difference
          + 17 = Number of leap years in those 70 years
           + 2 = Make 30/12 into 01/01
  - TZB / 1440 = Put into local timezone }
     UnixTimeToDateTime := (ATime / 86400) + (365 * 70 + 17 + 2) - (TimeZoneBias / 1440);
end;

end.
