{
  MCRT.PAS
  Screen handling routines

    Written By:   Rick Parrish
    Last Updated: September 07, 2002

  CHANGE LOG

    09/07/02 - First official release

  NOTES

    In the future I would like to "messy up" this file with some IFDEFs
    so a special WINDOWS.PAS would not be required for BP7/TP7
}
unit mCrt;

interface

uses
  Crt, Windows;

procedure FastWrite(ALine: String; AX, AY, AAttr: Byte);
function GetAttrAt(AX, AY: Byte): Byte;
function GetCharAt(AX, AY: Byte): Char;
function Input(ADefault, AChars: String; APass: Char; AShowLen, AMaxLen, AAttr: Byte): String;
procedure SetAttrAt(AAttr, AX, AY: Byte);
procedure SetCharAt(ACh: Char; AX, AY: Byte);

implementation

uses
  mAnsi, mStrings;

var
   OutHandle: THandle;

{
  Write ALINE at the screen coordinates AX, AY with text attribute AATTR
}
procedure FastWrite(ALine: String; AX, AY, AAttr: Byte);
var
   Buffer: Array[0..255] of TWin32Cell;
   BufferCoord: TCoord;
   BufferSize: TCoord;
   I: Integer;
   WriteRegion: TSmallRect;
begin
     for I := 0 to Length(ALine) - 1 do
     begin
          Buffer[I].Attr := AAttr;
          Buffer[I].Ch := Ord(ALine[I + 1]);
     end;
     BufferSize.X := Length(ALine);
     BufferSize.Y := 1;
     BufferCoord.X := 0;
     BufferCoord.Y := 0;
     WriteRegion.Left := AX - 1;
     WriteRegion.Top := AY - 1;
     WriteRegion.Right := AX + Length(ALine) - 2;
     WriteRegion.Bottom := AY - 1;
     WriteConsoleOutput(OutHandle, @Buffer, BufferSize, BufferCoord, WriteRegion);
end;

{
  Returns the text attribute at screen position AX, AY
}
function GetAttrAt(AX, AY: Byte): Byte;
var
   Attr: SmallWord;
   Coord: TCoord;
   NumRead: LongInt;
begin
     Coord.X := AX - 1;
     Coord.Y := AY - 1;
     ReadConsoleOutputAttribute(OutHandle, @Attr, 1, Coord, NumRead);
     GetAttrAt := Attr;
end;

{
  Returns the character at screen position AX, AY
}
function GetCharAt(AX, AY: Byte): Char;
var
   Ch: Char;
   Coord: TCoord;
   NumRead: LongInt;
begin
     Coord.X := AX - 1;
     Coord.Y := AY - 1;
     ReadConsoleOutputCharacter(OutHandle, @Ch, 1, Coord, NumRead);
     if (NumRead = 0) then
        GetCharAt := #32
     else
         GetCharAt := Ch;
end;

{
  A fancy input routine

  ADefault - The text initially displayed in the edit box
  AChars   - The characters ALLOWED to be part of the string
             Look in MSTRINGS.PAS for some defaults
  APass    - The password character shown instead of the actual text
             Use #0 if you dont want to hide the text
  AShowLen - The number of characters big the edit box should be on screen
  AMaxLen  - The number of characters the edit box should allow
             AMaxLen can be larger than AShowLen, it will just scroll
             if that happens.
  AAttr    - The text attribute of the editbox's text and background
             Use formula Attr = Foreground + (Background * 16)

  If the user pressed ESCAPE then ADefault is returned.  If they hit enter
  the current string is returned.  They cannot hit enter on a blank line.
}
function Input(ADefault, AChars: String; APass: Char; AShowLen, AMaxLen, AAttr: Byte): String;
var
   Ch: Char;
   Attr: Byte;
   S: String;
   XPos: Byte;

  procedure UpdateText;
  begin
       GotoXY(XPos, WhereY);
       if (Length(S) > AShowLen) then
       begin
            if (APass = #0) then
               Write(Copy(S, Length(S) - AShowLen + 1, AShowLen))
            else
                Write(PadRight('', APass, AShowLen));
            GotoXY(XPos + AShowLen, WhereY);
       end else
       begin
            if (APass = #0) then
               Write(S)
            else
                Write(PadRight('', APass, Length(S)));
            Write(PadRight('', ' ', AShowLen - Length(S)));
            GotoXY(XPos + Length(S), WhereY);
       end;
  end;

begin
     if (Length(ADefault) > AMaxLen) then
        ADefault := Copy(ADefault, 1, AMaxLen);
     S := ADefault;

     Attr := TextAttr;
     TextAttr := AAttr;
     XPos := WhereX;

     UpdateText;

     repeat
           Ch := ReadKey;
           if (Ch = #8) and (Length(S) > 0) then
           begin
                Delete(S, Length(S), 1);
                Write(#8 + ' ' + #8);
                if (Length(S) >= AShowLen) then
                   UpdateText;
           end else
           if (Ch = #25) and (S <> '') then {CTRL-Y}
           begin
                S := '';
                UpdateText;
           end else
           if (Pos(Ch, AChars) > 0) and (Length(S) < AMaxLen) then
           begin
                S := S + Ch;
                if (Length(S) > AShowLen) then
                   UpdateText
                else
                if (APass = #0) then
                   Write(Ch)
                else
                    Write(APass);
           end;
     until (Ch = #27) or ((Ch = #13) and (S <> ''));

     TextAttr := Attr;
     WriteLn;

     if (Ch = #27) then
        S := ADefault;
     Input := S;
end;

{
  Set the text attribute at screen coordinate AX, AY to AATTR
}
procedure SetAttrAt(AAttr, AX, AY: Byte);
var
   WriteCoord: TCoord;
   NumWritten: LongInt;
begin
     WriteCoord.X := AX - 1;
     WriteCoord.Y := AY - 1;
     WriteConsoleOutputAttribute(OutHandle, @AAttr, 1, WriteCoord, NumWritten);
end;

{
  Set the character at screen coordinate AX, AY to ACH
}
procedure SetCharAt(ACh: Char; AX, AY: Byte);
var
   WriteCoord: TCoord;
   NumWritten: LongInt;
begin
     WriteCoord.X := AX - 1;
     WriteCoord.Y := AY - 1;
     WriteConsoleOutputCharacter(OutHandle, @ACh, 1, WriteCoord, NumWritten);
end;

{
  Initialization stuff
}
begin
     OutHandle := GetStdHandle(STD_OUTPUT_HANDLE);
end.
