unit win32crt;
{ Based on the CRT unit from Free Pascal RTL }
{ Modified by alp@pro.hu }

interface

uses windows,sysutils;

const
  Black=0;Blue=1;Green=2;Cyan=3;Red=4;Magenta=5;
  Brown=6;LightGray=7;DarkGray=8;LightBlue=9;LightGreen=10;
  LightCyan=11;LightRed=12;LightMagenta=13;Yellow=14;White=15;
  Blink=128;
  BW40=0;CO40=1;BW80=2;CO80=3;Mono=7;Font8x8=256;
  C40=CO40;C80=CO80;
  MOUSEB_LEFT=1;
  MOUSEB_RIGHT=2;
  MOUSEB_MID=4;

type
  TMemScr=array [1..25,1..80,1..2] of byte; // [y,x,a] a= 1->char 2->attr
  TScr=record
    x1,y1,x2,y2:integer;
    dat:TMemScr;
    oldx,oldy:integer;
    oldattr:byte;
  end;

var
  CheckEOF:boolean=false;
  CheckBreak:boolean=false;
  TextAttr:byte;
  WindMin,WindMax:word;
  OutHandle,InHandle:THandle;
  ScreenWidth,ScreenHeight:longint;
  CrtInited:boolean;
  schar:boolean;
  keystate:longint;
  DefCursorSize:longint;
  usemouse:boolean=false;
  mousevisible:boolean=false;
  mxshift:byte=3;
  myshift:byte=3;
  mousex:integer=0;
  mousey:integer=0;
  mouseb:integer=0;
  mousedbl:boolean=false;
  mouseldbl:boolean=false;
  mouserdbl:boolean=false;
  mousebuttons:longword;
  extshowmouse:procedure=nil;
  exthidemouse:procedure=nil;

procedure MouseOn;
procedure MouseOff;

procedure AssignCrt(var f:text);
function KeyPressed:boolean;
function ReadKey:char;
function RdKey:char;
procedure TextMode(mode:integer);
procedure Window(x1,y1,x2,y2:byte);
procedure GotoXY(x,y:byte);
function WhereX:byte;
function WhereY:byte;
procedure ClrScr;
procedure ClrEol;
procedure InsLine;
procedure DelLine;
procedure TextColor(color:byte);
procedure TextBackground(color:byte);
procedure LowVideo;
procedure HighVideo;
procedure NormVideo;
procedure Delay(ms:word);
procedure Sound(hz:word);
procedure NoSound;
function GetCursorSize:longint;
procedure SetCursorSize(size:longint);
procedure CursorOn;
procedure CursorOff;
procedure CursorBig;
procedure CursorNorm;
procedure InitCrt;
procedure DoneCrt;

procedure ReadScr(x1,y1,x2,y2:integer;var dest:TScr);
procedure WriteScr(var src:TScr;rcoordattr:boolean);
procedure ScrollScr(x1,y1,x2,y2,l:integer;attr:byte);
procedure ScrollScrH(x1,y1,x2,y2,c:integer;attr:byte);
function GetTitle:string;
procedure SetTitle(s:string);
procedure FillAreaCh(x1,y1,x2,y2:integer;ch,color:byte);
procedure FillArea(x1,y1,x2,y2:integer;color:byte);
procedure WriteStr(x,y:integer;s:string);
procedure WriteStrScr(var dest:TScr;x,y:integer;s:string);
function CharAtPos(x,y:integer):char;
function AttrAtPos(x,y:integer):byte;
procedure DrawBackgroundCh(ch,color:byte);
procedure DrawBackground(color:byte);
procedure DrawFrame(x1,y1,x2,y2:integer;frametype,frameattr:byte);
procedure DrawShadow(x1,y1,x2,y2:integer);
procedure DrawWindow(x1,y1,x2,y2:integer;wndcolor,frametype,frameattr,
  titattr:byte;title:string;has_shadow:boolean);

implementation

type
  TMouseHandler=procedure(ir:TInputRecord);

var
  IsWindowsNT:boolean;
  mousehandler:TMouseHandler=nil;

procedure dcrtmaus_mh(ir:tinputrecord);
begin
  case ir.event.mouseevent.dweventflags of
    0:begin
      mousedbl:=false;mouseldbl:=false;mouserdbl:=false;
      mouseb:=ir.event.mouseevent.dwbuttonstate;
    end;
    mouse_moved:begin
      mousedbl:=false;mouseldbl:=false;mouserdbl:=false;
      mousex:=ir.event.mouseevent.dwmouseposition.x;
      mousey:=ir.event.mouseevent.dwmouseposition.y;
    end;
    double_click:begin
      mousedbl:=true;
      mouseldbl:=true;
    end;
  end;
end;

procedure MouseOn;
var
  mode:dword;
begin
  if getconsolemode(inhandle,mode) then begin
    mode:=mode or enable_mouse_input;
    setconsolemode(inhandle,mode);
    usemouse:=true;
    mousevisible:=true;
  end;
end;

procedure MouseOff;
var
  mode:dword;
begin
  if getconsolemode(inhandle,mode) then begin
    mode:=mode and not enable_mouse_input;
    setconsolemode(inhandle,mode);
    usemouse:=false;
    mousevisible:=false;
  end;
end;

procedure TurnMouseOff(turnon:boolean);
var
  mode:dword;
begin
  if getconsolemode(inhandle,mode) then begin
    mode:=mode and not enable_processed_input;
    if turnon then mode:=mode or enable_mouse_input else
      mode:=mode and not enable_mouse_input;
    setconsolemode(inhandle,mode);
  end;
end;

function GetScreenHeight:longint;
var
  consoleinfo:TConsoleScreenBufferInfo;
begin
  getconsolescreenbufferinfo(outhandle,consoleinfo);
  result:=consoleinfo.dwsize.y;
end;

function GetScreenWidth:longint;
var
  consoleinfo:TConsoleScreenBufferInfo;
begin
  getconsolescreenbufferinfo(outhandle,consoleinfo);
  result:=consoleinfo.dwsize.x;
end;

var
  CursorSaveX,CursorSaveY:longint;

procedure SetScreenCursor(x,y:longint);
var
  curinfo:TCoord;
begin
  fillchar(curinfo,sizeof(curinfo),0);
  curinfo.x:=x-1;
  curinfo.y:=y-1;
  setconsolecursorposition(outhandle,curinfo);
  cursorsavex:=x-1;
  cursorsavey:=y-1;
end;

procedure GetScreenCursor(var x,y:longint);
begin
  x:=cursorsavex+1;
  y:=cursorsavey+1;
end;

function WinMinX:byte;
begin
  result:=(windmin and $ff)+1;
end;

function WinMinY:byte;
begin
  result:=(windmin shr 8)+1;
end;

function WinMaxX:byte;
begin
  result:=(windmax and $ff)+1;
end;

function WinMaxY:byte;
begin
  result:=(windmax shr 8)+1;
end;

function FullWin:boolean;
begin
  result:=(winminx=1) and (winminy=1) and
    (winmaxx=screenwidth) and (winmaxy=screenheight);
end;

procedure TextMode(mode:integer);
begin
end;

procedure TextColor(color:byte);
begin
  textattr:=(color and $8f) or (textattr and $70);
end;

procedure TextBackground(color:byte);
begin
  textattr:=((color shl 4) and ($f0 and not blink)) or
    (textattr and ($0f or blink));
end;

procedure HighVideo;
begin
  textcolor(textattr or $08);
end;

procedure LowVideo;
begin
  textcolor(textattr and $77);
end;

procedure NormVideo;
begin
  textcolor(7);
  textbackground(0);
end;

procedure GotoXY(x,y:byte);
begin
  if (x>0) and (x<=winmaxx-winminx+1) and
    (y>0) and (y<=winmaxy-winminy+1) then begin
      inc(x,winminx-1);
      inc(y,winminy-1);
      setscreencursor(x,y);
    end;
end;

procedure Window(x1,y1,x2,y2:byte);
begin
  if (x1>x2) or (x2>screenwidth) or (y1>y1) or (y2>screenheight) then exit;
  windmin:=((y1-1) shl 8)+(x1-1);
  windmax:=((y2-1) shl 8)+(x2-1);
  gotoxy(1,1);
end;

procedure ClrScr;
var
  ClipRect:TSmallRect;
  SrcRect:TSmallRect;
  DestCoor:TCoord;
  CharInfo:TCharInfo;
begin
  charinfo.unicodechar:=#32;
  charinfo.attributes:=textattr;
  srcrect.left:=winminx-1;
  srcrect.top:=winminy-1;
  srcrect.right:=winmaxx-1;
  srcrect.bottom:=winmaxy-1;
  cliprect:=srcrect;
  if iswindowsnt then begin
    destcoor.x:=-winmaxx;
    destcoor.y:=-winmaxy;
    scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
  end else begin
    destcoor.x:=winminx-1;
    destcoor.y:=winminy-(succ((winmaxy-winminy) div 2));
    scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
    scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
    scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
  end;
  gotoxy(1,1);
end;

procedure ClrEol;
var
  temp:dword;
  charinfo:char;
  coord:TCoord;
  x,y:longint;
begin
  getscreencursor(x,y);
  charinfo:=#32;
  coord.x:=x-1;
  coord.y:=y-1;
  fillconsoleoutputcharacter(outhandle,charinfo,winmaxx-(x+1),coord,temp);
end;

function WhereX:byte;
var
  x,y:longint;
begin
  getscreencursor(x,y);
  result:=x-winminx+1;
end;

function WhereY:byte;
var
  x,y:longint;
begin
  getscreencursor(x,y);
  result:=y-winminy+1;
end;

var
  scancode:char;
  specialkey:boolean;
  doingnumchars:boolean;
  doingnumcode:byte;

function RemapScanCode(scancode:byte;ctrlkeystate:byte;keycode:longint):byte;
var
  altkey,ctrlkey,shiftkey:boolean;
const
  ctrlkeypadkeys:array [$47..$53] of byte=
    ($77,$8D,$84,$8E,$73,$8F,$74,$4E,$75,$91,$76,$92,$93);
begin
  altkey:=((ctrlkeystate and (right_alt_pressed or left_alt_pressed))>0);
  ctrlkey:=((ctrlkeystate and (right_ctrl_pressed or left_ctrl_pressed))>0);
  shiftkey:=((ctrlkeystate and shift_pressed)>0);
  if altkey then begin
    case keycode of
      vk_numpad0..vk_numpad9:begin
        doingnumchars:=true;
        doingnumcode:=byte((doingnumcode*10)+(keycode-vk_numpad0));
      end;
    end;
    case scancode of
      $02..$0D:inc(scancode,$76);
      $3B..$44:inc(scancode,$2D);
      $57..$58:inc(scancode,$34);
      $47..$49,$4B,$4D,$4F..$53:inc(scancode,$50);
      $1C:scancode:=$A6;
      $35:scancode:=$A4;
    end;
  end else if ctrlkey then case scancode of
    $0F:scancode:=$94;
    $3B..$44:inc(scancode,$23);
    $57..$58:inc(scancode,$32);
    $35:scancode:=$95;
    $37:scancode:=$96;
    $47..$53:scancode:=ctrlkeypadkeys[scancode];
  end else if shiftkey then case scancode of
    $3B..$44:inc(scancode,$19);
    $57..$58:inc(scancode,$30);
  end else case scancode of
    $57..$58:inc(scancode,$2E);
  end;
  result:=scancode;
end;

function KeyPressed:boolean;
var
  i,k,nevents,nread:longword;
  buf:TInputRecord;
  altkey,ctrlkey,shiftkey:boolean;
begin
  result:=false;
  if scancode<>#0 then result:=true else begin
    nevents:=0;
    getnumberofconsoleinputevents(ttextrec(input).handle,nevents);
    for i:=1 to nevents do begin
      readconsoleinputa(ttextrec(input).handle,buf,1,nread);
      if buf.eventtype=key_event then begin
        k:=buf.event.keyevent.dwcontrolkeystate;
        altkey:=((k and (right_alt_pressed or left_alt_pressed))>0);
        ctrlkey:=((k and (right_ctrl_pressed or left_ctrl_pressed))>0);
        shiftkey:=((k and shift_pressed)>0);
        keystate:=0;
        if altkey then keystate:=keystate or 8;
        if ctrlkey then keystate:=keystate or 4;
        if shiftkey then keystate:=keystate or 2;
        if buf.event.keyevent.bkeydown then begin
          altkey:=((buf.event.keyevent.dwcontrolkeystate and
            (right_alt_pressed or left_alt_pressed))>0);
          if buf.event.keyevent.wvirtualkeycode in [vk_shift,vk_menu,vk_control,
            vk_capital,vk_numlock,vk_scroll] then begin
            end else begin
              result:=true;
              if ord(buf.event.keyevent.asciichar)=0 then begin
                specialkey:=true;
                scancode:=chr(remapscancode(buf.event.keyevent.wvirtualscancode,
                  buf.event.keyevent.dwcontrolkeystate,buf.event.keyevent.wvirtualkeycode));
              end else begin
                specialkey:=false;
                scancode:=chr(ord(buf.event.keyevent.asciichar));
                if altkey then begin
                  specialkey:=true;
                  case scancode of
                    #97,#65:scancode:=#30;
                    #98,#66:scancode:=#48;
                    #99,#67:scancode:=#46;
                    #100,#68:scancode:=#32;
                    #101,#69:scancode:=#18;
                    #102,#70:scancode:=#33;
                    #103,#71:scancode:=#34;
                    #104,#72:scancode:=#35;
                    #105,#73:scancode:=#23;
                    #106,#74:scancode:=#36;
                    #107,#75:scancode:=#37;
                    #108,#76:scancode:=#38;
                    #109,#77:scancode:=#50;
                    #110,#78:scancode:=#49;
                    #111,#79:scancode:=#24;
                    #112,#80:scancode:=#25;
                    #113,#81:scancode:=#16;
                    #114,#82:scancode:=#19;
                    #115,#83:scancode:=#31;
                    #116,#84:scancode:=#20;
                    #117,#85:scancode:=#22;
                    #118,#86:scancode:=#47;
                    #119,#87:scancode:=#17;
                    #120,#88:scancode:=#45;
                    #121,#89:scancode:=#21;
                    #122,#90:scancode:=#44;
                    #48:scancode:=#129;
                    #49:scancode:=#120;
                    #50:scancode:=#121;
                    #51:scancode:=#122;
                    #52:scancode:=#123;
                    #53:scancode:=#124;
                    #54:scancode:=#125;
                    #55:scancode:=#126;
                    #56:scancode:=#127;
                    #57:scancode:=#128;
                    '-','_':scancode:=#130;
                    '=','+':scancode:=#131;
                    else specialkey:=false;
                  end;
                end;
              end;
              if buf.event.keyevent.wvirtualkeycode in  [vk_numpad0..vk_numpad9] then
                if altkey then begin
                  result:=false;
                  specialkey:=false;
                  scancode:=#0;
                end else break;
            end;
        end else if buf.event.keyevent.wvirtualkeycode in [vk_menu] then
          if doingnumchars then if doingnumcode>0 then begin
            scancode:=chr(doingnumcode);
            result:=true;
            doingnumchars:=false;
            doingnumcode:=0;
            break;
          end;
      end else if buf.eventtype=_mouse_event then begin
        if assigned(mousehandler) then mousehandler(buf);
      end;
    end;
  end;
end;

function ReadKey:char;
begin
  repeat
    sleep(1);
  until keypressed;
  if specialkey then begin
    result:=#0;
    specialkey:=false;
  end else begin
    result:=scancode;
    scancode:=#0;
  end;
end;

function RdKey:char;
begin
  schar:=false;
  result:=readkey;
  if result=#0 then begin
    schar:=true;
    result:=readkey;
  end;
end;

procedure Delay(ms:word);
begin
  sleep(ms);
end;

procedure Sound(hz:word);
begin
  messagebeep(0);
end;

procedure NoSound;
begin
end;

procedure RemoveLine(y:longint);
var
  ClipRect:TSmallRect;
  SrcRect:TSmallRect;
  DestCoor:TCoord;
  CharInfo:TCharInfo;
begin
  charinfo.unicodechar:=#32;
  charinfo.attributes:=textattr;
  y:=winminy+y-1;
  srcrect.top:=y-1;
  srcrect.left:=winminx-1;
  srcrect.right:=winmaxx-1;
  srcrect.bottom:=winmaxy-1;
  destcoor.x:=winminx-1;
  destcoor.y:=y-2;
  cliprect:=srcrect;
  scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
end;

procedure DelLine;
begin
  removeline(wherey);
end;

procedure InsLine;
var
  ClipRect:TSmallRect;
  SrcRect:TSmallRect;
  DestCoor:TCoord;
  CharInfo:TCharInfo;
  x,y:longint;
begin
  getscreencursor(x,y);
  charinfo.unicodechar:=#32;
  charinfo.attributes:=textattr;
  srcrect.top:=y-1;
  srcrect.left:=winminx-1;
  srcrect.right:=winmaxx-1;
  srcrect.bottom:=winmaxy-1;
  destcoor.x:=winminx-1;
  destcoor.y:=y;
  cliprect:=srcrect;
  scrollconsolescreenbuffer(outhandle,srcrect,@cliprect,destcoor,charinfo);
end;

function GetCursorSize:longint;
var
  CursorInfo:TConsoleCursorInfo;
begin
  getconsolecursorinfo(outhandle,cursorinfo);
  result:=cursorinfo.dwsize;
end;

procedure SetCursorSize(size:longint);
var
  CursorInfo:TConsoleCursorInfo;
begin
  getconsolecursorinfo(outhandle,cursorinfo);
  cursorinfo.dwsize:=size;
  cursorinfo.bvisible:=true;
  setconsolecursorinfo(outhandle,cursorinfo);
end;

procedure CursorOn;
begin
  setcursorsize(defcursorsize);
end;

procedure CursorOff;
var
  CursorInfo:TConsoleCursorInfo;
begin
  getconsolecursorinfo(outhandle,cursorinfo);
  cursorinfo.bvisible:=false;
  setconsolecursorinfo(outhandle,cursorinfo);
end;

procedure CursorBig;
begin
  setcursorsize(99);
end;

procedure CursorNorm;
begin
  setcursorsize(12);
end;

var
  CurrX,CurrY:longint;

procedure WriteChar(c:char);
var
  Cell:TCharInfo;
  BufSize:TCoord;
  WritePos:TCoord;
  DestRect:TSmallRect;
begin
  case c of
    #10:inc(curry);
    #13:currx:=winminx;
    #08:if currx>winminx then dec(currx);
    #07:;
    else begin
      bufsize.x:=1;
      bufsize.y:=1;
      writepos.x:=0;
      writepos.y:=0;
      cell.unicodechar:=widechar(c);
      cell.attributes:=textattr;
      destrect.left:=currx-1;
      destrect.top:=curry-1;
      destrect.right:=currx-1;
      destrect.bottom:=curry-1;
      writeconsoleoutput(outhandle,@cell,bufsize,writepos,destrect);
      inc(currx);
    end;
  end;
  if currx>winmaxx then begin
    currx:=winminx;
    inc(curry);
  end;
  while curry>winmaxy do begin
    removeline(1);
    dec(curry);
  end;
end;

function CrtWrite(var f:TTextRec):integer;
var
  i:longint;
begin
  getscreencursor(currx,curry);
  for i:=0 to f.bufpos-1 do writechar(f.buffer[i]);
  setscreencursor(currx,curry);
  f.bufpos:=0;
  result:=0;
end;

function CrtRead(var f:TTextRec):integer;

  procedure BackSpace;
  begin
    if (f.bufpos>0) and (f.bufpos=f.bufend) then begin
      writechar(#8);
      writechar(' ');
      writechar(#8);
      dec(f.bufpos);
      dec(f.bufend);
    end;
  end;

var
  ch:char;

begin
  getscreencursor(currx,curry);
  f.bufpos:=0;
  f.bufend:=0;
  repeat
    if f.bufpos>f.bufend then f.bufend:=f.bufpos;
    setscreencursor(currx,curry);
    ch:=readkey;
    case ch of
      #0:case readkey of
        #71:while f.bufpos>0 do begin
          dec(f.bufpos);
          writechar(#8);
        end;
        #75:if f.bufpos>0 then begin
          dec(f.bufpos);
          writechar(#8);
        end;
        #77:if f.bufpos<f.bufend then begin
          writechar(f.bufptr[f.bufpos]);
          inc(f.bufpos);
        end;
        #79:while f.bufpos<f.bufend do begin
          writechar(f.bufptr[f.bufpos]);
          inc(f.bufpos);
        end;
      end;
      ^S,#8:backspace;
      ^Y,#27:begin
        f.bufpos:=f.bufend;
        while f.bufend>0 do backspace;
      end;
      #13:begin
        writechar(#13);
        writechar(#10);
        f.bufptr[f.bufend]:=#13;
        f.bufptr[f.bufend+1]:=#10;
        inc(f.bufend,2);
        break;
      end;
      #26:if checkeof then begin
        f.bufptr[f.bufend]:=#26;
        inc(f.bufend);
        break;
      end;
      else begin
        if f.bufpos<f.bufsize-2 then begin
          f.buffer[f.bufpos]:=ch;
          inc(f.bufpos);
          writechar(ch);
        end;
      end;
    end;
  until false;
  f.bufpos:=0;
  setscreencursor(currx,curry);
  result:=0;
end;

function CrtReturn(var f:TTextRec):integer;
begin
  result:=0;
end;

function CrtClose(var f:TTextRec):integer;
begin
  f.mode:=fmclosed;
  result:=0;
end;

function CrtOpen(var f:TTextRec):integer;
begin
  if f.mode=fmoutput then begin
    ttextrec(f).inoutfunc:=@crtwrite;
    ttextrec(f).flushfunc:=@crtwrite;
  end else begin
    f.mode:=fminput;
    ttextrec(f).inoutfunc:=@crtread;
    ttextrec(f).flushfunc:=@crtreturn;
  end;
  ttextrec(f).closefunc:=@crtclose;
  result:=0;
end;

procedure AssignCrt(var f:text);
begin
  assign(f,'');
  ttextrec(f).openfunc:=@crtopen;
end;

procedure InitCrt;
var
  CursorInfo:TConsoleCursorInfo;
  ConsoleInfo:TConsoleScreenBufferInfo;
begin
  if crtinited then exit;
  outhandle:=getstdhandle(std_output_handle);
  inhandle:=getstdhandle(std_input_handle);
  fillchar(cursorinfo,sizeof(cursorinfo),0);
  getconsolecursorinfo(outhandle,cursorinfo);
  defcursorsize:=cursorinfo.dwsize;
  fillchar(consoleinfo,sizeof(consoleinfo),0);
  getconsolescreenbufferinfo(outhandle,consoleinfo);
  cursorsavex:=consoleinfo.dwcursorposition.x;
  cursorsavey:=consoleinfo.dwcursorposition.y;
  textattr:=consoleinfo.wattributes;
  screenwidth:=getscreenwidth;
  screenheight:=getscreenheight;
  turnmouseoff(usemouse);
  windmax:=(screenwidth-1) or ((screenheight-1) shl 8);
  doingnumchars:=false;
  doingnumcode:=0;
  assigncrt(output);
  rewrite(output);
  ttextrec(output).handle:=outhandle;
  assigncrt(input);
  reset(input);
  ttextrec(input).handle:=inhandle;
  schar:=false;
  mousehandler:=dcrtmaus_mh;
  if not getnumberofconsolemousebuttons(mousebuttons) then mousebuttons:=0;
  crtinited:=true;
end;

procedure DoneCrt;
begin
  crtinited:=false;
  flushconsoleinputbuffer(inhandle);
end;

procedure ReadScr(x1,y1,x2,y2:integer;var dest:TScr);
type
  pbyte=^byte;
var
  rect:TSmallRect;
  bufsize,bufcoord:TCoord;
  buf:array [0..1999] of TCharInfo;
  p1,p2:pbyte;
  i:integer;
begin
  dest.x1:=x1;dest.y1:=y1;dest.x2:=x2;dest.y2:=y2;
  dest.oldx:=wherex;dest.oldy:=wherey;dest.oldattr:=textattr;
  bufsize.x:=80;
  bufsize.y:=25;
  bufcoord.x:=0;
  bufcoord.y:=0;
  rect.left:=x1-1;
  rect.top:=y1-1;
  rect.right:=x2-1;
  rect.bottom:=y2-1;
  readconsoleoutput(outhandle,@buf[0],bufsize,bufcoord,rect);
  p1:=@buf;
  p2:=@dest.dat;
  for i:=0 to 1999 do begin
    p2^:=p1^; //char
    inc(p1,2);
    inc(p2);
    p2^:=p1^; //attr
    inc(p1,2);
    inc(p2);
  end;
end;

procedure WriteScr(var src:TScr;rcoordattr:boolean);
type
  pbyte=^byte;
var
  rect:TSmallRect;
  bufsize,bufcoord:TCoord;
  buf:array [0..1999] of TCharInfo;
  p1,p2:pbyte;
  i:integer;
begin
  with src do begin
    bufsize.x:=80;
    bufsize.y:=25;
    bufcoord.x:=0;
    bufcoord.y:=0;
    rect.left:=x1-1;
    rect.top:=y1-1;
    rect.right:=x2-1;
    rect.bottom:=y2-1;
    p1:=@dat;
    p2:=@buf;
    for i:=0 to 1999 do begin
      p2^:=p1^; //char
      inc(p2);p2^:=0;inc(p2);
      inc(p1);
      p2^:=p1^; //attr
      inc(p2);p2^:=0;inc(p2);
      inc(p1);
    end;
    writeconsoleoutput(outhandle,@buf[0],bufsize,bufcoord,rect);
    if rcoordattr then begin
      gotoxy(oldx,oldy);
      textattr:=oldattr;
    end;
  end;
end;

procedure ScrollScr(x1,y1,x2,y2,l:integer;attr:byte);
var
  up:boolean;
  buf:tscr;
  x,y:integer;
begin
  if l=0 then exit;
  up:=l<0;
  readscr(1,1,80,25,buf);
  if up then begin
    while l<0 do begin
      for y:=y1+1 to y2 do
        move(buf.dat[y,x1,1],buf.dat[y-1,x1,1],(x2-x1+1)*2);
      for x:=x1 to x2 do begin
        buf.dat[y2,x,1]:=0;
        buf.dat[y2,x,2]:=attr;
      end;
      inc(l);
    end;
  end else begin
    while l>0 do begin
      for y:=y2-1 downto y1 do
        move(buf.dat[y,x1,1],buf.dat[y+1,x1,1],(x2-x1+1)*2);
      for x:=x1 to x2 do begin
        buf.dat[y1,x,1]:=0;
        buf.dat[y1,x,2]:=attr;
      end;
      dec(l);
    end;
  end;
  writescr(buf,false);
end;

procedure ScrollScrH(x1,y1,x2,y2,c:integer;attr:byte);
var
  left:boolean;
  buf:tscr;
  x,y:integer;
begin
  if c=0 then exit;
  left:=c<0;
  readscr(1,1,80,25,buf);
  if left then begin
    while c<0 do begin
      for y:=y1 to y2 do
        for x:=x1+1 to x2 do begin
          buf.dat[y,x-1,1]:=buf.dat[y,x,1];
          buf.dat[y,x-1,2]:=buf.dat[y,x,2];
        end;
      for y:=y1 to y2 do begin
        buf.dat[y,x2,1]:=0;
        buf.dat[y2,x2,2]:=attr;
      end;
      inc(c);
    end;
  end else begin
    while c>0 do begin
      for y:=y1 to y2 do
        for x:=x2-1 downto x1 do begin
          buf.dat[y,x+1,1]:=buf.dat[y,x,1];
          buf.dat[y,x+1,2]:=buf.dat[y,x,2];
        end;
      for y:=y1 to y2 do begin
        buf.dat[y,x1,1]:=0;
        buf.dat[y,x1,2]:=attr;
      end;
      dec(c);
    end;
  end;
  writescr(buf,false);
end;

function GetTitle:string;
var
  buf:array [0..255] of char;
begin
  GetConsoleTitle(buf,255);
  result:=strpas(buf);
end;

procedure SetTitle(s:string);
var
  pch:array [0..255] of char;
begin
  StrPCopy(pch,s);
  SetConsoleTitle(pch);
end;

procedure FillAreaCh(x1,y1,x2,y2:integer;ch,color:byte);
var
  x,y:integer;
  buf:tscr;
begin
  buf.x1:=x1;buf.y1:=y1;buf.x2:=x2;buf.y2:=y2;
  for y:=y1 to y2 do
    for x:=x1 to x2 do begin
      buf.dat[y-y1+1,x-x1+1,1]:=ch;
      buf.dat[y-y1+1,x-x1+1,2]:=color;
    end;
  writescr(buf,false);
end;

procedure FillArea(x1,y1,x2,y2:integer;color:byte);
begin
  fillareach(x1,y1,x2,y2,219,color);
end;

procedure WriteStr(x,y:integer;s:string);
var
  buf:tscr;
begin
  readscr(1,y,80,y,buf);
  writestrscr(buf,x,1,s);
  writescr(buf,false);
end;

procedure WriteStrScr(var dest:TScr;x,y:integer;s:string);
var
  i:integer;
begin
  for i:=1 to length(s) do begin
    dest.dat[y,x+i-1,1]:=ord(s[i]);
    dest.dat[y,x+i-1,2]:=textattr;
  end;
end;

function CharAtPos(x,y:integer):char;
var
  buf:tscr;
begin
  readscr(x,y,x,y,buf);
  result:=chr(buf.dat[1,1,1]);
end;

function AttrAtPos(x,y:integer):byte;
var
  buf:tscr;
begin
  readscr(x,y,x,y,buf);
  result:=buf.dat[1,1,2];
end;

procedure DrawBackgroundCh(ch,color:byte);
begin
  fillareach(1,1,80,25,ch,color);
end;

procedure DrawBackground(color:byte);
begin
  drawbackgroundch(178,color);
end;

procedure DrawFrame(x1,y1,x2,y2:integer;frametype,frameattr:byte);
var
  ul,ur,ll,lr,horiz,vert:char;
  i:integer;
  buf:tscr;
begin
  case frametype of
    0:begin
      ul:=chr(218);ur:=chr(191);ll:=chr(192);lr:=chr(217);
      horiz:=chr(196);vert:=chr(179);
    end;
    else begin
      ul:=chr(201);ur:=chr(187);ll:=chr(200);lr:=chr(188);
      horiz:=chr(205);vert:=chr(186);
    end;
  end;
  textattr:=frameattr;
  readscr(x1,y1,x2,y2,buf);
  dec(x2,x1-1);dec(y2,y1-1);x1:=1;y1:=1;
  writestrscr(buf,x1,y1,ul);
  for i:=x1+1 to x2-1 do writestrscr(buf,i,y1,horiz);
  writestrscr(buf,x2,y1,ur);
  for i:=y1+1 to y2-1 do begin
    writestrscr(buf,x1,i,vert);
    writestrscr(buf,x2,i,vert);
  end;
  writestrscr(buf,x1,y2,ll);
  writestrscr(buf,x2,y2,lr);
  for i:=x1+1 to x2-1 do writestrscr(buf,i,y2,horiz);
  writescr(buf,false);
end;

procedure DrawShadow(x1,y1,x2,y2:integer);
var
  x,y:integer;
  oldattr:byte;
  buf:tscr;
begin
  readscr(1,1,80,25,buf);
  oldattr:=textattr;
  for y:=y1 to y2 do
    for x:=x1 to x2 do begin
      textattr:=buf.dat[y,x,2];
      if buf.dat[y,x,1]<>219 then textattr:=$08 else textattr:=$00;
      buf.dat[y,x,2]:=textattr;
    end;
  textattr:=oldattr;
  writescr(buf,False);
end;

procedure DrawWindow(x1,y1,x2,y2:integer;wndcolor,frametype,frameattr,
  titattr:byte;title:string;has_shadow:boolean);
var
  s:string;
begin
  if has_shadow then begin
    DrawShadow(x2+1,y1+1,x2+1,y2+1);
    DrawShadow(x1+1,y2+1,x2+1,y2+1);
  end;
  DrawFrame(x1,y1,x2,y2,frametype,frameattr);
  FillArea(x1+1,y1+1,x2-1,y2-1,wndcolor);
  if Length(title)>0 then begin
    if Length(title)<x2-x1-5 then s:=title else
      s:=Copy(title,1,x2-x1-5);
    textattr:=titattr;
    GotoXY(x1+((x2-x1-1) div 2)-(Length(s) div 2),y1);
    Write(' ',s,' ');
  end;
end;

initialization
  IsWindowsNT:=(Win32Platform=VER_PLATFORM_WIN32_NT);
  crtinited:=false;
  if IsConsole then InitCrt;

finalization
  if crtinited then DoneCrt;

end.
