; ----------------------------------------------------------------------
; File: MACRO.INC    Standard Macros    Ben Ritchey Jr
;                    Propriety Use ONLY - All Rights Reserved

; Add these equates to Source if needed:
BIOSVID        EQU     10h     ; BIOS Video Int
BIOSEQU        EQU     11h     ;  "   Equipment Flags
BIOSMEM        EQU     12h     ;  "   Memory Size
BIOSDSK        EQU     13h     ;  "   Floppy Disk
BIOSCOM        EQU     14h     ;  "   Communications
BIOSEXT        EQU     15h     ;  "   Extended
BIOSKBD        EQU     16h     ;  "   Keyboard
BIOSPRT        EQU     17h     ;  "   Printer
BIOSRTC        EQU     1Ah     ;  "   Real Time Clock
; (See individual Macros for Data I/O variables)

.XCREF
.XLIST
       IF1                     ; Pass 1 Only!

@DELAY         MACRO           ; Delay cx:dx uSec

;      In   cx = Msb usecs  ((Seconds*1000)*1000)/65536
;           dx = LSB usecs

               xor     bx,bx
               mov     ax,8600h  ; Delay usec
               int     BIOSEXT
               ENDM

@GET_VER       MACRO           ; Get DOS Version

;      Out  al = Bin Major
;           ah = Bin Minor

               mov     ah,30h
               int     DOS
               ENDM

@SET_DVF       MACRO           ; Set Disk Verify Flag

               mov     al,1h
               mov     ah,2Eh
               int     DOS
               ENDM

@GET_DRV       MACRO           ; Get Cur Drive

;      Out  al = Bin Drive (0=A, 1=B, etc.)
;          (ah = ASCII Drive 'A')
;           PBDRIVE = ah

               mov     ah,19h
               int     DOS
               mov     ah,al   ; Save #
               add     ah,65   ; Cv to ASCII
               mov     PBDRIVE,ah  ; Save
               ENDM

@CHG_DRV       MACRO           ; Chg Cur Drive

;      In   dl = Drive (0=A,etc)
;      Out  al = Last Logical Drive

               mov     ah,0Eh
               int     DOS
               ENDM

@GET_CDI       MACRO           ; Get Current Path

;      Out  PBPATH = Name (excl. d:\)

               xor     dl,dl
               mov     si,OFFSET PBPATH
               mov     ah,47h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@CHG_DIR       MACRO           ; Chg Cur Dir (ChDir)

;      In   [ds:dx] = ASCIIZ Path

               mov     ah,3Bh
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@NEW_DIR       MACRO           ; Create Sub-Dir

;      In   ds:dx = ASCIIZ Path

               mov     ah,39h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@FND_1ST       MACRO           ; Find 1st Dir

;      In   Current DTA Set   ds:dx = ASCIIZ Path/Wildcard
;           cx = Attribute Mask:  +0h-n/a  +1h-R/O  +2h-Hidden  +4h-System
;                           +8h-Vol Label  +10h-Sub Dir  +20h-Archive
;      Out  DTA+00 x21 = Find Next Pointer (Binary)
;              +21 x 1 = Attribute (1=R/O 2=Hid 4=Sys 8=Vol 10h=Dir 20h=Arc
;              +22 x 2 = Time (ax=hhhhhmmm.mmmsssss (sec/2))
;              +24 x 2 = Date (ax=yyyyyyym.mmmddddd (yr-80))
;              +26 x 4 = Size in Bytes (L/Msb)  4,294,967,295 = 0FFFFFFFFh
;              +30 x13 = FName.Ext (AsciiZ) Len 1 to 12, 0

               mov     ah,4Eh
               int     DOS

               jnc     Short @F
               cmp     al,18   ; No more Ok
               je      Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@FND_NXT       MACRO           ; Find Next Dir

;      In   (DTA Set from @FND_1ST!)
;      Out  (See @FND-1ST)

               mov     ah,4Fh
               int     DOS

               jnc     Short @F
               cmp     al,18   ; No more Ok
               je      Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@MOV_FDR       MACRO           ; Move/Rename Dir Entry

;      In   ds:dx = ASCIIZ Path - Existing FSpec
;           es:di = ASCIIZ Path - New Path, FSpec or BOTH

               mov     ah,56h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@DEL_DIR       MACRO           ; Delete Sub-Dir

;      In   ds:dx = ASCIIZ Path

               mov     ah,3Ah
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@GET_VEC       MACRO           ; Get Int Vec Addr

;      In   al = Int #
;      Out  [es:bx] = Routine (Vec Addr)

               mov     ah,35h
               int     DOS
               ENDM

@SET_VEC       MACRO           ; Set Interrupt Vector

;      In   al = Interrupt No.
;           ds:dx = Vector Addr

               mov     ah,25h
               int     DOS
               ENDM

@GET_DTA       MACRO           ; Get Disk Transfer Addr

;      Out  es:bx = Current DTA
;           PBDTA = Saved DTA Offset
;           PBSDTA = Saved DTA Seg

               mov     ah,2Fh
               int     DOS

               mov     PBDTA,bx
               mov     PBSDTA,es
               ENDM

@SET_DTA       MACRO           ; Set Disk Transfer Addr

;      In   ds:dx = Addr of Buffer
;      Out  PBDTA = Saved Offset (dx)
;           PBSDTA = Saved Segment (ds)

               mov     PBSDTA,ds
               mov     PBDTA,dx
               mov     ah,1Ah
               int     DOS
               ENDM

@GET_KBS       MACRO           ; Get Kybd Status Flag

;      In   (40:17,18h ROM Bios RAM Data)
;      Out  al = Flag   Bit 7=Ins ON, 6=Caps ON, 5=Num ON, 4=Scroll ON,
;                          3=Alt Dn, 2=Ctrl Dn, 1=L-Shift Dn, 0=R-Shift Dn
;           KBSTAT = ax

               mov     ah,2
               int     BIOSKBD

               mov     KBSTAT,ax
               ENDM

@GET_CSR       MACRO           ; Read Cursor Row/Col

;      Out  CSR_LOC = Cursor Row-1/Col-1

               xor     bx,bx   ; Page
               mov     ah,3
               int     BIOSVID

               xchg    dh,dl
               mov     CSR_LOC,dx
               ENDM

@SET_CSR       MACRO           ; Set Cursor at Row/Col

;      In   CSR_LOC = Cursor Row-1/Col-1

               mov     dx,CSR_LOC
               xchg    dh,dl
               xor     bx,bx   ; Page
               mov     ah,2
               int     BIOSVID
               ENDM

@BLK_CSR       MACRO           ; Set Block Cursor

               mov     ch,10   ; Top
               mov     cl,12   ; Bottom
               xor     bx,bx
               xor     dx,dx
               xor     al,al
               mov     ah,1
               int     BIOSVID
               ENDM

@OFF_CSR       MACRO           ; Set Cursor OFF Screen

               mov     bh,0    ; Page
               mov     dh,50   ; Row-1
               mov     dl,0    ; Col-1
               mov     ah,2
               int     BIOSVID
               ENDM

@CLR_KEY       MACRO           ; Clear Kybd Buffer

               xor     al,al
               mov     ah,0Ch
               int     DOS
               ENDM

@CHK_KEY       MACRO           ; Chk if Key Pressed

;      Out  al = Flag (00h=No, 0FFh=Yes)

               mov     ah,0Bh
               int     DOS
               ENDM

@GET_KEY       MACRO           ; Wait for Kybd (NO Echo)

;      Out  al = ASCII Character

               mov     ah,08h
               int     DOS
               ENDM

@GET_CHR       MACRO           ; Wait for Kybd then Echo

;      Out  al = ASCII Character

               mov     ah,01h
               int     DOS
               ENDM

@PUT_CHR       MACRO           ;  Display Character

;      In   dl = ASCII Character

               mov     ah,02h
               int     DOS
               ENDM

@PUT_STR       MACRO           ; Display String

;      In   [ds:dx] = String Addr (end with $)

               mov     ah,09h
               int     DOS
               ENDM

@PUT_PRT       MACRO           ; Print Character

;      In   dl = ASCII Character

               mov     ah,05h
               int     DOS
               ENDM

@CREATEF       MACRO           ; Create File

;      In   [ds:dx] = ASCIIZ FSpec
;           cx = Attribute (0h-Std, 1h-R/O, 2h-Hidden,
;                           4h-System, 8h-Vol Label,
;                           10h-Sub Dir, 20h-Archive)
;      Out  ax = File Handle
;           PBFH = ax
;           PBFSA = ASCIIZ FSpec Addr (dx)

               mov     PBFSA,dx
               mov     ah,3Ch
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            mov     PBFH,ax
               ENDM

@OPENF         MACRO           ; Open File (will NOT Create)

;      In   [ds:dx] = ASCIIZ FSpec
;           al = Access (0-Read, 1-Write, 2-R/W)
;      Out  ax = File Handle
;           PBFH = ax
;           PBFSA = ASCIIZ FSpec Addr (dx)

               mov     PBFSA,dx
               mov     ah,3Dh
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            mov     PBFH,ax
               ENDM

@STARTF        MACRO           ; Set File Pointer

;      In   cx:dx = Byte Offset {Optional}
;           al = Position (0-TOF, 1-Cur, 2-EOF)
;           bx = File Handle
;      Out  dx:ax = New position

               mov     ah,42h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@APPENDF       MACRO           ; Set File to EOF

;      Out  dx:ax = File Size

               xor     cx,cx
               xor     dx,dx
               mov     al,2
               mov     ah,42h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@READF         MACRO           ; Read File Block

;      In   [ds:dx] = DTA Buffer
;           cx = # Bytes
;           bx = File Handle
;      Out  ax = # Bytes Read

               mov     ah,3Fh
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@WRITEF        MACRO           ; Write File Block

;      In   [ds:dx] = DTA Buffer
;           cx = # Bytes
;           bx = File Handle
;      Out  ax = # Bytes Written

               push    cx
               mov     ah,40h
               int     DOS

               jnc     Short @F
               pop     cx
               jmp     ERR_SET
@@:            pop     cx
               cmp     ax,cx
               je      Short @F
               mov     RC,103
               jmp     ERR_EXIT
@@:            nop
               ENDM

@CLOSEF        MACRO           ; Close File

;      In   bx = File Handle

               mov     ah,3Eh
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

@DELETEF       MACRO           ; Delete File

;      In   ds:dx = ASCIIZ Path
;      Out  PBFSA = ASCIIZ FSpec Addr (dx)

               mov     PBFSA,dx
               mov     ah,41h
               int     DOS

               jnc     Short @F
               jmp     ERR_SET
@@:            nop
               ENDM

       ENDIF                   ; End of Macros

.CREF
.LIST
;*** End of MACRO.INC ***

