Unit IGMUNIT;  {V1.0}

Interface

Uses DOS,CRT,ANSI;

type player_info = record
 names: string[20]; {player handle in the game}
 real_names: string[50] {real name/or handle from BBS} ;
 hit_points  {player hit points}
 ,bad  {don't know - might not be used at all}
 ,rate: integer; {again, couldn't find this one in the source}
 hit_max: integer; {hit_point max}
 weapon_num: integer; {weapon number}
 weapon: string[20]; {name of weapon}
 seen_master: integer; {equals 5 if seen master, else 0}
 fights_left: integer; {forest fights left}
 human_left: integer; {human fights left}
 gold: longint; {gold in hand}
 bank: longint; {gold in bank}
 def: integer;  {total defense points }
 strength: integer; {total strength}
 charm: integer; {good looking meter}
 seen_dragon: integer; {seen dragon?  5 if yes else 0}
 seen_violet: integer; {seen violet?  5 if yes else 0}
 level: integer; {level of player}
 time: word; {day # that player last played on}
 arm: string[20]; {armour name}
 arm_num: integer; {armour number}
 dead: shortint; {player dead?  5 if yes else 0}
 inn: shortint; {player sleeping at inn?  5 if yes else 0}
 gem: integer; {# of gems on hand}
 exp: longint; {experience}
 sex: shortint; {gender, 5 if female else 0}
 seen_bard: shortint; {seen bard?  5 if yes else 0}
 last_alive_time: integer; {day # player was last reincarnated on}
 Lays: integer; {players lays stat}
 Why: integer; {not used yet}
 on_now: boolean; {is player on?}
 m_time: integer; {day on_now stat was last used}
 time_on: string[5]; {time player logged on in Hour:Minutes format}
 class: shortint; {class, should be 1, 2 or 3}
 extra: integer;      {*NEW*  If 1, player has a horse}
 love: string[25]; {not used - may be used for inter-player marrages later}
 married: integer; {who player is married to, should be -1 if not married}
 kids: integer; {# of kids}
 king: integer; {# of times player has won game}
 skillw: shortint; {number of Death Knight skill points}
 skillm: shortint; {number of Mystical Skills points}
 skillt: shortint; {number of Thieving Skills points}
 levelw: shortint; {number of Death Knight skill uses left today}
 levelm: shortint; {number of Mystical skill uses left today}
 levelt: shortint; {number of Thieving skill uses left today}
 inn_random: boolean; {not used yet}
 married_to: integer; {same as Married, I think - don't know why it's here}
 v1: longint;
 v2: integer; {# of player kills}
 v3: integer; {if 5, 'wierd' event in forest will happen}
 v4: boolean; {has player done 'special' for that day?}
 v5: shortint; {has player flirted with another player that day?  if so, 5}
   new_stat1: shortint;
   new_stat2: shortint;  {these 3 are unused right now}
   new_stat3: shortint;  {Warning: Joseph's NPCLORD screws with all three}
   end;

Var
 Player: Player_info;
 TicksSinceMidnight : longint ABSOLUTE $0040:$006c;

Function AddColor(F:Byte):String;
Function PutColor(Out:String):String;
Procedure Show(Out:String);
Procedure Showln(Out:String);
Function SC(TempStr:String) : String;
Function DWNCase(DWNCH:Char):Char;
Procedure DWNCaseString(Var CString:String);
Procedure UPCaseStr(Var CString:String);
Function UPCaseString(CString:String) : String;
function direxist(d: pathstr): boolean;
function fileExists(s : string) : boolean;
Procedure GetPath(Var Path:String);
Function GetPathFunc:String;
Procedure EraseFile(FileName:String);
Procedure LockFile(FileName:String);
Procedure UnlockFile(FileName:String);
Procedure Wait(TimeDelay:LongInt);
Function StrVal(Value:LongInt) : String;
Function ValStr(Str:String) : LongInt;
Function Date : String;
Procedure PressAKey;
Function AreYouSure : Boolean;
Function NoCodes(InString:String) : String;
Procedure GetPlayer (Var Player:Player_Info; Name:String);
Procedure PutPlayer (Player:Player_Info; Name:String);

Implementation

Function AddColor(F:Byte):String;
const
  colorf: array[0..7] of string[2] = ('30','34','32','36','31','35','33','37');
Var I:Byte;
begin;
 Addcolor:='';
 if f > 31 then exit;
 if (f=7) then Addcolor:=#27+'[0m'
 else
  begin
   If (F>=0) and (F<=6) then
    Addcolor:=#27+'[0;'+colorf[F]+'m'
   Else If (F>=8) and (F<=15) then
    Addcolor:=#27+'[1;'+colorf[F-8]+'m'
   Else If (F>=16) and (F<=23) then
    Addcolor:=#27+'[0;5;'+Colorf[F-16]+'m'
   Else If (F>=24) and (F<=31) then
    Addcolor:=#27+'[1;5;'+colorf[F-24]+'m';
  End;
End;

Function PutColor(Out:String):String;
Var Final:String; Temp:Char; I:Byte;
Begin
 Final:='';
 For I:=1 to Length(Out) do
  If Copy(Out,I,1)='`' then
   Begin
    I:=I+1;
      {$V-} Temp:=Out[I]; {$V+}
      case Temp of
       '.'  : Final := Final+Addcolor(0);
       '1'  : Final := Final+Addcolor(1);
       '2'  : Final := Final+Addcolor(2);
       '3'  : Final := Final+Addcolor(3);
       '4'  : Final := Final+Addcolor(4);
       '5'  : Final := Final+Addcolor(5);
       '6'  : Final := Final+Addcolor(6);
       '7'  : Final := Final+Addcolor(7);
       '8'  : Final := Final+Addcolor(8);
       '9'  : Final := Final+Addcolor(9);
       '0'  : Final := Final+Addcolor(10);
       '!'  : Final := Final+Addcolor(11);
       '@'  : Final := Final+Addcolor(12);
       '#'  : Final := Final+Addcolor(13);
       '$'  : Final := Final+Addcolor(14);
       '%'  : Final := Final+Addcolor(15);
       ')'  : Final := Final+Addcolor(20);
      End;
   End
  Else Final:=Final+Copy(Out,I,1);
 PutColor:=Final;
End;

Procedure Show(Out:String);
Var S:String;
Begin
 S:=PutColor('`2'+Out);
 AnsiWrite(S);
 {Put the command to write S to the modem here}
End;

Procedure Showln(Out:String);
Var S:String;
Begin
 AnsiWriteln(S);
 {Put the command to write S to the modem here}
End;

Function SC(TempStr:String) : String;
Var First,Last,Into:String; Distance,F,I:Byte;
Begin
 First:='';
 Last:='';
 Distance:=Length(TempStr);
 F:=1;
 Repeat
  First:=Copy(TempStr,F,1);
  If First=' ' then F:=F+1;
 Until First<>' ';
 Last:=Copy(TempStr,F+1,Distance);
 Into:='';
 If F<>1 then For I:=1 to F do
  Into:=Into+' ';
 SC:=Into+'`2(`5'+First+'`2)'+Last;
End;

Function DWNCase(DWNCH:Char):Char;
begin
 if ('A' <= DWNCH) and (DWNCH <= 'z') then DWNCase:=CHR(orD(DWNCH)+32);
end;

Procedure DWNCaseString(Var CString:String);
{$V-}
Var I:Byte;
begin
 For I:=1 to LENGTH(CString) do CString[I]:=DWNCase(CString[I]);
{$V+}
end;

Procedure UPCaseStr(Var CString:String);
Var I:Byte;
begin
{$V-}
 For I:=1 to LENGTH(CString) do CString[I]:=UPCase(CString[I]);
{$V+}
end;

Function UPCaseString(CString:String) : String;
begin
 UpCaseStr(CString);
 UpCaseString:=CString;
end;

function direxist(d: pathstr): boolean;
var
 f   : file;
 attr: word;
 len : byte;
begin
 len:= length(d);
 if (d[len] = '\') then         
   dec(d[0]);                   
 d:= d + '\.';                  
 assign(f,d);                   
 getfattr(f,attr);              
 direxist := ((attr and directory)=directory);
end;

function fileExists(s : string) : boolean;
begin
  fileExists := fSearch(s, '') <> '';
end;

Procedure GetPath(Var Path:String);
{$V-}
Var Last,I:Integer; FileName:String;
Begin
 FileName:=ParamStr(0);
 For I := 1 to Length(FileName) do
  If FileName[I]='\' then Last:=I;
 Path:='';
 Path:=Copy(FileName,1,Last);
{$V+}
End;

Function GetPathFunc:String;
{$V-}
Var Last,I:Integer; FileName,Path:String;
Begin
 FileName:=ParamStr(0);
 For I := 1 to Length(FileName) do
  If FileName[I]='\' then Last:=I;
 Path:='';
 Path:=Copy(FileName,1,Last);
 GetPathFunc:=UpCaseString(Path);
{$V+}
End;

Procedure EraseFile(FileName:String);
Var
 VFile:File;
Begin
 If FileExists(FileName) then
  Begin
   Assign(VFile,FileName);
   Erase(VFile);
  End;
End;

Procedure LockFile(FileName:String);
Var
 AName:String;
 FName:Text;
 Seconds:Longint;
Begin
 {$V-}
 AName:=FileName;
 AName[Length(AName)]:='X';
 {$V+}
 Seconds:=TicksSinceMidnight;
 If FileExists(AName) Then
  Repeat
   If TicksSinceMidnight>=(Seconds+55) then EraseFile(AName);
  Until Not FileExists(AName);
 Assign(FName,AName);
 ReWrite(FName);
 Close(FName);
End;

Procedure UnlockFile(FileName:String);
Var
 FName:String;
Begin
 FName:=FileName;
 {$V-}
 FName[Length(Fname)]:='X';
 {$V+}
 EraseFile(FName);
End;

Procedure Wait(TimeDelay:LongInt);
Var
 Counter:LongInt;
Begin
 TimeDelay:=Round(TimeDelay/54.925529502);
 Counter:=TimeDelay+TicksSinceMidnight;
 If Counter>(1573039) then
  Begin
   Counter:=Counter-(1573039);
   While NOT(TicksSinceMidnight<=Counter) do;
  End;
 While (Counter>TicksSinceMidnight) do;
End;

Function StrVal(Value:LongInt) : String;
Var TempStr:String;
Begin
 Str(Value,TempStr);
 StrVal:=TempStr;
End;

Function ValStr(Str:String) : LongInt;
Var Code:Integer; TempInt:LongInt;
Begin
 Val(Str,TempInt,code);
 ValStr:=TempInt;
End;

Function Date : String;
Var
 Y,M,D,DoW:Word;
 MS,DS:String[2];
 YS:String[4];
Begin
 GetDate(Y,M,D,DoW);
 MS:=StrVal(M);
 DS:=StrVal(D);
 YS:=StrVal(Y);
 If Length(MS)<2 then MS:='0'+MS;
 If Length(DS)<2 then DS:='0'+DS;
 If Length(YS)<4 then
 Repeat
   YS:='0'+YS;
 Until Length(YS)>=4;
 Date:=MS+'/'+DS+'/'+YS;
End;

Procedure PressAKey;
Const
 More='<MORE>';
Var
 I:Byte;
 Junk:Char;
Begin
 Showln('');
  For I:=1 to Length(More) do
   Begin
    Show(Copy(More,I,1));
    Wait(50);
   End;
  Junk:=Readkey;
  For I:=1 to Length(MORE) do
   Show(#27+'[1D');
  For I:=1 to Length(More) do
   Begin
    Show(' ');
    Wait(50);
   End;
  Show('');
End;

Function AreYouSure : Boolean;
Var TKey:Char;
Begin
 Showln('');
 Show('  Are you SURE? [`0Y`2/`0N`2]  ');
 TKEY:=Readkey;
 If Upcase(Tkey)='Y' then
  AreYouSure:=True
 Else
  AreYouSure:=False;
 Showln('');
End;

Function NoCodes(InString:String) : String;
{$V-}
Var
 OK:Boolean;
 TempChar1,
 TempChar2: Char;
 I: Integer;
 TempStr:String;
Begin
 TempStr:='';
 If InString[1]<>'`' then TempStr:=TempStr+InString[1];
 For I:=2 to length(instring) do
  Begin
   OK:=True;
   TempChar1:=Instring[I-1];
   TempChar2:=InString[I];
   If ((TempChar1='`') or (TempChar2='`')) then OK:=False else OK:=True;
   If OK then
    Begin
     TempStr:=TempStr+TempChar2;
    End;
  End;
 NoCodes:=TempStr;
{$V+}
End;

Procedure GetPlayer (Var Player:Player_Info; Name:String);
Var TempStr1,TempStr2:String; PlayerFile:File of Player_info;
Begin
 Assign(PlayerFile,'player.dat');
 LockFile('Player.Dat');
 Reset(PlayerFile);
 TempStr2:=UpCaseString(Name);
 While not EOF(PlayerFile) do
  Begin
   Read(PlayerFile, Player);
   TempStr1:=UpCaseString(Player.Names);
   If TempStr1=TempStr2 then
    Begin
     Close(PlayerFile);
     UnLockFile('Player.Dat');
     Exit;
    End;
  End;
 UnlockFile('Player.Dat');
 Writeln('Player Not Found Error');
end;

Procedure PutPlayer (Player:Player_Info; Name:String);
Var TempFile,PlayerFile:File of Player_Info; TPlayer:Player_Info;
Begin
 Assign(TempFile,'Temp.WWW');
 Assign(PlayerFile,'Player.Dat');
 LockFile('Temp.www');
 LockFile('Player.Dat');
 Rewrite(TempFile);
 Reset(PlayerFile);
 While not EOF(PlayerFile) do
  Begin
   Read(PlayerFile, TPlayer);
   If UpCaseString(TPlayer.Names)=UpCaseString(Name) then
    Begin
     Write(TempFile,Player);
    End
   Else
    Write(TempFile,TPlayer);
  End;
 Reset(TempFile);
 Rewrite(PlayerFile);
 While not EOF(TempFile) do
  Begin
   Read(TempFile, TPlayer);
   Write(PlayerFile, TPlayer);
  End;
 Close(PlayerFile);
 Close(TempFile);
 UnlockFile('Player.Dat');
 UnlockFile('Temp.WWW');
 EraseFile('Temp.WWW');
end;

End.