unit ddansi2s;

interface

uses dos, crt;
{----------------------------------------------------------------------------}
{                       Ansi screen emulation routines                       }
{                              By Scott Baker                                }
{                        Revised By Derrick Parkhurst
{----------------------------------------------------------------------------}
{                                                                            }
{ Purpose: to execute ansi escape sequences locally. This includes changing  }
{          color, moving the cursor, setting high/low intensity, setting     }
{          blinking, and playing music.                                      }
{                                                                            }
{ Remarks: These routines use a few global variables which are defined       }
{          below. So far, only ESC m, J, f, C, and ^N are supported by these }
{          routines. I hope to include more in the future.                   }
{                                                                            }
{ Routines: Here is a listing of the subroutines:                            }
{                                                                            }
{             change_color(x):      Change to ansi color code X.             }
{             Eval_string(s):       Evaluate/execute ansi string             }
{             ansi_write(ch):       Write a character with ansi checking     }
{                                                                            }
{----------------------------------------------------------------------------}

var
 escape,blink,high,norm,any,any2,fflag,gflag: boolean;
 ansi_string: string;
const
 ddansibanner: boolean = true;

procedure ansi_write(ch: char);
procedure ansi_write_str(var s: string);
procedure initddansi;

implementation

const
 scale: array[0..7] of integer = (0,4,2,6,1,5,3,7);
 scaleh: array[0..7] of integer = (8,12,10,14,9,13,11,15);
var
 bbb: boolean;
 t: char;
 restx,resty,curcolor: integer;
 Note_Octave: integer;
 Note_Fraction, Note_Length, Note_Quarter: real;

procedure change_color(c: integer);
begin;
 case c of
  00: begin;any:=true;blink:=false;high:=false;norm:=true;end;
  01: begin;high:=true;end;
  02: begin;clrscr;any:=true;end;
  05: begin;blink:=true;any:=true;end;
 end;
 if (c>29) and (c<38) then begin;
  any:=true;
  any2:=true;
  c:=c-30;
  curcolor:=c;
  if (high=true) and (blink=true) then textcolor(scaleh[c]+128);
  if (high=true) and (blink=false) then textcolor(scaleh[c]);
  if (high=false) and (blink=true) then textcolor(scale[c]+128);
  if (high=false) and (blink=false) then textcolor(scale[c]);
  fflag:=true;
 end;
 if (c>39) and (c<48) then begin;
  any:=true;
  c:=c-40;
  textbackground(scale[c]);
  gflag:=true;
 end;
end;

procedure eval_string(var s: string);
var
 cp: integer;
 T: CHAR;
 jj,tt,ttt,tttt: integer;
 flag1:boolean;
begin;
 t:=s[length(s)];
 cp:=2;
 case t of
  'k','K': clreol;
  'u': gotoxy(restx,resty);
  's': begin;
        restx:=wherex;
        resty:=wherey;
       end;
  'm','J':begin;
           repeat;
            tt:=-1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
             change_color(tt);
            end;
            cp:=cp+1;
           until cp>=length(s);
           if norm=true then begin;
             if (fflag=false) and (gflag=false) then begin;textcolor(7);textbackground(0);curcolor:=7;end;
             if (fflag=false) and (gflag=true) then begin;textcolor(7);curcolor:=7;end;
             if (high=true) and (fflag=false) then textcolor(scaleh[curcolor]);
             if (blink=true) and (fflag=false) then textcolor(scale[curcolor]+128);
             if (blink=true) and (high=true) and (fflag=false) then textcolor(scaleh[curcolor]+128);
             if (fflag=true) and (gflag=false) then begin;textbackground(0);end;
            end;
           if any=false then textcolor(scaleh[curcolor]);
           if (high=true) and (any2=false) then textcolor(scaleh[curcolor]);
           any2:=false;any:=false;fflag:=false;gflag:=false;norm:=false;
         end;
   'C': begin;
            tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
            end else tt:=1;
            ttt:=wherex;
            if tt+ttt<=80 then gotoxy(tt+ttt,wherey);
           end;
   'D': begin;
            tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
            end else tt:=1;
            ttt:=wherex;
            if ttt-tt>=1 then gotoxy(ttt-tt,wherey);
           end;
   'A': begin;
            tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
            end else tt:=1;
            ttt:=wherey;
            if ttt-tt>=1 then gotoxy(wherex,ttt-tt);
           end;
   'B': begin;
            tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
            end else tt:=1;
            ttt:=wherey;
            if ttt+tt<=25 then gotoxy(wherex,ttt+tt);
           end;
  'f','H': begin;
           flag1:=false;
           tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
              flag1:=true;
             end;
            end else tt:=1;
            jj:=tt;
            if flag1=false then cp:=cp+1;
            if flag1=true then cp:=cp+2;
            if cp<length(s) then begin;
            tt:=1;
            val(s[cp],tt,tttt);
            if tttt=0 then begin;
             cp:=cp+1;
             val(s[cp],ttt,tttt);
             if tttt=0 then begin;
              tt:=tt*10;
              tt:=tt+ttt;
             end;
            end else tt:=1;
           end else tt:=1;
          gotoxy(tt,jj);
       end;
  else writeln(s);
 end;
end;

Procedure ansi_write(ch: char);
begin;
  case ch of
   #12: clrscr;
   #09: repeat; write(' '); until wherex/8 = wherex div 8;
   #27: begin; escape:=true; bbb:=true; end;

   else begin;
    if escape then begin;
     if (bbb=true) and (ch<>'[') then begin;
      blink:=false;
      high:=false;
      escape:=false;
      ansi_string:='';
      write(#27);
     end else bbb:=false;
     if escape then begin;
      ansi_string:=ansi_string+ch;
      if ch=#13 then escape:=false;
      if (ch in ['u','s','A','B','C','D','H','m','J','f','K','k',#14]) then begin;
       escape:=false;
       eval_string(ansi_string);
       ansi_string:='';
      end;
     end;
    end else write(ch);
   end;
  end;
end;

Procedure ansi_write_str(var s: string);
var
 a: integer;
ch: char;
begin;
 escape:=false;
 ansi_string:='';
 blink:=false;
 high:=false;

for a:=1 to length(s) do begin;
  case s[a] of
   #12: clrscr;
   #09: repeat; write(' '); until wherex/8 = wherex div 8;
   #27: begin; escape:=true; bbb:=true; end;
  #96: begin;

          if not (a >= length(s)) then begin;
          inc(a);
     ch := s[a];
      if ch ='1' then TextColor(Blue);
      if upcase(ch) ='C' then begin; clrscr;
 escape:=false;
 ansi_string:='';
 blink:=false;
 high:=false;

writeln(''); writeln('');

 end;

         if ch ='2' then TextColor(Green);
         if ch ='3' then TextColor(Cyan);
         if ch ='4' then TextColor(Red);
         if ch ='5' then TextColor(Magenta);
         if ch ='6' then TextColor(Brown);
         if ch ='7' then TextColor(LightGray);
         if ch ='8' then TextColor(DarkGray);
         if ch ='9' then TextColor(LightBlue);
         if ch ='0' then TextColor(Lightgreen);
         if ch ='!' then TextColor(LightCyan);
         if ch ='@' then TextColor(LightBlue);
         if ch ='#' then TextColor(LightMagenta);
         if ch ='$' then TextColor(Yellow);
         if ch ='%' then TextColor(White);
         if ch ='b' then textcolor(20);
          if ch ='r' then begin;
                   inc(a);
                   ch := s[a];
     if ch ='1' then textbackground(1);
         if ch ='2' then textbackground(2);
         if ch ='3' then textbackground(3);
         if ch ='4' then textbackground(4);
         if ch ='5' then textbackground(5);
         if ch ='6' then textbackground(6);
         if ch ='7' then textbackground(7);
         if ch ='8' then textbackground(8);
         if ch='0' then textbackground(0);
 end;
      end;

   end;

   else begin;
    if escape then begin;
     if (bbb=true) and (s[a]<>'[') then begin;
      blink:=false;
      high:=false;
      escape:=false;
      ansi_string:='';
      write(#27);
     end else bbb:=false;
     if escape then begin;
      ansi_string:=ansi_string+s[a];
      if s[a]=#13 then escape:=false;
      if (s[a] in ['u','s','A','B','C','D','H','m','J','f','K','k',#14]) then begin;
       escape:=false;
       eval_string(ansi_string);
       ansi_string:='';
      end;
     end;
    end else write(s[a]);
   end;
  end;
 end;
end;

procedure InitDDAnsi;
begin;
 escape:=false;
 ansi_string:='';
 blink:=false;
 high:=false;
end;

end.