@Echo off
GOTO MAINPROC

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 Program name: NLSS.bat

      Purpose: Search through a current nodelist for a -given- _Fidonet_
               address, and display the nodelisted details.

    Arguments: %1 - node# to find (ZCs, RCs, NCs and regular nodes)
               %2 - path\nodelist.### (where the nodelist file is).

      Example: NLSS 1:123/456 NODELIST.###[Enter]
                 [...]
               [...Should find Ross Cassell's node...]
                 [...]

 This version: designed for a Nodelist updated since day #348 of 2007,
               which has -no- nodes in Zone 6 (in fact, not even a Zone
               6 entry at all).

NB - Requires: A _ZONE_1_ Fidonet nodelist (preferably a -copy- as the
               changed file required for use is useless to run nodediffs
               against), as only the Zone 1 version allows for a simple
               incremental progression through zone numbers during a
               search.

       "  "    Also, that nodelist has to be purged of any and all DOS
               redirection symbols which would otherwise preclude using
               a BATch file search solution, like so (using REPLACE.COM,
               below):

               REPLACE NODELIST.### "<" "["
               REPLACE NODELIST.### ">" "]"

       "  "    512 bytes DOS environment, where DOS keeps session
               information such as the PATH, TEMP and DIRCMD settings
               in.  The DOS default is only 256 bytes.  Settings can be
               changed via the Config.Sys file, like this:
               "SHELL=C:\COMMAND.COM C:\ /P /E:512 /F".

       "  "    FIND.EXE ----- supplied MS-DOS util.
                              (and COMMAND.COM for ECHO, IF & SET... =:)
       "  "    IFNUMBER.EXE - a free batch util by Frank Dethlefsen.
                              (*see IFNUMBER.ZIP)
       "  "    NSET.COM ----- util by Horst Schaeffer.
                              (*see HORST32.ZIP (NSET 2.1, I think))
       "  "    LMOD.COM ----- yet another util by Horst Schaeffer.
                              (*see LMOD13.ZIP)
       "  "    PSIS.COM ----- a free batch util by Greg Miskelly.
                              (*see PSIS-600.ZIP - I'm using 5.00)
       "  "    REPLACE.COM -- Gene Garapic, 1987-88 (C) Ver 2.01.15
                              (*see REPLACE2.ZIP)

               * Available from a BFDS site near you.

       "  "    In its current form, the batch is =known= to run in only
               MS-DOS version 7.0x - it does execute nicely in a vBox
               emulation of MS-DOS 6.22 under linux.  It will most likely
               _not_ run under NT-based versions of Windows like NT, W2K,
               XP or Vista.  (It's do-able, just not at this stage.)

         Uses: %TEMP% variable setting for temporary files location,
               otherwise the root (\) directory is used.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   * Some of the above required utils can be found at:

     http://members.dodo.com.au/~colgilly/bat_utils.html

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:READNODE
  :: Pull the requested address to bits to be tested and used later...

  :: Extract the zone number from the input...
  ECHO %1|NSET /P1 /X: ZONE=$1

  :: Separate the net # (or region #) -and- node # (i.e. 999/9999)...
  ECHO %1|NSET /P2 /X: NETNODE=$1

  :: Grab the net # or region #...
  ECHO %NETNODE%|NSET /P1 /X/ NETREGON=$1

  :: Extract the node #...
  ECHO %1|NSET /P2 /X/ NODENUM=$2

  :: Test the elements for reasonableness...
    :: Zones #s between 1-5, thanks...
    IFNUMBER %ZONE% smallerthan 1
      IF ERRORLEVEL 1 GOTO ERRMSG_2
    IFNUMBER %ZONE% biggerthan 5
      IF ERRORLEVEL 1 GOTO ERRMSG_2

    :: Net/Region #s between 1-7211, only...
    IFNUMBER %NETREGON% smallerthan 1
      IF ERRORLEVEL 1 GOTO ERRMSG_2
    IFNUMBER %NETREGON% biggerthan 7211
      IF ERRORLEVEL 1 GOTO ERRMSG_2

    :: Node #s between 0-9999 (0=clerical entry)...
    IFNUMBER %NODENUM% smallerthan 0
      IF ERRORLEVEL 1 GOTO ERRMSG_2
    IFNUMBER %NODENUM% biggerthan 9999
      IF ERRORLEVEL 1 GOTO ERRMSG_2
GOTO WRITZONE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:WRITZONE
  :: Write a temporary zone file (instead of using the whole nodelist)...

  :: There are 3 possible exit conditions from this section:
  :: 1 - for zone #s less than 5, the next sequential zone # is computed
  ::     and found, in which case program flow is directed to the zone
  ::     search section
  :: 2 - otherwise, if the target zone is the last one listed then an
  ::     alternate method is used to determine the extent of the target
  ::     zone's listings and program flow is then directed to the zone
  ::     search section
  :: 3 - else an error condition exists, in which case the program is
  ::     exited.

  :: ********* What line# is the target %ZONE% at, in the NODELIST (%2)?
  SET TESTFILE=FIND
  FIND /N /I "Zone,%ZONE%," %2
  :: Was there a FIND-specific error?
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO EL_ERR_1
  SET TESTFILE=NSET
  FIND /N /I "Zone,%ZONE%," %2|NSET /P2 /L3 /X] COUNTER=$1
  :: Was there an NSET-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1


  :: We have a nodelist with _no_ final Zone 6 'placekeeper'...
  IFNUMBER %ZONE% equival 5
    IF ERRORLEVEL 1 GOTO LASTZONE


  :: *** For zones 1-4, where is the next Zone entry at in the NODELIST?
  :: Calculate the next zone #...
  PSIS ADD %ZONE% 1
  SET NEXTZONE=%PSIS%

  SET TESTFILE=FIND
  FIND /N /I "Zone,%NEXTZONE%," %2
  :: Was there a FIND-specific error?
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO EL_ERR_1
  SET TESTFILE=NSET
  FIND /N /I "Zone,%NEXTZONE%," %2|NSET /P2 /L3 /X] LINECONT=$1
  :: Was there an NSET-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1

  :: Decrement the next zone's line # (we want the target zone only)...
  PSIS SUB %LINECONT% 2
  SET LINECONT=%PSIS%

  :: Output the lines of text for the target zone to the ZONEFILE...
  TYPE %2|LMOD /L%COUNTER%-%LINECONT% [] >%TEMP%\ZONE_%ZONE%.TXT
GOTO USE_ZONE


:LASTZONE
  :: **** For zone #5, where is the end of the listings in the NODELIST?
  SET TESTFILE=FIND
  FIND /N "Flags authorized" %2
  :: Was there a FIND-specific error?
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO EL_ERR_1
  SET TESTFILE=NSET
  FIND /N "Flags authorized" %2|NSET /P2 /L3 /X] LINECONT=$1
  :: Was there an NSET-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1

  :: Decrement the counter to remove reference to the 'fluff' entries...
  PSIS SUB %LINECONT% 2
  SET LINECONT=%PSIS%

  :: Output the lines of text for the target zone to the ZONEFILE...
  TYPE %2|LMOD /L%COUNTER%-%LINECONT% [] >%TEMP%\ZONE_%ZONE%.TXT
GOTO USE_ZONE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                       PLACE ADVERTISEMENT HERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:USE_ZONE
  :: Search for the target node # in the temp zone file, checking for *C
  :: possibilities first...

  :: There are 5 possible exit conditions from this section:
  :: 1 - the target node is a zone, 2 - region or 3 - net (/0) admin
  ::     entry, in which case jump to the node display section (recall
  ::     that there isn't any node "0" listings in the nodelist)
  :: 4 - the target node # is discovered, in which case the program flow
  ::     is directed to the node display section
  :: 5 - an error condition exists, in which case the program is exited.

  :: Reseed the 'pointer' variable...
  SET COUNTER=0


  :: Exit condition #1: are we searching for a Z?C entry...?
  SET TESTFILE=FIND
  FIND /N /I "Zone,%ZONE%," %TEMP%\ZONE_%ZONE%.TXT
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO NETCHECK
  SET TESTFILE=NSET
  FIND /N /I "Zone,%ZONE%," %TEMP%\ZONE_%ZONE%.TXT|NSET /P2 /L3 /X] COUNTER=$1
  :: Was there an NSET-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1

  :: There's an implied AND operation on 2x IFs here...
  IF [%ZONE%]==[%NETREGON%] IF [%NODENUM%]==[0] GOTO FOUND_IT


  :: Exit conditions #2 & #3: are we looking for a RC or NC admin entry?
  :: What line# is the target %NETREGON% at, in the ZONELIST
  :: Are we after a Region: node or *C...?
  SET TESTFILE=FIND
  FIND /N /I "Region,%NETREGON%," %TEMP%\ZONE_%ZONE%.TXT
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO NETCHECK
  SET TESTFILE=NSET
  FIND /N /I "Region,%NETREGON%," %TEMP%\ZONE_%ZONE%.TXT|NSET /P2 /L3 /X] COUNTER=$1
  :: Was there an NSET-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1

  :: At this time the %TEXTLINE% could be an RC entry...?
  IF [%NODENUM%]==[0] GOTO FOUND_IT

  :NETCHECK
  :: Okay it's not a Region, so what line# is the target NET at then...?
  SET TESTFILE=FIND
  FIND /N /I "Host,%NETREGON%," %TEMP%\ZONE_%ZONE%.TXT
  IF ERRORLEVEL 2 GOTO EL_ERR_2
  IF ERRORLEVEL 1 GOTO NODECHEK
  SET TESTFILE=NSET
  FIND /N /I "Host,%NETREGON%," %TEMP%\ZONE_%ZONE%.TXT|NSET /P2 /L3 /X] COUNTER=$1
  :: Was there an NSET-specific error in any case?
  IF ERRORLEVEL 1 GOTO EL_ERR_1

  :: Okay... %TEXTLINE% could be an NC entry...?
  IF [%NODENUM%]==[0] GOTO FOUND_IT


  :NODECHEK
  :: Exit condition #4: look for the required grunt node, then...
  :: Increment the line counter and keep looking...
  PSIS INC COUNTER 1

  :: ********** Look at the ZONELIST, analyzing the found %TEXTLINE% ...
  :NEXTLINE
    :: Copy the current %TEXTLINE% from %TEMP%\ZONE_%ZONE%.TXT...
    SET TESTFILE=LMOD
    :: Under MS-DOS 6.22, copying the -whole- line causes an error for
    :: any line longer than (say) 100 characters, so we just copy the
    :: first -10- chars of %TEXTLINE% from %TEMP%\ZONE_%ZONE%.TXT when
    :: testing for various address possibilities...
    LMOD /L%COUNTER% set TEXTLINE=[1,10] <%TEMP%\ZONE_%ZONE%.TXT >%TEMP%\temp.bat
    :: Was there an LMOD-specific error?
    IF ERRORLEVEL 1 GOTO EL_ERR_1
    CALL %TEMP%\temp.bat

      SET TESTFILE=FIND
      :: Analyze the %TEXTLINE% seeking the target ",%NODENUM%," string...
      ECHO %TEXTLINE%|FIND /N ",%NODENUM%,"
      :: Was there a FIND-specific error?
      IF ERRORLEVEL 2 GOTO EL_ERR_2
      :: Was there a no-find error?
      IF ERRORLEVEL 1 GOTO REGIONET

        :: Oops, we just found the node!?!?!
        IF ERRORLEVEL 0 GOTO FOUND_IT

      :REGIONET
      :: Check for another Region/0 or Net/0 entry in case of a "no find"
      :: condition for a =node=, as we're tripping through the zone's
      :: file...
      ECHO %TEXTLINE%|FIND /N /I "Region,"
      :: Was there a FIND-specific error?
      IF ERRORLEVEL 2 GOTO EL_ERR_2
      :: Was there a no-find error?  If so, keep looking...
      IF ERRORLEVEL 1 GOTO NET_CHEK
      :: Uh, oh.  We've run out of listings in the current Region...
      IF ERRORLEVEL 0 GOTO STOPHERE

      :NET_CHEK
      ECHO %TEXTLINE%|FIND /N /I "Host,"
      :: Was there a FIND-specific error?
      IF ERRORLEVEL 2 GOTO EL_ERR_2
      :: Was there a no-find error?  If so, keep looking...
      IF ERRORLEVEL 1 GOTO FINDNODE
      :: Uh, oh.  We've run out of listings in the current Net...
      IF ERRORLEVEL 0 GOTO STOPHERE

    :FINDNODE
    :: Else, increment the line counter and keep looking...
    PSIS INC COUNTER 1

    :: Any more %TEXTLINE%s to be processed?
    IFNUMBER %COUNTER% smallerequivalthan %LINECONT%
  :: Bummer, IFNUMBER error...
  IF ERRORLEVEL 255 GOTO ERRMSG_2
  :: If %COUNTER% is *_NOT_* bigger than %LINECONT%... look at the next
  ::                                                      %TEXTLINE%...
  IF ERRORLEVEL 1 GOTO NEXTLINE
  :: Uh oh! %COUNTER% is greater than %LINECONT% so, no more %TEXTLINE%s
  :: -AND- we still haven't found the target node - something's wrong!!!
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:FOUND_IT
  :: Display the found node's details using the contents of %TEXTLINE%...
  
  :: Re-read the -whole- %TEXTLINE% from %TEMP%\ZONE_%ZONE%.TXT, since
  :: it's now only required to -display- the target node's listing...
  SET TESTFILE=LMOD
  LMOD /L%COUNTER% set TEXTLINE=[] <%TEMP%\ZONE_%ZONE%.TXT >%TEMP%\temp.bat
  :: Was there an LMOD-specific error?
  IF ERRORLEVEL 1 GOTO EL_ERR_1
  CALL %TEMP%\temp.bat

  Echo +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Echo You asked for %1, which should be this entry:
  Echo.
  echo %TEXTLINE%
  Echo.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:HELP
  ECHO  Search through a current nodelist for a -given- Fidonet address.
  ECHO  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  ECHO.
  ECHO  Usage:   NLSS   target_address   path_to_nodelist
  ECHO  =====          (format #:##/##)
  ECHO.
  ECHO  The following (external) utils _must_ be available on the DOS
  ECHO  search PATH -
  ECHO        IFNUMBER.EXE --- a free batch util by Frank Dethlefsen.
  ECHO        LMOD.COM ------- yet another util by Horst Schaeffer.
  ECHO        NSET.COM ------- yet another util by Horst Schaeffer.
  ECHO        PSIS.COM ------- a free batch util by Greg Miskelly.
  ECHO        REPLACE.COM ---- Gene Garapic, 1987-88 (C) Ver 2.01.15
  ECHO.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                       THIS SPACE AVAILABLE FOR RENT

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:EL_ERR_1
  Echo General-purpose error trapper for FIND/LMOD/NSET.
  Echo.
  Echo  Errorlevel 0:ok, 1:invalid token/expression, 2:invalid options.
  Echo  Therefore, testing for EL=>1 is enough.
  Echo.
  Echo  An error occurred in %TESTFILE%.
  Echo.
  Echo  %0 is now stopping...
  Echo.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:EL_ERR_2
  Echo Specific error on exit trap for FIND.
  Echo.
  Echo The search was not completed successfully.  In this case, an
  Echo error occurred during the search, and FIND cannot report whether
  Echo any matches were found.
  Echo.
  Echo  A serious error occurred in %TESTFILE%.
  Echo.
  Echo  %0 is now stopping...
  Echo.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:ERRMSG_1
  Echo We've tested for the existence of a file or directory and DOS has
  Echo come up empty-handed.
  Echo.
  Echo  Cannot find the required file, %2!
  Echo.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:ERRMSG_2
  Echo  IFNUMBER out of bounds error!
  Echo.
GOTO STOPHERE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:MAINPROC
  :: Main program section...

  ECHO  NLSS [ver 2.01.09]
  ECHO.

  :: ********** Check the command-line info...
  :: Maybe somone wants help, first...
  for %%f in (h H ?) do if [%1]==[/%%f] goto HELP
  for %%f in (h H ?) do if [%1]==[-%%f] goto HELP
  for %%f in (h H ?) do if [%1]==[%%f] goto HELP

  :: ********** Simple checks for the required params...
  IF [%2]==[] GOTO HELP
  IF NOT EXIST %2 GOTO ERRMSG_1
  IF [%1]==[] GOTO HELP

  :: Initialise the local-to-this-batch envars...
  FOR %%X IN (COUNTER LINECONT NETREGON) DO SET %%X=0
  FOR %%X IN (NEXTZONE NODENUM PSIS ZONE) DO SET %%X=0
  SET NETNODE=0/0
  SET TESTFILE=Some tool
  SET TEXTLINE=Line of text :)

  :: Temporary files created during execution...
  ::   %TEMP%\temp.bat
  ::   %TEMP%\ZONE_%ZONE%.TXT
GOTO READNODE

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:STOPHERE
:: Clean up the messy bits...

  ::xxxx Not needed as the REPLACE function is now an external step...
  ::xxxx ERASE %TEMP%\nodelist.*
  IF EXIST %TEMP%\temp.bat ERASE %TEMP%\temp.bat
  IF EXIST %TEMP%\ZONE_%ZONE%.TXT ERASE %TEMP%\ZONE_%ZONE%.TXT

  FOR %%X IN (COUNTER LINECONT NETNODE NEXTZONE PSIS) DO SET %%X=
  FOR %%X IN (NODENUM NETREGON TESTFILE TEXTLINE ZONE) DO SET %%X=

Echo [End of job.]

  :: End of procedure.      ---===[ * * * ]===---
  :: %0 is *free*  Enjoy!  8-)  Paul D. Quinn
:: FidoNet: 3:640/384, e-mail: eskimo261@bigfoot.com - 30 August 2008.