program FilesRAX;
(*
** FILES.RA Converter for EleBBS/RemoteAccess
**
** This utility converts the LongPathNames in FILES.RA
** to the DOS compatible shortf~1 equlivent.
*)

uses crt, dos, windows, cfgrec;

function shortname(path: string): string;
var templen:longint;
tempstr: string;
begin
    Path := Path + #00;
    TempLen := GetShortPathName(@Path[1], @TempStr[1], SizeOf(TempStr));
    TempStr[0] := Chr(TempLen);
    shortname:=tempstr;
end;

var orig_F: file;
    dest_F: file;
    ff: filesrecord;
begin
  assign(orig_F, 'files.ra');
  reset(orig_F, 1);

  assign(Dest_f, 'files.newfile');
  rewrite(dest_f, 1);

  while not eof(orig_F) do
    begin
      blockread(orig_F, ff, sizeof(ff));

      WriteLn(Ff.FilePath, ' -> ', shortname(ff.filepath));
      ff.filepath := shortname(ff.filepath);

      blockwrite(dest_f, ff, sizeof(ff));
    end;

  close(orig_F);
  close(Dest_f);
end.
