REM Sample program to read dos standard input piping. v1.0a PD 2006.

REM To use, redirect a file into pipe, for example:

REM   Type test.txt | pipe

REM Or, try stdout:

REM   Type test.txt | pipe > file.out

'--------D-213F-------------------------------
'INT 21 - DOS 2+ - "READ" - READ FROM FILE OR DEVICE
'        AH = 3Fh
'        BX = file handle
'        CX = number of bytes to read
'        DS:DX -> buffer for data
'Return: CF clear if successful
'            AX = number of bytes actually read (0 if at EOF before call)
'        CF set on error
'            AX = error code (05h,06h) (see #01680 at AH=59h/BX=0000h)
'
'--------D-2142-------------------------------
'INT 21 - DOS 2+ - "LSEEK" - SET CURRENT FILE POSITION
'        AH = 42h
'        AL = origin of move
'            00h start of file
'            01h current file position
'            02h end of file
'        BX = file handle
'        CX:DX = (signed) offset from origin of new file position
'Return: CF clear if successful
'            DX:AX = new file position in bytes from start of file
'        CF set on error
'            AX = error code (01h,06h) (see #01680 at AH=59h/BX=0000h)

' read interrupt structures
REM $INCLUDE: 'qbx.bi'

' declare interrupt structures
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

' declare pipe buffer
DIM Buffer AS STRING * 1

' move pointer to stdin eof
InregsX.AX = &H4202 ' eof
InregsX.BX = 0 ' stdin
InregsX.CX = 0
InregsX.DX = 0
Call InterruptX(&H21, InregsX, OutregsX)

' check stdin length
If OutregsX.AX = 0 Then
   End
Endif

' move pointer to stdin start of file
InregsX.AX = &H4200
InregsX.BX = 0 ' stdin
InregsX.CX = 0
InregsX.DX = 0
Call InterruptX(&H21, InregsX, OutregsX)

' start input loop
Do
   ' read from device
   InregsX.AX = &H3F00
   InregsX.BX = 0 ' stdin
   InregsX.CX = 1 ' char
   InregsX.DS = VARSEG(Buffer)
   InregsX.DX = VARPTR(Buffer)
   Call InterruptX(&H21, InregsX, OutregsX)

   ' check flag error
   If (OutregsX.Flags AND &H1) = &H1 Then
      Exit Do
   Endif

   ' check length of input
   If OutregsX.AX = 0 Then
      Exit Do
   Endif

   ' process stdin character
   Select Case Buffer
   Case Chr$(10)
   Case Chr$(13)
      Print
   Case Chr$(26)
      Exit Do
   Case Else
      Print Buffer;
   End Select
Loop
End
