REM Quick Library Viewer Program PD 2005.

REM QLBView displays the procedures contained in a Quick Library.

CONST FALSE = 0
CONST TRUE = NOT FALSE

TYPE ExeHdr                  ' Part of DOS .EXE header
    other1    AS STRING * 8  ' Other header information
    CParHdr   AS INTEGER     ' Size of header in paragraphs
    other2    AS STRING * 10 ' Other header information
    IP        AS INTEGER     ' Initial IP value
    CS        AS INTEGER     ' Initial (relative) CS value
END TYPE

TYPE QBHdr                   ' QLB header
    QBHead    AS STRING * 6  ' QB specific heading
    Magic     AS INTEGER     ' Magic word: identifies file as
                             ' a Quick library
    SymStart  AS INTEGER     ' Offset from header to first code symbol
    DatStart  AS INTEGER     ' Offset from header to first data symbol
END TYPE

TYPE QbSym                   ' QuickLib symbol entry
    Flags     AS INTEGER     ' Symbol flags
    NameStart AS INTEGER     ' Offset into name table
    other     AS STRING * 4  ' Other header info
END TYPE

DIM SHARED EHdr AS ExeHdr, QHdr AS QBHdr, QHdrPos AS LONG
DIM SHARED FileName$, PathName$
DIM SHARED FileNum%

DIM QuickLib AS STRING
PRINT "Enter .qlb filename: ";
LINE INPUT QuickLib

' Open Quick Library.
FileNum% = 1
OPEN QuickLib FOR BINARY AS #FileNum%

GET #FileNum%, , EHdr               ' Read the EXE format header.
temp& = EHdr.CParHdr + EHdr.CS      'Use a LONG temp to prevent overflow.
QHdrPos = temp& * 16 + EHdr.IP + 1

GET #FileNum%, QHdrPos, QHdr        ' Read the QuickLib format header.
IF QHdr.Magic <> &H6C75 THEN
   PRINT QuickLib; ": Not a valid Quick Library."
ELSE
   DIM QlbSym AS QbSym
   DIM NextSym AS LONG, CurrentSym AS LONG

   ' Calculate the location of the first symbol entry, then read that entry:
   NextSym = QHdrPos + QHdr.SymStart
   GET #FileNum%, NextSym, QlbSym

   DO
      NextSym = SEEK(FileNum%)          ' Save the location of the next
                                        ' symbol.
      CurrentSym = QHdrPos + QlbSym.NameStart
      SEEK #FileNum%, CurrentSym        ' Use SEEK to move to the name
                                        ' for the current symbol entry.
      Prospect$ = INPUT$(40, #FileNum%) ' Read the longest legal string,
                                        ' plus one additonal byte for the
                                        ' final null character (CHR$(0)).

      ' Extract the null-terminated name:
      SName$ = MID$(Prospect$, 1, INSTR(Prospect$, CHR$(0)))

      ' Filter out reserved routines that have a Quick library interface.
      temp$ = UCASE$(SName$)
      IF MID$(temp$, 1, 1) <> "_" AND MID$(temp$, 1, 1) <> "$" AND UCASE$(MID$(temp$, 1, 2)) <> "B$" AND LEFT$(temp$, 8) <> "FO_TEXT_" THEN
         IF MID$(temp$, 1, 12) <> "GETCONTAINER" AND MID$(temp$, 1, 11) <> "GETPROPERTY" AND MID$(temp$, 1, 11) <> "INVOKEEVENT" AND MID$(temp$, 1, 12) <> "INVOKEMETHOD" THEN
            IF MID$(temp$, 1, 11) <> "SETPROPERTY" AND MID$(temp$, 1, 9) <> "SETUEVENT" AND MID$(temp$, 1, 12) <> "STRINGASSIGN" AND MID$(temp$, 1, 13) <> "STRINGRELEASE" THEN
               IF MID$(temp$, 1, 13) <> "STRINGADDRESS" AND MID$(temp$, 1, 12) <> "STRINGLENGTH" THEN
                  PRINT SName$
               END IF
            END IF
         END IF
      END IF

      GET #FileNum%, NextSym, QlbSym    ' Read a symbol entry.
   LOOP WHILE QlbSym.Flags       ' Flags=0 (false) means end of table.
END IF
CLOSE #FileNum%
END

