unit toyinfo;
{$O+,F+}

interface

function armorname(x:integer):string;
function weaponname(x:integer):string;

implementation

uses bbskv,bbskern,engine2,rgoods;

type istr=string[39];
     iptr=^istr;

var weapon:array[0..160] of iptr;
    armor:array[0..160] of iptr;
    tf:text;
    index:word;
    tstr:istr;
    done:boolean;

function weaponname(x:integer):string;
begin
  if x<0 then begin weaponname:='Invalid Selection'; exit; end;
  if x=9999 then begin weaponname:='`C** `PEnchanted Elixir of the Ghods `C**`G'; exit; end;
  if x>maxweapon then begin weaponname:='+'+int2str(x-maxweapon)+' '+weapon[maxweapon]^; exit; end;
  weaponname:=weapon[x]^;
end;

function armorname(x:integer):string;
begin
  if x<0 then begin armorname:='Invalid Selection'; exit; end;
  if x=9999 then begin armorname:='`D** `LBelt of Damnation `D**`G'; exit; end;
  if x>maxarmor then begin armorname:='+'+int2str(x-maxarmor)+' '+armor[maxarmor]^; exit; end;
  armorname:=armor[x]^;
end;

begin
  {This is the only unit which critically depends on its initialization}
  {block.  Here we load the weapons and armor into heap memory.}

  assign(tf,'TOYS.LST');
  reset(tf);
  done:=false;
  index:=0;
  repeat
    if eof(tf) then done:=true;
    readln(tf,tstr);
    new(weapon[index]);
    weapon[index]^:=tstr;
    inc(index);
  until done;
  close(tf);
  maxweapon:=index-2;
  if debugmode then writeln(maxweapon);

  assign(tf,'DEFENSE.LST');
  reset(tf);
  index:=0;
  done:=false;
  repeat
    if eof(tf) then done:=true;
    readln(tf,tstr);
    new(armor[index]);
    armor[index]^:=tstr;
    inc(index);
  until done;
  close(tf);
  maxarmor:=index-2;
  if debugmode then writeln(maxarmor);

end.
