unit robot;
{$O+,F+}
{$E+}
{$N+}
{$D-,L-}
interface

procedure payrobots;
procedure moverobots;
procedure quikemove;
procedure startlog;

implementation

uses dos,crt,bbskv,bbskern,engine2,rgoods,usered,toyinfo,miscpl5,sys_msg;


var user:userrec;
    tstr:string;
    tmp:longint;
    currentuser:word;
    quit:boolean;

    temp1,temp2:string;
    tempor:t_orientation;
    tempgen:t_gender;
    tempmode:byte;

    thisroom:roomrec;
    roomno:word;

    mazefile:file of roomrec;
    mxrm:integer;

procedure loadrooms;
begin
  if mxrm<>0 then exit;
  if
    not(exist(mazname))
  then
    begin
      writeln;
      writeln('No maze file!  Run RANCHO -M first!');
      halt;
    end;
  assign(mazefile,mazname);
  reset(mazefile);
  mxrm:=filesize(mazefile);
  index:=1;
  repeat
    read(mazefile,room^[index]);
    inc(index);
  until (eof(mazefile) or (index>mxrm));
  close(mazefile);
end;

function goodroom(roomno:word):boolean;
var tmp:boolean;
    t2:word;
begin
  tmp:=true;
  t2:=(room^[roomno].room_north)
     +(room^[roomno].room_south)
     +(room^[roomno].room_east)
     +(room^[roomno].room_west)
     +(room^[roomno].room_up)
     +(room^[roomno].room_down);
  tmp:=(t2>0);
  goodroom:=tmp;
end;

function findroom:word;
var tmproom:word;
    done:boolean;
begin
  done:=false;
  repeat
    begin
      tmproom:=random(mxrm)+1;
      if goodroom(tmproom) then done:=true;
    end;
  until done;
  findroom:=tmproom;
end;

function paygold(level:integer):comp;
var tmp1,tmp2,t3:comp;
begin
  t3:=level;
  tmp1:=t3*t3*50;
  tmp2:=hugernd(tmp1);
  paygold:=tmp1+tmp2;
end;

procedure payrobots;
var uf,uf2:file of userrec;
    tu:userrec;
    index:word;
    tmp:comp;
begin
  sysmsg(700);
  if maxuser=0 then exit;
  index:=1;
  repeat
    user:=userlog^[index];
    if
      user.robot
    then
      begin
        tmp:=paygold(user.level); tmp:=tmp*2.0;
        tmp:=(tmp*user.robotfactor)/128.0;
        tmp:=hugernd(tmp);
        tmp:=(tmp*config.robotpaypercent)/100.0;
        user.gp:=user.gp+tmp;
      end;
    userlog^[index]:=user;
    inc(index);
  until index>maxuser;
end;

procedure quikemove;
var index:byte;
begin
  if mxrm=0 then loadrooms;
  totallines:=0;
  sysmsg(701);
  for index:=1 to maxuser
  do
    if
      userlog^[index].robot
    then
      begin
        userlog^[index].room:=findroom;
        send('.'); totallines:=0;
      end;
  sysmsg(702);
  writeuserlog;
end;

procedure startlog;
var f:text;
    tstr:string;
    i,j,lines:integer;
begin
  nukefile('RANCHO.LOG');
  log('');
  if
    exist('STARTDAY.DAT')
  then
    begin
      assign(f,'STARTDAY.DAT');
      reset(f);
      lines:=0; while not(eof(f)) do begin inc(lines); readln(f,tstr); end;
      if
        lines=0
      then
        close(f)
      else
        begin
          reset(f);
          i:=random(lines);
          for j:=1 to i do readln(f,tstr);
          readln(f,tstr);
          close(f);
        end;
      safelog:=false;
      log(tstr);
    end
  else
    log('               `LA new day begins at Rancho Nevada!');
end;

procedure moverobots;
var tmp4,tmp5:longint;
    tu:userrec;
    t1,t2:byte;
    tc2,
    tcomp:extended;
    index:word;
    f:text;
    tstr:string;
    i,j,lines:integer;
    userdays:longint;
begin
  totallines:=0;
  verbbump:=false;
  sysmsg(703);
  loadrooms;
  if maxuser=0 then exit;
  startlog;

  for index:=1 to maxuser do
  begin
    user:=userlog^[index];
    userlog^[index].playstoday:=0;
    userdays:=userlog^[index].lastplayed;
{    w(user.name+' '+int2str(ds1970-userdays)); {beta code - view each user''s last call days since}
    if
      config.nukedays<>0
    then
      begin
        if
          ((ds1970-userdays)>config.nukedays) and (not(userlog^[index].robot)) and (not(userlog^[index].deleted))
        then
          begin
            writeln(userlog^[index].name,' has not played in ',config.nukedays,' days - deleting!');
            log(userlog^[index].name+' has not played in '+int2str(config.nukedays)+' days - deleting!');
            fryuser(userlog^[index]);
          end;
      end;
    if
      user.robot
    then
      begin
        send('.');
        totallines:=0;
        tmp:=user.stamina+user.skill+user.jwins-user.jlosses;
        if
          tmp<1
        then
          begin
            user.jlosses:=0;
            user.jwins:=0;
          end;
        user.weapon:=user.level*2;
        user.armor:=user.level;
        user.armor:=user.armor+(user.robotfactor div 64);
        user.weapon:=user.weapon+(user.robotfactor div 32);
        user.room:=findroom;
        if(user.robotfactor=0) then user.robotfactor:=random(256);
        tmp4:=((8*user.robotfactor) div 255)+1;
        tmp:=random(tmp4)+2;
        tmp:=(tmp*user.robotfactor) div 128;
        t1:=random(256);
        if (t1<user.robotfactor) then user.stamina:=user.stamina+tmp;
        tmp:=random(tmp4)+2;
        tmp:=(tmp*user.robotfactor) div 128;
        t1:=random(256);
        if (t1<user.robotfactor) then user.skill:=user.skill+tmp;
        tmp:=random(tmp4)+2;
        tmp:=(tmp*user.robotfactor) div 128;
        t1:=random(256);
        if (t1<user.robotfactor) then user.knowledge:=user.knowledge+tmp;
        tmp:=random(tmp4)+2;
        tmp:=(tmp*user.robotfactor) div 128;
        t1:=random(256);
        if (t1<user.robotfactor) then user.talent:=user.talent+tmp;

        tc2:=nextlevelxp(user.level+1)-nextlevelxp(user.level); {Find out the difference between this level's XP and next}
        tc2:=hugernd(tc2*2);  {Take a random of this, mul. by 2}
        tc2:=tc2*user.robotfactor/128; {Multiply by robotfaktor}
        tcomp:=tc2*config.robotxppercent/100;

        awardxp(user,tcomp);
        t1:=random(100);
        t2:=random(255);
        if
          (user.level>=105)  {Re-roll is automatic if an employee hits 105}
        or
          ((t1<config.robotreroll) and (t2>user.robotfactor))
        then
          begin {Re-Roll Employee}
            temp1:=user.name;
            temp2:=user.BBSname;
            tempor:=user.orientation;
            tempgen:=user.gender;
            tempmode:=user.attackmode;
            default(user);
            user.robot:=true;
            user.name:=temp1;
            user.BBSname:=temp2;
            user.gender:=tempgen;
            user.orientation:=tempor;
            user.attackmode:=tempmode;
            parameter[1]:=mixedcase(user.name);
            sysmsg(704);
          end;
        user.givenvd:=false;
        userlog^[index]:=user;
      end;
  end;
  payrobots;
  sysmsg(705);
  anykey;
end;

begin
  mxrm:=0;
end.
