
unit bldmaze;
{$O+,F+}
interface

uses dos,crt,bbskv,bbskern,sys_msg;

var linein:string;
    restofline:string;
    arg,arg2,arg3:string[64];
    parses:array[1..16] of string[20];
    v1,v2,v3,v4,v5,v6,v7,v8,v9:integer;
    v0:word;

procedure makemaze;
procedure parse;

implementation

{$I RN-STRUC.PAS}

type roomptr=^roomrec;

var
    ps:pathstr; ds:dirstr; ns:namestr; es:extstr;

    thisroom:roomrec;
    room:array[1..800] of roomptr;
    roomno:word;

    mazefile:file of roomrec;
    descfile:text;

    taskstr: string[2];
    workfile:text;
    fnam:string[80];
    tmp1,tmp2,tmp3,tmp4:string;
    comd:char;
    linenum,index2:integer;
    addressindex:integer;
    cfilename:string;
    totalrooms:integer;

procedure parse;
var index:integer;
begin
  fillchar(parses,sizeof(PARSES),chr(0));
(*  fillchar(days,sizeof(DAYS),chr(0));
  fillchar(months,sizeof(MONTHS),chr(0)); *)
  for index2:=1 to length(linein) do if linein[index2]=#9 then linein[index2]:=#32;
  while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
  index2:=one;
  repeat
    begin
      index:=one; {reset the counter}
      while ((copy(linein,index,one)<>' ') and (index <= length(linein))) do index:=index+one; {Seek out space}
      parses[index2]:=copy(linein,one,(index-one)); {When it finds space the length of the first string is index-1}
      delete(linein,one,index); {Get rid of that part of the input string; it's now in parse1}
      while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
      if index2=1 then restofline:=linein;
      inc(index2);
    end
  until((index2>4) or (length(linein)<1));
end; {Procedure Parse}

procedure processline;
var cml,cmle:string[64];
    cmle2,cmle3:string[3];
    index:integer;
    zone,net,node,point:word;
    s:string[10];
begin
  roomno:=1;
  addressindex:=0;
  for index:=1 to 3 do parses[index]:=upcasestr(parses[index]);
  cml:=copy(parses[1],1,2); arg:=parses[2]; arg2:=parses[3]; arg3:=parses[4];
  v2:=str2int(arg); v3:=str2int(arg2); v4:=str2int(arg3);

  if
    (cml='RO')
  then
    begin
      inc(totalrooms);
      fillchar(thisroom,sizeof(thisroom),#00);
      thisroom.attr:=$00;
      cmle:='';
      roomno:=v2;
      if (roomno>0) and (roomno<800) then
        begin
          thisroom:=room[roomno]^;
          repeat
            begin
              readln(workfile,linein);
              inc(linenum);
              parse;
              for index:=1 to 16 do parses[index]:=upcasestr(parses[index]);
              cmle:=parses[1]; arg:=parses[2]; arg2:=parses[3]; v2:=str2int(arg); v3:=str2int(arg2);
              cmle2:=copy(cmle,1,2); cmle3:=copy(arg,1,2);

              if (cmle2='NO') then thisroom.room_north:=v2;
              if (cmle2='SO') then thisroom.room_south:=v2;
              if (cmle2='EA') then thisroom.room_east:=v2;
              if (cmle2='WE') then thisroom.room_west:=v2;
              if (cmle2='UP') then thisroom.room_up:=v2;
              if (cmle2='DO') then thisroom.room_down:=v2;

              if (cmle2='DE') then thisroom.description:=restofline;
              if (cmle2='PA') then thisroom.parm:=v2;
              if (cmle2='EX') then begin
                                     s:='00000'+int2str(roomno);
                                     s:=copy(s,length(s)-4,5);
                                     writeln(descfile,s+' '+restofline);
                                   end;

              if
                (cmle2='SP')
              then
                begin
                  if
                    v2<>0
                  then
                    thisroom.special:=v2
                  else
                    begin
{VKR #01}             if (cmle3='VK') or (cmle3='HO') then thisroom.special:=1;
{Shop #02}            if cmle2='SHOP' then thisroom.special:=2;
{Bar #03}             if cmle3='BA' then thisroom.special:=3;
{Phone #04}           if cmle3='PH' then thisroom.special:=4;
{Terminal #05}        if cmle3='TE' then thisroom.special:=5;
{AVTerm #06}          if cmle3='AV' then thisroom.special:=6;
{ATM #07}             if cmle3='AT' then thisroom.special:=7;
{Jacuzzi #08}         if cmle3='JA' then thisroom.special:=8;
{Slot Machine #09}    if cmle3='SL' then thisroom.special:=9;
{Safe #10}            if cmle3='SA' then thisroom.special:=10;
{Condom Vender#11}    if (cmle3='CO') or (cmle3='PR') or (cmle3='VE') then thisroom.special:=11;
{Masseuse #12}        if cmle3='MA' then thisroom.special:=12;
{Shower #13}          if cmle2='SHOWER' then thisroom.special:=13;

                     end;
                end;

{Safe Room}   if (cmle2='SA') then thisroom.attr:=thisroom.attr+$80;
{Free Room}   if (cmle2='FR') then thisroom.attr:=thisroom.attr+$40;
{Dark Room}   if (cmle2='DA') then thisroom.attr:=thisroom.attr+$20;
              
            end;
          until (cmle2='EN');

              if
                (thisroom.room_north=roomno)
              or
                (thisroom.room_south=roomno)
              or
                (thisroom.room_east=roomno)
              or
                (thisroom.room_west=roomno)
              or
                (thisroom.room_up=roomno)
              or
                (thisroom.room_down=roomno)
              then
                begin
                  writeln;
                  writeln('Warning: Room #',roomno,' is self-referential!');
                end;
          room[roomno]^:=thisroom;
        end;
    end;

end;

procedure makemaze;
begin
  linenum:=0;
  clrscr;
  totalrooms:=0;
  sysmsg(20);
  fillchar(thisroom,sizeof(thisroom),#0);
  for index:=1 to 800 do begin new(room[index]); room[index]^:=thisroom; end;

  cfilename:='MAZE.CTL';
  if
    (not exist(cfilename))
  then
    begin
      sysmsg(21);
      halt;
    end;
  assign(workfile,cfilename);
  assign(descfile,'MAZEDESC.TXT'); rewrite(descfile);
  reset(workfile);
  repeat
    begin
      readln(workfile,linein);
      inc(linenum);
      parse;
      processline;
    end;
  until eof(workfile);
  close(workfile);
  close(descfile);

  assign(mazefile,'RANCHO.MAZ');
  rewrite(mazefile);
  for index:=1 to 800 do write(mazefile,room[index]^);
  close(mazefile);
  parameter[1]:=int2str(totalrooms); sysmsg(22);
end;

begin
end.

;
;               1 -- Hall of Fun
;               2 -- Toy Shoppe
;               3 -- Bar
;               4 -- Pay Phone
;               5 -- Computer Terminal
;               6 -- AV Station
;               7 -- ATM
;               8 -- Jacuzzi
;               9 -- Slot Machine
;               10 -- Safe (1 in 10,000 chance of getting $10,000*level)
;               11 -- Protection machine (cost 20% more than Annies)
;               12 -- Masseuse (restore R/L for $5*(level^1.5) per R/L point)
;               13 -- Showers (same chance of l/r restore as jacuzzi, uses a jacuzzi point)
