UNIT EASup ;

INTERFACE

USES dos, crt, JPDoor32, EADef ;

TYPE
   charset  = SET OF #0..#255 ;
   STR2     = STRING[2] ;
   STR7     = STRING[7] ;
   STR12    = STRING[12] ;
   STR35    = STRING[35] ;

   UseRec   = RECORD
                 Node       : STR2 ;
                 Player     : STR35 ;
                 Activity   : BYTE ;
                    { Activity        Description
                         1            Normal play
                         2            Processing tournament files
                         3            Logging on
                    }
              END ;


CONST
		 hialpha  : charset = ['A'..'Z'];
		 loalpha  : charset = ['a'..'z'];
		 digits   : charset = ['0'..'9'];
		 puncset  : charset = ['!'..'/','['..'''','{'..'~'];

FUNCTION hex(n:Word):STRING;
FUNCTION bin(n:Word):STRING;
FUNCTION FixByte(n:WORD):STR2 ;
FUNCTION Strn(n:LongInt) : STR7 ;
FUNCTION tabstr(instr : STRING;n:Byte):STRING;
FUNCTION triml(instr:STRING):STRING;
FUNCTION trimr(instr:STRING):STRING;
FUNCTION trimall(instr:STRING):STRING;
FUNCTION lowcase(ch:Char):Char;
FUNCTION strc(ii:LONGINT) : STRING ;
FUNCTION Half(n:LONGINT) : LONGINT ;
PROCEDURE ShowText(Fname:STRING) ;
FUNCTION AtoI(Tstr:STRING) : LONGINT ;
PROCEDURE TinyFlag ;
PROCEDURE LastComments ;
PROCEDURE AddUser(path:STRING ; player : STR35 ; PNode : STR2) ;
PROCEDURE RemoveUser(path:STRING ; player : STR35) ;
FUNCTION UsersOn(path:STRING) : BYTE ;
PROCEDURE SetActivity(path:STRING ; Player : STR35 ; Act : BYTE) ;
FUNCTION Activity(path:STRING ; Act : BYTE) : BOOLEAN ;
PROCEDURE ClearActivity(path:STRING ; n : BYTE) ;
FUNCTION GetBaudRate(instr:STRING) : LONGINT ;
FUNCTION BummerList(instr:String) : BOOLEAN ;
PROCEDURE PollTerm ;
PROCEDURE SendFname(cmd:char;fname:STRING) ;
FUNCTION Julian( year : INTEGER; mon, day : BYTE): REAL;
PROCEDURE WriteToInnerBoard(FileToWrite:STRING;
                            Header:BOOLEAN;NumberOfHeaders:BYTE;
                            PauseOn:BOOLEAN) ;
PROCEDURE Space ;
PROCEDURE RedisplayInnerBoard ;
PROCEDURE MakeMessage(WhoTo:STR35) ;
PROCEDURE CheckMail(ins:char) ;
PROCEDURE ClearStatusArea ;
PROCEDURE WriteDisplay(color:BYTE;Tstr:STRING) ;
PROCEDURE PostScores(Full:BOOLEAN) ;
PROCEDURE Pause ;
PROCEDURE ShowHelp(fname:STRING) ;
PROCEDURE SetRIPDefault ;
PROCEDURE SetupRipScreen ;
PROCEDURE SendButtons(eleven:char) ;
PROCEDURE AddButton(ch:CHAR) ;
PROCEDURE ResetButtons ;
PROCEDURE YesNo ;
PROCEDURE TenButtons ;


VAR
   FILLCH        : CHAR;
   SHOWSIGN      : BOOLEAN;
   NEGSOFF       : BOOLEAN;
   UseFile       : FILE OF UseRec ;
   Use           : UseRec ;
   Regs          : Registers ;
   Alias         : STRING[35] ;
   NameOfGame    : STRING[45] ;
   GameInUse     : BOOLEAN ;
    

IMPLEMENTATION


PROCEDURE SetRIPDefault ;
BEGIN
   if not rip then exit ;
   crlf ;
   sendout('!|1K|*|w0000270O12|10000$COFF$|#|#|#') ;
   clearscreen ;
END ;


PROCEDURE SetupRipScreen ;
VAR  k : BYTE ;
BEGIN
   if not rip then exit ;
   { RipSeqON ; }
   for k := 1 to 10 do button[k] := #0 ;
   Crlf ;
   SendOut('') ;
   SendOut('!|1K|*|=00000001|S0107|B0K0GH87C|S010F|p040K7C0A7K0A080K0G') ;
   SendOut('!|p040K0G0A08HI08H80G|S0108|p04HI08H80GH87CHI7K') ;
   SendOut('!|p04HI7KH87C0K7C0A7K|S0100|B0U0OGY74|c08|LH80GGY0O') ;
   SendOut('!|L0K0G0U0O|L0K7C0U74|LH87CGY74|LH87CHI7K|LH87CHI7K') ;
   SendOut('!|c0F|LH87CHI7K|1B00000200LC030F000F080700000F07000000') ;
   SendOut('!|Y00000100|1U0B7RHJ8N0000<><>') ;
   SendOut('!|Y02000500|1B00000200LC030F000F080100000F01000000') ;
   SendOut('!|1U4680DM8G0000<>Eclectic Avenue 2.00 by John Parlin<>') ;
   SendOut('!|w06042D0R11|1B0000020074030F000F080100000F01000000') ;
   SendOut('!|1U0U68GY740000<><>') ;
   SendOut('!|#|#|#') ;
   { RipSeqOFF ; }
END ;


PROCEDURE ResetButtons ;
VAR k : BYTE ;
BEGIN
   for k := 1 to 11 do button[k] := #0 ;
   numbuttons := 0 ;
END ;


PROCEDURE ClearButtons ;
BEGIN
   SendOut('|1K|1B0000020074030F000F080100000F01000000') ;
   SendOut('!|1U0U68GY740000<><>') ;
   SendOut('!|#|#|#') ;
END ;


PROCEDURE AddButton(ch:CHAR) ;
BEGIN
   INC(numbuttons) ;
   if numbuttons > 10 then exit ;
   button[numbuttons] := ch ;
END ;


PROCEDURE SENDBUTTONS(eleven:char) ;
VAR
   k  : BYTE ;
   ts : STRING ;
BEGIN
   if not RIP then exit ;
   { RipSeqON ; }
   ClearButtons ;
   button[11] := eleven ;
   SendOut('|1B00000201DU030F000F080400000F04000000|Y00000100');
   for k := 1 to numbuttons do begin
      case k of
         1 : ts := '!|1U3M6G466W0000' ;
         2 : ts := '!|1U4G6G506W0000' ;
         3 : TS := '!|1U5A6G5U6W0000' ;
         4 : TS := '!|1U646G6O6W0000' ;
         5 : TS := '!|1U6Y6G7I6W0000' ;
         6 : TS := '!|1U7S6G8C6W0000' ;
         7 : TS := '!|1U8M6G966W0000' ;
         8 : TS := '!|1U9G6GA06W0000' ;
         9 : TS := '!|1UAA6GAU6W0000' ;
         10: TS := '!|1UB46GBO6W0000' ;
      end ;
      SendOut(ts+'<>'+button[k]+'<>'+button[k]) ;
   end ;
   case button[11] of
      #32 : SendOut('!|1U1E6G326W0000<>Space<> ') ;
      #13 : SendOut('!|1U1E6G326W0000<>Enter<>^m') ;
   end ;
   SendOut('!|#|#|#') ;
   { RipSeqOFF ; }
end ;


PROCEDURE YesNo ;
BEGIN
   ResetButtons ;
   AddButton('Y') ;
   AddButton('N') ;
   SendButtons(#13) ;
   buttonchange := true ;
END ;


PROCEDURE TenButtons ;
VAR
   k    : BYTE ;
   ks   : STRING[2] ;
BEGIN
   ResetButtons ;
   FOR k := 0 TO 9 DO BEGIN
      STR(k,ks) ;
      AddButton(ks[1]) ;
   END ;
   SendButtons(#13) ;
   buttonchange := true ;
END ;


PROCEDURE Space ;
VAR
   ch   : CHAR ;
   row  : BYTE ;
   i    : BYTE ;
BEGIN
   row := WhereY ;
   sDisplay(0,7,0,'[20C[0;1;30;40m[37;47m[30;40m') ;
   Display(0,7,0,' ') ;
   sDisplay(0,7,0,'[20C[0;30;47m     Press <SPACEBAR>To Continue     [1;30;40m') ;
   Display(0,7,0,' ') ;
   sDisplay(0,7,0,'[20C[47m[40m[0m') ;
   Display(0,7,0,' ') ;
   sDisplay(0,12,0,' ') ;

   repeat
      ch := Getchar ;
   until ch = #32 ;

   FOR i := row TO row+3 DO BEGIN
      CursorPos(i,1) ;
      sDisplay(0,7,0,#27+'[K') ;
   END ;
   CursorPos(row,1) ;
END ;


PROCEDURE ShowHelp(fname:STRING) ;
VAR
   infile    : TEXT ;
   line      : STRING ;
   i         : INTEGER ;
   ch        : CHAR ;

   PROCEDURE ClearBarArea ;
   VAR
      i         : BYTE ;
   BEGIN
      FOR i := 4 TO 20 DO BEGIN
         CursorPos(i,1) ;
         sDisplay(0,15,0,#27+'[K') ;
      END ;
   END ;


BEGIN
   IF NOT Exist(fname) THEN EXIT ;
   ClearScreen ;
   sDisplay(0,12,0,'[0;1;37;47m[40m') ;
   Display(0,12,0,' ') ;
   sDisplay(0,12,0,'[47m[0;30;47m                        Eclectic Avenue Instructions                          [40m') ;
   Display(0,12,0,' ') ;
   sDisplay(0,12,0,'[47m[1;30m[40m') ;
   Display(0,12,0,' ') ;
   CursorPos(21,1) ;
   sDisplay(0,12,0,'[47m[37m[40m') ;
   Display(0,12,0,' ') ;
{                                  123456789012345678901234567890123456789012345678901234567890123456789012345678}
   sDisplay(0,12,0,'[47m[0;30;47m                           Copyright 1995 John Parlin                         [40m') ;
   Display(0,12,0,' ') ;
   sDisplay(0,12,0,'[47m[1;30m[0m') ;
   sDisplay(0,12,0,' ') ;
   i := 3 ;
   ASSIGN(infile,fname) ;
   RESET(infile) ;
   WHILE NOT EOF(infile) DO BEGIN
      READLN(infile,line) ;
      INC(i) ;
      IF i > 19 THEN BEGIN
         ClearBarArea ;
         i := 4 ;
      END ;
      CursorPos(i,1) ;
      sDisplay(0,7,0,line) ;
      IF i = 19 THEN BEGIN
         CursorPos(20,1) ;
         sDisplay(0,9,0,Center('Press <any key> to Continue',79)) ;
         ch := GetChar ;
      END ;
   END ;
   CLOSE(infile) ;
   CursorPos(20,1) ;
   sDisplay(0,9,0,Center('Press <any key> to Continue',79)) ;
   ch := GetChar ;
END ;


FUNCTION Julian( year : INTEGER; mon, day : BYTE): REAL;
var
  temp        : real;
begin                                      { function Julian                 }
  if (year < 0) OR (mon < 1) OR (day < 1) OR (day > 31) then
    begin
      Julian := -1;
      exit;
    end;  { IF }
  if year < 100 then
    year := year + 1900;
  temp := int((mon - 14.0) / 12.0);
  Julian := day - 32075.0 +
            int(1461.0 * (year + 4800.0 + temp) / 4.0) +
            int(367.0 * (mon - 2.0 - temp * 12.0) / 12.0) -
            int(3.0 * int((year + 4900.0 + temp) / 100.0) / 4.0)
end;

PROCEDURE PollTerm ;
VAR
   timeout    : INTEGER ;
   Seconds    : INTEGER ;
   hr,mn,s,d  : WORD ;
   ACKStr     : STRING ;
BEGIN
   IF Local THEN BEGIN
      RIP := FALSE ;
      Exit ;
   END ;
   sDisplay(0,0,0,' ') ;
   sDisplay(0,0,0,#27+'[!') ;
   Timeout := 0 ;
   Seconds := 0 ;
   ACKStr := '' ;
   REPEAT
      GetTime(hr,mn,s,d) ;
      IF Seconds <> s THEN BEGIN
         INC(Timeout) ;
         Seconds := s ;
      END ;
      IF InReady THEN ACKstr := ACKStr + GetChar ;
   UNTIL (LENGTH(ACKStr) > 8) OR (Timeout > 3) ;
   IF POS('RIPSCRIP',ACKStr) > 0 THEN BEGIN
      RIP := TRUE ;
      Exit ;
   END ELSE BEGIN
      RIP := FALSE ;
      Exit ;
   END ;
END ;



PROCEDURE SendFname(cmd:char;fname:STRING) ;
VAR
   c   : CHAR ;
BEGIN
   sdisplay(0,0,0,''+cmd+fname+'.') ;
   sdisplay(0,7,0,' ') ;
END ;

PROCEDURE Pause ;
BEGIN
   CursorPos(23,1) ;
   More('Press <any key> to continue'+#27+'[K',10) ;
END ;


PROCEDURE ClearStatusArea ;
VAR
   i : BYTE ;
BEGIN
   FOR i := 20 TO 23 DO BEGIN
      CursorPos(i,1) ;
      sDisplay(0,7,0,#27+'[K') ;
   END ;
END ;


PROCEDURE WriteDisplay(color:BYTE;Tstr:STRING) ;
BEGIN
   ClearStatusArea ;
   CursorPos(20,1) ;
   sDisplay(0,color,0,Tstr) ;
   Pause ;
END ;

PROCEDURE PostScores(Full:BOOLEAN) ;
VAR
   i   : BYTE ;
   tc  : BYTE ;
   cc  : BYTE ;
BEGIN
   IF Info.MultiLine THEN Full := TRUE ;
   IF DrawFull THEN BEGIN
      Full := TRUE ;
      DrawFull := FALSE ;
   END ;
   FOR i := 1 TO 8 DO BEGIN
      IF (Full) OR (GameInfo.PlayerName[i] = Alias) THEN BEGIN
         IF GameInfo.PlayerName[i] <> '' THEN BEGIN
            CASE i OF
               1 : CursorPos(11,11) ;
               2 : CursorPos(11,41) ;
               3 : CursorPos(12,11) ;
               4 : CursorPos(12,41) ;
               5 : CursorPos(13,11) ;
               6 : CursorPos(13,41) ;
               7 : CursorPos(14,11) ;
               8 : CursorPos(14,41) ;
            END ;
         END ;
      END ;
      IF i = 8 THEN cc := 5 ELSE cc := i + 8 ;
      IF Full THEN BEGIN
         IF GameInfo.PlayerName[i] <> '' THEN BEGIN
            sDisplay(0,cc,0,LJust(GameInfo.PlayerName[i],19)) ;
         END ;
      END ELSE BEGIN
         IF GameInfo.PlayerName[i] = Alias THEN
            sDisplay(0,cc,0,LJust(GameInfo.PlayerName[i],19)) ;
      END ;
      IF (Full) OR (GameInfo.PlayerName[i] = Alias) THEN BEGIN
         IF GameInfo.PlayerName[i] <> '' THEN BEGIN
            CASE i OF
               1 : CursorPos(11,33) ;
               2 : CursorPos(11,63) ;
               3 : CursorPos(12,33) ;
               4 : CursorPos(12,63) ;
               5 : CursorPos(13,33) ;
               6 : CursorPos(13,63) ;
               7 : CursorPos(14,33) ;
               8 : CursorPos(14,63) ;
            END ;
            IF Full THEN BEGIN
               IF GameInfo.PlayerName[i] = Alias THEN
                  sDisplay(0,cc,0,RJust(ItoA(PlayerScore),7))
               ELSE BEGIN
                  IF NOT GameInfo.OutOfGame[i] THEN
                     sDisplay(0,cc,0,RJust(ItoA(GameInfo.PlayerScore[i]),7))
                  ELSE
                     sDisplay(0,9,0,RJust('OUT',7));
               END ;
            END ELSE BEGIN
               IF GameInfo.PlayerName[i] = Alias THEN
                  sDisplay(0,cc,0,RJust(ItoA(PlayerScore),7)) ;
            END ;
         END ;
      END ;
   END ;
END ;



PROCEDURE WriteToInnerBoard(FileToWrite:STRING;
                            Header:BOOLEAN;NumberOfHeaders:BYTE;
                            PauseOn:BOOLEAN) ;
VAR
   c,i,j     : BYTE ;
   TFile     : TEXT ;
   Line      : STRING ;
   Holding   : CHAR ;
   Tcolor    : BYTE ;
BEGIN
   ASSIGN(TFile,FileToWrite) ;
   {$I-} RESET(Tfile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      CursorPos(20,1) ;
      sDisplay(0,12,0,'ERROR! '+FileToWrite+' NOT FOUND!') ;
      DELAY(3000) ;
      EXIT ;
   END ;
   c := 0 ;
   i := 5 ;
   WHILE NOT EOF(Tfile) DO BEGIN
      READLN(TFile,Line) ;
      INC(c) ;
      CursorPos(i,10) ;
      IF (Header) AND (c <= NumberOfHeaders) THEN tcolor := 12
         ELSE tcolor := 15 ;
      IF POS('TOTAL',Line) > 0 THEN tcolor := 14 ;
      sDisplay(0,tcolor,0,Line+MkString((62-Length(Line)),' ')) ;
      INC(i) ;
      IF c MOD 10 = 0 THEN BEGIN
         i := 5 ;
         CursorPos(15,10) ;
         sDisplay(0,4,0,'Press ') ;
         sDisplay(0,12,0,'<any key> ') ;
         sDisplay(0,4,0,'to continue') ;
         Holding := GetChar ;
      END ;
   END ;
   CLOSE(Tfile) ;
   WHILE i < 16 DO BEGIN
      CursorPos(i,10) ;
      sDisplay(0,15,0,MkString(62,' ')) ;
      INC(i) ;
   END ;
   IF PauseOn THEN BEGIN
      CursorPos(15,10) ;
      sDisplay(0,4,0,'Press ') ;
      sDisplay(0,12,0,'<any key> ') ;
      sDisplay(0,4,0,'to continue') ;
      Holding := GetChar ;
   END ;
END ;


PROCEDURE RedisplayInnerBoard ;
VAR
   j,i    : BYTE ;
   LArray : ARRAY [1..11] OF STRING ;
   TFile  : TEXT ;
   Holding: CHAR ;
BEGIN
   fn := 'ANSFILES\INNER.ANS' ;
   ASSIGN(TFile,fn) ;
   {$I-} RESET(TFile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      WRITE(#7) ;
      CursorPos(22,1) ;
      sDisplay(0,12,0,'ERROR! ANSFILES\INNER.ANS NOT FOUND!') ;
      Holding := GetChar ;
      Exit ;
   END ;
   FOR j := 1 TO 11 DO READLN(TFile,LArray[j]) ;
   CLOSE(TFile) ;
   i := 0 ;
   FOR j := 5 TO 15 DO BEGIN
      INC(i) ;
      CursorPos(j,9) ;
      sDisplay(0,15,0,LArray[i]) ;
   END ;
END ;




PROCEDURE MakeMessage(WhoTo:STR35) ;
VAR
   tstr              : STRING ;
   nuser             : UserRecord ;
   linearray         : ARRAY [1..20] OF STRING[80] ;
   choice,mc         : CHAR ;
   f                 : TEXT ;
   found             : BOOLEAN ;
   hr,min,sec,sec100 : WORD ;
   i,ii,linecount    : BYTE ;
   Empty             : BOOLEAN ;
   linetoedit        : byte ;
   k,kk,kkk          : byte ;
   newtext           : string ;


PROCEDURE ListMsg ;
VAR
   i,ii   : BYTE ;
BEGIN
   ClearScreen ;
   i := 5 ;
   Crlf ;
   sDisplay(0,13,0,'To:       ') ;
   sDisplay(0,15,0,Msg.WhoTo) ;
   if msg.private then sdisplay(0,14,0,' (Private)') ;
   if msg.received then sdisplay(0,14,0,' (Received)') ;
   crlf ;
   sDisplay(0,13,0,'From:     ') ;
   Display(0,15,0,Msg.From) ;
   sDisplay(0,13,0,'Subject:  ') ;
   Display(0,15,0,Msg.Subject) ;
   sDisplay(0,13,0,'Date:     ') ;
   Display(0,15,0,Msg.DTG) ;
   Display(0,14,0,MkString(78,'')) ;
   FOR ii := 1 TO 20 DO BEGIN
      IF LineArray[ii] = '' THEN ii := 20 ELSE BEGIN
         sDisplay(0,11,0,fixbyte(ii)+': ') ;
         Display(0,3,0,LineArray[ii]) ;
         INC(i) ;
         IF i MOD 22 = 0 THEN More('-=More=-',9) ;
      END ;
   END ;
END ;



BEGIN
   Crlf ;
   Display(0,13,0,'Write a message to another player.') ;
   if whoto = '' then begin
      found := false ;
      repeat
         crlf ;
         display(0,14,0,'Enter the full or partial player name, ALL, or ? to list players.') ;
         crlf ;
         sdisplay(0,15,0,'Write to: ') ;
         tstr := getinput('',1,35) ;
         if tstr = '' then exit ;
         if tstr = '?' then begin
            display(0,7,0,Center('Player Listing',30)) ;
            display(0,15,0,MkString(30,'')) ;
            assign(userfile,'ea.dat') ;
            reset(userfile) ;
            while not eof(userfile) do begin
               read(userfile,nuser) ;
               display(0,3,0,nuser.alias)
            end ;
            close(userfile) ;
         end ;
      until tstr <> '?' ;
      if tstr <> 'ALL' then begin
         crlf ;
         display(0,10,0,'Searching for: '+tstr) ;
         crlf ;
         assign(userfile,'ea.dat') ;
         reset(userfile) ;
         while not eof(userfile) do begin
            read(userfile,nuser) ;
            if pos(tstr,nuser.alias) > 0 then begin
               sdisplay(0,11,0,'Send message to ') ;
               sdisplay(0,15,0,nuser.alias) ;
               sdisplay(0,11,0,'? [y,n]: ') ;
               repeat
                  choice := upcase(getchar) ;
               until choice in ['Y','N'] ;
               display(0,14,0,choice) ;
               if choice = 'Y' then begin
                  found := true ;
                  WhoTo := nuser.alias ;
                  seek(userfile,filesize(userfile)) ;
               end ;
            end ;
         end ;
         close(userfile) ;
      end else begin
         WhoTo := 'ALL' ;
         found := true ;
      end ;
   end else found := true ;
   IF Found THEN BEGIN
      Msg.WhoTo := WhoTo ;
      Crlf ;
      sDisplay(0,13,0,'Subject:') ;
      sDisplay(0,7,0,' ') ;
      tstr := GetInput('',1,35) ;
      IF tstr = '' THEN Exit ;
      Msg.Subject := tstr ;
      GetDate(yr,mn,dt,dy) ;
      GetTime(hr,min,sec,sec100) ;
      Msg.CreationDate := Julian(yr,mn,dt) ;
      Msg.Received := false ;
      Msg.DTG := FixByte(mn)+'-'+FixByte(dt)+'-'+ItoA(yr)+
                 ' at '+FixByte(hr)+':'+FixByte(min)+' hrs.' ;
      Msg.From := Alias ;
      if Msg.WhoTo <> 'ALL' then begin
         crlf ;
         sdisplay(0,7,0,'Private message? [y,N]: ') ;
         repeat
            choice := upcase(getchar) ;
            if choice = #13 then choice := 'N' ;
         until choice in ['Y','N'] ;
         display(0,15,0,choice) ;
         Msg.Private := choice = 'Y' ;
      end else Msg.Private := false ;
      Scrap_entry := '' ;
      ClearScreen ;
      sDisplay(0,13,0,'To:       ') ;
      sDisplay(0,15,0,Msg.WhoTo) ;
      if msg.private then sdisplay(0,14,0,' (Private)') ;
      if msg.received then sdisplay(0,14,0,' (Received)') ;
      crlf ;
      sDisplay(0,13,0,'From:     ') ;
      Display(0,15,0,Msg.From) ;
      sDisplay(0,13,0,'Subject:  ') ;
      Display(0,15,0,Msg.Subject) ;
      sDisplay(0,13,0,'Date:     ') ;
      Display(0,15,0,Msg.DTG) ;
      Display(0,9,0,MkString(78,'')) ;
      FOR ii := 1 TO 20 DO BEGIN
         LineArray[ii] := '' ;
         LineArray[ii][0] := #0 ;
      END ;
      Display(0,7,0,Center('Enter up to 20 lines of text to be sent to '+formatstr(Msg.WhoTo)+'.',78)) ;
      Display(0,7,0,Center('Enter a blank line or press <ENTER> past line 20 to save',78)) ;
      Display(0,9,0,MkString(78,'')) ;
      linecount := 0 ;
      FOR ii := 1 TO 20 DO BEGIN
         inc(linecount) ;
         sDisplay(0,2,0,fixbyte(ii)+': ') ;
         LineArray[ii] := getline(72,8,3) ;
         IF LineArray[ii] = '' THEN ii := 20 ;
      END ;
      repeat
         ResetButtons ;
         AddButton('A') ;
         AddButton('C') ;
         AddButton('E') ;
         AddButton('L') ;
         AddButton('S') ;
         SendButtons(#13) ;
         crlf ;
         sdisplay(0,15,0,'Editor Options: ') ;
         sdisplay(0,9,0,'<') ;
         sdisplay(0,14,0,'A') ;
         sdisplay(0,9,0,'>bort, <') ;
         sdisplay(0,14,0,'C') ;
         sdisplay(0,9,0,'>ontinue, <') ;
         sdisplay(0,14,0,'E') ;
         sdisplay(0,9,0,'>dit Line, <') ;
         sdisplay(0,14,0,'L') ;
         sdisplay(0,9,0,'>ist Msg, <') ;
         sdisplay(0,14,0,'S') ;
         sdisplay(0,9,0,'>ave: ') ;
         repeat
            mc := upcase(getchar) ;
         until mc in ['A','C','E','L','S'] ;
         display(0,15,0,mc) ;
         case mc of
            'A' : begin
                     crlf ;
                     sdisplay(0,12,0,'Abort message?') ;
                     repeat
                        choice := upcase(getchar) ;
                     until choice in ['Y','N'] ;
                     if choice = 'Y' then begin
                        crlf ;
                        display(0,15,0,'Message aborted.') ;
                     end else mc := 'z' ;
                  end ;
            'C' : begin
                     crlf ;
                     if linecount >= 20 then
                        display(0,12,0,'The message is already full!')
                     else begin
                        k := linecount ;
                        dec(linecount) ;
                        FOR ii := k TO 20 DO BEGIN
                           inc(linecount) ;
                           sDisplay(0,2,0,fixbyte(ii)+': ') ;
                           LineArray[ii] := getline(72,8,3) ;
                           IF LineArray[ii] = '' THEN ii := 20 ;
                        END ;
                     end ;
                  end ;
            'E' : begin
                     crlf ;
                     sdisplay(0,14,0,'Line number to edit: ') ;
                     tstr := getinput('',1,2) ;
                     if tstr = '' then tstr := '0' ;
                     if (atoi(tstr) > 0) and (atoi(tstr) < 21) then begin
                        crlf ;
                        linetoedit := atoi(tstr) ;
                        display(0,15,0,'The line currently reads:') ;
                        display(0,7,0,linearray[linetoedit]) ;
                        crlf ;
                        display(0,15,0,'Enter text to be replaced or <ENTER> to replace entire line:') ;
                        sdisplay(0,7,0,'> ') ;
                        tstr := getinput('',0,72) ;
                        if tstr = '' then begin
                           crlf ;
                           display(0,15,0,'Enter new line:') ;
                           sdisplay(0,7,0,'> ') ;
                           linearray[linetoedit] := getinput('',0,72) ;
                        end else begin
                           if pos(tstr,linearray[linetoedit]) > 0 then begin
                              crlf ;
                              display(0,15,0,'Enter replacement text:') ;
                              sdisplay(0,7,0,'> ') ;
                              k := length(linearray[linetoedit]) ;
                              kk := length(tstr) ;
                              kkk := 72 - (k - kk) ;
                              newtext := getinput('',0,kkk) ;
                              k := pos(tstr,linearray[linetoedit]) ;
                              delete(linearray[linetoedit],k,kk) ;
                              if newtext <> '' then
                                 insert(newtext,linearray[linetoedit],k) ;
                           end else begin
                              crlf ;
                              display(0,12,0,'No text was matched.') ;
                           end ;
                        end ;
                     end ;
                  end ;
            'L' : begin
                     ListMsg ;
                  end ;
            'S' : begin
                  end ;
         end ; {case mc of}
      until mc in ['A','S'] ;
      if mc = 'A' then exit ;
      Empty := True ;
      FOR ii := 1 TO 20 DO BEGIN
         IF LineArray[ii] <> '' THEN Empty := FALSE ;
      END ;
      IF Empty THEN BEGIN
         Crlf ;
         Display(0,13,0,'Your message is empty!  Discarding...') ;
         Crlf ;
         Exit ;
      END ;
      fn := 'EA.MSG' ;
      ASSIGN(MsgFile,'EA.MSG') ;
      {$I-} RESET(MsgFile) ; {$I+}
      IF IOResult <> 0 THEN REWRITE(MsgFile) ;
      SEEK(MsgFile,FileSize(MsgFile)) ;
      Msg.FileName := 'MESSAGES\' + FixByte(dt) + FixByte(hr) +
                       FixByte(mn) + FixByte(sec) + '.M' +
                       FixByte(sec100) ;
      WriteMsg ;
      CLOSE(MsgFile) ;
      ASSIGN(f,Msg.FileName) ;
      REWRITE(f) ;
      FOR ii := 1 TO 20 DO BEGIN
         IF LineArray[ii] = '' THEN ii := 20
            ELSE WRITELN(f,LineArray[ii]) ;
      END ;
      FLUSH(f) ;
      CLOSE(f) ;
      ClearScreen ;
      Display(0,15,0,'Message sent to '+Msg.WhoTo+'.') ;
   END ELSE BEGIN
      Crlf ;
      Display(0,9,0,'End of player list or player not found!') ;
   END ;
   Crlf ;
END ;


FUNCTION mail_logic(ins:char) : boolean ;
VAR
   tb   : boolean ;
BEGIN
   tb := false ;
   if upcase(ins) = 'E' then begin
      tb := false ;
      if ((Msg.WhoTo = 'ALL') and (Msg.CreationDate >= User.LastOn))  {all}
      or (Msg.WhoTo = Alias) then tb := true ;
      mail_logic := tb ;
      exit ;
   end else if upcase(ins) = 'A' then begin
      tb := false ;
      if Msg.Private then begin
         if Msg.WhoTo = Alias then tb := true ;
         if Msg.From = Alias then tb := true ;
      end else tb := true ;
      mail_logic := tb ;
      exit ;
   end else if upcase(ins) = 'N' then begin
      tb := false ;
      if Msg.CreationDate >= User.LastOn then begin
         if Msg.Private then
            if (Msg.WhoTo = Alias) or (Msg.From = Alias) then tb := true
         else tb := true ;
      end ;
      mail_logic := tb ;
      exit ;
   end else if upcase(ins) = 'F' then begin
      tb := false ;
      if Msg.From = Alias then tb := true ;
      mail_logic := tb ;
      exit ;
   end else if upcase(ins) = 'T' then begin
      tb := false ;
      if Msg.WhoTo = Alias then tb := true ;
      mail_logic := tb ;
      exit ;
   end ;
END ;



PROCEDURE CheckMail(ins:char) ;
VAR
   choice      : CHAR ;
   jstr,
   line        : STRING ;
   f           : TEXT ;
   ReplyName   : STRING[35] ;
   i           : BYTE ;
   FoundOne    : BOOLEAN ;
   DelCmd      : BOOLEAN ;
   ReplyCmd    : BOOLEAN ;
   LastPosition: BYTE ;
BEGIN
   crlf ;
   DelCmd := true ;
   sDisplay(0,15,0,'Checking mail...') ;
   IF NOT Exist('EA.MSG') THEN BEGIN
      Display(0,12,0,'Empty!') ;
      Crlf ;
      More('Press <any key> to continue',12) ;
      Exit ;
   END ;
   FoundOne := FALSE ;
   fn := 'EA.MSG' ;
   ASSIGN(MsgFile,fn) ;
   RESET(MsgFile) ;
   WHILE NOT EOF(MsgFile) DO BEGIN
      DelCmd := true ;
      ReadMsg ;
      if (mail_logic(ins)) and (Msg.WhoTo <> '') then begin
         if (Msg.WhoTo = 'ALL') and (Msg.From <> Alias) then DelCmd := false ;
         FoundOne := True ;
         i := 5 ;
         Crlf ; Crlf ;
         sDisplay(0,13,0,'To:         ') ;
         sDisplay(0,15,0,Msg.WhoTo) ;
         if msg.private then sdisplay(0,14,0,' (Private)') ;
         if msg.received then sdisplay(0,14,0,' (Received)') ;
         crlf ;
         sDisplay(0,13,0,'From:       ') ;
         Display(0,15,0,Msg.From) ;
         ReplyName := Msg.From ;
         sDisplay(0,13,0,'Subject:    ') ;
         Display(0,15,0,Msg.Subject) ;
         sDisplay(0,13,0,'Posted On:  ') ;
         Display(0,15,0,Msg.DTG) ;
         Display(0,14,0,MkString(78,'')) ;
         ASSIGN(f,Msg.FileName) ;
         {$I-} RESET(f) ; {$I+}
         IF IOResult <> 0 THEN BEGIN
            Msg.WhoTo := '' ;
            Msg.From := '' ;
            Msg.Subject := '' ;
            Msg.DTG := '' ;
            Msg.FileName := '' ;
            Msg.Private := false ;
            Msg.Received := false ;
            SEEK(MsgFile,FilePos(MsgFile)-1) ;
            WriteMsg ;
            sDisplay(1,15,0,'The message is empty!') ;
            Display(0,15,0,' ' ) ;
            Crlf ;
            More('Press <any key> to continue',12) ;
         END ELSE BEGIN
            WHILE NOT EOF(f) DO BEGIN
               INC(i) ;
               READLN(f,line) ;
               Display(0,7,0,Line) ;
               IF i MOD 22 = 0 THEN More('-=More=-',9) ;
            END ;
            CLOSE(f) ;

            ResetButtons ;
            AddButton('N') ;
            jstr := 'Select - <N>ext' ;
            if DelCmd then begin
               AddButton('D') ;
               jstr := jstr + ' <D>elete'
            end ;
            if Msg.From <> Alias then begin
               AddButton('R') ;
               jstr := jstr + ' <R>eply' ;
               ReplyCmd := true ;
            end else ReplyCmd := false ;
            jstr := jstr + ': ' ;
            SendButtons(#13) ;
            Crlf ;
            sdisplay(0,14,0,jstr) ;
            REPEAT
              choice := UPCASE(GetChar) ;
              if choice = #13 then choice := 'N' ;
              if (not DelCmd) and (choice='D') then choice := 'z' ;
              if (not ReplyCmd) and (choice='R') then choice := 'z' ;
            UNTIL choice IN ['D','R','N'] ;
            Display(0,15,0,choice) ;
            if ((choice = 'D')) or ((Msg.Private) and (Msg.Received))
            then begin
               DeleteFile(Msg.FileName) ;
               Msg.WhoTo := '' ;
               Msg.From := '' ;
               Msg.Subject := '' ;
               Msg.DTG := '' ;
               Msg.FileName := '' ;
               Msg.Private := false ;
               Msg.Received := false ;
               SEEK(MsgFile,FilePos(MsgFile)-1) ;
               WriteMsg ;
            end ;
            IF choice = 'R' THEN BEGIN
               LastPosition := filepos(MsgFile) - 1 ;
               CLOSE(MsgFile) ;
               MakeMessage(ReplyName) ;
               fn := 'EA.MSG' ;
               ASSIGN(MsgFile,'EA.MSG') ;
               RESET(MsgFile) ;
               SEEK(MsgFile,LastPosition) ;
            END ;
         END ;
      END ;
      DelCmd := true ;
   END ;
   CLOSE(MsgFile) ;
   IF NOT FoundOne THEN Display(0,12,0,'Empty!') ELSE BEGIN
      Crlf ;
      Display(0,14,0,'End of mail.') ;
   END ;
   Crlf ;
   More('Press <any key> to continue',12) ;
END ;



FUNCTION BummerList(instr:String) : BOOLEAN ;
VAR
   BumFile    : text ;
   Search     : string ;
BEGIN
   if not exist('EA.BUM') then begin
      BummerList := false ;
      exit ;
   end ;
   filemode := 66 ;
   fn := 'EA.BUM' ;
   assign(bumfile,fn) ;
   reset(bumfile) ;
   while not eof(bumfile) do begin
      readln(bumfile,search) ;
      if search <> '' then begin
         search := changecase(search) ;
         if pos(search,instr) <> 0 then begin
            close(bumfile) ;
            crlf ;
            display(0,12,0,'Sorry but that alias is not allowed!') ;
            crlf ;
            BummerList := true ;
            exit ;
         end ;
      end ;
   end ;
   close(bumfile) ;
   bummerlist := false ;
END ;


FUNCTION GetBaudRate(instr:STRING) : LONGINT ;
VAR
   tstr     : STRING ;
   tval     : LONGINT ;
   code2    : INTEGER ;
BEGIN
   Tstr := COPY(instr,1,POS(' ',instr)-1) ;
   VAL(Tstr,tval,code2) ;
   GetBaudRate := Tval ;
END ;


Procedure WriteUse;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(UseFile) * Sizeof(Use)) + 1 ;
  LockEnd := (filepos(UseFile) + 1) * sizeof(Use) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(UseFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(UseFile,Use);
    UnLock(UseFile,LockStart,LockEnd) ;
  End;
End;


Procedure ReadUse ;
Var
   LockStart,
   LockEnd     : LongInt ;
   Err,
   ErrCnt      : Integer ;
Begin
   ErrCnt := 0 ;
   LockStart := (filepos(UseFile) * Sizeof(Use)) + 1 ;
   LockEnd := (filepos(UseFile) + 1) * sizeof(Use) ;
   Repeat
      Inc(ErrCnt) ;
      Err := Lock(UseFile,lockstart,lockend) ;
   Until (err = 0) or (ErrCnt > 9999) ;
   If ErrCnt < 10000 then
   Begin
     Read(UseFile,Use) ;
     UnLock(UseFile,LockStart,LockEnd) ;
   End ;
End ;


PROCEDURE AddUser(path:STRING ; player : STR35 ; PNode : STR2) ;
BEGIN
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} RESET(UseFile) ; {$I+}
   IF IOResult <> 0 THEN REWRITE(UseFile) ;
   Use.node := PNode ;
   Use.player := player ;
   Use.activity := 1 ;
   SEEK(UseFile,FileSize(UseFile)) ;
   WriteUse ;
   CLOSE(UseFile) ;
END ;


PROCEDURE RemoveUser(path:STRING ; player : STR35) ;
VAR
   FileEmpty    : BOOLEAN ;
BEGIN
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} RESET(UseFile) ; {$I+}
   IF IOResult <> 0 THEN EXIT ;
   While NOT Eof(UseFile) DO BEGIN
      ReadUse ;
      IF Use.player = player THEN BEGIN
         Use.Player := '' ;
         Use.Node := '' ;
         Use.Activity := 0 ;
         SEEK(UseFile,FilePos(UseFile)-1) ;
         WriteUse ;
      END ;
   END ;
   SEEK(UseFile,0) ;
   FileEmpty := TRUE ;
   WHILE NOT Eof(UseFile) DO BEGIN
      ReadUse ;
      IF Use.player <> '' THEN FileEmpty := FALSE ;
   END ;
   CLOSE(UseFile) ;
   IF FileEmpty THEN ERASE(UseFile) ;
END ;


FUNCTION UsersOn(path:STRING) : BYTE ;
VAR
   lcount    : BYTE ;
BEGIN
   lcount := 0 ;
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} RESET(UseFile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      UsersOn := 0 ;
      Exit ;
   END ;
   WHILE NOT Eof(UseFile) DO BEGIN
      ReadUse ;
      IF Use.Player <> '' THEN Inc(lcount) ;
   END ;
   CLOSE(UseFile) ;
   UsersOn := lcount ;
END ;


PROCEDURE SetActivity(Path:STRING ; Player : STR35 ; Act : BYTE) ;
BEGIN
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} Reset(Usefile) ; {$I+}
   IF IOResult <> 0 THEN EXIT ;
   WHILE NOT EOF(UseFile) DO BEGIN
      ReadUse ;
      IF Use.Player = Player THEN BEGIN
         Use.Activity := Act ;
         SEEK(UseFile,FilePos(UseFile)-1) ;
         WRITEUse ;
      END ;
   END ;
   CLOSE(UseFile) ;
END ;


FUNCTION Activity(Path:STRING ; Act : BYTE) : BOOLEAN ;
VAR
   TBool   : BOOLEAN ;
BEGIN
   TBool := FALSE ;
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} Reset(Usefile) ; {$I+}
   IF IOResult <> 0 THEN EXIT ;
   WHILE NOT EOF(UseFile) DO BEGIN
      ReadUse ;
      IF Use.Activity = Act THEN TBool := TRUE ;
   END ;
   CLOSE(UseFile) ;
   Activity := TBool ;
END ;

PROCEDURE ClearActivity(path:STRING ; n : BYTE) ;
BEGIN
   fn := path+'EA.USE' ;
   ASSIGN(UseFile,fn) ;
   {$I-} RESET(UseFile) ; {$I+}
   IF IOResult <> 0 THEN EXIT ;
   WHILE NOT EOF(UseFile) DO BEGIN
      ReadUse ;
      IF Use.Activity = n THEN BEGIN
         Use.Activity := 1 ;
         SEEK(UseFile,FilePos(UseFile)-1) ;
         WriteUse ;
      END ;
   END ;
   CLOSE(UseFile) ;
END ;

PROCEDURE NukeMail(instr:STRING) ;
VAR
   f          : text ;
   line       : string[80] ;
   DirInfo    : SearchRec ;
BEGIN
   displayloc(0,7,0,' Deleting messages for '+instr) ;
   FindFirst('*.FSG',Archive,DirInfo) ;
   While DosError = 0 do begin
      assign(f,DirInfo.Name) ;
      reset(f) ;
      readln(f,line) ;
      close(f) ;
      if line = formatstr(instr) then erase(f) ;
      FindNext(DirInfo) ;
   end ;
END ;


PROCEDURE TinyFlag ;
BEGIN
   sDisplay(0,15,0,'This software was made in a small computer room in the USA ') ;
   sDisplay(1,15,0,'**') ;
   sDisplay(4,15,0,'') ;
   Display(0,15,0,' ') ;
END ;


PROCEDURE LastComments ;
BEGIN
   TinyFlag ;
   sDisplay(0,14,0,'Closing ') ;
   sDisplay(0,12,0,'Eclectic Avenue ') ;
   sDisplay(0,14,0,'and returning to ') ;
   Display(0,9,0,SystemName) ;
   CRLF ;
   Display(0,7,0,'One moment...') ;
END ;


FUNCTION AtoI(Tstr:STRING) : LONGINT ;
VAR
   num        : LONGINT ;
   code       : INTEGER ;
BEGIN
   VAL(Tstr,num,code) ;
   IF code <> 0 THEN BEGIN
      AtoI := 0 ;
      EXIT ;
   END ELSE BEGIN
      AtoI := num ;
      EXIT ;
   END ;
END ;


FUNCTION Half(n:LONGINT) : LONGINT ;
BEGIN
   Half := Trunc((n DIV 2)) ;
   Exit ;
END ;


PROCEDURE ShowText(Fname:STRING) ;
VAR
   i        : BYTE ;
   FileName : STRING ;
BEGIN
   FileName := '' ;
   REPEAT
      i := Random(100) ;
   UNTIL (i > 0) AND (i < 10) ;
   FileName := 'TXTFILES\' + Fname + '.TXT' ;
   WriteToInnerBoard(FileName,FALSE,0,TRUE) ;
END ;


FUNCTION StrC(ii:LONGINT) : STRING ;
VAR
   TempString : STRING ;
BEGIN
   STR(ii,TempString) ;
   StrC := TempString ;
END ;

FUNCTION hex(n:Word):STRING;
CONST digits : ARRAY [0..15] OF Char='0123456789ABCDEF';
BEGIN
	hex:=digits[Hi(n) shr 4]+digits[Hi(n) AND $f] +
			 digits[Lo(n) shr 4]+digits[Lo(n) AND $f];
END;

FUNCTION bin(n:Word):STRING;
CONST digits : ARRAY [0..15] OF STRING[4]=('0000','0001','0010','0011',
																					 '0100','0101','0110','0111',
																					 '1000','1001','1010','1011',
																					 '1100','1101','1110','1111');
BEGIN
	bin:=digits[Hi(n) shr 4]+digits[Hi(n) AND $f] +
			 digits[Lo(n) shr 4]+digits[Lo(n) AND $f];
END;


FUNCTION FixByte(n:WORD) : STR2 ;
VAR
   temp    : STR2 ;
   solve   : STR2 ;
BEGIN
   STR(n,temp) ;
   CASE n OF
      0..9 : solve := CONCAT('0',temp) ;
      ELSE solve := temp ;
   END ;
   FixByte := solve ;
END ;

FUNCTION Strn(n:LONGINT) : STR7 ;
VAR
   temp   : STR7 ;
BEGIN
   STR(n,temp) ;
   Strn := temp ;
END ;

FUNCTION tabstr;
VAR temp : STRING;
BEGIN
	temp[0]:=Chr(n);
	FillChar(temp[1],n,fillch);
	Move(instr[1],temp[1],Length(instr));
	tabstr:=temp
END;

FUNCTION lowcase;
BEGIN
	IF ch IN ['A'..'Z'] THEN ch:=Chr(Ord(ch)+32);
	lowcase:=ch
END;

FUNCTION trimr;
BEGIN
	WHILE (Length(instr)>0) AND (instr[Length(instr)]=' ') DO
		instr[0]:=Pred(instr[0]);
	trimr:=instr
END;

FUNCTION triml;
BEGIN
	WHILE (Length(instr)>0) AND (instr[1]=' ') DO
		instr:=Copy(instr,2,Length(instr)-1);
	triml:=instr
END;

FUNCTION trimall;
BEGIN
	WHILE Pos('  ',instr)>0 DO Delete(instr,Pos('  ',instr),1);
	instr:=triml(trimr(instr));
	trimall:=instr
END;


BEGIN
  FILLCH:=' ';
  SHOWSIGN:=FALSE;
  NEGSOFF:=FALSE;
END.
