{$F+}

PROCEDURE TrapExit;
VAR
   ErrFile     : TEXT ;
   i           : byte ;

(* {$A+,B-,D+,E+,F-,I+,L+,N-,O-,R+,S+,V+}
{$M 2024,0,1024}
*)

PROCEDURE WriteLog(tstr:STRING) ;
BEGIN
   ASSIGN(ErrFile,'EA.LOG') ;
   IF EXIST('EA.LOG') THEN APPEND(ErrFile) ELSE REWRITE(ErrFile) ;
   WRITELN(ErrFile,Date,' ',Time,'  Node: ',ThisNode) ;

   WRITELN(ErrFile,'User online: ',Alias,' (',UserName,')') ;
   WRITELN(ErrFile,Tstr) ;
   WRITELN(ErrFile) ;
   flush(ErrFile) ;
   Close(ErrFile) ;
END ;


BEGIN
   IF ErrorAddr = NIL THEN BEGIN
      CASE ExitCode OF
         0   : BEGIN END ;
         1   : WriteLog('Carrier dropped') ;
         2   : WriteLog('Time limit exceeded') ;
         3   : WriteLog('User inactive') ;
         4,5 : WriteLog('EXITINFO.BBS, DORINFOx.DEF or DOOR.SYS not found') ;
         6   : WriteLog('Directory change/read error') ;
         7   : WriteLog('Communications Timeout error') ;
         10  : WriteLog('No configuration filename specified on the command line was found') ;
      END ;
      Terminate(ExitCode) ;
   END ELSE BEGIN
      ASSIGN(ErrFile,'EA.LOG') ;
      IF EXIST('EA.LOG') THEN APPEND(ErrFile) ELSE REWRITE(ErrFile) ;
      WRITELN('Runtime error occurred');
      WRITELN('Runtime error: ', exitcode);
      WRITELN('Address of error:');
      WRITELN('  Segment: ', hex(seg(erroraddr^)));
      WRITELN('  Offset:  ', hex(ofs(erroraddr^))) ;
      WRITELN(ErrFile,Date) ;
      WRITELN(ErrFile,'User online: ',UserName) ;
      WRITELN(ErrFile,'Run-time error occurred');
      WRITELN(ErrFile,'Exitcode = ', exitcode);
      WRITELN(ErrFile,'Address of error:');
      WRITELN(ErrFile,'  Segment:          ', hex(seg(erroraddr^)));
      WRITELN(ErrFile,'  Offset:           ', hex(ofs(erroraddr^))) ;
      WRITELN(ErrFile,'  Last File Opened: ',fn) ;
      WRITELN(ErrFile) ;
      flush(ErrFile) ;
      Close(ErrFile) ;
      Terminate(10) ;
   END ;
   ErrorAddr := NIL ;
END ;
{$F-}
