{$R-}
PROGRAM EAConfig ;

{$V-}
{$DEFINE VER50}

USES DOS, Crt, FastTTT5, WinTTT5, KeyTTT5, MenuTTT5,
     ReadTTT5, DirTTT5, StrnTTT5, JPString ;

{$DEFINE DIRFULL}

CONST
   Version = '2.xFW' ;
   X1 = 3;             {main coordinates - make them constants so they can }
   Y1 = 2;             {be easily modified if the screen doesn't look right}
   X2 = 79;
   Y2 = 23;
   UpArrow    = #200 ;
   DnArrow    = #208 ;
   EnterKey   = #13 ;
   F10Key     = #196 ;
   F1Key      = #187 ;


TYPE
   Str15    = String[15] ;
   FigRec  = Record
                Tnode          : STRING[2] ;
                SysName        : STRING ;
                OpName         : STRING ;
                DoorSys        : BOOLEAN ;
                DropPath       : STRING ;
                UseFossil      : BOOLEAN ;
                CName          : BYTE ;
                ComAddress     : INTEGER ;
                IRQNum         : INTEGER ;
                LockRate       : LONGINT ;
                KeyLine        : STRING ;
                AdoptedBy      : STRING ;
                MultiLine      : BOOLEAN ;
                CommDrive      : STRING ;
                TextBull,
                ANSIBull       : STRING ;

                Snoop          : BOOLEAN ;
                UseHandles     : BOOLEAN ;
                MaxParticipate : BYTE ;
                MaxGamesStarted: BYTE ;
                TurnsPerGame   : BYTE ;
                GameRetention  : BYTE ;
                StartingNumber : BYTE ;
                MaxDarts       : BYTE ;
                MaxGambles     : BYTE ;
                AllowRestrictions : BOOLEAN ;
                InactiveDays   : BYTE ;
                DungeonEnable  : byte ;
             END ;


   GameDataRec = Record
      SquareNumber            : byte ;
      Description             : string ;
      Owner                   : string ;
      PurchasePrice           : integer ;
      RentalPrice             : integer ;
      SellPrice               : integer ;
   End ;

   GameRecord = Record
      GameData                : array [1..33] of GameDataRec ;
      PlayerName              : array [1..8] of string[35] ;
      PlayerScore             : array [1..8] of longint ;
      TurnCount               : array [1..8] of integer ;
      PlayerSquareNumber      : array [1..8] of byte ;
      LastDate                : array [1..8] of string[18] ;
      StartDate               : real ;
      OutOfGame               : array [1..8] of boolean ;
      InJail                  : array [1..8] of boolean ;
      GetOutOfJail            : array [1..8] of boolean ;
      GameId                  : STRING[12] ;
      DartScore               : array [1..8] OF INTEGER ;
      InUse                   : BOOLEAN ;
   END ;


VAR
   GameFile       : FILE OF GameRecord ;
   GameInfo       : GameRecord ;
   BoxF           : byte;    {box foreground color}
   Misc           : byte;    {Misc. text foreground color}
   Back           : byte;    {main background color}
   MsgF           : byte;    {message foreground color}
   MsgB           : byte;    {message background color}
   HiF            : byte;    {highlighted field foreground color}
   HiB            : byte;    {highlighted field background color}
   LoF            : byte;    {normal field foreground color}
   LoB            : byte;    {normal field background color}
   Choice         : INTEGER ;
   Datafile       : file of FigRec ;
   info           : FigRec ;
   loopvar        : integer ;
   TVal           : INTEGER ;
   Tstr           : STRING ;
   i              : INTEGER ;
   holding        : CHAR ;
   configfilename : string ;
   modelname      : string ;
   dirinfo        : searchrec ;
   ActiveField    : byte ;
   f,b            : BYTE ;
   GlobalPick     : INTEGER ;
   HStr           : ARRAY [1..10] OF STRING ;
   help           : BYTE ;
   cgame          : BYTE ;


PROCEDURE Beep ;
BEGIN
   sound(1000) ;
   delay(300) ;
   nosound ;
END ;


PROCEDURE FunkyClear ;
VAR
   i    : BYTE ;
BEGIN
   exit ;
   textbackground(0) ;
   textcolor(15) ;
   gotoxy(1,1) ;
   for i := 1 to 25 do begin
      delay(2) ;
      delline ;
   end ;
END ;


FUNCTION hex(n:Word):STRING;
CONST digits : ARRAY [0..15] OF Char='0123456789ABCDEF';
BEGIN
	hex:=digits[Hi(n) shr 4]+digits[Hi(n) AND $f] +
			 digits[Lo(n) shr 4]+digits[Lo(n) AND $f];
END;

FUNCTION Half(n:LONGINT) : LONGINT ;
BEGIN
   Half := Trunc((n DIV 2)) ;
   Exit ;
END ;


{$I EAHELP}


 Procedure Set_Colors;
 begin
     If ColorScreen then
     begin
         BoxF := yellow;
         Misc := LightCyan;
         Back := blue;
         MsgF := yellow;
         MsgB := red;
         HiF  := white;
         HiB  := red;
         LoF  := white;
         LoB  := Cyan;
     end
     else
     begin
         BoxF := white;
         Misc := Lightgray;
         Back := black;
         MsgF := black;
         MsgB := lightgray;
         HiF  := black;
         HiB  := lightgray;
         LoF  := white;
         LoB  := black;
     end;
 end; {of proc Set_Colors}



PROCEDURE ShowComName ;
BEGIN
   CASE Info.CName OF
      0 : WriteAt(27,11,f,b,'COM1 ') ;
      1 : WriteAt(27,11,f,b,'COM2 ') ;
      2 : WriteAt(27,11,f,b,'COM3 ') ;
      3 : WriteAt(27,11,f,b,'COM4 ') ;
      4 : WriteAt(27,11,f,b,'COM5 ') ;
      5 : WriteAt(27,11,f,b,'COM6 ') ;
      6 : WriteAt(27,11,f,b,'COM7 ') ;
      7 : WriteAt(27,11,f,b,'COM8 ') ;
      8 : WriteAt(27,11,f,b,'LOCAL') ;
      ELSE WriteAt(27,11,f,b,'ERROR') ;
   END ;
END ;


PROCEDURE ShowSystemValues ;
BEGIN
   WriteAt(27,5,f,b,Info.Tnode) ;
   WriteAt(27,6,f,b,Info.SysName) ;
   WriteAt(27,7,f,b,Info.OpName) ;
   IF Info.DoorSys THEN WriteAt(27,8,f,b,'DOOR.SYS    ')
     ELSE WriteAt(27,8,f,b,'DORINFOx.DEF') ;
   WriteAt(27,9,f,b,Info.DropPath) ;
   IF Info.UseFossil THEN WriteAt(27,10,f,b,'FOSSIL DRIVER')
     ELSE WriteAt(27,10,f,b,'ASYNC ENGINE ') ;
   ShowComName ;
   WriteAt(27,12,f,b,'$'+Hex(Info.ComAddress)) ;
   WriteAt(27,13,f,b,ItoA(Info.IRQNum)) ;
   WriteAt(27,14,f,b,ItoA(Info.LockRate)) ;
   WriteAt(27,15,f,b,Info.KeyLine) ;
   WriteAt(27,16,f,b,Info.AdoptedBy) ;
   IF Info.MultiLine THEN WriteAt(27,17,f,b,'MULTI-LINE ')
     ELSE WriteAt(27,17,f,b,'SINGLE-LINE') ;
   IF Info.CommDrive = '' THEN WriteAt(27,18,f,b,'NONE')
     ELSE WriteAt(27,18,f,b,Info.CommDrive) ;
   WriteAt(27,19,f,b,Info.TextBull) ;
   WriteAt(27,20,f,b,Info.ANSIBull) ;
END ;


PROCEDURE ShowGameValues ;
VAR
   f, b   : BYTE ;
BEGIN
    f := 14 ;
    b := 0 ;
    IF Info.Snoop THEN WriteAt(74,5,f,b,'YES')
      ELSE WriteAt(74,5,f,b,'NO ') ;
    IF Info.UseHandles THEN WriteAt(74,6,f,b,'YES')
      ELSE WriteAt(74,6,f,b,'NO ') ;
    WriteAt(74,7,f,b,ItoA(Info.MaxParticipate)) ;
    WriteAt(74,8,f,b,ItoA(Info.MaxGamesStarted)) ;
    WriteAt(74,9,f,b,ItoA(Info.TurnsPerGame)) ;
    WriteAt(74,10,f,b,ItoA(Info.GameRetention)) ;
    WriteAt(74,11,f,b,ItoA(Info.StartingNumber)) ;
    WriteAt(74,12,f,b,ItoA(Info.MaxDarts)) ;
    WriteAt(74,13,f,b,ItoA(Info.MaxGambles)) ;
    if info.allowrestrictions then writeat(74,14,f,b,'YES')
      else writeat(74,14,f,b,'NO ') ;
    writeat(74,15,f,b,ItoA(info.inactivedays)) ;
    if info.dungeonenable = 0 then writeat(74,16,f,b,'YES')
      else writeat(74,16,f,b,'NO ') ;
END ;


PROCEDURE ShowPropertyValues ;
VAR
   f, b   : BYTE ;
BEGIN
    f := 14 ;
    b := 0 ;
    ClearText(22,5,25,5,f,b) ;
    WriteAt(22,5,7,b,ItoA(GameInfo.GameData[cgame].SquareNumber)) ;
    ClearText(22,6,45,6,f,b) ;
    WriteAt(22,6,7,b,GameInfo.GameData[cgame].Description) ;
    ClearText(22,7,45,7,f,b) ;
    WriteAt(22,7,f,b,ItoA(GameInfo.GameData[cgame].PurchasePrice)) ;
    ClearText(22,8,45,8,f,b) ;
    WriteAt(22,8,f,b,ItoA(GameInfo.GameData[cgame].RentalPrice)) ;
END ;



PROCEDURE SaveChanges ;
VAR ch : char ;
    b  : byte ;
BEGIN
   RTTT.PFcol := yellow ;
   RTTT.PBcol := blue ;
   RTTT.End_Chars := [EnterKey,MLeftB] ;
   R_Char := #0 ;
   GrowMkWin(28,11,52,13,15,1,7) ;
   Read_Select(30,12,'Save Profile?  ','Yes No',b) ;
   RmWin ;
   if b = 1 then ch := 'Y' else ch := 'N' ;
   if ch = 'N' then begin
      delay(100) ;
      GrowMkWin(29,11,50,13,15,1,7) ;
      WriteBetween(29,50,12,15,1,'Profile Not Saved.') ;
      delaykey(5000) ;
      RmWin ;
      exit ;
   end ;
   assign(datafile,configfilename) ;
   rewrite(datafile) ;
   write(datafile,info) ;
   close(datafile) ;
   GrowMkWin(29,11,50,13,15,1,7) ;
   WriteBetween(29,50,12,15,1,'Profile Saved.') ;
   delaykey(3000) ;
   RmWin ;
END ;


Procedure PaintSystemScreen;
var
   f,b    : byte ;
begin
    Set_Colors;
    f := 15 ;
    b := 0 ;
    FunkyClear ;
    FillScreen(1,1,80,25,lightcyan,blue,chr(177)) ;
    GrowMkWin(X1,Y1,X2,Y2,f,b,7) ;
    WriteAt(33,3,12,b,'System Settings') ;
    WriteAt(5,5,f,b,'Line Number:');
    WriteAt(5,6,f,b,'BBS Name:');
    WriteAt(5,7,f,b,'Sysop Operator Name:');
    WriteAt(5,8,f,b,'DropFile Type:');
    WriteAt(5,9,f,b,'DropFile Path:');
    WriteAt(5,10,f,b,'Communication Driver:');
    WriteAt(5,11,f,b,'Comm. Port Name:');
    WriteAt(5,12,f,b,'Comm. Port Address:') ;
    WriteAt(5,13,f,b,'IRQ Number:') ;
    WriteAt(5,14,f,b,'Locked Baud Rate:') ;
    WriteAt(5,15,f,b,'Registration Number:') ;
    WriteAt(5,16,f,b,'Adopted By:') ;
    WriteAt(5,17,f,b,'Multiline Operations:') ;
    WriteAt(5,18,f,b,'Communications Drive:') ;
    WriteAt(5,19,f,b,'Text Bulletin Name:') ;
    WriteAt(5,20,f,b,'ANSI Bulletin Name:') ;
    WriteAt(X1+10,22,12,b,'Press F1 for help on any field or F10 to complete input') ;
    for i := 5 to 20 do WriteAt(26,i,15,b,'[') ;
    WriteAt(29,5,15,b,']') ;
    WriteAt(72,6,15,b,']') ;
    WriteAt(62,7,15,b,']') ;
    WriteAt(39,8,15,b,']') ;
    WriteAt(77,9,15,b,']') ;
    WriteAt(40,10,15,b,']') ;
    WriteAt(32,11,15,b,']') ;
    WriteAt(32,12,15,b,']') ;
    WriteAt(29,13,15,b,']') ;
    WriteAt(33,14,15,b,']') ;
    WriteAt(37,15,15,b,']') ;
    WriteAt(62,16,15,b,']') ;
    WriteAt(38,17,15,b,']') ;
    WriteAt(77,18,15,b,']') ;
    WriteAt(77,19,15,b,']') ;
    WriteAt(77,20,15,b,']') ;
end ;


Procedure PaintGameScreen;
var
   f,b    : byte ;
begin
    Set_Colors;
    f := 15 ;
    b := 0 ;
    FunkyClear ;
    FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
    ClearText(1,23,80,24,white,red) ;
    WriteCenter(23,white,red,'Another fine program from JPSoft') ;
    WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
    GrowMkWin(X1,Y1,X2,19,15,0,7) ;
    WriteAt(34,3,12,b,'Game Settings') ;
    WriteAt(5,5,f,b, 'Do you wish to use Snoop mode?.....................................') ;
    WriteAt(5,6,f,b, 'Can players use Handles (aliases)?.................................');
    WriteAt(5,7,f,b, 'The maximum number of games each player may participate in?........');
    WriteAt(5,8,f,b, 'How many games may each player start per "game duration" period?...');
    WriteAt(5,9,f,b, 'How many turns each player receives per game/per day?..............') ;
    WriteAt(5,10,f,b,'How many days will each game last (game duration)?.................');
    WriteAt(5,11,f,b,'How many players are required in a game before play may commence?..');
    WriteAt(5,12,f,b,'How many darts may a player throw when landing on space 26?........') ;
    WriteAt(5,13,f,b,'How many times may a player gamble when landing on space 22?.......') ;
    WriteAt(5,14,f,b,'Are players allowed to place restrictions on games they start?.....') ;
    WriteAt(5,15,f,b,'How many days of inactivity before a player is removed?............') ;
    WriteAt(5,16,f,b,'Should the Dungeon be enabled at Lookout Point?....................') ;
    WriteAt(X1+10,18,12,b,'Press F1 for help on any field or F10 to complete input') ;
    f := white ;
    b := 0 ;
    ClearText(74,5,77,5,f,b) ;
    ClearText(74,6,77,6,f,b) ;
    ClearText(74,7,76,7,f,b) ;
    ClearText(74,8,76,8,f,b) ;
    ClearText(74,9,76,9,f,b) ;
    ClearText(74,10,76,10,f,b) ;
    ClearText(74,11,76,11,f,b) ;
    ClearText(74,12,76,12,f,b) ;
    ClearText(74,13,76,13,f,b) ;
    ClearText(74,14,76,14,f,b) ;
    ClearText(74,15,76,15,f,b) ;
    ClearText(74,16,76,16,f,b) ;
end ;


Procedure PaintPropertyScreen;
var
   f,b    : byte ;
begin
    Set_Colors;
    f := 15 ;
    b := 0 ;
    FunkyClear ;
    FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
    ClearText(1,23,80,24,white,red) ;
    WriteCenter(23,white,red,'Another fine program from JPSoft') ;
    WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
    GrowMkWin(X1,Y1,X2,12,15,0,7) ;
    WriteAt(34,3,12,b,'Property Values') ;
    WriteAt(5,5,7,b, 'Square Number:') ;
    WriteAt(5,6,7,b, 'Property Name:');
    WriteAt(5,7,f,b, 'Purchase Price:');
    WriteAt(5,8,f,b, 'Rental Price:') ;
    WriteAt(12,10,12,b,'Ctrl-Left=Previous, Ctrl-Right=Next, F1=Help, F10=Finished') ;
    f := 15 ;
    b := 0 ;
    ClearText(22,5,77,5,f,b) ;
    ClearText(22,6,77,6,f,b) ;
    ClearText(22,7,76,7,f,b) ;
    ClearText(22,8,76,8,f,b) ;
end ;


PROCEDURE EvaluateKey(up,dn:BYTE) ;
BEGIN
   CASE R_Char OF
      F1Key     : ShowHelp(help) ;
      MUp,
      UpArrow   : ActiveField:=up ;
      DnArrow,
      MDown,
      MLeftB,
      EnterKey  : ActiveField:=dn ;
   END ;
END ;


PROCEDURE GetFieldInput ;
VAR
   Tstr   : STRING ;
   num,
   code   : INTEGER ;
   chx    : CHAR ;
BEGIN
   Oncursor ;
   CASE ActiveField OF
      1 : BEGIN
             help := 1 ;
             R_Char := #0 ;
             Read_String_Upper(27,5,2,'',0,Info.Tnode) ;
             EvaluateKey(14,2) ;
          END ;
      2 : BEGIN
             help := 2 ;
             R_char := #0 ;
             Read_String_Upper(27,6,45,'',0,Info.SysName) ;
             EvaluateKey(1,3) ;
          END ;
      3 : BEGIN
             help := 3 ;
             R_char := #0 ;
             Read_String_Upper(27,7,35,'',0,Info.OpName) ;
             EvaluateKey(2,4) ;
          END ;
      4 : BEGIN
             help := 4 ;
             R_Char := #0 ;
             GotoXY(27,8) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                MLeftB,
                DnArrow  : ActiveField := 5 ;
                UpArrow  : ActiveField := 3 ;
                #32      : BEGIN
                              IF Info.DoorSys THEN BEGIN
                                 WriteAt(27,8,f,b,'DORINFOx.DEF') ;
                                 Info.DoorSys := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(27,8,f,b,'DOOR.SYS    ') ;
                                 Info.DoorSys := TRUE ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
      5 : BEGIN
             help := 5 ;
             R_Char := #0 ;
             Read_String_Upper(27,9,50,'',0,Info.DropPath) ;
             IF Info.DropPath <> '' THEN BEGIN
                IF Info.DropPath[length(Info.DropPath)] <> '\'
                  THEN Info.DropPath := Info.DropPath + '\' ;
                WriteAt(27,9,f,b,Info.DropPath) ;
             END ;
             EvaluateKey(4,6) ;
          END ;
      6 : BEGIN
             help := 6 ;
             R_Char := #0 ;
             GotoXY(27,10) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                MLeftB,
                DnArrow  : BEGIN
                              IF Info.UseFossil THEN ActiveField := 11
                                ELSE ActiveField := 7 ;
                           END ;
                UpArrow  : ActiveField := 5 ;
                #32      : BEGIN
                              IF Info.UseFossil THEN BEGIN
                                 WriteAt(27,10,f,b,'ASYNC ENGINE ') ;
                                 Info.UseFossil := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(27,10,f,b,'FOSSIL DRIVER') ;
                                 Info.UseFossil := TRUE ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
      7 : BEGIN
             help := 7 ;
             R_Char := #0 ;
             IF NOT Info.UseFossil THEN BEGIN
                GotoXY(27,11) ;
                REPEAT
                   chx := GetKey ;
                   IF (chx = F10Key) OR (chx = MLeftB) THEN BEGIN
                      R_Char := F10Key ;
                      Exit ;
                   END ;
                   IF chx = F1Key THEN ShowHelp(help)
                   ELSE IF chx = #32 THEN BEGIN
                      IF Info.CName < 8 THEN INC(Info.CName)
                         ELSE Info.CName := 0 ;
                      ShowComName ;
                      CASE Info.Cname OF
                         0 : BEGIN
                                Info.ComAddress := $03F8 ;
                                Info.IRQNum := 4 ;
                             END ;
                         1 : BEGIN
                                Info.ComAddress := $02F8 ;
                                Info.IRQNum := 3 ;
                             END ;
                         2 : BEGIN
                                Info.ComAddress := $03E8 ;
                                Info.IRQNum := 4 ;
                             END ;
                         3 : BEGIN
                                Info.ComAddress := $02E8 ;
                                Info.IRQNum := 3 ;
                             END ;
                      END ; {case}
                      WriteAt(27,12,f,b,'$'+Hex(Info.ComAddress)) ;
                      WriteAt(27,13,f,b,ItoA(Info.IRQNum)) ;
                      GotoXY(27,11) ;
                   END ELSE IF (chx=EnterKey) OR (chx=DnArrow)
                     THEN ActiveField := 8
                   ELSE IF chx=UpArrow
                     THEN ActiveField := 6 ;
                UNTIL chx IN [EnterKey,UpArrow,DnArrow] ;
             END ELSE ActiveField := 8 ;
          END ;
      8 : BEGIN
             help := 8 ;
             R_Char := #0 ;
             Tstr := Hex(Info.ComAddress) ;
             Read_String(27,12,4,'$',0,Tstr) ;
             IF Tstr <> '' THEN BEGIN
                IF Tstr[1] <> '$' THEN INSERT('$',Tstr,1) ;
                Info.ComAddress := Str_to_Int(Tstr) ;
             END ;
             WriteAt(27,12,f,b,'$'+Hex(Info.ComAddress)) ;
             EvaluateKey(7,9) ;
          END ;
      9 : BEGIN
             help := 9 ;
             R_Char := #0 ;
             Read_Int(27,13,2,'',0,Info.IrqNum,1,12) ;
             EvaluateKey(8,10) ;
          END ;
      10: BEGIN
             help := 10 ;
             R_Char := #0 ;
             Read_LongInt(27,14,6,'',0,Info.LockRate,0,115200) ;
             CASE R_Char OF
                UpArrow   : BEGIN
                               IF Info.UseFossil THEN ActiveField := 6
                                 ELSE ActiveField := 9 ;
                            END ;
                DnArrow,
                MLeftB,
                EnterKey  : ActiveField := 11 ;
                F1Key     : ShowHelp(Help) ;
             END ;
             IF Info.LockRate=0 THEN WriteAt(27,14,f,b,'0') ;
          END ;
      11: BEGIN
             help := 11 ;
             R_Char := #0 ;
             Read_String_Upper(27,15,10,'',0,Info.KeyLine) ;
             IF Info.UseFossil THEN EvaluateKey(6,12)
               ELSE EvaluateKey(10,12) ;
          END ;
      12: BEGIN
             help := 12 ;
             R_Char := #0 ;
             Read_String_Upper(27,16,35,'',0,Info.AdoptedBy) ;
             EvaluateKey(11,13) ;
          END ;
      13: BEGIN
             help := 13 ;
             R_Char := #0 ;
             GotoXY(27,17) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                MLeftB,
                DnArrow  : ActiveField := 14 ;
                UpArrow  : ActiveField := 12 ;
                #32      : BEGIN
                              IF Info.MultiLine THEN BEGIN
                                 WriteAt(27,17,f,b,'SINGLE LINE') ;
                                 Info.MultiLine := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(27,17,f,b,'MULTI-LINE ') ;
                                 Info.MultiLine := TRUE ;
                              END ;
                           END ;
             END ; {case}
          END ;
      14: BEGIN
             help := 14 ;
             R_Char := #0 ;
             Read_String_Upper(27,18,50,'',0,Info.CommDrive) ;
             EvaluateKey(13,15) ;
             IF Info.CommDrive <> '' THEN BEGIN
                IF Info.CommDrive[length(Info.CommDrive)] <> '\'
                  THEN Info.CommDrive := Info.CommDrive + '\' ;
                WriteAt(27,18,f,b,Info.CommDrive) ;
             END ;
          END ;
      15: BEGIN
             help := 15 ;
             R_Char := #0 ;
             Read_String_Upper(27,19,50,'',0,Info.TextBull) ;
             EvaluateKey(14,16) ;
          END ;
      16: BEGIN
             help := 16 ;
             R_Char := #0 ;
             Read_String_Upper(27,20,50,'',0,Info.ANSIBull) ;
             EvaluateKey(15,1) ;
          END ;
   END ; {case}
   Offcursor ;
END ;



PROCEDURE SystemSetup ;
BEGIN
   f := 14 ;
   b := 0 ;
   PaintSystemScreen ;
   ShowSystemValues ;
   WITH RTTT DO BEGIN
      EraseDefault := true ;
      End_Chars := [UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
      AllowEsc := False ;
      FCol := 14 ;
      BCol := 0 ;
      PFcol := 14 ;
      PBcol := 0 ;
      WhiteSpace := #250 ;
      Msg_Line := 24 ;
   END ;
   ActiveField := 1 ;
   REPEAT
      GetFieldInput ;
   UNTIL R_Char = F10Key ;
END ;



PROCEDURE GetGameFieldInput ;
VAR
   chx    : CHAR ;
BEGIN
   f := 14 ;
   b := 0 ;
   Oncursor ;
   CASE ActiveField OF
      1 : BEGIN
             help := 17 ;
             GotoXY(74,5) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                DnArrow  : ActiveField := 2 ;
                UpArrow  : ActiveField := 12 ;
                #32      : BEGIN
                              IF Info.Snoop THEN BEGIN
                                 WriteAt(74,5,f,b,'NO ') ;
                                 Info.Snoop := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(74,5,f,b,'YES') ;
                                 Info.Snoop := TRUE ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
      2 : BEGIN
             help := 18 ;
             GotoXY(74,6) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                DnArrow  : ActiveField := 3 ;
                UpArrow  : ActiveField := 1 ;
                #32      : BEGIN
                              IF Info.UseHandles THEN BEGIN
                                 WriteAt(74,6,f,b,'NO ') ;
                                 Info.UseHandles := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(74,6,f,b,'YES') ;
                                 Info.UseHandles := TRUE ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
      3 : BEGIN
             help := 19 ;
             Read_Byte(74,7,2,'',0,Info.MaxParticipate,1,10) ;
             EvaluateKey(2,4) ;
          END ;
      4 : BEGIN
             help := 20 ;
             Read_Byte(74,8,2,'',0,Info.MaxGamesStarted,1,10) ;
             EvaluateKey(3,5) ;
          END ;
      5 : BEGIN
             help := 21 ;
             Read_Byte(74,9,2,'',0,Info.TurnsPerGame,1,25) ;
             EvaluateKey(4,6) ;
          END ;
      6 : BEGIN
             help := 22 ;
             Read_Byte(74,10,2,'',0,Info.GameRetention,1,99) ;
             EvaluateKey(5,7) ;
          END ;
      7 : BEGIN
             help := 23 ;
             Read_Byte(74,11,2,'',0,Info.StartingNumber,1,8) ;
             EvaluateKey(6,8) ;
          END ;
      8 : BEGIN
             help := 24 ;
             Read_Byte(74,12,2,'',0,Info.MaxDarts,1,10) ;
             EvaluateKey(7,9) ;
          END ;
      9 : BEGIN
             help := 25 ;
             Read_Byte(74,13,2,'',0,Info.MaxGambles,1,10) ;
             EvaluateKey(8,10) ;
          END ;
      10: BEGIN
             help := 28 ;
             GotoXY(74,14) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                DnArrow  : ActiveField := 11 ;
                UpArrow  : ActiveField := 9 ;
                #32      : BEGIN
                              IF Info.allowrestrictions THEN BEGIN
                                 WriteAt(74,14,f,b,'NO ') ;
                                 Info.allowrestrictions := FALSE ;
                              END ELSE BEGIN
                                 WriteAt(74,14,f,b,'YES') ;
                                 Info.allowrestrictions := TRUE ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
      11: BEGIN
             help := 29 ;
             Read_Byte(74,15,2,'',0,Info.InActiveDays,7,255) ;
             EvaluateKey(10,12) ;
          END ;
      12: BEGIN
             help := 30 ;
             GotoXY(74,16) ;
             REPEAT
                chx := UPCASE(GetKey) ;
             UNTIL chx IN [#32,#13,UpArrow,DnArrow,EnterKey,F10Key,F1Key] ;
             CASE chx OF
                F1Key    : ShowHelp(help) ;
                F10Key   : R_Char := F10Key ;
                EnterKey,
                DnArrow  : ActiveField := 1 ;
                UpArrow  : ActiveField := 11 ;
                #32      : BEGIN
                              IF Info.DungeonEnable = 0 THEN BEGIN
                                 WriteAt(74,16,f,b,'NO ') ;
                                 Info.DungeonEnable := 1 ;
                              END ELSE BEGIN
                                 WriteAt(74,16,f,b,'YES') ;
                                 Info.DungeonEnable := 0 ;
                              END ;
                           END ;
             END ; {case chx}
          END ;
   END ;
   OffCursor ;
END ;


PROCEDURE GetPropertyInput ;
VAR
   chx    : CHAR ;
BEGIN
   f := 14 ;
   b := 0 ;
   Oncursor ;
   CASE ActiveField OF
      1 : BEGIN
             help := 26 ;
             Read_Int(22,7,4,'',0,GameInfo.GameData[cgame].PurchasePrice,1,9999) ;
             EvaluateKey(2,2) ;
          END ;
      2 : BEGIN
             help := 27 ;
             Read_Int(22,8,4,'',0,GameInfo.GameData[cgame].RentalPrice,1,9999) ;
             EvaluateKey(1,1) ;
          END ;
   END ;
   OffCursor ;
END ;




PROCEDURE GameSetup ;
VAR
   Choice    : BYTE ;
BEGIN
   PaintGameScreen ;
   ShowGameValues ;
   WITH RTTT DO BEGIN
      EraseDefault := true ;
      End_Chars := [UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
      AllowEsc := False ;
      PFcol := 14 ;
      PBcol := 0 ;
      Msg_Line := 24 ;
      WhiteSpace := ' ' ;
      FCol := 14 ;
      BCol := 0 ;
   END ;
   ActiveField := 1 ;
   R_Char := #0 ;
   REPEAT
      GetGameFieldInput ;
   UNTIL R_Char = F10Key ;
END ;


PROCEDURE PropertySetup ;
VAR
   Choice    : BYTE ;
BEGIN
   PaintPropertyScreen ;

   WITH RTTT DO BEGIN
      EraseDefault := true ;
      End_Chars := [CtrlLarr,CtrlRarr,UpArrow,DnArrow,EnterKey,F10Key,MLeftB,F1Key] ;
      AllowEsc := False ;
      PFcol := 14 ;
      PBcol := 0 ;
      Msg_Line := 24 ;
      WhiteSpace := ' ' ;
      FCol := 14 ;
      BCol := 0 ;
   END ;
   ActiveField := 1 ;
   R_Char := #0 ;
   assign(GameFile,'DEFAULT.BRD') ;
   {$I-} reset(GameFile) ; {$I+}
   if ioresult <> 0 then exit ;
   read(GameFile,GameInfo) ;
   cgame := 2 ;
   ShowPropertyValues ;
   REPEAT
      GetPropertyInput ;
      if r_char = ctrlLarr then begin
         case cgame of
            2      : cgame := 33 ;
            3..4   : dec(cgame) ;
            6      : cgame := 4 ;
            7..12  : dec(cgame) ;
            19     : cgame := 12 ;
            20..22 : dec(cgame) ;
            24     : cgame := 22 ;
            25..28 : dec(cgame) ;
            30     : cgame := 28 ;
            32     : cgame := 30 ;
            33     : cgame := 32 ;
         end ;
         ShowPropertyValues ;
      end else if r_char = ctrlRarr then begin
         case cgame of
            2..3   : inc(cgame) ;
            4      : cgame := 6 ;
            6..11  : inc(cgame) ;
            12     : cgame := 19 ;
            19..21 : inc(cgame) ;
            22     : cgame := 24 ;
            24..27 : inc(cgame) ;
            28     : cgame := 30 ;
            30     : cgame := 32 ;
            32     : cgame := 33 ;
            33     : cgame := 2 ;
         end ;
         ShowPropertyValues ;
      end ;
   UNTIL R_Char = F10Key ;
   seek(gamefile,0) ;
   write(gamefile,gameinfo) ;
   close(gamefile) ;
END ;



PROCEDURE MainMenu ;
VAR
   M       : Menu_Record ;
   Retcode,
   Pick    : INTEGER ;
BEGIN
   Pick := 1 ;
   assign(datafile,configfilename) ;
   reset(datafile) ;
   read(datafile,info) ;
   close(datafile) ;
   REPEAT
      Menu_Set(M) ;
      with M do begin
         Heading1 := 'Eclectic Avenue Configuration Utility' ;
         Heading2 := 'Editing Profile '+configfilename ;
         Topic[1] := 'System Setup Options' ;
         Topic[2] := 'Game Setup Options' ;
         Topic[3] := 'Quit This Profile' ;
         TotalPicks := 3 ;
         PicksPerLine := 1 ;
         AddPrefix := 4 ;
         TopLeftXY[1] := 0 ;
         TopLeftXY[2] := 6 ;
         BoxType := 5 ;
         Margins := 10 ;
         if ColorScreen then begin
            Colors[1] := white ;
            Colors[2] := red ;
            Colors[3] := lightgray ;
            Colors[4] := blue ;
            Colors[5] := cyan ;
         end else begin
            Colors[1] := white ;
            Colors[2] := black ;
            Colors[3] := black ;
            Colors[4] := lightgray ;
            Colors[5] := white ;
         end ;
         AllowESC := true ;
      end ;
      FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
      FillScreen(1,25,80,25,white,black,chr(32)) ;
      ClearText(1,23,80,24,white,red) ;
      WriteCenter(23,white,red,'Use cursor keys, highlighted letter, or mouse to select.') ;
      WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
      DisplayMenu(M,true,Pick,retcode) ;
      if (Pick = 3) or (retcode=1) then begin
         SaveChanges ;
         exit ;
      end ;
      Case Pick Of
         1 : SystemSetup ;
         2 : GameSetup ;
      End ;
   UNTIL (Pick=3) or (retcode=1) ;
END ;


FUNCTION GetNew : STRING ;
VAR
   NewName     : STRING ;
   i           : BYTE ;
   Errcode     : INTEGER ;
BEGIN
   FunkyClear ;
   NewName := '' ;
   Read_String(12,12,8,
     ' Enter new profile name (NO EXTENSION!) => ',2,newname) ;
   if newname = '' then begin
      GetNew := '' ;
      exit ;
   end ;
   if pos('.',newname) <> 0 then begin
      GrowMkWin(28,11,48,13,15,4,1) ;
      WriteBetween(28,48,12,15,4,'Invalid filename!') ;
      delaykey(10000) ;
      RmWin ;
      GetNew := '' ;
      exit ;
   end ;

   newname := changecase(newname) ;
   configfilename := newname+'.CFG' ;
   if exist(configfilename) then begin
      GrowMkWin(20,11,60,13,15,1,1) ;
      WriteBetween(20,60,12,15,1,'Profile already exists!') ;
      delaykey(10000) ;
      RmWin ;
      configfilename := '' ;
      GetNew := '' ;
      exit ;
   end ;

   modelname := '' ;
   findfirst('*.cfg',archive,dirinfo) ;
   if doserror = 0 then begin
      FunkyClear ;
      FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
      ClearText(1,23,80,24,white,red) ;
      WriteCenter(23,white,red,'Select a profile to use as a model and press <ENTER>.') ;
      WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
      GrowMkWin(20,9,60,16,15,4,8) ;
      WriteAt(22,11,15,4,'Select an existing profile to be used') ;
      WriteAt(22,12,15,4,'as a model for the new profile.  All') ;
      WriteAt(22,13,15,4,'values will be copied from the model') ;
      WriteAt(22,14,15,4,'to the new profile.') ;
      delaykey(20000) ;
      RmWin ;
      DTTT.AllowCD := false ;
      DTTT.AllowInput := false ;
      ModelName := Display_Directory('*.CFG',Errcode) ;
      if Errcode <> 0 then ModelName := '' ;
      FunkyClear ;
   end ;
   if modelname <> '' then begin
      if pos('\',modelname) <> 0 then begin
         modelname:=copy(modelname,(lastpos('\',modelname)+1),12) ;
      end ;
      GrowMkWin(20,11,60,13,15,1,1) ;
      WriteBetween(20,60,12,15,1,'Using '+modelname+' as model') ;
      delaykey(10000) ;
      RmWin ;
      assign(datafile,modelname) ;
      reset(datafile) ;
      read(datafile,info) ;
      close(datafile) ;
      assign(datafile,configfilename) ;
      rewrite(datafile) ;
      write(datafile,info) ;
      close(datafile) ;
   end else begin
      GrowMkWin(20,11,60,13,15,1,1) ;
      WriteBetween(20,60,12,15,1,'No model will be used') ;
      delaykey(10000) ;
      RmWin ;
      assign(datafile,configfilename) ;
      {$I-} reset(datafile) ; {$I+}
      if ioresult <> 0 then begin
         rewrite(datafile) ;
         with info do begin
            Tnode        := '1' ;
            SysName      := '' ;
            SysName[0]   := #0 ;
            OpName       := '' ;
            OpName[0]    := #0 ;
            DoorSys      := FALSE ;
            DropPath     := 'C:\BBS\' ;
            CName        := 0 ;
            ComAddress   := $3F8 ;
            IRQNum       := 4 ;
            LockRate     := 0 ;
            UseFossil    := TRUE ;
            KeyLine      := '000000' ;
            AdoptedBy    := '' ;
            MultiLine    := FALSE ;
            CommDrive    := '' ;
            TextBull     := '' ;
            ANSIBull     := '' ;

            Snoop        := TRUE ;
            UseHandles   := FALSE ;
            MaxParticipate := 5 ;
            MaxGamesStarted := 3 ;
            TurnsPerGame := 10 ;
            GameRetention := 7 ;
            StartingNumber := 1 ;
            MaxDarts := 10 ;
            MaxGambles := 10 ;
            allowrestrictions := false ;
            inactivedays := 30 ;
            DungeonEnable := 0 ;
         end ;
         write(datafile,info) ;
         close(datafile) ;
      end ;
   end ;
   GrowMkWin(20,11,60,13,15,1,1) ;
   WriteBetween(20,60,12,15,1,'New profile has been created.') ;
   delaykey(10000) ;
   RmWin ;
   GetNew := ConfigFileName ;
END ;


PROCEDURE PickList ;
CONST
   maxnumfiles  = 20 ;
TYPE
   str12        = string[12] ;
VAR
   i            : byte ;
   dirinfo      : searchrec ;
   M            : Menu_Record ;
   Pick,RetCode : integer ;
   Delname,
   FileName     : string ;
   Errcode      : integer ;
   ch           : char ;
BEGIN
   GlobalPick := 1 ;
   FunkyClear ;
   REPEAT
      ConfigFileName := '' ;
      Menu_Set(M) ;
      with M do begin
         Heading1 := 'Eclectic Avenue '+version ;
         Heading2 := 'Configuration Utility';
         Topic[1] := 'Edit Existing Profile' ;
         Topic[2] := 'Create New Profile' ;
         Topic[3] := 'Delete Existing Profile' ;
         Topic[4] := 'Property Value Defaults' ;
         Topic[5] := 'Quit' ;
         TotalPicks := 5 ;
         PicksPerLine := 1 ;
         AddPrefix := 4 ;
         TopLeftXY[1] := 0 ;
         TopLeftXY[2] := 6 ;
         BoxType := 5 ;
         Margins := 10 ;
         if ColorScreen then begin
            Colors[1] := white ;
            Colors[2] := red ;
            Colors[3] := lightgray ;
            Colors[4] := blue ;
            Colors[5] := cyan ;
         end else begin
            Colors[1] := white ;
            Colors[2] := black ;
            Colors[3] := black ;
            Colors[4] := lightgray ;
            Colors[5] := white ;
         end ;
         AllowESC := true ;
      end ; {with}
      FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
      ClearText(1,23,80,24,white,red) ;
      WriteCenter(23,white,red,'Use cursor keys, highlighted letter, or mouse to select.') ;
      WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
      DisplayMenu(M,true,GlobalPick,retcode) ;
      if (GlobalPick = 5) or (retcode=1) then begin
         FunkyClear ;
         Reset_Startup_Mode ;
         oncursor ;
         halt(0) ;
      end ;
      case GlobalPick of
          1 : begin           { edit existing profile }
                 IF Exist('*.CFG') THEN BEGIN
                    FunkyClear ;
                    FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
                    ClearText(1,23,80,24,white,red) ;
                    WriteCenter(23,white,red,'Use cursor keys or mouse to make selection and then press <ENTER>.') ;
                    WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
                    DTTT.AllowCD := false ;
                    DTTT.AllowInput := false ;
                    ConfigFileName := Display_Directory('*.CFG',Errcode) ;
                    if Errcode <> 0 then ConfigFileName := '' ;
                    if configfilename <> '' then begin
                       if pos('\',configfilename) <> 0 then
                          configfilename:=copy(configfilename,(lastpos('\',configfilename)+1),12) ;
                    end ;
                    FunkyClear ;
                 END ELSE BEGIN
                    GrowMkWin(29,11,50,13,15,1,6) ;
                    WriteBetween(29,50,12,15,1,'No profiles found!') ;
                    delaykey(5000) ;
                    RmWin ;
                 END ;
              end ;
          2 : ConfigFileName := GetNew ;
          3 : begin           { delete a profile }
                 if exist('*.cfg') then begin
                    FunkyClear ;
                    FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
                    ClearText(1,23,80,24,white,red) ;
                    WriteCenter(23,white,red,'Use cursor keys or mouse to make selection and then press <ENTER>.') ;
                    WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;
                    DTTT.AllowCD := false ;
                    DTTT.AllowInput := false ;
                    DelName := Display_Directory('*.CFG',Errcode) ;
                    FunkyClear ;
                    if Errcode = 0 then begin
                       WriteCenter(12,12,0,'Delete profile '+Delname+'? (y,n): ') ;
                       repeat
                          ch := upcase(readkey) ;
                       until ch in ['Y','N'] ;
                       GrowMkWin(29,11,50,13,15,1,1) ;
                       if ch = 'Y' then begin
                          deletefile(delname) ;
                          WriteBetween(29,50,12,15,1,'Profile deleted.') ;
                       end else WriteBetween(29,50,12,15,1,'Profile saved.') ;
                       delaykey(5000) ;
                       RmWin ;
                    end ;
                 end else begin
                    GrowMkWin(29,11,50,13,15,1,6) ;
                    WriteBetween(29,50,12,15,1,'No profiles found!') ;
                    delaykey(5000) ;
                    RmWin ;
                 end ;
              end ;
          4 : begin
                 propertysetup ;
              end ;
      end ; {case}
      if ConfigFileName <> '' then MainMenu ;
   UNTIL (GlobalPick=5) or (retcode=1) ;
   Reset_Startup_Mode ;
   FunkyClear ;
END ;

 Procedure Welcome;
 { paints an introduction screen }
 begin
     CreateScreen(3,25);
     Activate_Virtual_Screen(3);   {all subsequent writes will be to screen 3}
     FillScreen(1,1,80,22,lightcyan,blue,chr(177)) ;
     ClearText(1,23,80,24,white,red) ;
     WriteCenter(23,white,red,'Another fine program from JPSoft') ;
     WriteCenter(24,white,red,'EACONFIG '+version+' - Copyright 1995 by John Parlin') ;

     FBox(18,5,63,15,white,blue,2);      { draw a single line filled box }
     WriteBetween(20,61,8,white,blue,'Eclectic Avenue '+version+' Configuration Utility') ;
     WriteBetween(20,61,11,white,blue,'Written by John Parlin') ;
     Activate_Visible_Screen;
 end;  {proc Welcome}

Procedure Press_A_Key ;
BEGIN
   DelayKey(1000) ;
   TempMessageBox(28,18,white,red,6,'Press any key to continue') ;
END ;


BEGIN
   speed := 180 ;
   help := 1 ;
   RTTT.LoFCol := 14 ;
   RTTT.LoBCol := 1 ;
   RTTT.PFCol := 14 ;
   RTTT.PBCol := 1 ;
   offcursor ;
   w_fatal := true ;
   welcome ;
   SlideRestoreScreen(3,up) ;
   Press_A_Key ;
   DisposeScreen(3) ;
   picklist ;
   oncursor ;
END.
