#include <OpenDoor.h>
#include <ctype.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <inttypes.h>

int reel[4][3] = {0};

struct highscore_t {
	char name[64];
	uint64_t score;
}__attribute__((packed));

struct highscore_t scores[10];

void load_highscores() {
	FILE *fptr;
	int i;
	
	for (i=0;i<10;i++) {
		sprintf(scores[i].name, "No-One");
		scores[i].score = 0;
	}
	
	fptr = fopen("scores.dat", "rb");
	if (fptr) {
		for (i=0;i<10;i++) {
			if (fread(&scores[i], sizeof(struct highscore_t), 1, fptr) == 0) {
				break;
			}
		}
		fclose(fptr);
	}
}

void update_highscores(uint64_t score) {
	int added = 0;
	int i;
	int j;
	for (i=0;i<10;i++) {
		if (score > scores[i].score) {
			added = 1;
			for (j=9;j>i;j--) {
				sprintf(scores[j].name, "%s", scores[j-1].name);
				scores[j].score = scores[j-1].score;
			}
			scores[i].score = score;
			snprintf(scores[i].name, 63, "%s", od_control_get()->user_name);
			break;
		}
	}
	
	if (added) {
		FILE *fptr;
		
		fptr = fopen("scores.dat", "wb");
		if (fptr) {
			for (i=0;i<10;i++) {
				fwrite(&scores[i], sizeof(struct highscore_t), 1, fptr);
			}
			fclose(fptr);
		}
	}
}

const char *values[] = {
	"`blue`  Oceanus `white`",
	"`bright blue`  Tethys  `white`",
	"`bright yellow` Hyperion `white`",
	"`bright white`   Theia  `white`",
	"`red`   Coeus  `white`",
	"`bright red`  Phoebe  `white`",
	"`cyan`  Cronus  `white`",
	"`bright cyan`   Rhea   `white`",
	"`magenta` Mnemosyne`white`",
	"`bright magenta`  Themis  `white`",
	"`brown`   Crius  `white`",
	"`white`  Iapetus `white`",
	"`green`  Uranus  `white`",
	"`bright green`   Gaia   `white`"
};

int spinreel(int col) {
	int i;
	
	for (i=0;i<10;i++) {
		reel[col][2] = reel[col][1];
		reel[col][1] = reel[col][0];
		
		reel[col][0] = rand() % 14;
		
		// draw
		usleep(10000);
		od_set_cursor(5, 12 + (11 * col));
		od_printf("%s", values[reel[col][0]]);
		usleep(10000);
		od_set_cursor(7, 12 + (11 * col));
		od_printf("%s", values[reel[col][1]]);
		usleep(10000);
		od_set_cursor(9, 12 + (11 * col));
		od_printf("%s", values[reel[col][2]]);
	}
	
	return reel[col][1];
}

void update_status_line(const char *text) {
	od_set_cursor(2, 16);
	od_printf("                                   ");
	od_set_cursor(2, 16);	
	od_printf("%s", text);
}

void print_highscores() {
	int i;
	
	for (i=0;i<10;i++) {
		od_set_cursor(7 + i, 24);
		od_printf("`bright cyan`%" PRIu64 " `bright black`- `bright green`%s`white`", scores[i].score, scores[i].name);
	}
}

void update_coin(uint64_t coin, uint32_t bet, uint32_t won, uint32_t lost, int turns) {
	od_set_cursor(3, 69);
	od_printf("            ");
	od_set_cursor(3, 69);
	od_printf("`white`%" PRIu64 , coin);
	od_set_cursor(4, 69);
	od_printf("            ");
	od_set_cursor(4, 69);
	od_printf("`white`%u", bet);
	od_set_cursor(6, 69);
	od_printf("            ");
	od_set_cursor(6, 69);
	od_printf("`white`%u", won);
	od_set_cursor(7, 69);
	od_printf("            ");
	od_set_cursor(7, 69);
	od_printf("`white`%u", lost);
	od_set_cursor(9, 69);
	od_printf("            ");
	od_set_cursor(9, 69);
	od_printf("`white`%d", turns);

	
}

int play(int bet) {
	int i, j;
	int result[4];
	int count;
	int prize;
	int value;

	update_status_line("            `bright cyan`Titan `bright green`Slots!");
	
	for (i=0;i<4;i++) {
		result[i] = spinreel(i);
	}
	
	value = 0;
	prize = 0;
	
	for (i=13;i >= 0;i--) {
		count = 0;
		for (j=0;j<4;j++) {
			if (result[j] == i) {
				count++;
			}
		}
		
		if (count == 4) {
			value = i * 3 * bet;
		} else if (count == 3) {
			value = i * 2 * bet;
		} else if (count == 2) {
			value = i * bet;
		}
		
		if (value > prize) {
			prize = value;
		}
	}
	
	if (prize > 0) {
		update_status_line("`bright green`      WINNER! WINNER! WINNER!`white`");
	}
	
	return prize;
}


#if defined(WIN32) || defined(_MSC_VER)
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif
	uint64_t coin = 100;
	uint32_t bet = 0;
	char buffer[5];
	uint32_t newbet;
	int seed = time(NULL);
	uint32_t won = 0;
	uint32_t lost = 0;
	uint32_t winnings = 0;
	int turns = 50;
	int done = 0;
	
	char c = 'x';
	
#if defined WIN32
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif
	od_init();
	
	srand(seed);
	
	load_highscores();
	
	while (tolower(c) != 'q') {
	
		od_clr_scr();
		od_send_file("start.ans");
	
		print_highscores();
	
		c = od_get_key(TRUE);
		
		if (tolower(c) == 'p') {
			coin = 100;
			bet = 0;
			won = 0;
			lost = 0;
			winnings = 0;
			turns = 50;
			done = 0;
			
			od_clr_scr();
			od_send_file("slots.ans");
			
			update_status_line(" `bright yellow`TITAN SLOTS - PLEASE PLACE A BET");
			update_coin(coin, bet, won, lost, turns);
			
			while (coin > 0 && turns > 0 && !done) {
				switch (tolower(od_get_key(TRUE))) {
					case ' ':
						if (bet == 0) {
							update_status_line("`bright yellow`    *!* (P)lace bet first! *!*`white`");
						} else if (bet > coin) {
							update_status_line("`bright red`   *!* You can't afford that! *!*`white`");
						} else {
							coin -= bet;
							lost += bet;
							winnings = play(bet);
							coin += winnings;
							won += winnings;
							if (winnings == 0) {
								turns--;
							}
							update_coin(coin, bet, won, lost, turns);
							
						}
						break;
					case 'p':
						od_set_cursor(19, 10);
						od_printf("`bright white`Place Bet (Max 1000): `white`");
						od_input_str(buffer, 4, '0', '9');
						newbet = strtol(buffer, NULL, 10);
						od_set_cursor(19, 10);
						od_printf("                          ");
						if (newbet < 0 || newbet > 1000) {
							update_status_line("`bright red`       *!* Invalid Bet! *!*`white`");
						} else {
							bet = newbet;
							update_coin(coin, bet, won, lost, 0);
						}
						break;
					case 'q':
						done = 1;
						break;
					default:
						break;
				}
			}
			
			// update high scores
			update_highscores(coin);
		}
	}
	
	od_exit(0, FALSE);
}
