#if defined WIN32
# define _MSC_VER 1
#	define _CRT_SECURE_NO_WARNINGS
#   include <Windows.h>
#   include <io.h>
#else
#   include <unistd.h>
#endif

#include <OpenDoor.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>

#if defined WIN32
long mGetFileSize(const TCHAR *fileName)
{
	BOOL                        fOk;
	WIN32_FILE_ATTRIBUTE_DATA   fileInfo;

	if (NULL == fileName)
		return -1;

	fOk = GetFileAttributesEx(fileName, GetFileExInfoStandard, (void*)&fileInfo);
	if (!fOk)
		return -1;
	return (long)fileInfo.nFileSizeLow;
}
#endif
#include <sys/stat.h>


struct sys_info {
	unsigned int jackpot;
	time_t last_played;
	char last_winner[32];
}__attribute__((packed));

struct user_info {
	unsigned int cash;
	unsigned int turns;
	unsigned int total_turns;
	time_t last_played;
	char username[32];
};

char savefile[256];
struct user_info info;
struct sys_info sys_inf;
int player_idx;

char *values[] = {
	"`bright red`JACKPOT!`white`",
	"`bright green` FAIRY! `white`",
	"`cyan`CAULDRON`white`",
	"`yellow`  WAND  `white`",
	"`bright blue` WIZARD `white`",
	"`bright yellow` RABBIT `white`",
	"`bright white`ILLUSION`white`"
};

int get_player_idx() {
	FILE *fptr;
	time_t wait_time;
	char buffer[257];

	int idx = 0;

	wait_time = time(NULL);

	do {
		fptr = fopen("players.idx", "r");
		if (fptr != NULL) {
			break;
		}
		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			break;
		}
		od_kernel();
	} while(!fptr);

	if (fptr != NULL) {

		fgets(buffer, 256, fptr);
		while (!feof(fptr)) {
			if (strncmp(buffer, savefile, strlen(savefile) - 1) == 0) {
				fclose(fptr);
				return idx;
			}
			fgets(buffer, 256, fptr);
			idx++;
		}

		fclose(fptr);
	}

	wait_time = time(NULL);

	do {
		fptr = fopen("players.idx", "a");
		if (fptr != NULL) {
			break;
		}
		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open players.idx");
			od_exit(-1, FALSE);
		}
		od_kernel();
	} while(!fptr);


	fprintf(fptr, "%s\n", savefile);

	fclose(fptr);
	return idx;
}

int load_player() {
	FILE *fptr;
	time_t wait_time;

	player_idx = get_player_idx();

	wait_time = time(NULL);
	do {
		fptr = fopen("players.dat", "r");
		if (fptr) {
			break;
		}
		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			break;
		}
		od_kernel();
	} while (!fptr);

	if (!fptr) {
		return 0;
	}
	fseek(fptr, sizeof(struct user_info) * player_idx, SEEK_SET);

	if (fread(&info, sizeof(struct user_info), 1, fptr) < 1) {
		fclose(fptr);
		return 0;
	}

	fclose(fptr);

	return 1;
}

void save_player() {
	int fd;
	time_t wait_time;

	wait_time = time(NULL);

#if defined WIN32
	do {
		fd = _open("players.dat", _O_CREAT | _O_BINARY | _O_WRONLY, _S_IREAD | _S_IWRITE);
		if (fd != -1) {
			break;
		}

		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open players.dat\n");
			od_exit(-1, FALSE);
		}
		od_kernel();
	} while (fd == -1);
	_lseek(fd, sizeof(struct user_info) * player_idx, SEEK_SET);
	_write(fd, &info, sizeof(struct user_info));

	_close(fd);
#else
	do {
		fd = open("players.dat", O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);

		if (fd != -1) {
			break;
		}
		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open players.dat\n");
			od_exit(-1, FALSE);
		}
		od_kernel();
	} while (fd == -1);
	lseek(fd, sizeof(struct user_info) * player_idx, SEEK_SET);
	write(fd, &info, sizeof(struct user_info));

	close(fd);
#endif
}

void write_sysinf() {
	FILE *fptr;
	time_t wait_time;

	wait_time = time(NULL);
	do {
		fptr = fopen("system.dat", "w");
		if (fptr != NULL) {
			break;
		}
		if (errno != EACCES || wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open system.dat\n");
			od_exit(-1, FALSE);
		}
		od_kernel();
	} while(!fptr);

	fwrite(&sys_inf, sizeof(struct sys_info), 1, fptr);

	fclose(fptr);
}
void maintenance() {
	FILE *fptr;

	time_t now = time(NULL);
	struct tm thetime;
	struct tm oldtime;

	time_t wait_time;

	wait_time = time(NULL);

	do {
		fptr = fopen("system.dat", "r");
		if (fptr != NULL) {
			break;
		}
		if (errno != EACCES) {
			break;
		}

		if (wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open system.dat\n");
			od_exit(-1, FALSE);
		}
		od_kernel();
	} while(!fptr);

	if (fptr) {

		fread(&sys_inf, sizeof(struct sys_info), 1, fptr);

		fclose(fptr);
	} else {
		sys_inf.last_played = 0;
		sprintf(sys_inf.last_winner, "No One");
	}
	memcpy(&thetime, localtime(&now), sizeof(struct tm));
	memcpy(&oldtime, localtime(&sys_inf.last_played), sizeof(struct tm));

	od_clr_scr();

	if (thetime.tm_mon != oldtime.tm_mon || thetime.tm_year != oldtime.tm_year) {
		sys_inf.jackpot = 1000;
		od_printf("New month, resetting game...\r\n");
		remove("players.dat");
		remove("players.idx");
		od_printf("Press any key to continue.");
		od_get_key(TRUE);
	} else if (thetime.tm_mday != oldtime.tm_mday || (thetime.tm_mday == oldtime.tm_mday && (thetime.tm_mon != oldtime.tm_mon || thetime.tm_year != oldtime.tm_year))) {
		od_printf("New day, adding 15%% to Jackpot...\r\n");
		sys_inf.jackpot += (sys_inf.jackpot * 0.15);
		od_printf("Press any key to continue.");
		od_get_key(TRUE);
	}
	sys_inf.last_played = time(NULL);
	write_sysinf();
}

void sort(struct user_info* infos, int n) {
    int j,i;

    for(i=1;i<n;i++)
    {
        for(j=0;j<n-i;j++)
        {
            if(infos[j].cash < infos[j+1].cash)
            {
				struct user_info temp;
				memcpy(&temp, &infos[j], sizeof(struct user_info));
				memcpy(&infos[j], &infos[j+1], sizeof(struct user_info));
				memcpy(&infos[j+1], &temp, sizeof(struct user_info));
            }
        }
    }
}

void display_highscores() {
	FILE *fptr;
	long fsz;
#ifndef WIN32
	struct stat s;
#endif
	struct user_info *scores;
	time_t wait_time;

	int i;

	wait_time = time(NULL);

	do {
		fptr = fopen("system.dat", "r");
		if (fptr != NULL) {
			break;
		}
		if (errno != EACCES) {
			break;
		}

		if (wait_time + 10 <= time(NULL)) {
			fprintf(stderr, "Unable to open system.dat\n");
			od_exit(-1, FALSE);
		}

		od_kernel();
	} while (!fptr);
	fptr = fopen("system.dat", "r");
	if (fptr) {
		fread(&sys_inf, sizeof(struct sys_info), 1, fptr);
		fclose(fptr);
	} else {
		sys_inf.last_played = 0;
		sprintf(sys_inf.last_winner, "No One");
	}

	od_clr_scr();
	od_send_file("scores.ans");
#ifdef WIN32
	fsz = mGetFileSize("players.dat");
	if (fsz >= 0) {
#else
	if (!stat("players.dat", &s)) {
		fsz = s.st_size;
#endif
		scores = (struct user_info *)malloc(fsz);
		wait_time = time(NULL);
		do {
			fptr = fopen("players.dat", "r");
			if (fptr != NULL) {
				break;
			}
			if (errno != EACCES || wait_time + 10 <= time(NULL)) {
				fprintf(stderr, "Unable to open players.dat\n");
				od_exit(-1, FALSE);
			}
			od_kernel();
		} while (!fptr);
		for (i=0;i<fsz / sizeof(struct user_info);i++) {
			fread(&scores[i], sizeof(struct user_info), 1, fptr);
		}
		fclose(fptr);

		sort(scores, fsz / sizeof(struct user_info));


		for (i=0;i<fsz / sizeof(struct user_info) && i < 10;i++) {
			od_set_cursor(4 + i, 8);
			od_printf("`white`%-32s %*d", scores[i].username, 10, scores[i].cash);
		}

		od_set_cursor(16, 19);
		od_printf("`white`$%d", sys_inf.jackpot);
		od_set_cursor(16, 59);
		od_printf("`white`%s", sys_inf.last_winner);
	}

	od_set_cursor(18, 23);
	od_printf("`white`Press any key to continue.");
	od_get_key(TRUE);
}

void play_game() {
	int done = 0;
	char c;
	int bet = 0;
	int slot1 = 0;
	int slot2 = 0;
	int slot3 = 0;
	int total_won = 0;
	int total_lost = 0;
	int win_amount = 0;
	char buffer[5];
	int tempbet;
	time_t now = time(NULL);
	struct tm thetime;
	struct tm oldtime;

	maintenance();

	if (!load_player()) {
		info.cash = 500;
		info.turns = 0;
		info.total_turns = 15;
		info.last_played = time(NULL);
		if(strlen(od_control_get()->user_name) == 0) {
			snprintf(info.username, 31, "%s", od_control_get()->user_handle);
		} else {
			snprintf(info.username, 31, "%s", od_control_get()->user_name);
		}
		save_player();
	}

	memcpy(&thetime, localtime(&now), sizeof(struct tm));
	memcpy(&oldtime, localtime(&info.last_played), sizeof(struct tm));

	if (thetime.tm_mday != oldtime.tm_mday || thetime.tm_mon != oldtime.tm_mon || thetime.tm_year != oldtime.tm_year) {
		info.turns = 0;
		info.total_turns = 15;
		info.last_played = time(NULL);
		save_player();
	}

	od_clr_scr();

	if (info.cash <= 0) {
		od_printf("`bright red`You are bankrupt!\r\n\r\n");
		od_printf("`white`You may play again when the game is next reset(next month).\r\n\r\n");
		od_printf("Press any key to quit.\r\n");
		od_get_key(TRUE);
		return;
	}

	od_send_file("slots.ans");

	od_set_cursor(6, 20);
	od_printf("                 ");
	od_set_cursor(6, 20);
	od_printf("`bright green`$%d", sys_inf.jackpot);
	od_set_cursor(6, 47);
	od_printf("`bright cyan`Cash: `white`$%-8d", info.cash);
	od_set_cursor(8, 47);
	od_printf("`bright cyan`Total Won: `white`$%-8d", total_won);
	od_set_cursor(9, 47);
	od_printf("`bright cyan`Total Lost: `white`$%-8d", total_lost);

	while (!done) {
		if (info.turns < info.total_turns) {
			od_set_cursor(4, 47);
			od_printf("`bright yellow`Turn %2d of %2d", info.turns + 1, info.total_turns);
			od_set_cursor(22, 23);
			od_printf("`white`[SPACE] SPIN, [P] Place Bet, [Q] Quit");
			od_set_cursor(6, 20);
			od_printf("                 ");
			od_set_cursor(6, 20);
			od_printf("`bright green`$%d", sys_inf.jackpot);

			c = od_get_key(TRUE);

			switch(tolower(c)) {
				case ' ':
					if (bet == 0) {
						od_set_cursor(2, 23);
						od_printf("`bright red`You must place a bet first!");
					} else {
						if (info.cash < bet) {
							od_set_cursor(2, 23);
							od_printf("`bright red`You don't have enough cash!\r\n");
						} else {
							info.cash -= bet;
							info.turns++;
							win_amount = 0;
							slot1 = rand() % 7 + 1;
							slot2 = rand() % 7 + 1;
							slot3 = rand() % 7 + 1;
							if (slot1 == slot2 && slot2 == slot3) {
								// three the same
								info.total_turns += 2;
								switch (slot1) {
									case 1:
										win_amount = bet + sys_inf.jackpot;
										strcpy(sys_inf.last_winner, info.username);
										sys_inf.jackpot = 1000;
										break;
									case 2:
										win_amount = bet * 32;
										break;
									case 3:
										win_amount = bet * 28;
										break;
									case 4:
										win_amount = bet * 24;
										break;
									case 5:
										win_amount = bet * 20;
										break;
									case 6:
										win_amount = bet * 16;
										break;
									case 7:
										win_amount = bet * 8;
										break;
								}
							} else if (slot1 == slot2 || slot2 == slot3 || slot1 == slot3) {
								// two the same
								info.total_turns++;
								if (slot1 == slot2 || slot1 == slot3) {
										switch (slot1) {
											case 1:
												win_amount = bet * 20;
												break;
											case 2:
												win_amount = bet * 16;
												break;
											case 3:
												win_amount = bet * 14;
												break;
											case 4:
												win_amount = bet * 12;
												break;
											case 5:
												win_amount = bet * 10;
												break;
											case 6:
												win_amount = bet * 8;
												break;
											case 7:
												win_amount = bet * 2;
												break;
										}
								} else {
									switch (slot2) {
										case 1:
											win_amount = bet * 20;
											break;
										case 2:
											win_amount = bet * 16;
											break;
										case 3:
											win_amount = bet * 14;
											break;
										case 4:
											win_amount = bet * 12;
											break;
										case 5:
											win_amount = bet * 10;
											break;
										case 6:
											win_amount = bet * 8;
											break;
										case 7:
											win_amount = bet * 2;
											break;
									}
								}
							} else {
								// none the same
								win_amount = 0;
							}
							sys_inf.jackpot += bet * 0.5;
							total_won += win_amount;
							total_lost += bet;
							info.cash += win_amount;

							write_sysinf();
							save_player();

							// display results

							od_set_cursor(10, 10);
							od_printf("%s", values[slot1-1]);
							od_set_cursor(10, 20);
							od_printf("%s", values[slot2-1]);
							od_set_cursor(10, 30);
							od_printf("%s", values[slot3-1]);

							if (win_amount > 0) {
								od_set_cursor(2, 23);
								od_printf("                           ");
								od_set_cursor(2, 23);
								od_printf("`bright green`You won $%d!", win_amount);
							}

							od_set_cursor(6, 47);
							od_printf("`bright cyan`Cash: `white`$%-8d", info.cash);
							od_set_cursor(8, 47);
							od_printf("`bright cyan`Total Won: `white`$%-8d", total_won);
							od_set_cursor(9, 47);
							od_printf("`bright cyan`Total Lost: `white`$%-8d", total_lost);
						}
					}
					break;
				case 'q':
					done = 1;
					break;
				case 'p':
					od_set_cursor(2, 23);
					od_printf("                           ");
					od_set_cursor(2, 23);
					od_printf("`bright white`Place Bet (Max 1000): `white`");
					od_input_str(buffer, 4, '0', '9');

					tempbet = atoi(buffer);
					if (tempbet > 1000 || tempbet < 0) {
						od_set_cursor(2, 23);
						od_printf("                           ");
						od_set_cursor(2, 23);
						od_printf("`bright red`Invalid Bet!\r\n");
					} else {
						bet = tempbet;
					}
					break;
			}
		} else {
			done = 1;
			od_set_cursor(22, 23);
			od_printf("`white`No more turns today, Press any key to exit...\r\n");
			od_get_key(TRUE);
		}
	}
}

#if defined WIN32
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif

  int done = 0;

#if defined WIN32
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif
	od_init();

	srand(time(NULL));
	snprintf(savefile, 255, "%s+%s", od_control_get()->user_name, od_control_get()->user_handle);

	while (!done) {
		od_clr_scr();
		od_send_file("intro.ans");

		char c = od_get_key(TRUE);

		switch(tolower(c)) {
			case 'v':
				od_clr_scr();
				od_send_file("odds.ans");
				od_get_key(TRUE);
				break;
			case 'q':
				done = 1;
				break;
			case 's':
				display_highscores();
				break;
			default:
				play_game();
				display_highscores();
				done = 1;
				break;
		}
	}
	od_exit(0, FALSE);
}
