#if WIN32
#   define _MSC_VER 1
#	define _CRT_SECURE_NO_WARNINGS
#   include <Windows.h>
#else
#
#endif

#include <OpenDoor.h>
#include <stdlib.h>
#include <string.h>
#include "inih/ini.h"

struct ansi_t {
    char *name;
    char *path;
};

struct gallery_t {
    char *name;
    int ansi_count;
    struct ansi_t **ansis;
};


int gallery_count;
struct gallery_t **galleries;


static int handler(void* user, const char* section, const char* name,
                   const char* value)
{
    int i;

    for (i=0;i<gallery_count;i++) {
        if (strcasecmp(section, galleries[i]->name) == 0) {
            galleries[i]->ansis = (struct ansi_t **)realloc(galleries[i]->ansis, sizeof(struct ansi_t *) * (galleries[i]->ansi_count+1));
            galleries[i]->ansis[galleries[i]->ansi_count] = (struct ansi_t *)malloc(sizeof(struct ansi_t));
            galleries[i]->ansis[galleries[i]->ansi_count]->name = strdup(name);
            galleries[i]->ansis[galleries[i]->ansi_count]->path = strdup(value);
            galleries[i]->ansi_count++;
            return 1;
        }
    }
    if (gallery_count == 0) {
        galleries = (struct gallery_t **)malloc(sizeof(struct gallery_t *));
    } else {
        galleries = (struct gallery_t **)realloc(galleries, sizeof(struct gallery_t *) * (gallery_count + 1));
    }
    galleries[gallery_count] = (struct gallery_t *)malloc(sizeof(struct gallery_t));
    galleries[gallery_count]->name = strdup(section);
    galleries[gallery_count]->ansi_count = 1;
    galleries[gallery_count]->ansis = (struct ansi_t **)malloc(sizeof(struct ansi_t *));
    galleries[gallery_count]->ansis[0] = (struct ansi_t *)malloc(sizeof(struct ansi_t));
    galleries[gallery_count]->ansis[0]->name = strdup(name);
    galleries[gallery_count]->ansis[0]->path = strdup(value);

    gallery_count++;
    return 1;
}

int view_gallery(int galleryno) {
	int i;
	int position = 0;
	int start = 0;
	int redraw = 1;
    tODInputEvent ch;

    while (1) {
        if (redraw) {
            od_clr_scr();
            od_set_cursor(1, 1);
            od_set_color(L_YELLOW, D_BLUE);
            od_printf("%s", galleries[galleryno]->name);
            od_clr_line();

            od_set_cursor(24, 1);
            od_set_color(L_YELLOW, D_BLUE);
            od_printf("Up/Down to Select, Enter to view, B to go Back, Q to Quit");
            od_clr_line();

            od_set_color(L_WHITE, D_BLACK);

            if (position >= 22) {
                start = position - 21;
            } else {
                if (start > 0) {
                    start--;
                }
            }

            for (i=start;i < start + 22 && i < galleries[galleryno]->ansi_count; i++) {
                od_set_cursor(i - start + 2, 1);
                if (i == position) {
                    od_set_color(D_BLACK, D_CYAN);
                }
                od_printf("%s", galleries[galleryno]->ansis[i]->name);
                od_clr_line();
                if (i == position) {
                    od_set_color(L_WHITE, D_BLACK);
                }
            }
            redraw = 0;
        }

        od_get_input(&ch, OD_NO_TIMEOUT, GETIN_NORMAL);
		if (ch.EventType == EVENT_EXTENDED_KEY) {
            switch (ch.chKeyPress) {
            case OD_KEY_DOWN:
                if (position + 1 >= start + 22) {
                    redraw = 1;
                }
                position++;
                if (position == galleries[galleryno]->ansi_count) {
                    position--;
                } else if (!redraw) {
                    od_set_cursor(position - start + 1, 1);
                    od_printf("%s", galleries[galleryno]->ansis[position -1]->name);
                    od_clr_line();
                    od_set_color(D_BLACK, D_CYAN);
                    od_set_cursor(position - start + 2, 1);
                    od_printf("%s", galleries[galleryno]->ansis[position]->name);
                    od_clr_line();
                    od_set_color(L_WHITE, D_BLACK);
                }
                break;
            case OD_KEY_UP:
                if (position -1 < start) {
                    redraw = 1;
                }
                position--;
                if (position < 0) {
                    position = 0;
                } else if (!redraw) {
                    od_set_cursor(position - start + 3, 1);
                    od_printf("%s", galleries[galleryno]->ansis[position +1]->name);
                    od_clr_line();
                    od_set_color(D_BLACK, D_CYAN);
                    od_set_cursor(position - start + 2, 1);
                    od_printf("%s", galleries[galleryno]->ansis[position]->name);
                    od_clr_line();
                    od_set_color(L_WHITE, D_BLACK);
                }
                break;
            }
		} else if (ch.EventType == EVENT_CHARACTER) {
            switch (ch.chKeyPress) {
            case 'q':
            case 'Q':
                return -1;
            case 13:
                od_clr_scr();
                od_send_file(galleries[galleryno]->ansis[position]->path);
                od_printf("\r\nPress a key...");
                od_get_key(TRUE);
                redraw = 1;
                break;
            case 'b':
            case 'B':
                return 0;
            }
		}

    }
    return 0;
}

#if _MSC_VER
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif
	int done = 0;
	int i;
	int position = 0;
	int start = 0;
	int redraw = 1;
	gallery_count = 0;
	tODInputEvent ch;
#if _MSC_VER
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif

	od_init();

	od_control_get()->od_emu_simulate_modem = 2;
	od_control_get()->od_page_pausing = 0;

    if (ini_parse("gallery.ini", handler, NULL) <0) {
		od_printf("`bright red`Unable to open gallery.ini\r\n");
		od_exit(-1, FALSE);
		return -1;
	}

    while (!done) {
        if (redraw) {
            od_clr_scr();
            od_set_cursor(1, 1);
            od_set_color(L_YELLOW, D_BLUE);
            od_printf("Ansi Gallery v0.1");
            od_clr_line();

            od_set_cursor(24, 1);
            od_set_color(L_YELLOW, D_BLUE);
            od_printf("Up/Down to Select, Enter to view, Q to Quit");
            od_clr_line();

            od_set_color(L_WHITE, D_BLACK);

            if (position >= 22) {
                start = position - 21;
            } else {
                if (start > 0) {
                    start--;
                }
            }

            for (i=start;i < start + 22 && i < gallery_count; i++) {
                od_set_cursor(i - start + 2, 1);
                if (i == position) {
                    od_set_color(D_BLACK, D_CYAN);
                }
                od_printf("%s", galleries[i]->name);
                od_clr_line();
                if (i == position) {
                    od_set_color(L_WHITE, D_BLACK);
                }
            }
            redraw = 0;
        }
        od_get_input(&ch, OD_NO_TIMEOUT, GETIN_NORMAL);
		if (ch.EventType == EVENT_EXTENDED_KEY) {
            switch (ch.chKeyPress) {
            case OD_KEY_DOWN:
                if (position + 1 >= start + 22) {
                    redraw = 1;
                }
                position++;
                if (position == gallery_count) {
                   position--;
                } else if (!redraw) {
                    od_set_cursor(position - start + 1, 1);
                    od_printf("%s", galleries[position -1]->name);
                    od_clr_line();
                    od_set_color(D_BLACK, D_CYAN);
                    od_set_cursor(position - start + 2, 1);
                    od_printf("%s", galleries[position]->name);
                    od_clr_line();
                    od_set_color(L_WHITE, D_BLACK);
                }

                break;
            case OD_KEY_UP:
                if (position - 1 < start) {
                    redraw = 1;
                }
                position--;

                if (position < 0) {
                    position = 0;
                } else if (!redraw) {
                    od_set_cursor(position - start + 3, 1);
                    od_printf("%s", galleries[position+1]->name);
                    od_clr_line();
                    od_set_color(D_BLACK, D_CYAN);
                    od_set_cursor(position - start + 2, 1);
                    od_printf("%s", galleries[position]->name);
                    od_clr_line();
                    od_set_color(L_WHITE, D_BLACK);
                }
                break;
            }
		} else if (ch.EventType == EVENT_CHARACTER) {
            switch (ch.chKeyPress) {
            case 'q':
            case 'Q':
                done = 1;
                break;
            case 13:
                if (view_gallery(position) != 0) {
                    done = 1;
                }
                redraw = 1;
                break;
            }
		}

    }

	od_exit(0, FALSE);

	return 0;
}
