/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __NODES_H
#define __NODES_H

#include <time.h>

#define WHO_DOINGS              13

#define DOING_DOWN              0
#define DOING_NOTHING           1
#define DOING_FILELIST          2
#define DOING_READ              3
#define DOING_WRITE             4
#define DOING_DOWNLOAD          5
#define DOING_UPLOAD            6
#define DOING_DOOR              7
#define DOING_LOGGING_IN        8
#define DOING_CHATTING          9
#define DOING_NEWFILES          10
#define DOING_FILE_SEARCH       11
#define DOING_GRABBING          12
#define DOING_WAITING_CALLER    13

#define NODETEXT_NORMAL         1
#define NODETEXT_MSGWRITTEN     2

extern char **node_doing;

typedef struct
{
    char name[36];
    char city[26];
    time_t login;
    unsigned long BPS;
    unsigned char doing;
    char data[60];
}
NODE_REC;

#define MAX_NODEMSGS_IN_MEMORY 100

typedef struct SAVED_NODEMSG
{
    struct SAVED_NODEMSG *next;
    char text[256];
}
SAVED_NODEMSG;

extern NODE_REC noderec;

void display_who(void);
void send_nodemsg(char *data);
void close_node_messages(void);
int display_nodefile(char *fname);
void display_old_nodemsgs(void);

int open_nodefile(void);
void close_nodefile(void);
void update_nodefile(int no_change);
int read_nodefile(unsigned node, NODE_REC *noderec);
void send_nodetext(char *text, int node);

#endif
