/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* new_user.c - New user questions */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "os.h"
#include "ask_str.h"
#include "bbs_func.h"
#include "userbase.h"
#include "output.h"
#include "setup.h"
#include "language.h"
#include "userbase.h"
#include "modem.h"

unsigned long ask_newu_questions(void)
{
    char str[2];

    time_left = 60;
    edit_setup("language");

    if (user.Emulation != USER_EMULATION_ANSI_X364)
    {
        do
        {
            user.Emulation = 0xff;
            edit_setup("terminal");
        }
        while (user.Emulation == 0xff && carr_det());
    }
    edit_setup("vt100key");
    logging = 0;

    edit_setup("lines");
    edit_setup("cols");

    if (wherey > user.ScreenLen) wherex = user.ScreenLen;
    if (wherex > user.ScreenWidth) wherex = user.ScreenWidth;

    edit_setup("alias");
    edit_setup("address");

    /* Ask birthday */
    output("\r\n");
    do
    {
        if (!ask_string(lang[LANG_ASK_BIRTHDAY], usrsub.birthday, sizeof(usrsub.birthday)-1, 0, NULL)) return 0;
    }
    while (usrsub.birthday[0] == '\0');

    /* Ask sex */
    output("\r\n");
    do
    {
        str[0] = '\0';
        if (!ask_string(lang[LANG_ASK_SEX], str, 1, 0, NULL)) return 0;
        switch (toupper(str[0]))
        {
            case 'M':
                user.Attrib1 &= ~USER_ATTRIB_FEMALE;
                break;
            case 'F':
                user.Attrib1 |= USER_ATTRIB_FEMALE;
                break;
            default:
                str[0] = '\0';
                break;
        }
    } while (str[0] == '\0');

    output("\r\n");
    user.LastFileChk = time(NULL)-7L*3600L*24L;

    edit_setup("protocol");
    edit_setup("charset");
    edit_setup("packer");

    edit_setup("password");

    return write_new_user();
}
