/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __MESSAGES_H
#define __MESSAGES_H

#define TYPE_HMB 1
#define TYPE_JAM 2
#define TYPE_MSG 3
#define TYPE_SQU 4
#define TYPE_DISP_PERSONAL 128

typedef struct
{
    unsigned long total_msgs;
    unsigned long unread_msgs;
    unsigned long personal_msgs;
}
MAREA_STAT;

typedef struct
{
    unsigned long usercrc;
    unsigned long hdrcrc;
    unsigned long txtcrc;
}
DUPE_REC;

extern unsigned long current_msg;       /* Current message */

extern MAREA_STAT marea_stat;           /* Message area status */

extern unsigned long msg_num;

int msgarea_stat(char *fname, int type);/* Get message area status */

int open_msgarea(char *fname, int type);/* Open new message area */
void close_msgarea(void);               /* Close area */

void draw_msg(unsigned long msgnum);    /* Draw message to screen */
void list_msgs(char *data);             /* List all messages in area to screen */

void prev_message(int display);         /* Go to previous message */
int next_message(int display);          /* Go to next message */
int next_new_message(int display);      /* Go to next unread message */
void goto_message(unsigned long msgnum);/* Go to message # */

unsigned long get_msgid(void);          /* Make MSGID kludge */

int check_dupe_msg(DUPE_REC *dupe);     /* Check if message is dupe */
void add_dupe_msg(DUPE_REC *dupe);      /* Add CRC to dupe message file */

int enter_message(int reply, int another, char *data);/* Enter message / reply message */
void kill_message(void);                /* Delete message */

void read_personal_msgs(void);          /* Search and read personal messages */
void check_message_text(char *fname);

void convert_file(char *fname, unsigned char *table);
#define convert_string(a,b) \
{ \
    unsigned char *c = (unsigned char *) a; \
    while (*c != '\0') \
    { \
        *c = b[*c]; \
        c++; \
    } \
}

#endif
