/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* memory.c - malloc() and free() debugging */

#include <stdio.h>
#include <malloc.h>

#include "logfile.h"

typedef struct MEMORY_REC
{
    struct MEMORY_REC *next;

    void *addr;
    unsigned long linenum;
#ifdef __WATCOMC__
    char fname[];
#else
    char fname[0];
#endif
}
MEMORY_REC;

static MEMORY_REC *first, *last;

void mem_init(void)
{
    first = NULL; last = NULL;
}

void mem_deinit(void)
{
    MEMORY_REC *rec;

    while (first != NULL)
    {
        write_log("Unreleased memory block, file %s line %lu", first->fname, first->linenum);
        rec = first->next;
        free(first);
        first = rec;
    }
}

void *mem_alloc(unsigned size, char *fname, unsigned long linenum)
{
    void *addr;
    MEMORY_REC *rec;

    addr = malloc(size);
    if (addr == NULL) return NULL;

    rec = (MEMORY_REC *) malloc(sizeof(MEMORY_REC)+strlen(fname)+1);
    if (rec == NULL)
    {
        free(addr);
        return NULL;
    }

    if (first == NULL) first = rec;
    if (last != NULL) last->next = rec;
    rec->next = NULL; last = rec;

    rec->addr = addr;
    rec->linenum = linenum;
    strcpy(rec->fname, fname);

    return addr;
}

void mem_free(void *addr, char *fname, unsigned long linenum)
{
    MEMORY_REC *rec, *prev;

    rec = first; prev = NULL;
    while (rec != NULL)
    {
        if (rec->addr == addr)
        {
            if (last == rec)
            {
                last = prev;
                if (last != NULL) last->next = NULL;
            }
            if (prev != NULL) prev->next = rec->next; else first = rec->next;
            free(rec->addr);
            free(rec);
            return;
        }
        prev = rec; rec = rec->next;
    }

    if (rec == NULL)
    {
        /*printf("mem_free() : Tried to release unallocated memory block\n");*/
        write_log("Unallocated memory block %p, file %s line %lu", addr, fname, linenum);
    }
}
