/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* mdm_dos.c - DOS modem routines */

/* Todo: Internal async routines? (fossil should be optional) */

#include <dos.h>
#include <i86.h>
#include <string.h>

#include "os.h"
#include "modem.h"

char devname[MAX_NAME_LEN];
int hCom = 0;
int carrier = 1,real_carrier = 1;

/* Initialize modem */
int init_modem(int com, unsigned long bpsrate)
{
    int params;
    union REGS regs;

    sprintf(devname, "%d", com);
    hCom = com;

    /* Activate */
    regs.loreg.ah = 4;
    regs.hireg.bx = 0x4f50;
    regs.hireg.dx = (unsigned short) (com-1);
    intr(0x14,&regs,&regs);
    if (regs.hireg.ax != 0x1954) return 0;

    /* Set BPS rate */
    switch (bpsrate)
    {
        case 300:
            params = 2 << 5;
            break;
        case 600:
            params = 3 << 5;
            break;
        case 1200:
            params = 4 << 5;
            break;
        case 2400:
            params = 5 << 5;
            break;
        case 4800:
            params = 6 << 5;
            break;
        case 9600:
            params = 7 << 5;
            break;
        case 19200:
            params = 0;
            break;
        default:
            params = 1 << 5;
            break;
    }

    params |= 3;

    regs.hireg.ax = (unsigned short) params;
    regs.hireg.dx = (unsigned short) (com-1);
    intr(0x14,&regs,&regs);

    return 1;
}

/* Deinitialize modem */
void deinit_modem(void)
{
    union REGS regs;

    if (hCom == 0) return;

    /* Deactivate fossil */
    regs.loreg.ah = 5;
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);
}

/* Output data block to modem */
int mdm_dataout(void REALLY_FAR *data, int size)
{
    union REGS regs;
    struct SREGS sregs;

    if (hCom == 0) return 0;
    regs.loreg.ah = 0x19;
    regs.hireg.cx = (unsigned short) (size);
    regs.hireg.dx = (unsigned short) (hCom-1);
    sregs.es = FP_SEG(data);
    regs.hireg.di = (unsigned short) FP_OFF(data);

    intrx(0x14,&regs,&regs,&sregs);

    return size;
}

/* Output string to modem */
int mdm_strout(char REALLY_FAR *data)
{
    union REGS regs;
    struct SREGS sregs;

    if (hCom == 0) return 0;
    regs.loreg.ah = 0x19;
    regs.hireg.cx = (unsigned short) strlen(data);
    regs.hireg.dx = (unsigned short) (hCom-1);
    sregs.es = FP_SEG(data);
    regs.hireg.di = (unsigned short) FP_OFF(data);

    intrx(0x14,&regs,&regs,&sregs);

    return 1;
}

/* Output character to modem */
int mdm_chrout(char chr)
{
    union REGS regs;

    if (hCom == 0) return 0;
    regs.hireg.ax = (unsigned short) ((1 << 8) + chr);
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);

    return 1;
}

/* Data available from modem */
int mdm_kbhit(void)
{
    union REGS regs;

    if (hCom == 0) return 0;
    if (mdm_waiting) return 1;

    regs.loreg.ah = 3;
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);

    return (regs.loreg.ah & 1);
}

int wait_modem(void)
{
    int num;

    if (hCom == 0) return 0;

    for (num = 0; num < 10; num++)
    {
        if (mdm_kbhit()) return 1;
        usleep(100000);
    }

    return 0;
}

/* Read data from modem */
unsigned char mdm_charin(void)
{
    union REGS regs;

    if (hCom == 0) return 0;
    regs.loreg.ah = 2;
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);

    return regs.loreg.al;
}

int mdm_datain(void REALLY_FAR *data, int size)
{
    union REGS regs;
    struct SREGS sregs;

    if (hCom == 0) return 0;
    regs.loreg.ah = 0x18;
    regs.hireg.cx = (unsigned short) size;
    regs.hireg.dx = (unsigned short) (hCom-1);
    sregs.es = FP_SEG(data);
    regs.hireg.di = (unsigned short) FP_OFF(data);
    intr(0x14,&regs,&regs);

    return regs.hireg.ax;
}

/* Set DTR ON/OFF */
void modem_setdtr(int dtr_on)
{
    union REGS regs;

    if (hCom == 0) return;
    regs.hireg.ax = (unsigned short) (0x0600 + (dtr_on > 0));
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);
}

/* Carrier */
int carr_det(void)
{
    union REGS regs;

    if (hCom == 0) return 1;
    if (!carrier) return 0;

    regs.loreg.ah = 3;
    regs.hireg.dx = (unsigned short) (hCom-1);
    intr(0x14,&regs,&regs);

    real_carrier = carrier = (regs.loreg.al & 0x80) == 0x80;
    return carrier;
}
