/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __MAREAS_H
#define __MAREAS_H

#include "config.h"

#define MAREA_FLAG_READ_RIGHTS          0x0001
#define MAREA_FLAG_WRITE_RIGHTS         0x0002
#define MAREA_FLAG_PRIVATE_MSGS         0x0004
#define MAREA_FLAG_PUBLIC_MSGS          0x0008
#define MAREA_FLAG_ECHO                 0x0010
#define MAREA_FLAG_SELECTED             0x0020
#define MAREA_FLAG_NETMAIL              0x0040
#define MAREA_FLAG_FORCED               0x0080
#define MAREA_FLAG_NO_TAGS              0x0100

typedef struct MAREA_REC
{
    struct MAREA_REC *prev;     /* Previous record */
    struct MAREA_REC *next;     /* Next record */

    unsigned long number;       /* Area number */
    char name[61];              /* Name */
    char bw_tag[21];            /* Blue Wave tag name */
    char path[256];             /* Message base path */
    char description[61];       /* Description */
    CHARSET_REC *charset;       /* Character set */

    unsigned char nodeaddr;     /* Node address number */
    unsigned short flags;       /* Flags */
    unsigned long lr_ptr;       /* Lastread pointer */
}
MAREA_REC;

typedef char NET_ADDR[24];

extern MAREA_REC marea;         /* Current msg area record */
extern MAREA_REC *marea_rec;    /* Current msg area record .. pointer */
extern MAREA_REC msg_area;      /* Message area record.. Again.. Used by @MAREA_xxx@ macros */

extern unsigned msg_areas;      /* Number of msg areas */
extern unsigned current_marea;  /* Current msg area number */

extern int msgnets;             /* Number of net addresses */
extern char *net_number[];      /* Net addresses */

/* Saved lastread pointers: */
extern unsigned long *ptrs_this_call; /* Start of this call */

int init_mareas(void);          /* Read message areas */
void deinit_mareas(void);       /* Deallocate memory used by message areas */

int select_marea(char *marea_name); /* Select new message area */
int read_marea_record(unsigned long marea_num); /* Read message area record # */

int search_areanum(unsigned long num); /* Search area by area number */
int search_areaname(char *name);/* Search area by area number */
int search_bwtag(char *bw_tag); /* Search Blue Wave tag area */

int update_pointers(unsigned long msgnum); /* Upload lastread pointers */

int save_pointers(unsigned long *ptrs, int forced); /* Save lastread pointers */
int restore_pointers(unsigned long *ptrs); /* Restore lastread pointers */
void clear_pointers(void);
void pointer_days(char *data);

void update_jam_lastread(unsigned long NameCRC, int forced);/* JAM's lastread pointer file .JLR -> YAK */
void update_rbbs_lastread(unsigned long NameCRC); /* YAK -> JAM's lastread pointer file .JLR */

void show_mareas_status(void);

int str2addr(char *addrstrp, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point);
NETADDR_REC *get_nearest_net(unsigned short d_zone, unsigned short d_net, unsigned short d_node, unsigned short d_point);

#endif
