/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* lastcall.c - Last callers and bbs usage handling */

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "bbs_func.h"
#include "files.h"
#include "output.h"
#include "ask_str.h"
#include "logfile.h"
#include "lastcall.h"
#include "userbase.h"
#include "language.h"

LASTCALL_REC current_lastrec;
LASTCALL_REC lastrec;

/* Remove old records.. */
void remove_olds(int Flast)
{
    time_t _tim;
    struct tm *tim;
    int day;

    _tim = time(NULL);
    tim = localtime(&_tim);
    day = tim->tm_mday;

    /* Read first record */
    if (!FileLock(Flast))
    {
        write_log("remove_olds() : Can't lock file: %s"SSLASH"lastcall.dat", data_path);
        return;
    }

    if (FileRead(Flast, &lastrec, sizeof(lastrec)) == sizeof(lastrec))
    {
        tim = localtime(&lastrec.logoff);
        if (day != tim->tm_mday)
        {
            /* Not same day, truncate file */
            FileTrunc(Flast,0);
        }
    }

    FileUnlock(Flast);
}

void last_callers(void)
{
    char tmp[256];
    int Flast;

    output(lang[LANG_LASTCALL_HEADER]);

    sprintf(tmp, "%s"SSLASH"lastcall.dat", data_path);
    Flast = FileOpen(tmp, O_RDWR | O_BINARY, SH_DENYNO);
    if (Flast != -1)
    {
        /* Remove old records */
        remove_olds(Flast);

        if (FileSeek(Flast, 0, SEEK_END)/sizeof(LASTCALL_REC) > (unsigned) (user.ScreenLen-7))
        {
            /* Display only as much records as fit in screen */
            FileSeek(Flast, -(user.ScreenLen-6)*sizeof(LASTCALL_REC), SEEK_END);
        }
        else
        {
            /* Can display them all.. */
            FileSeek(Flast, 0, SEEK_SET);
        }

        while (FileRead(Flast, &lastrec, sizeof(lastrec)))
        {
            output(lang[LANG_LASTCALL_ENTRY]);
        }
    }
    FileClose(Flast);

    output(lang[LANG_LASTCALL_BOTTOM]);

    yes_no("", 1, NULL); /* Wait for enter */
}

void write_lastcaller(void)
{
    char tmp[256];
    int Flast;
    BBSUSAGE_REC bbsusage;

    /* Don't put sysops in last callers list */
    if (in_group("sysop")) return;

    sprintf(tmp, "%s"SSLASH"lastcall.dat", data_path);
    Flast = FileOpen(tmp, O_RDWR | O_BINARY, SH_DENYWR);
    if (Flast == -1)
    {
        /* Not found, create */
        Flast = FileCreate(tmp, CREATE_MODE);
        if (Flast == -1)
        {
            /* Couldn't create it. */
            printf("Warning! Can't create '%s'!\n", tmp);
            write_log("Can't create '%s", tmp);
            return;
        }
        FileMode(Flast,O_BINARY);
    }

    /* Write record */
    if (!FileLock(Flast))
        write_log("write_lastcaller() : Can't lock file: %s", tmp);
    else
    {
        FileSeek(Flast, 0, SEEK_END);
        FileWrite(Flast, &current_lastrec, sizeof(current_lastrec));
        FileUnlock(Flast);
    }
    FileClose(Flast);

    /* Write to BBS usage file. */
    sprintf(tmp, "%s"SSLASH"bbsusage.dat", data_path);
    Flast = FileOpen(tmp, O_WRONLY | O_BINARY, SH_DENYWR);
    if (Flast == -1)
    {
        Flast = FileCreate(tmp, CREATE_MODE);
        if (Flast == -1)
        {
            write_log("Can't create '%s'", tmp);
            return;
        }
    }
    if (!FileLock(Flast))
        write_log("write_lastcaller() : Can't lock file: %s", tmp);
    else
    {
        bbsusage.nodenum = nodenum;
        bbsusage.login = current_lastrec.login;
        bbsusage.logoff = current_lastrec.logoff;
        FileSeek(Flast, 0, SEEK_END);
        FileWrite(Flast, &bbsusage, sizeof(bbsusage));
    }
    FileClose(Flast);
}

#define days 7

void bbs_time_usage(char *data)
{
    char tmp[256];
    int F;
    int readed, num, daysince, node, nodes;
    unsigned long daybuf[days];
    int calls[days];
    time_t since, tmptim;
    struct tm *tim, tim2;
    BBSUSAGE_REC bu[100];
    char str[4];

    /* Ask node number */
    str[0] = '\0';
    if (!ask_string(lang[LANG_ASK_BBSUSAGE_NODE], str, 3, 0, &data) || str[0] == '\0') return;
    if (sscanf(str, "%d", &node) != 1) return;

    since = time(NULL)-(long) (days-1)*3600*24; /* days last day statistics. */
    tim = localtime(&since);
    tim->tm_hour = 0; tim->tm_min = 0; tim->tm_sec = 0;
    since = mktime(tim);
    daysince = tim->tm_yday;

    tmptim = time(NULL);
    tim = localtime(&tmptim);
    if (tim->tm_yday < daysince)
    {
        tim->tm_mday = 1; tim->tm_mon = 0; tim->tm_yday = 1;
        tim->tm_hour = 0; tim->tm_min = 0; tim->tm_sec = 0;
        tmptim = mktime(tim)-1; /* Get last day number of last year. */
        tim = localtime(&tmptim);

        daysince -= tim->tm_yday;
    }

    memset(daybuf, 0, sizeof(daybuf[0])*days);
    memset(calls, 0, sizeof(calls[0])*days);

    sprintf(tmp, "%s"SSLASH"bbsusage.dat", data_path);
    F = FileOpen(tmp, O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1)
    {
        output(lang[LANG_NO_BBSUSAGE]);
        return;
    }

    nodes = 1;
    for (;;)
    {
        readed = FileRead(F, bu, sizeof(bu)) / sizeof(BBSUSAGE_REC);
        if (readed == 0) break;

        for (num=0; num<readed; num++)
        {
            if (since <= bu[num].login && (node == 0 || bu[num].nodenum == node))
            {
                if (node == 0 && bu[num].nodenum > nodes) nodes = bu[num].nodenum;

                tim = localtime(&bu[num].logoff);
                memcpy(&tim2, tim, sizeof(struct tm));
                tim = localtime(&bu[num].login);
                calls[tim->tm_yday-daysince]++;
                if (tim->tm_mday == tim2.tm_mday)
                {
                    /* Same day. */
                    daybuf[tim->tm_yday-daysince] += bu[num].logoff-bu[num].login+1;
                }
                else
                {
                    /* User was in during midnight, first calculate first day time used.. */
                    tim2.tm_hour = 0; tim2.tm_min = 0; tim2.tm_sec = 0;
                    tmptim = mktime(&tim2);
                    daybuf[tim->tm_yday-daysince] += tmptim-bu[num].login;

                    /* And next day time used.. */
                    daybuf[tim->tm_yday-daysince+1] += bu[num].logoff-tmptim;
                }
            }
        }
    }
    FileClose(F);

    output(lang[LANG_BBSUSAGE_HEADER]);
    for (num=0; num<7; num++)
    {
        tim = localtime(&since);
        output(lang[LANG_BBSUSAGE_ENTRY], tim->tm_mday, tim->tm_mon+1, calls[num], (int) (daybuf[num]/60), (int) ((long)(daybuf[num]*100) / (long)(3600L*24L*nodes)), (int) ((long)(daybuf[num]*15) / (3600L*24L*nodes)));
        since += 3600L*24L; /* Go to next day */
    }
    output(lang[LANG_BBSUSAGE_BOTTOM]);
}
