/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* fsed.c - Full screen editor */

/* Todo: add_character() should not be recursive, dummy-ansi support */
/* vhn bugaa viel jos on rivi quotattu ja kirjoittaa roskaa eteenpin vaan */
/* Backspace rivin alussa bugaa joskus */

#include <stdio.h>
#include <string.h>

#include "os.h"
#include "memory.h"
#include "output.h"
#include "config.h"
#include "modem.h"
#include "files.h"
#include "userbase.h"
#include "keyb.h"
#include "timeslic.h"
#include "language.h"

typedef struct LINE_REC
{
    struct LINE_REC *next;
    struct LINE_REC *prev;

    unsigned char len;
    char joined; /* Next line belongs to same chapter */
    char text[81];
}
LINE_REC;

static LINE_REC *first_line, *line;
static int xpos, ypos;
static int linecol, oldcol;
static unsigned lines, upy;

static int header_lines;

int line_color(LINE_REC *line)
{
    char *strp;
    int num;

    /*while (line->prev != NULL && line->prev->joined) line = line->prev;*/

    if (strncmp(line->text, "... ", 4) == 0)
    {
        output("@X%c%c", lang[LANG_FSED_HEADER][9], lang[LANG_FSED_HEADER][10]);
        return 1;
    }
    else
    {
        strp = line->text;
        for (num = 0; num < QUOTE_MAX && *strp != '\0'; num++)
        {
            if (*strp == '"' || *strp == '\'' || *strp == '<') break;
            if (*strp == '>')
            {
                num = 100;
                break;
            }
            strp++;
        }
        if (num == 100)
        {
            output("@X%c%c", lang[LANG_FSED_HEADER][6], lang[LANG_FSED_HEADER][7]);
            return 2;
        }
        else
        {
            output("@X%c%c", lang[LANG_FSED_HEADER][3], lang[LANG_FSED_HEADER][4]);
            return 3;
        }
    }
}

void add_character(unsigned char ch)
{
    LINE_REC *tmpline;
    int oldx, bpos;
    char *strp,buffer[80];

    while (line->len == 79)
    {
        strp = line->text+78;
        while (*strp == ' ' && strp > line->text) strp--;
        while (*strp != ' ' && strp > line->text) strp--;
        if (strp > line->text)
        {
            strcpy(buffer,strp+1);
            line->len = (unsigned char) ((strp-line->text)+1);
            bpos = strlen(buffer)-(xpos-line->len);
        }
        else
        {
            strcpy(buffer,line->text+78);
            line->len--;
            bpos = 0;
        }

        if (line->next == NULL || line->joined == 0)
        {
            /* Make new line */
            if (line->next != NULL && ypos < user.ScreenLen)
                output("@CR@@INSLINE@");
            line->joined = 1;
            tmpline = (LINE_REC *) _malloc(sizeof(LINE_REC));
            tmpline->prev = line;
            tmpline->next = line->next;
            if (line->next != NULL) line->next->prev = tmpline;
            line->next = tmpline;
            line = tmpline;

            line->len = 0;
            line->joined = 0;
            line->text[0] = '\0';
            lines++;
        }
        else
        {
            line = line->next;
        }

        oldx = xpos;
        xpos = 0; ypos++;
        strp = buffer;
        if (ypos <= user.ScreenLen) output("@GOTO:1,%d@",ypos);
        while (*strp != '\0') add_character(*strp++);

        ypos--; line = line->prev;
        line->text[line->len] = '\0';

        oldcol = line_color(line);
        linecol = 1;
        if (ypos <= user.ScreenLen) output("@GOTO:%d,%d@@CLREOL@",line->len+1,ypos);

        if (oldx >= line->len)
        {
            line = line->next;
            if (ypos < user.ScreenLen)
            {
                ypos++;
            }
            else
            {
                upy++;
                output("@SCROLL_UP:2@@GOTO:1,%d@%s",ypos,line->text);
            }
            xpos -= bpos;
        }
        else
        {
            xpos = oldx;
        }
        if (ypos <= user.ScreenLen) output("@GOTO:%d,%d@",xpos+1,ypos);
    }

    if (!linecol) oldx = line_color(line); else oldx = oldcol;
    memmove(line->text+xpos+1,line->text+xpos,line->len-xpos+1);
    line->text[xpos] = ch; line->len++; xpos++;

    if (ypos <= user.ScreenLen)
    {
        if (!linecol || xpos <= QUOTE_MAX)
        {
            oldcol = line_color(line);
            linecol = 1;
            if (oldx != oldcol)
            {
                outchr('\r');
                outtext(line->text);
                output("@GOTO:%d,%d@", xpos+1, ypos);
                return;
            }
        }

        if (user.Emulation == USER_EMULATION_ANSI_X364)
        {
            if (xpos < line->len) output("@INSCHR@");
            outchr(ch);
        }
        else
        {
            outtext(line->text+xpos-1);
            output("@GOTO:%d,%d@",xpos+1,ypos);
        }
    }
}

void add_string(char *text)
{
    while (*text != '\0') add_character(*text++);
}

void refresh_screen(void)
{
    LINE_REC *tmpline;
    int num;

    output(lang[LANG_FSED_HEADER]+12);
    tmpline = first_line; num = upy;
    while (num > 0 && tmpline != NULL)
    {
        tmpline = tmpline->next;
        num--;
    }

    if (tmpline != NULL)
    {
        for (num = header_lines+1; num <=user.ScreenLen; num++)
        {
            oldcol = line_color(tmpline);
            outtext(tmpline->text);
            if (num < user.ScreenLen) output("\r\n");
            tmpline = tmpline->next;
            if (tmpline == NULL) break;
        }
    }
    output("@GOTO:%d,%d@",xpos+1,ypos);
    linecol = 0;
}

/* Read file to message */
void read_file(char *fname)
{
    char str[82];
    LINE_REC *tmpline;
    int F;

    F = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1) return;

    while (_fgets(str,sizeof(str),F) != NULL)
    {
        strcpy(line->text,str);
        line->len = (unsigned char) strlen(line->text);

        /* Make new line */
        tmpline = (LINE_REC *) _malloc(sizeof(LINE_REC));
        line->next = tmpline;
        tmpline->prev = line;
        tmpline->next = NULL;
        line = tmpline;

        line->len = 0;
        line->joined = 0;
        line->text[0] = '\0';
        lines++;
    }

    line = first_line;
    FileClose(F);
}

/* Write message to file */
void save_file(char *fname)
{
    int F;

    F = FileCreate(fname, CREATE_MODE);
    if (F == -1) return;
    FileMode(F,O_BINARY);

    line = first_line;
    while (line != NULL)
    {
        if (line->len > 0) FileWrite(F,line->text,line->len);
        if (!line->joined)
            FileWrite(F, "\r", 1);
        else
            if (line->text[line->len-1] != ' ') FileWrite(F, " ", 1);
        line = line->next;
    }

    FileClose(F);
}

int fs_editor(char *fname)
{
    char ch, quit, hit, buffer[81];
    int num, oldx, oldy;
    LINE_REC *tmpline;

    header_lines = (lang[LANG_FSED_HEADER][0]-'0')*10 + lang[LANG_FSED_HEADER][1]-'0';

    first_line = (LINE_REC *) _malloc(sizeof(LINE_REC));
    line = first_line;
    line->len = 0;
    line->joined = 0;
    line->next = NULL;
    line->prev = NULL;
    line->text[0] = '\0';

    xpos = 0; ypos = header_lines+1; upy = 0; lines = 1;
    read_file(fname);
    refresh_screen();

    quit = 0;
    while (!quit)
    {
        if (!carr_det())
        {
            quit = 1;
            break;
        }

        hit = (char) kbhit();
        if (hit || mdm_kbhit())
        {
            ch = (char) (hit ? getch() : mdm_getch());
            switch (ch)
            {
                case 0:
                    ch = (char) (hit ? getch() : mdm_getch());
                    switch (ch)
                    {
                        case 'K':
                            /* Left */
                            if (xpos > 0)
                            {
                                xpos--;
                                output("@GOTO:%d,%d@",xpos+1,ypos);
                            }
                            break;
                        case 'M':
                            /* Right */
                            if (xpos < line->len)
                            {
                                xpos++;
                                output("@GOTO:%d,%d@",xpos+1,ypos);
                            }
                            break;
                        case 'H':
                            /* Up */
                            if (ypos+upy > header_lines+1)
                            {
                                line = line->prev;
                                if (xpos > line->len) xpos = line->len;

                                if (ypos > header_lines+1)
                                {
                                    ypos--; linecol = 0;
                                    output("@GOTO:%d,%d@",xpos+1,ypos);
                                }
                                else
                                {
                                    upy--;
                                    output("@SCROLL_DOWN:%d@\r",header_lines+1);
                                    oldcol = line_color(line);
                                    linecol = 1;
                                    outtext(line->text);
                                    output("@CLREOL@@GOTO:%d,%d@",xpos+1,ypos);
                                }
                            }
                            break;
                        case 'P':
                            /* Down */
                            if (ypos+upy-header_lines < lines)
                            {
                                line = line->next;
                                if (xpos > line->len) xpos = line->len;
                                if (ypos < user.ScreenLen)
                                {
                                    ypos++; linecol = 0;
                                    output("@GOTO:%d,%d@",xpos+1,ypos);
                                }
                                else
                                {
                                    upy++;
                                    output("@SCROLL_UP:%d@@GOTO:%d,%d@\r",header_lines+1,xpos+1,ypos);
                                    oldcol = line_color(line);
                                    linecol = 1;
                                    outtext(line->text);
                                    output("@CLREOL@@GOTO:%d,%d@",xpos+1,ypos);
                                }
                            }
                            break;
                        case 'G':
                            /* Home */
                            if (xpos > 0)
                            {
                                xpos = 0;
                                output("@GOTO:1,%d@",ypos);
                            }
                            break;
                        case 'O':
                            /* End */
                            if (xpos < line->len)
                            {
                                xpos = line->len;
                                output("@GOTO:%d,%d@",xpos+1,ypos);
                            }
                            break;
                    }
                    break;
                case 1:
                    /* Ctrl-A = Abort */
                    quit = 1;
                    break;
                case 13:
                    /* Enter */

                    /* Make new line */
                    tmpline = (LINE_REC *) _malloc(sizeof(LINE_REC));
                    tmpline->prev = line;
                    tmpline->next = line->next;
                    if (line->next != NULL) line->next->prev = tmpline;
                    line->next = tmpline; line->joined = 0;

                    strcpy(tmpline->text, line->text+xpos);
                    tmpline->len = (unsigned char) strlen(tmpline->text);
                    line->text[xpos] = '\0'; line->len = (unsigned char) xpos;
                    tmpline->joined = line->joined; line = tmpline;
                    lines++; xpos = 0;
                    output("@CLREOL@");
                    oldcol = line_color(line);
                    linecol = 1;
                    if (ypos == user.ScreenLen)
                    {
                        /* Scroll down */
                        output("@SCROLL_UP:%d@@GOTO:1,%d@@CLREOL@%s\r", header_lines+1, ypos, line->text);
                        upy++;
                    }
                    else
                    {
                        output("@CR@@INSLINE@%s\r",line->text);
                        ypos++;
                    }

                    break;
                case 8:
                    /* Backspace */
                    if (xpos == 0)
                    {
                        if (ypos+upy == header_lines+1) break;

                        if (ypos == header_lines+1)
                        {
                            output("\r@INSLINE@");
                            oldcol = line_color(line->prev);
                            outtext(line->prev->text);
                            outchr('\n');
                            oldcol = line_color(line);
                            upy--;
                        }
                        else
                            ypos--;
                        output("\r@CLREOL@");

                        strcpy(buffer, line->text);
                        line->len = 0; line->text[0] = '\0';
                        line = line->prev;
                        if (line->text[line->len-1] != ' ')
                        {
                            line->text[line->len++] = ' ';
                            line->text[line->len] = '\0';
                        }
                        xpos = line->len; line->joined = 1;
                        output("@GOTO:%d,%d@",xpos+1,ypos);
                        oldx = xpos; oldy = ypos; tmpline = line; linecol = 0;
                        add_string(buffer); xpos = oldx; ypos = oldy;
                        line = tmpline; tmpline = line->next;
                        if (tmpline->len == 0)
                        {
                            /* Remove line */
                            line->joined = tmpline->joined;
                            line->next = tmpline->next;
                            if (tmpline->next != NULL) tmpline->next->prev = line;
                            _free(tmpline); lines--;
                            output("@SCROLL_UP:%d@",ypos+1);
                            tmpline = line;
                            num = ypos;
                            while (num < user.ScreenLen && tmpline != NULL)
                            {
                                tmpline = tmpline->next;
                                num++;
                            }
                            output("@GOTO:1,%d@@CLREOL@",user.ScreenLen);
                            if (tmpline != NULL) outtext(tmpline->text);
                        }
                        output("@GOTO:%d,%d@",xpos+1,ypos);
                    }
                    else
                    {
                        xpos--;
                        memmove(line->text+xpos,line->text+xpos+1,line->len-xpos+1);
                        line->len--;

                        if (!linecol || xpos <= QUOTE_MAX)
                        {
                            linecol = 1;
                            oldx = oldcol;
                            oldcol = line_color(line);
                            if (oldx != oldcol)
                            {
                                outchr('\r');
                                outtext(line->text);
                                output(" @GOTO:%d,%d@", xpos+1, ypos);
                                oldx = 0;
                            }
                            else
                                oldx = 1;
                        }
                        else
                            oldx = 1;

                        if (oldx)
                        {
                            if (user.Emulation == USER_EMULATION_ANSI_X364)
                                output("\x08@DELCHR@");
                            else
                            {
                                outchr('\x08');
                                outtext(line->text+xpos);
                                output(" @GOTO:%d,%d@", xpos+1, ypos);
                            }
                        }
                    }
                    break;
                case 18:
                    /* Ctrl-R = Redraw */
                    refresh_screen();
                    break;
                case 25:
                    /* Ctrl-Y = Remove line */
                    if (line->next == NULL)
                    {
                        /* Last line, just clear line */
                        xpos = 0; line->len = 0; line->text[0] = '\0';
                        output("\r@CLREOL@");
                    }
                    else
                    {
                        /* Delete line */
                        tmpline = line;
                        line = line->next;

                        if (tmpline == first_line) first_line = line;
                        if (tmpline->prev != NULL) tmpline->prev->next = line;
                        line->prev = tmpline->prev;
                        _free(tmpline); lines--;
                        output("@DELLINE@");

                        /* Draw last line */
                        tmpline = line;
                        num = ypos;
                        while (num < user.ScreenLen && tmpline != NULL)
                        {
                            tmpline = tmpline->next;
                            num++;
                        }
                        output("@GOTO:1,%d@@CLREOL@",user.ScreenLen);
                        if (tmpline != NULL)
                        {
                            oldcol = line_color(tmpline);
                            linecol = 1;
                            outtext(tmpline->text);
                        }

                        if (xpos > line->len) xpos = line->len;
                        output("@GOTO:%d,%d@",xpos+1,ypos);
                    }
                    break;
                case 26:
                    /* Ctrl-Z = Save */
                    save_file(fname);
                    quit = 2;
                    break;
                default:
                    if ((unsigned char) ch >= 32) add_character(ch);
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    /* Release memory */
    while (first_line != NULL)
    {
        line = first_line->next;
        _free(first_line);
        first_line = line;
    }

    return quit-1;
}
