/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __FILES_H
#define __FILES_H

#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/stat.h>

#ifdef __BORLANDC__
#  include <dirent.h>
#  include <dir.h>
#elif defined (__linux__) || defined (__EMX__)
#  include <dirent.h>
#elif defined (__WATCOMC__)
#  include <direct.h>
#endif

#ifdef __linux__
#  include <unistd.h>
#  include <sys/file.h>
#else
#  include <process.h>
#  include <dos.h>
#  include <share.h>
#  include <io.h>
#endif

#ifdef __linux__
#  define __NO_DRIVES__
#  define __FILES_CASE_SENSITIVE__
#  define DEV_IN  "/dev/tty"
#  define DEV_OUT "/dev/tty"
#  define SLASH '/'
#  define SSLASH "/"
#  define SH_DENYNO 0
#  define SH_DENYRD 0
#  define SH_DENYWR 0
#  define SH_DENYRW 0
#  define O_BINARY 0
#else
#  define DEV_IN  "con"
#  define DEV_OUT "con"
#  define SLASH '\\'
#  define SSLASH "\\"
#endif

#ifdef __linux__
int exec(char *path, char *params);
#  define FileTrunc(a,b) ftruncate(a,b)
#  define ISDIR(a) S_ISDIR(a.st_mode)
#  define ISLNK(a) S_ISLNK(a.st_mode)
#else
#  define search_ign_file(a) (a)
#  define exec(a,b) spawnlp(P_WAIT,a,a,b,NULL)
#  define FileTrunc(a,b) chsize(a,b)
#  define ISDIR(a) (((a.st_mode) & S_IFDIR) == S_IFDIR)
#endif

#if defined (__linux__) || defined (__EMX__)
#  define lock(a,b,c) flock(a,LOCK_EX | LOCK_NB)
#  define unlock(a,b,c) flock(a,LOCK_UN)
#endif

#ifndef __FILES_CASE_SENSITIVE__
#  define FileOpenIgn(a,b,c) FileOpen(a,b,c)
#endif

#ifdef OWN_FILE_ROUTINES

/* Use own file routines instead of internal open(), read(), etc .. */

#define CREATE_MODE 0660 /* -rw-rw---- */
int FileOpen(char *path, int mode, int share);
int FileCreate(char *path, int mode);
int FileMode(int handle, int mode);
int FileClose(int handle);
int FileRead(int handle, void *data, int size);
int FileWrite(int handle, void *data, int size);
long FileSeek(int handle, long pos, int mode);
int FileLock(int handle);
void FileUnlock(int handle);

#else

#ifdef __linux__
#  define FileOpen(a,b,c) open(a,b)
#  define FileMode(a,b)
#  define CREATE_MODE 0660 /* -rw-rw---- */
#else
#  define FileOpen(a,b,c) sopen(a,b,c)
#  define FileMode(a,b) setmode(a,b);
#  define CREATE_MODE (S_IREAD | S_IWRITE)
#endif
#define FileCreate(a,b) creat(a,b)
#define FileClose(a) close(a)
#define FileRead(a,b,c) read(a,b,c)
#define FileWrite(a,b,c) write(a,b,c)
#define FileSeek(a,b,c) lseek(a,b,c)
int FileLock(int handle);
#define FileUnlock(a) unlock(a,0,1)

#endif

char *_fgets(char *buf, size_t n, int handle);
int copyfile(char *src, char *dest);

int mkpath(char *path);

int insert_space(int handle, long pos, long size, long fsize);
int erase_path(char *path);

#ifdef __NO_DRIVES__
#  define change_dir(a) chdir(a)
#else
void change_dir(char *path);
#endif

#ifdef __FILES_CASE_SENSITIVE__
char *search_ign_file(char *fname);
int FileOpenIgn(char *fname, int flags, int share);
#endif

typedef struct
{
    int handle;

    time_t last_mtime;
    int buffering; /* Buffering on/off */

    long bufstart,bufend;
    char buffer[16384];

    long seekpos;
    unsigned long filesize;
}
FILE_BUF;

/* For buffered file reading.. */

FILE_BUF *FileBufOpen(char *fname, int mode, int share_mode);
FILE_BUF *FileBufCreate(char *fname, int mode);
void FileBufClose(FILE_BUF *file);
int FileBufRead(FILE_BUF *file, void **buffer, int bufsize);
int FileBufWrite(FILE_BUF *file, void *buffer, int bufsize);
long FileBufSeek(FILE_BUF *file, long filepos, int type);
#define FileBuffering(a, b) a->buffering = b
#define FileBufLock(a) FileLock(a->handle)
#define FileBufUnlock(a) FileUnlock(a->handle)

#endif
