/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __FAREAS_H
#define __FAREAS_H

#define FAREA_FLAG_READ_RIGHTS          0x01
#define FAREA_FLAG_WRITE_RIGHTS         0x02
#define FAREA_FLAG_UPLOAD_AREA          0x04
#define FAREA_FLAG_HOLD_AREA            0x08
#define FAREA_FLAG_DATABASE_AREA        0x10

typedef struct FAREA_REC
{
    struct FAREA_REC *prev;     /* Previous record */
    struct FAREA_REC *next;     /* Next record */

    char name[61];              /* Name */
    char path[256];             /* Real path */
    char description[61];       /* Description */
    unsigned char flags;        /* Flags */

    unsigned subarea;           /* This is area is in subarea # */
    unsigned jumparea;          /* This is a pointer to subarea # */
}
FAREA_REC;

extern FAREA_REC farea;         /* Current file area record */
extern FAREA_REC *farea_rec;    /* Current file area record .. pointer */
extern FAREA_REC hold_farea;    /* Hold file area record */
extern FAREA_REC ul_farea;      /* Upload file area record */

extern unsigned ul_area;        /* Which area to put uploads */
extern unsigned file_areas;     /* Number of file areas */

extern unsigned current_farea;  /* Current file area number */
extern unsigned current_subarea;/* Current subarea number */

extern char farea_history[256]; /* "/area/area2/..." style area history */

int init_fareas(int all_areas); /* Read file areas */
void deinit_fareas(void);       /* Deallocate memory used by file areas */

int select_farea(char *farea_name_ptr); /* Select new file area */
int read_farea_record(unsigned long farea_num); /* Read file area record # */
unsigned search_path(char *path); /* Read file area record # */
char *get_history(unsigned long farea_num, char *history); /* Get path history of file area # */

#endif
