/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* config.c - Configuration file reading */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "os.h"
#include "memory.h"
#include "config.h"
#include "mareas.h"
#include "files.h"

#define SECTION_GENERAL 1
#define SECTION_PATHS   2
#define SECTION_PROTOS  3
#define SECTION_LANGS   4
#define SECTION_CHARSET 5
#define SECTION_PACKERS 6
#define SECTION_ADDRS   7

#define datacpy(field) \
{ \
    if (strlen(data) > sizeof(field)-1) goto __err_toolong; \
    strcpy(field, data); \
    break; \
}

char bbs_name[80];
char sysop_name[36];
char bbs_location[80];
char bbs_phone[80];
char first_sysop_name[80];
char msg_packet_id[9];
char origin_line[80];
char tear_line[80];
char bw_tear[80];
char qwk_tear[80];
char shell[256];
char fareas_bbs[256];
char mareas_bbs[256];
char data_path[256];
char log_file[256];
char filebase_name[256];
char common_path[256];
char jam_base_file[256];
char concord_base[256];
char filemail_path[256];
char init_string[100];
char answer_string[100];
char ok_string[100];
char resp_ok[100];
char resp_ring[100];

int nodes;

PACKER_REC *firstpacker = NULL;
PROTO_REC *firstproto = NULL;
LANG_REC *firstlang = NULL;
NETADDR_REC *firstnet = NULL;
CHARSET_REC *firstcharset = NULL;

PACKER_REC user_packer;
PROTO_REC user_proto;
LANG_REC user_lang;
CHARSET_REC user_charset;

int read_table(char *fname, unsigned char *table)
{
    int h;
    int num, num2;
    char str[256];
    unsigned long line;

    for (num = 0; num < 256; num++) table[num] = (unsigned char) num;

    if (fname[0] == '\0') return 1;

    h = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    if (h == -1)
    {
        printf("Translation table file not found: %s\n", fname);
        return 0;
    }

    line = 0;
    while (_fgets(str, sizeof(str), h) != NULL)
    {
        line++;
        if (str[0] == '\0' || str[0] == ';') continue;

        if (sscanf(str, "%d %d", &num, &num2) < 2)
        {
            printf("Error in file '%s' line %lu\n", fname, line);
            FileClose(h);
            return 0;
        }

        table[num] = (unsigned char) num2;
    }

    FileClose(h);
    return 1;
}


int read_config(char *fname)
{
    PACKER_REC *packer, *tmppacker;
    PROTO_REC *proto, *tmpproto;
    LANG_REC *lang, *tmplang;
    CHARSET_REC *charset, *tmpchar;
    NETADDR_REC *net, *tmpnet;
    int fcfg, section;
    char line[256], *strp, *data;
    unsigned linenum;

    fcfg = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    if (fcfg == -1)
    {
        printf("Can't open configuration file %s\n", fname);
        return 0;
    }

    bbs_name[0] = '\0'; sysop_name[0] = '\0'; bbs_location[0] = '\0';
    bbs_phone[0] = '\0'; first_sysop_name[0] = '\0'; msg_packet_id[0] = '\0';
    tear_line[0] = '\0'; bw_tear[0] = '\0'; qwk_tear[0] = '\0'; nodes = 1;
    firstpacker = NULL; firstproto = NULL; firstlang = NULL; firstnet = NULL;
    packer = NULL; proto = NULL; lang = NULL; net = NULL;
    firstcharset = NULL; charset = NULL;

    section = 0; linenum = 0;
    while (_fgets(line, sizeof(line), fcfg) != NULL)
    {
        linenum++;
        if (line[0] == '\0' || line[0] == ';') continue;

        if (line[0] == '[')
        {
            if (stricmp(line, "[general]") == 0)
            {
                section = SECTION_GENERAL;
                continue;
            }
            if (stricmp(line, "[paths]") == 0)
            {
                section = SECTION_PATHS;
                continue;
            }
            if (strnicmp(line, "[protocol:", 10) == 0)
            {
                tmpproto = (PROTO_REC *) _malloc(sizeof(PROTO_REC));
                if (tmpproto == NULL)
                {
                    printf("Not enough memory to allocate %d bytes\n", (int) sizeof(PROTO_REC));
                    return 0;
                }
                if (firstproto == NULL) firstproto = tmpproto;
                if (proto != NULL) proto->next = tmpproto;
                proto = tmpproto; proto->next = NULL;
                if (strlen(line+10) > sizeof(proto->name)) goto __err_toolong;
                strcpy(proto->name, line+10); proto->name[strlen(proto->name)-1] = '\0';

                section = SECTION_PROTOS;
                continue;
            }
            if (strnicmp(line, "[language:", 10) == 0)
            {
                tmplang = (LANG_REC *) _malloc(sizeof(LANG_REC));
                if (tmplang == NULL)
                {
                    printf("Not enough memory to allocate %d bytes\n", (int) sizeof(LANG_REC));
                    return 0;
                }
                if (firstlang == NULL) firstlang = tmplang;
                if (lang != NULL) lang->next = tmplang;
                lang = tmplang; lang->next = NULL;
                if (strlen(line+10) > sizeof(lang->name)) goto __err_toolong;
                strcpy(lang->name, line+10); lang->name[strlen(lang->name)-1] = '\0';

                section = SECTION_LANGS;
                continue;
            }
            if (strnicmp(line, "[charset:", 9) == 0)
            {
                tmpchar = (CHARSET_REC *) _malloc(sizeof(CHARSET_REC));
                if (tmpchar == NULL)
                {
                    printf("Not enough memory to allocate %d bytes\n", (int) sizeof(CHARSET_REC));
                    return 0;
                }
                if (firstcharset == NULL) firstcharset = tmpchar;
                if (charset != NULL) charset->next = tmpchar;
                charset = tmpchar; charset->next = NULL;
                if (strlen(line+10) > sizeof(charset->name)) goto __err_toolong;
                strcpy(charset->name, line+10); charset->name[strlen(charset->name)-1] = '\0';

                section = SECTION_CHARSET;
                continue;
            }
            if (strnicmp(line, "[packer:", 8) == 0)
            {
                tmppacker = (PACKER_REC *) _malloc(sizeof(PACKER_REC));
                if (tmppacker == NULL)
                {
                    printf("Not enough memory to allocate %d bytes\n", (int) sizeof(PACKER_REC));
                    return 0;
                }
                if (firstpacker == NULL) firstpacker = tmppacker;
                if (packer != NULL) packer->next = tmppacker;
                packer = tmppacker; packer->next = NULL;
                if (strlen(line+8) > sizeof(packer->name)) goto __err_toolong;
                strcpy(packer->name, line+8); packer->name[strlen(packer->name)-1] = '\0';

                section = SECTION_PACKERS;
                continue;
            }
            if (stricmp(line, "[addresses]") == 0)
            {
                section = SECTION_ADDRS;
                continue;
            }
            goto __err;
        }

        switch (section)
        {
            case SECTION_GENERAL:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';

                if (stricmp(line, "OriginLine") == 0)
                {
                    if (strlen(data) > sizeof(origin_line)-1)
                    {
                    __err_toolong:
                        FileClose(fcfg);
                        printf("Error in configuration file %s line %u: data field too long.\n", fname, linenum);
                        return 0;
                    }
                    strcpy(origin_line, data);
                    break;
                }

                while (*data == ' ') data++;

                //if (stricmp(line, "Port") == 0) datacpy(bbs_name);
                if (stricmp(line, "Nodes") == 0)
                {
                    if (sscanf(data, "%d", &nodes) != 1) nodes = 1;
                    break;
                }
                if (stricmp(line, "InitString") == 0) datacpy(init_string);
                if (stricmp(line, "AnswerString") == 0) datacpy(answer_string);
                if (stricmp(line, "OKString") == 0) datacpy(ok_string);
                if (stricmp(line, "RespOK") == 0) datacpy(resp_ok);
                if (stricmp(line, "RespRING") == 0) datacpy(resp_ring);
                if (stricmp(line, "BBS_Name") == 0) datacpy(bbs_name);
                if (stricmp(line, "Sysop") == 0) datacpy(sysop_name);
                if (stricmp(line, "BBS_Location") == 0) datacpy(bbs_location);
                if (stricmp(line, "BBS_Phone") == 0) datacpy(bbs_phone);
                if (stricmp(line, "SysopFirstName") == 0) datacpy(first_sysop_name);
                if (stricmp(line, "MsgPacketID") == 0) datacpy(msg_packet_id);
                if (stricmp(line, "TearLine") == 0) datacpy(tear_line);
                if (stricmp(line, "BWTear") == 0) datacpy(bw_tear);
                if (stricmp(line, "QWKTear") == 0) datacpy(qwk_tear);

                goto __err;
            case SECTION_PATHS:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';
                while (*data == ' ') data++;

                if (stricmp(line, "Shell") == 0) datacpy(shell);
                if (stricmp(line, "FileAreas") == 0) datacpy(fareas_bbs);
                if (stricmp(line, "MsgAreas") == 0) datacpy(mareas_bbs);
                if (stricmp(line, "DataPath") == 0) datacpy(data_path);
                if (stricmp(line, "LogFile") == 0) datacpy(log_file);
                if (stricmp(line, "FilebaseName") == 0) datacpy(filebase_name);
                if (stricmp(line, "CommonPath") == 0) datacpy(common_path);
                if (stricmp(line, "JAMBaseFile") == 0) datacpy(jam_base_file);
                if (stricmp(line, "ConcordPath") == 0) datacpy(concord_base);
                if (stricmp(line, "FileMailPath") == 0) datacpy(filemail_path);
                break;
            case SECTION_PROTOS:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';
                while (*data == ' ') data++;

                if (stricmp(line, "Bidir") == 0)
                {
                    if (stricmp(data, "Yes") == 0)
                        proto->bidir = 1;
                    else if (stricmp(data, "No") == 0)
                        proto->bidir = 0;
                    else
                        goto __err;
                    break;
                }
                if (stricmp(line, "Mode") == 0)
                {
                    if (stricmp(data, "Stdio") == 0)
                        proto->mode = PROTO_MODE_STDIO;
                    else if (stricmp(data, "Normal") == 0)
                        proto->mode = PROTO_MODE_NORMAL;
                    else if (stricmp(data, "SModem") == 0)
                        proto->mode = PROTO_MODE_SMODEM;
                    else
                        goto __err;
                    break;
                }
                if (stricmp(line, "Efficiency") == 0)
                {
                    if (sscanf(data, "%d", &proto->efficiency) != 1) goto __err;
                    break;
                }
                if (stricmp(line, "Key") == 0)
                {
                    proto->key = (char) toupper(data[0]);
                    if (data[1] != '\0') goto __err;
                    break;
                }
                if (stricmp(line, "Upload") == 0)
                {
                    proto->upload = (char *) _malloc(strlen(data)+1);
                    strcpy(proto->upload, data);
                    break;
                }
                if (stricmp(line, "Download") == 0)
                {
                    proto->download = (char *) _malloc(strlen(data)+1);
                    strcpy(proto->download, data);
                    break;
                }
                if (stricmp(line, "DLChar") == 0)
                {
                    proto->dlchar = data[0];
                    if (data[1] != '\0') goto __err;
                    break;
                }
                break;
            case SECTION_LANGS:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';
                while (*data == ' ') data++;

                if (stricmp(line, "Key") == 0)
                {
                    lang->key = (char) toupper(data[0]);
                    if (data[1] != '\0') goto __err;
                    break;
                }
                if (stricmp(line, "FileName") == 0)
                {
                    lang->fname = (char *) _malloc(strlen(data)+1);
                    strcpy(lang->fname, data);
                    break;
                }
                if (stricmp(line, "AnsiPath") == 0)
                {
                    lang->ansipath = (char *) _malloc(strlen(data)+1);
                    strcpy(lang->ansipath, data);
                    break;
                }
                if (stricmp(line, "MenuPath") == 0)
                {
                    lang->menupath = (char *) _malloc(strlen(data)+1);
                    strcpy(lang->menupath, data);
                    break;
                }
                if (stricmp(line, "MainMenu") == 0)
                {
                    lang->mainmenu = (char *) _malloc(strlen(data)+1);
                    strcpy(lang->mainmenu, data);
                    break;
                }
                break;
            case SECTION_CHARSET:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';
                while (*data == ' ') data++;

                if (stricmp(line, "Key") == 0)
                {
                    charset->key = (char) toupper(data[0]);
                    if (data[1] != '\0') goto __err;
                    break;
                }
                if (stricmp(line, "Kludge") == 0) datacpy(charset->kludge);
                if (stricmp(line, "Intable") == 0)
                    if (!read_table(data, charset->intable)) return 0;
                if (stricmp(line, "Outtable") == 0)
                    if (!read_table(data, charset->outtable)) return 0;
                break;
            case SECTION_PACKERS:
                strp = strchr(line, '=');
                if (strp == NULL) goto __err;
                data = strp+1;
                while (*(strp-1) == ' ') strp--; *strp = '\0';
                while (*data == ' ') data++;

                if (stricmp(line, "ID") == 0) datacpy(packer->id);
                if (stricmp(line, "Key") == 0)
                {
                    packer->key = (char) toupper(data[0]);
                    if (data[1] != '\0') goto __err;
                    break;
                }
                if (stricmp(line, "Pack") == 0)
                {
                    packer->pack = (char *) _malloc(strlen(data)+1);
                    strcpy(packer->pack, data);
                    break;
                }
                if (stricmp(line, "Unpack") == 0)
                {
                    packer->unpack = (char *) _malloc(strlen(data)+1);
                    strcpy(packer->unpack, data);
                    break;
                }
                break;
            case SECTION_ADDRS:
                tmpnet = (NETADDR_REC *) _malloc(sizeof(NETADDR_REC));
                if (tmpnet == NULL)
                {
                    printf("Not enough memory to allocate %d bytes\n", (int) sizeof(NETADDR_REC));
                    return 0;
                }
                if (firstnet == NULL) firstnet = tmpnet;
                if (net != NULL) net->next = tmpnet;
                net = tmpnet; net->next = NULL;

                if (!str2addr(line, &net->zone, &net->net, &net->node, &net->point)) goto __err;
                break;
            default:
            __err:
                close(fcfg);
                printf("Error in configuration file %s line %u\n", fname, linenum);
                return 0;
        }
    }
    close(fcfg);

    return 1;
}

void close_config(void)
{
    PACKER_REC *packer;
    PROTO_REC *proto;
    LANG_REC *lang;
    NETADDR_REC *net;
    CHARSET_REC *charset;

    while (firstpacker != NULL)
    {
        packer = firstpacker->next;
        if (firstpacker->pack != NULL) _free(firstpacker->pack);
        if (firstpacker->unpack != NULL) _free(firstpacker->unpack);
        _free(firstpacker);
        firstpacker = packer;
    }

    while (firstproto != NULL)
    {
        proto = firstproto->next;
        if (firstproto->upload != NULL) _free(firstproto->upload);
        if (firstproto->download != NULL) _free(firstproto->download);
        _free(firstproto);
        firstproto = proto;
    }

    while (firstlang != NULL)
    {
        lang = firstlang->next;
        if (firstlang->fname != NULL) _free(firstlang->fname);
        if (firstlang->ansipath != NULL) _free(firstlang->ansipath);
        if (firstlang->menupath != NULL) _free(firstlang->menupath);
        if (firstlang->mainmenu != NULL) _free(firstlang->mainmenu);
        _free(firstlang);
        firstlang = lang;
    }

    while (firstnet != NULL)
    {
        net = firstnet->next;
        _free(firstnet);
        firstnet = net;
    }

    while (firstcharset != NULL)
    {
        charset = firstcharset->next;
        _free(firstcharset);
        firstcharset = charset;
    }
}
