
#define __MBD

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
/*#include <stdlib.h>*/



#include "mbox.h"
#define N_OPT
#include "s_global.h"

extern struct GLOBAL_OPT_TYP OPT;
#include "config.h"
extern int ALL;

#undef NOCLEANTMP
#include "mbd.h"

#undef STRING
#define STRING 160

extern UNSIGNED char tmp[STRING], _TO[2*STRING],_FROM[2*STRING];
extern UNSIGNED char alias[MAX_XMD_ALIAS][2][STRING];
extern UNSIGNED char x400[STRING],ERR_MBOX[STRING],ADMIN[STRING],_SUBJECT[STRING];
extern UNSIGNED char SYSTEM[STRING],ALIAS_FROM[STRING];
UNSIGNED char PIPE_REC[STRING];
extern int INTERACT;
extern int maillogsize;



#undef DEBUG




/* #ET - Calculates the delivering time out of a "Date:" header line [hd].

   This function returns a "X-Delivering-Time:" header line. */

UNSIGNED char *elapsed_time( hd )
UNSIGNED char hd[];
{
  UNSIGNED char tag[STRING];
  UNSIGNED char monat[STRING];
  UNSIGNED char jahr[STRING];
  UNSIGNED char zeit[STRING];
  UNSIGNED char zone[STRING];

static  UNSIGNED char s[2*STRING];
static  UNSIGNED char t[STRING];
 
  UNSIGNED char mon[12][4];

  UNSIGNED char tzcode[STRING];
  UNSIGNED char tzfact[STRING];
  UNSIGNED char tzname[STRING];

  int i = 0, a = 0;

  long ljahr, lzeit;
  long njahr, nzeit;

  FILE *fp;


  strcpy(mon[ 1], "Jan");
  strcpy(mon[ 2], "Feb");
  strcpy(mon[ 3], "Mar");
  strcpy(mon[ 4], "Apr");
  strcpy(mon[ 5], "May");
  strcpy(mon[ 6], "Jun");
  strcpy(mon[ 7], "Jul");
  strcpy(mon[ 8], "Aug");
  strcpy(mon[ 9], "Sep");
  strcpy(mon[10], "Oct");
  strcpy(mon[11], "Nov");
  strcpy(mon[12], "Dec");

  while((a == 0) && (hd[i] != 0)){
	if((hd[i] >= '0') && (hd[i] <= '9')) a = i;
	i++;
  }

  strcpy(s, (UNSIGNED char *) strcopy(hd, a, (strlen(hd))));

  sscanf(s, "%s %s %s %s %s", tag, monat, jahr, zeit, zone);
 
  for(i = 1; i <= 12; i++){
	if(strcomp(mon[i], monat) == 0) a = i;
  }

  sprintf(s, "%02.2d.%02.2d.%02.2d", atoi(tag), a, atoi(jahr));
  ljahr = dateconv( (UNSIGNED char *) s );

  lzeit = (long) (atol( strcopy(zeit, 0, 1) ) * 60) + (atol(strcopy(zeit, 3, 4)));
  
  strcpy(s, (UNSIGNED char *) mydate( 0 ));
  njahr = dateconv( (UNSIGNED char *) s );

  strcpy(s, (UNSIGNED char *) mytime( 0 ));
  nzeit = (long) (atol( strcopy(s, 0, 1) ) * 60) + (atol(strcopy(s, 3, 4)));

  if((zone[1] >= '0') && (zone[1] <= '9')){     /* +0500, -0100, ...  */
	strcpy(tzfact, (UNSIGNED char *) zone);
	tzname[0] = 0;
  }
  else{						/* GMT, CET, EET, ... */
	fp = fopen( TIMEZONES, "r" );
	if(fp == NULL){
		sprintf(t, "XMD-FILE-NOT-FOUND: %s\n", (UNSIGNED char *) TIMEZONES);
		return (UNSIGNED char *) t;
	}
	while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
	while(fgets(s, STRING, fp) != NULL){
		sscanf(s, "%s", t);
		if(strcomp(zone, t) == 0){
			sscanf(s, "%s %s", tzcode, tzfact);	
			strcpy(tzname, (UNSIGNED char *) stripped(strcopy(s, 19, strlen(s))));
		}
	}
	fclose(fp);
  }

  strcpy(s, (UNSIGNED char *) GMT_DIFF);	
  if(s[0] == '-'){
	s[0] = ' ';
	nzeit += (long) (atol(s) * 60 / 100); 
  }
  else{
	s[0] = ' ';
	nzeit -= (long) (atol(s) * 60 / 100); 
  }
  
  if(tzfact[0] == '-'){
  	tzfact[0] = ' ';
	lzeit += (long) (atol(tzfact) * 60 / 100); 
  }
  else{
	tzfact[0] = ' ';
	lzeit -= (long) (atol(tzfact) * 60 / 100); 
  }
  
  njahr -= ljahr; 

  if(njahr > 30){
	njahr -= 70;	
  }
  if(njahr > 30){
	return( (UNSIGNED char *) "X-Delivering-Time: Not able to calculate!\n" );
  }

  nzeit -= lzeit;
  
  if(nzeit < 0){
	nzeit += (24 * 60);
	njahr -= 1;
  }

  if(njahr > 0){
	sprintf(s, "X-Delivering-Time: %ld day(s), %ld hour(s) and %ld minute(s)",
		  (long) njahr, 
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));
  }
  else{
	sprintf(s, "X-Delivering-Time: %ld hour(s) and %ld minute(s)",
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));	
  }

  if(tzname[0] != 0){
	sprintf(t, "; %s", tzname);
	strcat(s, t);
  }

  strcat(s, "\n");


  return (UNSIGNED char *) s;
}



void log_it( s1, s2, s3 )
UNSIGNED char s1[], s2[], s3[];
{
  FILE *ff;
  char t[STRING];


  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't open %s\n", XMDLOG);
	return;
  }
  fprintf(ff, "%5.5s  %5.5s > %-29.29s   [%s %s]\n",
	(UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
        (UNSIGNED char *) s1, s2, s3);
  fclose(ff);
      
}


void log_mail( to,s1 )
UNSIGNED char *to,*s1;
{
  FILE *ff;
  char t[STRING];


  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't append %s\n", XMDLOG);
	return;
  }
  fprintf(ff, "%5.5s  %5.5s w:%-30.30s  ",
	(UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
        sstrings((UNSIGNED char *) to));
  fprintf(ff,"%-29.29s\n", sstrings((UNSIGNED char *) s1));
  fclose(ff);
      
}





/* #BR - ERR-Mail to a ext.user [arg]. */

err_brief(mode)
int mode;
/* modes :
 	0 	-> bbs-user unknown 
 	
*/
{
  FILE *fp;
  FILE *fd,*ff;
  time_t timer,k;
  int ffd;


  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  UNSIGNED char rec_char[STRING];
  struct userdaten LOOSER;

  int receiver;


if (1 /*mode==3*/)
{
  chdir(HOME);
  ffd = open(UDBASE, O_RDONLY);
  if (ffd == -1) {
	log_it( "Can't read:", UDBASE, "!" );
	printf("\nCan't read %s\n", UDBASE);
	massiv_unlock();
	exit(-1);
  }
  lseek(ffd, 0L, SEEK_SET);
  
  while ((read(ffd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER))) {
      if (LOOSER.id==1) {
       strcpy(ADMIN,LOOSER.name);
      }
/*      printf("O");fflush(stdout);*/
  }
  close(ffd);




}

	time(&timer); k=time(0);
        sprintf(s,"%s/tmp/errmail.%d",HOME,getpid());
        if ((ff=fopen(s,"w"))==NULL)
        {
          printf("\nCan't write to (%s)\n",s);      
          massiv_unlock();
          exit(-1);
        }        
        
        sprintf(s,"%s/etc/log/bbsmail.error.log",HOME);
        if ((fp=fopen(s,"a"))==NULL)
        {
          printf("\nCan't append to (%s)\n",s);      
          massiv_unlock();
          exit(-1);
        }        
        if (mode!=5)
        {
	 fprintf(ff, "From: %s@%s (postmaster@%s)\n", "Administration" /*ADMIN*/,UUCPID2,UUCPID2);
	} else
	{  /* message is looping */
	 fprintf(ff, "From: TBBS_MAILER-DAEMON@%s\n",UUCPID2);
	}
	fprintf(ff, "Sender: T-BBS_MAILER-DAEMON@%s\n", UUCPID2); 
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	
	
	if (mode!=5) 
	{
	 fprintf(ff, "To: %s\n", cut_bef(_FROM));
 	 fprintf(ff, "Cc: %s\n", ZPOSTMASTER);	 
	} else
	{
 	 fprintf(ff, "To: %s\n", ZPOSTMASTER);
	}
	if (mode!=5)
	 fprintf(ff, "Subject: %s\n",BBSMD01_MSG);
	else fprintf(ff, "Subject: %s\n",BBSMD01a_MSG);
	fprintf(ff, "X-Mailer: xmd %s <%s>\n", VERSION,  AUTOR2);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);
     fprintf(ff,"Received: by \"%s\"  %s \nMessage-ID: <%d.%d-tbbs@%s>\n\n",
       s,BBSMD_VERSION,getpid(),k,UUCPID2);
    }
	
	fputs("\n", ff);

switch (mode)
{
    case 0: /* keine User-Pfad */
       fprintf(ff, "%s\n%s\n%s\n \"%s\"",BBSMD03_MSG, BBSMD03a_MSG,BBSMD04_MSG,_TO);
       fprintf(ff, " %s \"%s@%s\")\n%s\n\n\n", 
        BBSMD04a_MSG,"Administration"/*leer2punkt(ADMIN)*/,UUCPID2,BBSMD05_MSG);
       break;
    case 2:  /* internel -error (permission) */
       fprintf(ff, "%s\n%s\n%s\n",BBSMD03_MSG, BBSMD03c_MSG,BBSMD05_MSG);
       break;       
    case 3:  /* user not found */
       fprintf(ff, "%s\n%s\n%s\n \"%s\"",BBSMD03_MSG, BBSMD03a_MSG,BBSMD04_MSG,_TO);
       fprintf(ff, " %s \"%s@%s\")\n%s\n\n\n", 
        BBSMD04x_MSG,leer2punkt(ADMIN),UUCPID2,BBSMD05_MSG);       
       break;      
    case 5:  /* Mail ist LOOPING */
       fprintf(ff, "%s\n%s\n%s\n%s@%s:\n\"%s\"\n%s",BBSMD03_MSG, BBSMD03e_MSG,BBSMD04_MSG,
        leer2punkt(ADMIN),UUCPID2,_TO,BBSMD04e_MSG);
       fprintf(ff,"\n%s\n",BBSMD05_MSG);       
       break;             
}

         
         
        sprintf(s,"%s/tmp/%d.XMD",HOME,getpid());
        fd=fopen(s,"r");
        while (fgets(s,STRING,fd)!=NULL)
        {
         s[STRING-1]=0;
         fprintf(ff,"%s",s);
        } 
	fclose(ff); fclose(fd);
	
	
	
	sprintf(t,"%s/tmp/errmail.%d",HOME,getpid());
	ff=fopen(t,"r");
	fprintf(fp,"\n\n\n----------- snip ---------- snip ---------- snip ------------ snip -----\n");
	while (fgets(s,STRING,ff)!=NULL)
	{
	  s[STRING]=0;
    	  fprintf(fp,"%s",s);
	}
	fclose(fp); fclose(ff);
	if (mode!=5) /* !=LOOPING-MSG */
	{

	 MailTo(t,"bbs",ZPOSTMASTER);
	 MailTo(t,"bbs",_FROM);
	} else
	{
	  MailTo(t,"bbs",ZPOSTMASTER);
	}
	unlink(t);
        
       massiv_unlock(); 
       sprintf(t,"%s/tmp/%d.XMD",HOME,getpid()); unlink(t);
       sprintf(t,"%s/tmp/%dPIP",HOME,getpid());unlink(t);
       sprintf(t,"%s/tmp/%d.DUMP",HOME,getpid());unlink(t);

/*
  sprintf(t, "%s/usr/%c/%d/seq", HOME, toupper(arg[0]),receiver);
  mbunlock(t);        
  */
     
       exit(0);
}






/* #BR - Weiterleiten -> Mail ext->BBS->ext.user  */

weiterl_brief(user)
unsigned char *user;
{
  FILE *ff,*fd;
  time_t timer,k;
  int ffd,i,j;


  UNSIGNED char s[2*STRING];
  UNSIGNED char t[2*STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  UNSIGNED char rec_char[STRING],_DUMP[STRING],_MSGID[STRING],_MSGID_OLD[STRING];
  struct userdaten LOOSER;

  int receiver;


#ifdef DEBUG
printf("\nweiterl_brief (%s)  ",user);
fflush(stdout);
#else
printf(" ");
fflush(stdout);
#endif
		
	time(&timer); k=time(0); 
	_MSGID[0]=0; 
	_MSGID_OLD[0]==0;
        sprintf(s,"%s/tmp/mail.%d",HOME,getpid());
        if ((ff=fopen(s,"w"))==NULL)
        {
          printf("\nCan't write to (%s)\n",s);      
          massiv_unlock();
          exit(-1);
        }        

        sprintf(s,"%s/tmp/%dPIP",HOME,getpid()); /*.XMD*/
        fd=fopen(s,"r"); _SUBJECT[0]=0;
        while ((fgets(s,STRING,fd)!=NULL)&&(!strlen(_SUBJECT)))
        {
         s[STRING-1]=0;
         if ((strpos("Subject:",s)==1)&&(_SUBJECT[0]==0)) strcpy(_SUBJECT,&s[9]);
         if ((strpos("From:",s)==1)&&(_FROM[0]==0)) strcpy(_FROM,s /* [6] */);
         if ((strpos("tbbs",s)!=0)&&(strpos("Message-ID:",s)==1)/*&&(_MSGID_OLD[0]==0)*/) /* ist eine BBS-Msg-ID, ich nehme nur die ersten tbbs-id's zwecks LOOP-MAILS  */
          {
            strcpy(_MSGID_OLD, _MSGID);
            strcpy(_MSGID,s /* [6] */);
          }
        } 

	fclose(fd);        
	log_mail((unsigned char *) user,(unsigned char *)_SUBJECT);
	
        sprintf(s,"%s/tmp/%dPIP",HOME,getpid()); /*.XMD*/
        fd=fopen(s,"r"); 
        while ((fgets(s,STRING,fd)!=NULL))
        {
         s[STRING-1]=0;
         if ((strpos("tbbs",s)!=0)&&(strpos("Message-ID: ",s)==1 )&&(_MSGID_OLD[0]==0)) /* ist eine BBS-Msg-ID, ich nehme nur die ersten tbbs-id's zwecks LOOP-MAILS  */
          {
            strcpy(_MSGID_OLD, _MSGID);
            strcpy(_MSGID,s /* [6] */);
          }
        } 
	fclose(fd);        	

        sprintf(s,"%s/tmp/%dPIP",HOME,getpid()); /*Fall 2*/
        fd=fopen(s,"r"); 
        while ((fgets(s,STRING,fd)!=NULL))
        {
         s[STRING-1]=0;
         if ((strpos("tbbs",s)!=0)&&(strpos("Message-ID: ",s)==3 )&&(_MSGID_OLD[0]==0)) /* ist eine BBS-Msg-ID, ich nehme nur die ersten tbbs-id's zwecks LOOP-MAILS  */
          {
            strcpy(_MSGID_OLD, _MSGID);
            strcpy(_MSGID,(char *) &s[2] /* [6] */);
          }
        } 
	fclose(fd);        		
	
        if(strpos(_MSGID_OLD, _MSGID)==1) /* eine LOOP-MAIL zum ZPOSTMASTER*/
        {
          err_brief(5);  /* looping-msg */
          exit(0);
        }

	i = 0; j = 0;			/* Receiver: Realname */

	sprintf(s,"%s/tmp/%dPIP",HOME,getpid());
        fd=fopen(s,"r"); _DUMP[0]=0;
        fgets(_DUMP,STRING,fd);
	fclose(fd);        

	fprintf(ff, "Date: %s", ctime(&k));
	fprintf(ff,/*"From: */"%s\n",sstrings(_FROM));
	fprintf(ff, "Subject: %s",_SUBJECT);
	fprintf(ff, "To: %s\n", user);
/*	fprintf(ff, "Sender: T-BBS_MAILER-DAEMON@%s\n", UUCPID2); */
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "X-Mailer: xmd %s <w>\n", VERSION);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);ctime(&k);
     if (
          (strpos("Message-ID:",_MSGID)==1) &&
          (strpos("tbbs",_MSGID)!=0)
        ) /* ist bereits eine BBS-Msg-ID  */
          {
     		fprintf(ff,"Received: by \"%s\"  (%s), %s\n%s\n\n",
     		s,BBSMD_VERSION,sstrings(ctime(&k)),
       		_MSGID);          
          
          }
          else/* generiere eine neue */
          {
     		fprintf(ff,"Received: by \"%s\"  (%s), %s\nMessage-ID: <%d.%d-tbbs@%s>\n\n",
     			s,BBSMD_VERSION,sstrings(ctime(&k)),
       		getpid(),k,UUCPID2);
          }
    }
	
	fputs("\n", ff);

/*	log_mail(user,_SUBJECT);*/
         
         
        sprintf(s,"%s/tmp/%d.XMD",HOME,getpid());
        fprintf(ff,"forward current message: (%s) -> (%s)\n",PIPE_REC,user);
        fd=fopen(s,"r");
        i=1;
        while (fgets(s,STRING,fd)!=NULL)
        {
         s[STRING]=0;
         strcpy((char *) t,(char *) sstrings(s));
         if ((t[0]!=32)&&(i))
          fprintf(ff,"> %s",s);
         else 
         {
          fprintf(ff,"%s",s); i=0;
         }
        } 
	fclose(ff); fclose(fd);
	
	
	
	sprintf(t,"%s/tmp/mail.%d",HOME,getpid());
	MailTo(t,"bbs",user);
	unlink( t );
       
    LogMailStat(0,user,_FROM);       
        
   massiv_unlock();
/*  if (!ALL) +++++++ */
    {    
        sprintf(t,"%s/tmp/%d.XMD",HOME,getpid()); unlink(t);
        sprintf(t,"%s/tmp/%dPIP",HOME,getpid());unlink(t);
        sprintf(t,"%s/tmp/%d.DUMP",HOME,getpid());unlink(t);
        
        exit(0);
     }
}










/* #IS - Old gateway stuff. */

int is_external( s )
UNSIGNED char s[];
{
  int i = 0, j = 0, p = 0;

  if(strcomp("To: Empty Address", s) == 0) return (int) -1;

  while(s[i] != 0){
	if(s[i] == '%') j++;
	if((s[i] == '@') && (j > 0)) p = i;
	i++;
  }
  return (int) p;
}



/* #MI - Finding a BBS username in a UUCP address and calling "brief()"
   with this address. */

mailing()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[LONGSTRING];
  int i, j;
  int toggle = 0;

#ifdef DEBUG
printf("\nmailing (%s)  ",PIPE_REC);
fflush(stdout);
#else 
printf("  ");
fflush(stdout);
#endif

  if(PIPE_REC[0] != 0){
	i = 0;
	while(PIPE_REC[i] != 0){
		if(PIPE_REC[i] == '.') PIPE_REC[i] = ' ';
		i++;
	}
	brief(PIPE_REC);
	return; 	
  } 

  fp = fopen(tmp, "r");
  if (fp == NULL) {
	log_it( "Can't read:", tmp, "!" );
	printf("\nCan't read %s\n", tmp);
	massiv_unlock();
	exit(-1);
  }
  while (fgets(s, STRING, fp) != NULL) {
     s[STRING]=0;
	if ((strcomp("X400-Recipients:", s) == 0) && (toggle == 0)){
		i = 16;
		j = 0;
		while(s[i] != 0){
			if(s[i] == '<') j = i+1;
			if(s[i] == '@'){
				strcpy(x400, (UNSIGNED char *) strcopy(s, j, (i-1)));
			}
			i++;
		}
	}
	if ((strcomp("To:", s) == 0) && (toggle == 0)){
		i = 1;
		toggle++;
		while(strcomp("EOL", alias[i][1]) != 0){	
			if(strcomp(alias[i][1], s) == 0) strcpy(s, alias[i][2]);
			i++;
		}

		i = 0;
		j = 0;
		while ((s[i] != 0) && (s[i] != '@')) {
			if (s[i] == '!') j = i;
			if (s[i] == '.') s[i] = ' ';
			i++;
		}
		i--;
		if (j == 0) {
			strcpy(t, (UNSIGNED char *) strcopy(s, 4, i));
		} else {
			strcpy(t, (UNSIGNED char *) strcopy(s, (j + 1), strlen(s)));
		}

		if(t[0] == '"'){
			j = 1;
			while((t[j] != 0) && (t[j] != '"')){
				j++;
			}
			j--;
			strcpy(t, (UNSIGNED char *) strcopy(t, 1, j));
		}

			brief(t);
	}
  }

  fclose(fp);
}


/* #ML - Do a HARD (!) locking on all XMDs actions. */

massiv_lock()
{
  
}


/* #MU - Unlock XMD */ 

massiv_unlock()
{
  UNSIGNED char s[STRING];

  sprintf(s, "%s/xmd.LCK", TMP);
  unlink(s);
}




/* #MA - XMD main function. 

   This is able to forward mails to addresses such as "Real.Name@UUCPID". 

   It also understands "Real.Name -" command lines. This is used by smail
   in the "aliases" file. The mailing text has to come from stdin than. */

xmd_main(argc, argv)
int argc;
UNSIGNED char *argv[];
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[LONGSTRING];
  UNSIGNED char dump[STRING];
  UNSIGNED char maildrop[STRING];
  int toggle = 0;
  int l;
  int c;
  int p;
  int i;
  int j;
  int i_next;

  umask(0000);
  
  setgid(GUEST_GID);
  setuid(GUEST_GID);
  
#ifdef DEBUG
printf("\nnach setuid()...");
#else
printf("  ");
#endif

  SetMain();
  SetZMain();

#ifdef DEBUG
printf("\nnach setmain()...");
printf("\nHOME=(%s)",HOME);
#else
printf("  ");
fflush(stdout);
#endif

  chdir(HOME);

#ifdef DEBUG
printf("\nvor massiv_lock...");
#else
printf("  ");
fflush(stdout);
#endif
   
  massiv_lock();

#ifdef DEBUG
printf("\nnach massiv-lock...");
#else
printf("  ");
fflush(stdout);
#endif

 PIPE_REC[0]=0;

#ifdef DEBUG
printf("\nmake defaults...");
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif

  strcpy(ORGANIZATION, _ORGANIZATION);
  strcpy(SYSTEM,       _SYSTEM);
  strcpy(UUCPSITE,     _UUCPSITE);
  strcpy(UUCPID2,      _UUCPID2);
  strcpy(UUCPID1,      _UUCPID1);

  strcpy(NAT_DOMAIN1, (unsigned char *) GetSection("[mail_domain]","nat1")); /*_NAT_DOMAIN1*/
  strcpy(NAT_DOMAIN2, (unsigned char *) GetSection("[mail_domain]","nat2")); /*_NAT_DOMAIN2*/
  strcpy(NAT_DOMAIN3, (unsigned char *) GetSection("[mail_domain]","nat3")); /*_NAT_DOMAIN3*/

  strcpy(UUCPBANG,     _UUCPBANG);
  strcpy(PHONE,        _PHONE);
  strcpy(LOCATION,     _LOCATION);
  strcpy(SMARTHOST,    _SMARTHOST);
  strcpy(NEWS_MINIMUM, _NEWS_MINIMUM);
  strcpy(PMS_TTY,      _PMS_TTY);
  strcpy(GREP,         _GREP);
  strcpy(UUX,          _UUX); 
  strcpy(TAR,          _TAR);
  strcpy(SORTEDCUT,    _SORTEDCUT);
  strcpy(SECONDCUT,    _SECONDCUT);
  strcpy(THIRDCUT,     _THIRDCUT);
  TARIF = (int) _TARIF;
  NZNT  = (int) _NZNT;
  NZBT  = (int) _NZBT;
  RZNT  = (int) _RZNT;
  RZBT  = (int) _RZBT;
  WZNT  = (int) _WZNT;
  WZBT  = (int) _WZBT;

#ifdef DEBUG
printf("\nnach make defaults...");
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif

  if(get_cfg() == -1)
	write_cfg();

#ifdef DEBUG
printf("\nnach write...");
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif


  if(argc < 2){
	INTERACT = 0;
  }
  else{
#ifdef DEBUG
printf("\nelse (argc > 1)..");
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif


/*SetSHExports();*/

  
	if(argv[2][0] == '-'){
		strcpy(PIPE_REC, (UNSIGNED char *) argv[1]);
		sprintf(maildrop, "%s/%dPIP", TMP, getpid());
		fp = fopen(maildrop, "w");
		if(fp == NULL){
			log_it( "Can't write to:", maildrop, "!" );
			log_it( "Mail LOST! No SETUID for XMD!!!", "CHMOD ug+s xmd", "IMMEDIATLY!!!" );
			printf("\nCan't write to %s\n", maildrop);
			return;
		}
		c = 0;
		do{
			c = fgetc(stdin);
			if((c != EOF) && (c != 4)){
				fputc(c, fp);
			}
		}while((c != EOF) && (c != 4));
		fclose(fp);
		/*	
		sprintf(s, "cp %s %s/%d.xmd-back", maildrop, TMP, getpid());
		system( s );
		*/
		fp = fopen(maildrop, "r");
		INTERACT = 1;	
	}
	else{
		maybe_locked(maildrop, "r"); mblock(maildrop);/*!!!!!!*/
		sprintf(maildrop, "%s/%s", MAILDROP, argv[1]);
		/*
		sprintf(s, "cp %s %s/%d.xmd-back", maildrop, TMP, getpid());
		system( s );
		*/
		fp = fopen(maildrop, "r");
		INTERACT = 1;
	}
  }
  if(INTERACT == 0) printf("\n");

  if (fp == NULL) {
	if(INTERACT == 0) printf("\nNo mail.\n");
	return;
  }

  l = 1; 
#ifdef XMS_ALIASES 
  ff = fopen( XMD_ALIAS, "r" );
  if(ff != 0){
	while(fgets(s, STRING, ff) != 0)
	{
	   s[STRING]=0;
		if((s[0] > 64) && (l < MAX_XMD_ALIAS))
		{
			strcpy(alias[l][1], (UNSIGNED char *) stripped(s));
			fgets(s, STRING, ff);
			strcpy(alias[l][2], (UNSIGNED char *) stripped(s));
			l++;
		}
	}
	fclose(ff);
  }
#endif

#ifdef DEBUG
printf("\nalias...");
#else
printf("  ");
fflush(stdout);
#endif
  
  strcpy(alias[l][1], "EOL");

  sprintf(dump, "%s/%d.DUMP", TMP, getpid());
  ff = fopen(dump, "w");
  if(ff == NULL){
	log_it( "Can't write to:", dump, "!" );
	printf("\nCan't write to %s\n", dump);
	return;
  }
#ifdef DEBUG
printf("\nnach DUMP...");
#else
printf("  ");
fflush(stdout);
#endif

  toggle = 0;

  while (fgets(s, STRING, fp) != NULL) {
      s[STRING]=0;
	l = 2;
	if (s[0] == '>') {
		if(PIPE_REC[0] == 0){
			if(s[1] != ' ') l = 1;
			strcpy(t, (UNSIGNED char *) strcopy(s, l, strlen(s)));
			strcpy(s, t);
		}
		if (strcomp("OOPS", s) != 0) {
			fputs(s, ff);
		}
	}
	else{
		if(strcomp("From ", s) == 0){
			fprintf(ff, "*%s", s);
			if(strcomp(RETURNED_MAIL, s) == 0){
				while(strcomp("> ", s) != 0){
					fgets(s, STRING, fp);
				}
			}
		}
		else{
			fputs(s, ff);
		}
	}

  }
  fclose(ff);
  fclose(fp);
#ifdef DEBUG
printf("\nvor DUMP-OPEN...");
#else
printf("  ");
fflush(stdout);
#endif
  

  fp = fopen(dump, "r");
  if(fp == NULL){
	log_it( "Can't read:", dump, "!" );
	printf("\nCan't read %s\n", dump);
	return;
  }

  sprintf(tmp, "%s/%d.XMD", TMP, getpid());

  ff = fopen(tmp, "w");
  if(ff == NULL){
	log_it( "Can't write to:", tmp, "!" );
	printf("\nCan't write to %s\n", tmp);
	return;
  }

  toggle = 0; i_next=1;
LOOP:  
#ifdef DEBUG
printf("\nnach LABEL LOOP: -> PIPE_REC=(%s)  ",PIPE_REC);
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif

  
if (strlen(PIPE_REC))
{
  while (fgets(s, STRING, fp) != NULL) {
        s[STRING]=0;
	if (strcomp("*From ", s) == 0){
		if (toggle == 1) {
			if (ff != 0) fclose(ff);
			
			mailing();
			/*if (ALL) goto LOOP;*/
			ff = fopen(tmp, "w");
			if(ff == NULL){
				log_it( "Can't write to:", tmp, "!" );
				printf("\nCan't write to %s\n", tmp);
 				return;
			}
		}
		toggle = 1;
	}
	if ((toggle == 1) && (strcomp("*From ", s) != 0)){

		if (strcomp("X400-Recipients:", s) == 0){
			i = 16;
			j = 0;
			while(s[i] != 0){
				if(s[i] == '<') j = i+1;
				if(s[i] == '@'){
					strcpy(x400, (UNSIGNED char *) strcopy(s, j, (i-1)));
				}
				i++;
			}
		}		
		
		if(strcomp("To: ", s) == 0){
			p = is_external(s);

			if(p > 0){
				s[p] = 0;
				strcat(s, (UNSIGNED char *) "@amnet.UUCP\n");
			}
			if(p == -1){
				sprintf(s, "To: %s@amnet.UUCP\n", x400);
			}
		}
		fputs(s, ff);
	}
  } 

  if (ff != 0) fclose(ff);
  if (toggle == 1) {
   mailing();
/*   if (ALL) goto LOOP;*/
  }

  } /* if strlen(PIPE_REC */    else ALL=0;
  

  fclose(fp);

  unlink(tmp);
  unlink(dump);


  sprintf(maildrop, "%s/%dPIP", TMP, getpid()); /* 9.4.94 - Bugfree ??? */
  unlink(maildrop);

  massiv_unlock();
}


unsigned char *leer2punkt(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=46;
}
 b[j]=0;
  	     
  return (UNSIGNED char *) (b);
}




/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
UNSIGNED char s[], t[];
{
  int j=0, i = 0, a = 0;


  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}



/* gibt die MailAlias-Adresse eines Users zurueck */
char *GetUsrMailAlias(user)
unsigned char *user;
{
static char s[STRING];
unsigned char name[STRING];
FILE *fd;
int fp,id,i;
struct userdaten LOOSER;


  chdir(HOME);
  fp = open(UDBASE, O_RDONLY);
  if (fp == -1) 
  {
	printf("\nxmd.c, 1199 \"GetUsrMailAlias\", \nCan't read %s\n", UDBASE);
	massiv_unlock();
	exit(-1);
  }
  lseek(fp, 0L, SEEK_SET);
  id=0;
  while 
  (
   (read(fp, (char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) 
    && (id == 0)
  ) 
  {
	if (strcomp(user, LOOSER.name) == 0)  
	    {
		id = LOOSER.id;
		strcpy(name, LOOSER.name);
 	    }
  }
  close(fp);
 if (!id) return(NULL);

sprintf(s,"%s/usr/%c/%d/.MailAlias",HOME,name[0],id);
fd=fopen(s,"r");
if (!fd) return(NULL);
fgets(s,STRING,fd);
fclose(fd);
strcpy(s,(char *) sstrings(s));
for (i=0; i<STRING; i++) 
{
 if (s[i]==SPACE) s[i]=0;
}


return((char *) &s); 
}





/* Mail-Size-Logging to File */
/*  modes :
 * 		0	-> aliases-adr
 *		1 	-> rmail-adr
 */
void LogMailStat(mode,to,alias)
int mode;
unsigned char *to,*alias;
{
FILE *fd;
unsigned char s[2*STRING];
struct stat fst;

chdir(HOME);
if ((maillogsize<10)) 
{ 
 return;  /* nicht loggen wenn schalter aus aus*/
}

sprintf(s,"%s/tmp/%dPIP",HOME,getpid());

/*
chdir(HOME);
if (checkdomain(to)||(ZOPT.OPT->maillogsize<10)) 
{ 
 return;  * lokale Mails  nicht loggen *
}
*/

stat(s,&fst);
if (mode==1) sprintf(s,"%s/etc/log/rmail/%s",HOME,leer2punkt(to));
ALIAS_FROM[strlen(ALIAS_FROM)]=0;
if (mode==0) sprintf(s,"%s/etc/log/rmail/%s",HOME,leer2punkt(ALIAS_FROM));


if ((fd=fopen(s,"a"))!=NULL)
{
  if ((fst.st_size>maillogsize)&&(mode==1)) /* normal-rmail */
  {
   fprintf(fd,"%s,%s [%d]<- %s \n",mydate(0),mytime(0),fst.st_size,alias) ;
   }
  if ((fst.st_size>maillogsize)&&(!mode)) /* alias-rmail */
  {
   strcpy(s,(char *) sstrings(alias));
   strcpy(s,&s[5]);
   fprintf(fd,"%s,%s [%d]<- %s (alias-mail)\n",mydate(0),mytime(0),fst.st_size,s) ;
  }
  fclose(fd);
}

}










/* ++++++++++++++++++++++  Globale ZCFG lesen ++++++++++++++++++ */
void SetZMain()
{
FILE *fd;
unsigned char t[STRING];
char s[STRING],*env;
int i,j;


strcpy(s,(char *) sstrings(GRead("mailsize"))); 
maillogsize= atoi(s);


strcpy(s,(char *) sstrings(GRead("log.mail"))); 
if (strpos("on",s)==NULL) maillogsize=0;



}



/* gibt den vollen namen eines Users zurueck */
char *GetRealName(user)
unsigned char *user;
{
static char s[STRING];
static char name[STRING];
FILE *fd;
int fp,id,i;
struct userdaten LOOSER;


  chdir(HOME);
  fp = open(UDBASE, O_RDONLY);
  if (fp == -1) 
  {
	nerror("xmd.c", 1548, "GetUsrMailAlias", "Can't read", UDBASE);
  }
  lseek(fp, 0L, SEEK_SET);
  id=0;
  while (
	   (read(fp,(char *)  &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) 
	    && (id == 0)
       ) 
  {
          if ((strcomp(user, LOOSER.name) == 0) ||
	      (strcomp(LOOSER.name, user) == 0) ||
	      (strcomp(user, LOOSER.nick) == 0) ||
	      (strcomp(user, LOOSER.sh_name) == 0))
          {
		id = LOOSER.id;
		strcpy(name, LOOSER.name);
		
          }
  }
  close(fp);
 if (!id) return(NULL);

fclose(fd);

return((char *) name); 
}


/* gibt den vollen namen eines Users zurueck */
char *GetNextUsr(id)
int id;
{
static char s[STRING];
static char name[STRING];
FILE *fd;
int fp,i;
struct userdaten LOOSER;


  chdir(HOME);
  fp = open(UDBASE, O_RDONLY);
  if (fp == -1) 
  {
	nerror("xmd.c", 1548, "GetUsrMailAlias", "Can't read", UDBASE);
  }
  lseek(fp, 0L, SEEK_SET);
  i=0;
  while (
	   (read(fp,(char *)  &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) 
	    && (i == 0)
       ) 
  {
          if (LOOSER.id==id) 
          {
		i = LOOSER.id;
		strcpy(name, LOOSER.name);
		
          }
  }
  close(fp);
 if (!i) return(NULL);

fclose(fd);

return((char *) name); 
}




int MailTo(_s,from,rec_char)
unsigned char *_s,*from,*rec_char;
{
FILE *fd,*fp;
char s[STRING];

if (!(fd=fopen(_s,"r"))) return (0);
sprintf(s,"%s -F%s -f%s %s", SYSTEM_MAIL,
	from,from,rec_char);
if ((fp = popen(s, "w")) == NULL)
{
 printf("\nxmd: Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
 exit(-2);
}
while (fgets(s,STRING,fd)!=NULL) 
{
  s[STRING]=0;
  fprintf(fp,"%s",s);
}
pclose(fp);
fclose(fd);
return (1);                                                          

}




unsigned char *cut_bef(s)
unsigned char s[];
{
static unsigned char bef[STRING];
int i = 0;
    
    
while (s[i] > 32) {
   bef[i] = s[i];
   i++;
 }
 bef[i] = 0;
 return (unsigned char *) bef;
}
                            




/* #BR - Mail to a BBS user [arg]. */
brief(arg)
char *arg;
{
  FILE *fp;
  FILE *ff;
  int fd;
  int i, a, b;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;

  int receiver;
  static int mail_id;
  int lines   = 0;
  int local   = 0;
  int arrived = 1;

  int rec;


  UNSIGNED char s[2*STRING];
  UNSIGNED char t[2*STRING],stt[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  char tt[STRING];
  UNSIGNED char rec_char[STRING];
  char  ex[LONGSTRING];
  UNSIGNED char user[STRING],zautor[STRING];
  UNSIGNED char destination[STRING];
  UNSIGNED char receipt[STRING];
  char *ttt;

  i = 0;
  ok = 0;

#ifdef DEBUG
printf("\nbrief (%s)  ",arg);
fflush(stdout);
#else
printf("  ");
fflush(stdout);
#endif

  strcpy(user, (UNSIGNED char *) stripped(arg));
  
  strcpy(_TO,user);
  strcpy(subject, XMD01_MSG);

  strcpy(ALIAS_FROM,user);
  if ((ttt=(char *) GetUsrMailAlias(user))!=NULL)  /* user hat alias gesetzt */
  {
    strcpy(user,ttt);
    weiterl_brief(user);
    massiv_unlock();
    exit(0);
  }
   


  JUNK:	receiver = 0;

  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	log_it( "Can't read:", UDBASE, "!" );
	printf("\nCan't read %s\n", UDBASE);
	massiv_unlock();
	exit(-1);
  }
  lseek(fd, 0L, SEEK_SET);
  rec=-1;
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)) {
      if (LOOSER.id==1) strcpy(ADMIN,LOOSER.name);
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		if (LOOSER.id!=-1) rec=LOOSER.id;
		strcpy(rec_char, LOOSER.name);

	}
  }
  close(fd);

  sprintf(s,"%s/tmp/%dPIP",HOME,getpid());
  ff=fopen(s,"r"); zautor[0]=autor[0]=0; 
  while (fgets(s, STRING, ff) != NULL) {
	i = 0;
        s[STRING-1]=0;
	if(strcomp("*From ", s) == 0){
		strcpy(s, (UNSIGNED char *) stripped(strcopy(s, 1, STRING)));
		strcat(s, "\n");
	}
	fputs(s, fp);
	if((strcomp("From: ", s) == 0) && ((autor[0] == 0) || (local = 1))){
	        if (autor[0]==0)
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 0;
	}
	if((strcomp("From: ", s) == 0) &&(zautor[0] == 0) ){
		strcpy(zautor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
	}	
	if(strcomp("From ", s) == 0){
                if (autor[0]==0)
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 5, STRING)));
		strcpy(_FROM,autor);
		local = 1;
	}
	if(strcomp("*From ", s) == 0){
	        if (autor[0]==0)
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 1;
	}
  }
  fclose(ff);
  strcpy(_FROM,autor);
  if (strpos("<",_FROM)) {
    strcpy(_FROM,&_FROM[strpos("<",_FROM)]);
    _FROM[strlen(_FROM)-1]=0;
  }
  if (zautor[0]==0) strcpy(zautor,_FROM);
  /* strcpy((char *) s,(char *) cut_bef(_FROM)); strcpy((char *)_FROM,(char *) s);*/

  if (rec==-1) 
  {
   err_brief(3);
   massiv_unlock();
   exit(0);
  }
  if (receiver == 0) {
	sprintf(subject, "[xmd:] '%s' ???   ", user);
	strcpy(user, POSTMASTER);
	arrived = 0;
	goto JUNK;
  }
  
  LogMailStat(1,_TO,zautor /*_FROM*/);
  time(&timer);
  sprintf(ex,"%s/spool/mail/%s#%d%x",HOME,leer2punkt(arg),getpid(),timer);
  sprintf(s,"%s/tmp/%dPIP",HOME,getpid());
  ff=fopen(s,"r");
  fp=fopen(ex,"w");
  while (fgets(s, STRING, ff) != NULL) {
   fprintf(fp,"%s",s);
  }
  fclose(fp); fclose(ff);
  massiv_unlock();
  sprintf(t,"%s/tmp/%d.XMD",HOME,getpid()); unlink(t);
  sprintf(t,"%s/tmp/%dPIP",HOME,getpid());unlink(t);
  sprintf(t,"%s/tmp/%d.DUMP",HOME,getpid());unlink(t);
/*  
  sprintf(s,"%s/bin/bbsmail.spool",HOME);
  sprintf(t," >/dev/null");
  if (!do_check())              
  execl(s,"bbsmail.spool",(char *) t ,((char *) NULL),(char *) NULL);
  system(s);
 */
  exit(0);
               
}


                

UNSIGNED char *cut_arg(s)
UNSIGNED char s[];
{
  static UNSIGNED char arg[2*STRING];
  int i = 0, a = 0;


  while (s[i] > 32) i++;
  if (s[i] == 0) return (UNSIGNED char *) "";

  while (s[i] == 32) i++;

  while (s[i] != 0) {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = 0;

  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = 0;
  }

  return (UNSIGNED char *) arg;
}
                
                

void SetSHExports()
{
FILE *fd;
unsigned char s[LONGSTRING],t[STRING],k[STRING];

sprintf(s,"%s/etc/list.export",HOME);


if ((fd=fopen(s,"r"))!=NULL)
{

  while (fgets(s,STRING*2,fd)!=NULL)
  {
    if (strpos("#",s)!=1)
    {
      strcpy(t,(char *) cut_bef(s)); 
      if (strpos(" ",t)!=0) t[strpos(" ",t)-1]=0;
      strcpy(k,(char *) cut_arg(s));
      if (strpos(" ",k)!=0) k[strpos(" ",k)-1]=0;
      if (setenv(t,k,1)==(-1)) ;
       /* logerror("sexport.c", 46, "SetSHExports", "CAN NOT SET THE ENVIROMENT (check ./etc/list.export)", s);   */
    }
  }
}
}
                



            

/* wandelt alle Zeilchen in Grossbuchstaben */
unsigned char *touppers(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>64)&&(b[j]<91)) b[j]=b[j]+32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}



